/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.graphic.configuration.shape;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class PredefinedPaint
extends TexturePaint {
    private Color foreground;
    private Color background;
    private int width;
    private int height;
    private int[] points;
    private float alphaValue = 1.0f;
    public static final PredefinedPaint TRANSPARENT = new PredefinedPaint(4, 4, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    public static final PredefinedPaint SOLID = new PredefinedPaint(4, 4, new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
    public static final PredefinedPaint DEFAULT = new PredefinedPaint(4, 4, new int[]{1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1});
    public static final PredefinedPaint SPACED_DOTS = new PredefinedPaint(4, 4, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    public static final PredefinedPaint DIAGONAL = new PredefinedPaint(4, 4, new int[]{0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    public static final PredefinedPaint DOT_LINE = new PredefinedPaint(4, 4, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0});
    public static final PredefinedPaint DASH_LINE = new PredefinedPaint(1, 4, new int[]{1, 1, 0, 0});
    public static final PredefinedPaint DOT_LINE2 = new PredefinedPaint(1, 2, new int[]{1, 0});
    public static final PredefinedPaint VERY_SPACED_DOTS = new PredefinedPaint(8, 8, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private static Object[][] data = new Object[][]{{"TRANSPARENT", TRANSPARENT}, {"SOLID", SOLID}, {"DEFAULT", DEFAULT}, {"SPACED_DOTS", SPACED_DOTS}, {"VERY_SPACED_DOTS", VERY_SPACED_DOTS}, {"DASH_LINE", DASH_LINE}, {"DIAGONAL", DIAGONAL}, {"DOT_LINE2", DOT_LINE2}, {"DOT_LINE", DOT_LINE}};
    private static HashMap shapePaintMap = null;

    public PredefinedPaint(int n, int n2, int[] nArray) {
        this(n, n2, nArray, Color.black, Color.white);
    }

    public PredefinedPaint(PredefinedPaint predefinedPaint, Color color, Color color2) {
        this(predefinedPaint.width, predefinedPaint.height, predefinedPaint.points, color, color2);
    }

    private PredefinedPaint(int n, int n2, int[] nArray, Color color, Color color2) {
        super(PredefinedPaint.createTexture(n, n2, nArray, color, color2), new Rectangle(0, 0, n, n2));
        this.width = n;
        this.height = n2;
        this.foreground = color;
        this.background = color2;
        this.points = nArray;
        float f = 0.0f;
        for (int i = 0; i < nArray.length; ++i) {
            f += (float)nArray[i];
        }
        this.alphaValue = (float)Math.pow(f / (float)nArray.length, 1.5);
    }

    private static BufferedImage createTexture(int n, int n2, int[] nArray, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                bufferedImage.setRGB(i, j, nArray[i + j * n] > 0 ? color.getRGB() : color2.getRGB());
            }
        }
        return bufferedImage;
    }

    public static HashMap getShapePaints() {
        if (shapePaintMap == null) {
            shapePaintMap = new HashMap();
            for (int i = 0; i < data.length; ++i) {
                Object[] objectArray = data[i];
                shapePaintMap.put(objectArray[0], objectArray[1]);
            }
        }
        return shapePaintMap;
    }

    public static PredefinedPaint find(String string) {
        return (PredefinedPaint)PredefinedPaint.getShapePaints().get(string);
    }

    public void applyPaint(Graphics2D graphics2D, boolean bl) {
        if (bl) {
            graphics2D.setPaint(this);
        } else {
            graphics2D.setColor(new Color(this.bar(this.foreground.getRed(), this.background.getRed(), this.alphaValue), this.bar(this.foreground.getGreen(), this.background.getGreen(), this.alphaValue), this.bar(this.foreground.getBlue(), this.background.getBlue(), this.alphaValue)));
        }
    }

    private int bar(float f, float f2, float f3) {
        return Math.round(f * f3 + (1.0f - f3) * f2);
    }
}

