/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.dependency;

import com.projectlibre1.association.InvalidAssociationException;
import com.projectlibre1.pm.dependency.Dependency;
import com.projectlibre1.pm.dependency.HasDependencies;
import com.projectlibre1.pm.task.SubProj;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.undo.DataFactoryUndoController;
import com.projectlibre1.undo.DependencyCreationEdit;
import com.projectlibre1.undo.DependencyDeletionEdit;
import com.projectlibre1.undo.DependencySetFieldsEdit;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.ClassUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.apache.commons.collections.Predicate;

public class DependencyService {
    private static DependencyService instance = null;

    public static DependencyService getInstance() {
        if (instance == null) {
            instance = new DependencyService();
        }
        return instance;
    }

    public Dependency newDependency(HasDependencies hasDependencies, HasDependencies hasDependencies2, int n, long l, Object object) throws InvalidAssociationException {
        if (hasDependencies == hasDependencies2) {
            throw new InvalidAssociationException(Messages.getString("Message.cantLinkToSelf"));
        }
        Task task = (Task)hasDependencies2;
        if (task.isExternal()) {
            throw new InvalidAssociationException(Messages.getString("Message.cantLinkToExternal"));
        }
        if (task.isSubproject() && !((SubProj)((Object)task)).isWritable()) {
            throw new InvalidAssociationException(Messages.getString("Message.cantLinkToClosedSubproject"));
        }
        Dependency dependency = Dependency.getInstance(hasDependencies, hasDependencies2, n, l);
        dependency.testValid(false);
        this.connect(dependency, object);
        dependency.setDirty(true);
        return dependency;
    }

    public void initDependency(Dependency dependency, HasDependencies hasDependencies, HasDependencies hasDependencies2, Object object) throws InvalidAssociationException {
        dependency.setPredecessor(hasDependencies);
        dependency.setSuccessor(hasDependencies2);
        if (!dependency.isDisabled()) {
            dependency.testValid(false);
        }
        this.connect(dependency, object);
    }

    public void addStartSentinelDependency(HasDependencies hasDependencies, HasDependencies hasDependencies2) {
        Dependency dependency = Dependency.getInstance(hasDependencies, hasDependencies2, 3, 0L);
        hasDependencies.getSuccessorList().add(dependency);
    }

    public void addEndSentinelDependency(HasDependencies hasDependencies, HasDependencies hasDependencies2) {
        Dependency dependency = Dependency.getInstance(hasDependencies2, hasDependencies, 1, 0L);
        hasDependencies.getPredecessorList().add(dependency);
    }

    public boolean removeEndSentinel(HasDependencies hasDependencies, HasDependencies hasDependencies2) {
        Dependency dependency = (Dependency)hasDependencies.getPredecessorList().findLeft(hasDependencies2);
        if (dependency != null) {
            hasDependencies.getPredecessorList().remove(dependency);
            return true;
        }
        return false;
    }

    public boolean removeStartSentinel(HasDependencies hasDependencies, HasDependencies hasDependencies2) {
        Dependency dependency = (Dependency)hasDependencies.getSuccessorList().findRight(hasDependencies2);
        if (dependency != null) {
            hasDependencies.getSuccessorList().remove(dependency);
            return true;
        }
        return false;
    }

    public void connect(Dependency dependency, Object object) {
        dependency.getPredecessor().getSuccessorList().add(dependency);
        dependency.getSuccessor().getPredecessorList().add(dependency);
        this.updateSentinels(dependency);
        if (object != null) {
            dependency.fireCreateEvent(object);
        }
        dependency.setDirty(true);
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport(dependency);
        if (undoableEditSupport != null && object != null && !(object instanceof UndoableEdit)) {
            undoableEditSupport.postEdit(new DependencyCreationEdit(dependency, object));
        }
    }

    public void fireTaskPredecessors(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Task)iterator.next()).getPredecessorList().iterator();
            while (iterator2.hasNext()) {
                ((Dependency)iterator2.next()).fireCreateEvent(this);
            }
        }
    }

    public void remove(Dependency dependency, Object object, boolean bl) {
        dependency.setDirty(true);
        dependency.getPredecessor().getSuccessorList().remove(dependency);
        dependency.getSuccessor().getPredecessorList().remove(dependency);
        this.updateSentinels(dependency);
        if (object != null) {
            dependency.fireDeleteEvent(object);
        }
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport(dependency);
        if (bl && undoableEditSupport != null && !(object instanceof UndoableEdit)) {
            undoableEditSupport.postEdit(new DependencyDeletionEdit(dependency, object));
        }
    }

    public void setFields(Dependency dependency, long l, int n, Object object) throws InvalidAssociationException {
        long l2 = dependency.getLag();
        int n2 = dependency.getDependencyType();
        dependency.setLag(l);
        dependency.setDependencyType(n);
        dependency.setDirty(true);
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport(dependency);
        if (undoableEditSupport != null && !(object instanceof UndoableEdit)) {
            undoableEditSupport.postEdit(new DependencySetFieldsEdit(dependency, l2, n2, object));
        }
    }

    public void update(Dependency dependency, Object object) {
        if (object != null) {
            dependency.fireUpdateEvent(object);
        }
        dependency.setDirty(true);
    }

    public void updateSentinels(Dependency dependency) {
        Task task = (Task)dependency.getPredecessor();
        Task task2 = (Task)dependency.getSuccessor();
        task.updateEndSentinel();
        task2.updateStartSentinel();
    }

    public void connect(List list, Object object, Predicate predicate) throws InvalidAssociationException {
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        for (int i = 0; i < list.size() - 1; ++i) {
            Object e = list.get(i);
            if (!(e instanceof HasDependencies)) continue;
            HasDependencies hasDependencies = (HasDependencies)e;
            for (int j = i + 1; j < list.size(); ++j) {
                e = list.get(j);
                if (!(e instanceof HasDependencies)) continue;
                HasDependencies hasDependencies2 = (HasDependencies)e;
                if (predicate != null && !predicate.evaluate(hasDependencies2) || hasDependencies2.getPredecessorList().findLeft(hasDependencies) != null || ClassUtils.isObjectReadOnly(hasDependencies2)) continue;
                Dependency dependency = Dependency.getInstance(hasDependencies, hasDependencies2, 1, 0L);
                dependency.testValid(false);
                if (j != i + 1) continue;
                arrayList.add(dependency);
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.connect((Dependency)iterator.next(), object);
        }
    }

    public void removeAnyDependencies(List list, Object object) {
        for (int i = 0; i < list.size() - 1; ++i) {
            Object e = list.get(i);
            if (!(e instanceof HasDependencies)) continue;
            HasDependencies hasDependencies = (HasDependencies)e;
            for (int j = i + 1; j < list.size(); ++j) {
                e = list.get(j);
                if (!(e instanceof HasDependencies)) continue;
                HasDependencies hasDependencies2 = (HasDependencies)e;
                this.removeAnyDependencies(hasDependencies, hasDependencies2, object);
            }
        }
    }

    public void removeAnyDependencies(HasDependencies hasDependencies, HasDependencies hasDependencies2, Object object) {
        if (hasDependencies == null || hasDependencies2 == null) {
            return;
        }
        Dependency dependency = (Dependency)hasDependencies.getPredecessorList().findLeft(hasDependencies2);
        if (dependency != null) {
            this.remove(dependency, object, true);
        }
        if ((dependency = (Dependency)hasDependencies2.getPredecessorList().findLeft(hasDependencies)) != null) {
            this.remove(dependency, object, true);
        }
        if ((dependency = (Dependency)hasDependencies.getSuccessorList().findRight(hasDependencies2)) != null) {
            this.remove(dependency, object, true);
        }
        if ((dependency = (Dependency)hasDependencies2.getSuccessorList().findRight(hasDependencies)) != null) {
            this.remove(dependency, object, true);
        }
    }

    public void remove(Collection collection, Object object) {
        for (Dependency dependency : collection) {
            this.remove(dependency, object, true);
        }
    }

    public void remove(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            collection2.add(iterator.next());
        }
    }

    public UndoableEditSupport getUndoableEditSupport(Dependency dependency) {
        if (dependency.getPredecessor() == null) {
            return null;
        }
        DataFactoryUndoController dataFactoryUndoController = ((Task)dependency.getPredecessor()).getProject().getUndoController();
        if (dataFactoryUndoController == null) {
            return null;
        }
        return dataFactoryUndoController.getEditSupport();
    }

    public static String getCircularCrossProjectLinkMessage(Object object, Object object2) {
        return MessageFormat.format(Messages.getString("Message.crossProjectCircularDependency.mf"), object, object2);
    }

    public static void warnCircularCrossProjectLinkMessage(final Object object, final Object object2) {
        if (Alert.allowPopups()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Alert.warn(DependencyService.getCircularCrossProjectLinkMessage(object, object2));
                }
            });
        }
    }
}

