/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.spreadsheet.editor;

import com.projectlibre1.datatype.CanSupplyRateUnit;
import com.projectlibre1.datatype.DurationFormat;
import com.projectlibre1.dialog.util.FixedSizeFilter;
import com.projectlibre1.field.Field;
import com.projectlibre1.field.FieldConverter;
import com.projectlibre1.field.FieldParseException;
import com.projectlibre1.pm.graphic.ChangeAwareTextField;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projectlibre1.pm.graphic.spreadsheet.common.CommonSpreadSheet;
import java.awt.Color;
import java.awt.Component;
import java.text.Format;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;

public class SimpleEditor
extends DefaultCellEditor {
    protected ChangeAwareTextField component = (ChangeAwareTextField)this.getComponent();
    protected Class clazz;
    protected Format useFormat = null;
    JTable cachedTable = null;

    public SimpleEditor() {
        super(new ChangeAwareTextField());
        this.component.setFocusLostBehavior(1);
        this.component.getInputMap(0).getParent().getParent().getParent().remove(KeyStroke.getKeyStroke(10, 0));
        this.clazz = String.class;
    }

    public SimpleEditor(Class clazz) {
        this();
        this.clazz = clazz;
    }

    public SimpleEditor(Class clazz, Format format) {
        this(clazz);
        this.useFormat = format;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.cachedTable = jTable;
        String string = object == null ? null : FieldConverter.toString(object);
        this.component.setText(string);
        this.component.setSelectedTextColor(Color.WHITE);
        this.component.setSelectionColor(Color.BLACK);
        if (jTable.getModel() instanceof SpreadSheetModel) {
            Object object2;
            SpreadSheetModel spreadSheetModel = (SpreadSheetModel)jTable.getModel();
            Field field = spreadSheetModel.getFieldInColumn(n2 + 1);
            int n3 = field.getTextWidth(null, null);
            if (n3 != Integer.MAX_VALUE) {
                ((AbstractDocument)this.component.getDocument()).setDocumentFilter(new FixedSizeFilter(n3));
            }
            this.component.setHorizontalAlignment(field.getHorizontalAlignment());
            if (field.isWork() && (object2 = spreadSheetModel.getObjectInRow(n)) instanceof CanSupplyRateUnit && ((CanSupplyRateUnit)object2).isMaterial()) {
                this.useFormat = DurationFormat.getNonTemporalWorkInstance();
            }
        } else if (object == null || object instanceof String) {
            this.component.setHorizontalAlignment(2);
        } else {
            this.component.setHorizontalAlignment(4);
        }
        this.component.selectAll();
        return this.component;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.useFormat == null) {
            try {
                return FieldConverter.convert(this.component.getText(), this.clazz, null);
            }
            catch (FieldParseException fieldParseException) {
                return null;
            }
        }
        try {
            return this.useFormat.parseObject(this.component.getText());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public boolean stopCellEditing() {
        if (this.component.hasChanged()) {
            boolean bl = super.stopCellEditing();
            if (this.handledPostErrorFocus()) {
                return false;
            }
            return bl;
        }
        this.cancelCellEditing();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
    }

    protected boolean handledPostErrorFocus() {
        if (this.cachedTable != null && this.cachedTable instanceof CommonSpreadSheet && ((CommonSpreadSheet)this.cachedTable).getLastException() != null) {
            this.cachedTable.requestFocus();
            return true;
        }
        return false;
    }
}

