/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FixedLengthInputStream
extends FilterInputStream {
    private long m_remaining;

    public FixedLengthInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.m_remaining = l;
    }

    @Override
    public void close() throws IOException {
        long l = 0L;
        if (this.m_remaining > 0L) {
            l = this.skip(this.m_remaining);
            while (this.m_remaining > 0L && l > 0L) {
                l = this.skip(this.m_remaining);
            }
        }
    }

    @Override
    public int available() {
        return this.m_remaining > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.m_remaining;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int n) {
    }

    @Override
    public synchronized void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        int n = -1;
        if (this.m_remaining > 0L && (n = this.in.read()) != -1) {
            --this.m_remaining;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        if (this.m_remaining > 0L && (n3 = this.in.read(byArray, n, (int)Math.min((long)n2, this.m_remaining))) > 0) {
            this.m_remaining -= (long)n3;
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        if (this.m_remaining > 0L) {
            l2 = this.in.skip(Math.min(l, this.m_remaining));
            this.m_remaining -= l2;
        }
        return l2;
    }
}

