import { HasProps } from "../core/has_props";
import { Color, Arrayable } from "../core/types";
import { Class } from "../core/class";
import { Vector } from "../core/vectorization";
import { VectorSpec, ScalarSpec, ColorSpec, UnitsSpec, Property } from "../core/properties";
import { RenderLevel } from "../core/enums";
import * as nd from "../core/util/ndarray";
import { Glyph, GlyphRenderer, ColumnarDataSource, CDSView, CoordinateMapping } from "./models";
import { AnnularWedge, Annulus, Arc, Bezier, Block, Circle, Ellipse, HArea, HBar, HexTile, Image, ImageRGBA, ImageURL, Line, MultiLine, MultiPolygons, Patch, Patches, Quad, Quadratic, Ray, Rect, Scatter, Segment, Spline, Step, Text, VArea, VBar, Wedge } from "../models/glyphs";
import { Marker } from "../models/glyphs/marker";
export declare type NamesOf<T extends HasProps> = (keyof T["properties"])[];
export declare type TypedGlyphRenderer<G extends Glyph> = GlyphRenderer & {
    glyph: G;
};
export declare type ColorNDArray = nd.Uint32Array1d | nd.Uint8Array1d | nd.Uint8Array2d | nd.FloatArray2d;
export declare type VectorArg<T> = T | Arrayable<T> | Vector<T>;
export declare type ColorArg = VectorArg<Color | null> | ColorNDArray;
export declare type AlphaArg = VectorArg<number>;
export declare type ColorAlpha = {
    color: ColorArg;
    selection_color: ColorArg;
    nonselection_color: ColorArg;
    hover_color: ColorArg;
    muted_color: ColorArg;
    alpha: AlphaArg;
    selection_alpha: AlphaArg;
    nonselection_alpha: AlphaArg;
    hover_alpha: AlphaArg;
    muted_alpha: AlphaArg;
};
export declare type AuxFill = {
    selection_fill_color: ColorArg;
    selection_fill_alpha: AlphaArg;
    nonselection_fill_color: ColorArg;
    nonselection_fill_alpha: AlphaArg;
    hover_fill_color: ColorArg;
    hover_fill_alpha: AlphaArg;
    muted_fill_color: ColorArg;
    muted_fill_alpha: AlphaArg;
};
export declare type AuxLine = {
    selection_line_color: ColorArg;
    selection_line_alpha: AlphaArg;
    nonselection_line_color: ColorArg;
    nonselection_line_alpha: AlphaArg;
    hover_line_color: ColorArg;
    hover_line_alpha: AlphaArg;
    muted_line_color: ColorArg;
    muted_line_alpha: AlphaArg;
};
export declare type AuxText = {
    selection_text_color: ColorArg;
    selection_text_alpha: AlphaArg;
    nonselection_text_color: ColorArg;
    nonselection_text_alpha: AlphaArg;
    hover_text_color: ColorArg;
    hover_text_alpha: AlphaArg;
    muted_text_color: ColorArg;
    muted_text_alpha: AlphaArg;
};
export declare type AuxGlyph = {
    source: ColumnarDataSource | ColumnarDataSource["data"];
    view: CDSView;
    legend_label: string;
    legend_field: string;
    legend_group: string;
    level: RenderLevel;
    name: string;
    visible: boolean;
    x_range_name: string;
    y_range_name: string;
    coordinates: CoordinateMapping | null;
};
export declare type ArgsOf<P> = {
    [K in keyof P]: (P[K] extends ColorSpec ? ColorArg : (P[K] extends VectorSpec<infer T, infer V> ? T | Arrayable<T> | V : (P[K] extends ScalarSpec<infer T, infer S> ? T | S : (P[K] extends Property<infer T> ? T : never))));
};
export declare type UnitsOf<P> = {
    [K in keyof P & string as `${K}_units`]: P[K] extends UnitsSpec<any, infer Units> ? Units : never;
};
export declare type GlyphArgs<P> = ArgsOf<P> & UnitsOf<P> & AuxGlyph & ColorAlpha;
export declare type AnnularWedgeArgs = GlyphArgs<AnnularWedge.Props> & AuxLine & AuxFill;
export declare type AnnulusArgs = GlyphArgs<Annulus.Props> & AuxLine & AuxFill;
export declare type ArcArgs = GlyphArgs<Arc.Props> & AuxLine;
export declare type BezierArgs = GlyphArgs<Bezier.Props> & AuxLine;
export declare type BlockArgs = GlyphArgs<Block.Props> & AuxLine & AuxFill;
export declare type CircleArgs = GlyphArgs<Circle.Props> & AuxLine & AuxFill;
export declare type EllipseArgs = GlyphArgs<Ellipse.Props> & AuxLine & AuxFill;
export declare type HAreaArgs = GlyphArgs<HArea.Props> & AuxFill;
export declare type HBarArgs = GlyphArgs<HBar.Props> & AuxLine & AuxFill;
export declare type HexTileArgs = GlyphArgs<HexTile.Props> & AuxLine & AuxFill;
export declare type ImageArgs = GlyphArgs<Image.Props>;
export declare type ImageRGBAArgs = GlyphArgs<ImageRGBA.Props>;
export declare type ImageURLArgs = GlyphArgs<ImageURL.Props>;
export declare type LineArgs = GlyphArgs<Line.Props> & AuxLine;
export declare type MarkerArgs = GlyphArgs<Marker.Props> & AuxLine & AuxFill;
export declare type MultiLineArgs = GlyphArgs<MultiLine.Props> & AuxLine;
export declare type MultiPolygonsArgs = GlyphArgs<MultiPolygons.Props> & AuxLine & AuxFill;
export declare type PatchArgs = GlyphArgs<Patch.Props> & AuxLine & AuxFill;
export declare type PatchesArgs = GlyphArgs<Patches.Props> & AuxLine & AuxFill;
export declare type QuadArgs = GlyphArgs<Quad.Props> & AuxLine & AuxFill;
export declare type QuadraticArgs = GlyphArgs<Quadratic.Props> & AuxLine;
export declare type RayArgs = GlyphArgs<Ray.Props> & AuxLine;
export declare type RectArgs = GlyphArgs<Rect.Props> & AuxLine & AuxFill;
export declare type ScatterArgs = GlyphArgs<Scatter.Props> & AuxLine & AuxFill;
export declare type SegmentArgs = GlyphArgs<Segment.Props> & AuxLine;
export declare type SplineArgs = GlyphArgs<Spline.Props> & AuxLine;
export declare type StepArgs = GlyphArgs<Step.Props> & AuxLine;
export declare type TextArgs = GlyphArgs<Text.Props> & AuxText;
export declare type VAreaArgs = GlyphArgs<VArea.Props> & AuxFill;
export declare type VBarArgs = GlyphArgs<VBar.Props> & AuxLine & AuxFill;
export declare type WedgeArgs = GlyphArgs<Wedge.Props> & AuxLine & AuxFill;
export declare abstract class GlyphAPI {
    abstract _glyph<G extends Glyph>(cls: Class<G>, positional: NamesOf<G>, args: unknown[], overrides?: object): TypedGlyphRenderer<G>;
    annular_wedge(args: Partial<AnnularWedgeArgs>): TypedGlyphRenderer<AnnularWedge>;
    annular_wedge(x: AnnularWedgeArgs["x"], y: AnnularWedgeArgs["y"], inner_radius: AnnularWedgeArgs["inner_radius"], outer_radius: AnnularWedgeArgs["outer_radius"], start_angle: AnnularWedgeArgs["start_angle"], end_angle: AnnularWedgeArgs["end_angle"], args?: Partial<AnnularWedgeArgs>): TypedGlyphRenderer<AnnularWedge>;
    annulus(args: Partial<AnnulusArgs>): TypedGlyphRenderer<Annulus>;
    annulus(x: AnnulusArgs["x"], y: AnnulusArgs["y"], inner_radius: AnnulusArgs["inner_radius"], outer_radius: AnnulusArgs["outer_radius"], args?: Partial<AnnulusArgs>): TypedGlyphRenderer<Annulus>;
    arc(args: Partial<ArcArgs>): TypedGlyphRenderer<Arc>;
    arc(x: ArcArgs["x"], y: ArcArgs["y"], radius: ArcArgs["radius"], start_angle: ArcArgs["start_angle"], end_angle: ArcArgs["end_angle"], args?: Partial<ArcArgs>): TypedGlyphRenderer<Arc>;
    bezier(args: Partial<BezierArgs>): TypedGlyphRenderer<Bezier>;
    bezier(x0: BezierArgs["x0"], y0: BezierArgs["y0"], x1: BezierArgs["x1"], y1: BezierArgs["y1"], cx0: BezierArgs["cx0"], cy0: BezierArgs["cy0"], cx1: BezierArgs["cx1"], cy1: BezierArgs["cy1"], args?: Partial<BezierArgs>): TypedGlyphRenderer<Bezier>;
    block(args: Partial<BlockArgs>): TypedGlyphRenderer<Block>;
    block(x0: BlockArgs["x"], y0: BlockArgs["y"], x1: BlockArgs["width"], y1: BlockArgs["height"], args?: Partial<BlockArgs>): TypedGlyphRenderer<Block>;
    circle(args: Partial<CircleArgs>): TypedGlyphRenderer<Circle>;
    circle(x: CircleArgs["x"], y: CircleArgs["y"], args?: Partial<CircleArgs>): TypedGlyphRenderer<Circle>;
    circle(...args: unknown[]): TypedGlyphRenderer<Circle>;
    ellipse(args: Partial<EllipseArgs>): TypedGlyphRenderer<Ellipse>;
    ellipse(x: EllipseArgs["x"], y: EllipseArgs["y"], width: EllipseArgs["width"], height: EllipseArgs["height"], args?: Partial<EllipseArgs>): TypedGlyphRenderer<Ellipse>;
    harea(args: Partial<HAreaArgs>): TypedGlyphRenderer<HArea>;
    harea(x1: HAreaArgs["x1"], x2: HAreaArgs["x2"], y: HAreaArgs["y"], args?: Partial<HAreaArgs>): TypedGlyphRenderer<HArea>;
    hbar(args: Partial<HBarArgs>): TypedGlyphRenderer<HBar>;
    hbar(y: HBarArgs["y"], height: HBarArgs["height"], right: HBarArgs["right"], left: HBarArgs["left"], args?: Partial<HBarArgs>): TypedGlyphRenderer<HBar>;
    hex_tile(args: Partial<HexTileArgs>): TypedGlyphRenderer<HexTile>;
    hex_tile(q: HexTileArgs["q"], r: HexTileArgs["r"], args?: Partial<HexTileArgs>): TypedGlyphRenderer<HexTile>;
    image(args: Partial<ImageArgs>): TypedGlyphRenderer<Image>;
    image(image: ImageArgs["image"], x: ImageArgs["x"], y: ImageArgs["y"], dw: ImageArgs["dw"], dh: ImageArgs["dh"], args?: Partial<ImageArgs>): TypedGlyphRenderer<Image>;
    image_rgba(args: Partial<ImageRGBAArgs>): TypedGlyphRenderer<ImageRGBA>;
    image_rgba(image: ImageRGBAArgs["image"], x: ImageRGBAArgs["x"], y: ImageRGBAArgs["y"], dw: ImageRGBAArgs["dw"], dh: ImageRGBAArgs["dh"], args?: Partial<ImageRGBAArgs>): TypedGlyphRenderer<ImageRGBA>;
    image_url(args: Partial<ImageURLArgs>): TypedGlyphRenderer<ImageURL>;
    image_url(url: ImageURLArgs["url"], x: ImageURLArgs["x"], y: ImageURLArgs["y"], w: ImageURLArgs["w"], h: ImageURLArgs["h"], args?: Partial<ImageURLArgs>): TypedGlyphRenderer<ImageURL>;
    line(args: Partial<LineArgs>): TypedGlyphRenderer<Line>;
    line(x: LineArgs["x"], y: LineArgs["y"], args?: Partial<LineArgs>): TypedGlyphRenderer<Line>;
    multi_line(args: Partial<MultiLineArgs>): TypedGlyphRenderer<MultiLine>;
    multi_line(xs: MultiLineArgs["xs"], ys: MultiLineArgs["ys"], args?: Partial<MultiLineArgs>): TypedGlyphRenderer<MultiLine>;
    multi_polygons(args: Partial<MultiPolygonsArgs>): TypedGlyphRenderer<MultiPolygons>;
    multi_polygons(xs: MultiPolygonsArgs["xs"], ys: MultiPolygonsArgs["ys"], args?: Partial<MultiPolygonsArgs>): TypedGlyphRenderer<MultiPolygons>;
    patch(args: Partial<PatchArgs>): TypedGlyphRenderer<Patch>;
    patch(x: PatchArgs["x"], y: PatchArgs["y"], args?: Partial<PatchArgs>): TypedGlyphRenderer<Patch>;
    patches(args: Partial<PatchesArgs>): TypedGlyphRenderer<Patches>;
    patches(xs: PatchesArgs["xs"], ys: PatchesArgs["ys"], args?: Partial<PatchesArgs>): TypedGlyphRenderer<Patches>;
    quad(args: Partial<QuadArgs>): TypedGlyphRenderer<Quad>;
    quad(left: QuadArgs["left"], right: QuadArgs["right"], bottom: QuadArgs["bottom"], top: QuadArgs["top"], args?: Partial<QuadArgs>): TypedGlyphRenderer<Quad>;
    quadratic(args: Partial<QuadraticArgs>): TypedGlyphRenderer<Quadratic>;
    quadratic(x0: QuadraticArgs["x0"], y0: QuadraticArgs["y0"], x1: QuadraticArgs["x1"], y1: QuadraticArgs["y1"], cx: QuadraticArgs["cx"], cy: QuadraticArgs["cy"], args?: Partial<QuadraticArgs>): TypedGlyphRenderer<Quadratic>;
    ray(args: Partial<RayArgs>): TypedGlyphRenderer<Ray>;
    ray(x: RayArgs["x"], y: RayArgs["y"], length: RayArgs["length"], args?: Partial<RayArgs>): TypedGlyphRenderer<Ray>;
    rect(args: Partial<RectArgs>): TypedGlyphRenderer<Rect>;
    rect(x: RectArgs["x"], y: RectArgs["y"], width: RectArgs["width"], height: RectArgs["height"], args?: Partial<RectArgs>): TypedGlyphRenderer<Rect>;
    segment(args: Partial<SegmentArgs>): TypedGlyphRenderer<Segment>;
    segment(x0: SegmentArgs["x0"], y0: SegmentArgs["y0"], x1: SegmentArgs["x1"], y1: SegmentArgs["y1"], args?: Partial<SegmentArgs>): TypedGlyphRenderer<Segment>;
    spline(args: Partial<SplineArgs>): TypedGlyphRenderer<Spline>;
    spline(x: SplineArgs["x"], y: SplineArgs["y"], args?: Partial<SplineArgs>): TypedGlyphRenderer<Spline>;
    step(args: Partial<StepArgs>): TypedGlyphRenderer<Step>;
    step(x: StepArgs["x"], y: StepArgs["y"], mode: StepArgs["mode"], args?: Partial<StepArgs>): TypedGlyphRenderer<Step>;
    text(args: Partial<TextArgs>): TypedGlyphRenderer<Text>;
    text(x: TextArgs["x"], y: TextArgs["y"], text: TextArgs["text"], args?: Partial<TextArgs>): TypedGlyphRenderer<Text>;
    varea(args: Partial<VAreaArgs>): TypedGlyphRenderer<VArea>;
    varea(x: VAreaArgs["x"], y1: VAreaArgs["y1"], y2: VAreaArgs["y2"], args?: Partial<VAreaArgs>): TypedGlyphRenderer<VArea>;
    vbar(args: Partial<VBarArgs>): TypedGlyphRenderer<VBar>;
    vbar(x: VBarArgs["x"], width: VBarArgs["width"], top: VBarArgs["top"], bottom: VBarArgs["bottom"], args?: Partial<VBarArgs>): TypedGlyphRenderer<VBar>;
    wedge(args: Partial<WedgeArgs>): TypedGlyphRenderer<Wedge>;
    wedge(x: WedgeArgs["x"], y: WedgeArgs["y"], radius: WedgeArgs["radius"], start_angle: WedgeArgs["start_angle"], end_angle: WedgeArgs["end_angle"], args?: Partial<WedgeArgs>): TypedGlyphRenderer<Wedge>;
    private _scatter;
    scatter(args: Partial<ScatterArgs>): TypedGlyphRenderer<Scatter>;
    scatter(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<ScatterArgs>): TypedGlyphRenderer<Scatter>;
    asterisk(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    asterisk(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    circle_cross(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    circle_cross(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    circle_dot(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    circle_dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    circle_x(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    circle_x(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    circle_y(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    circle_y(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    cross(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    cross(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    dash(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    dash(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    diamond(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    diamond(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    diamond_cross(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    diamond_cross(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    diamond_dot(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    diamond_dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    dot(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    hex(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    hex(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    hex_dot(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    hex_dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    inverted_triangle(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    inverted_triangle(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    plus(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    plus(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    square(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    square(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    square_cross(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    square_cross(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    square_dot(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    square_dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    square_pin(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    square_pin(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    square_x(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    square_x(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    star(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    star(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    star_dot(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    star_dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    triangle(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    triangle(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    triangle_dot(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    triangle_dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    triangle_pin(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    triangle_pin(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    x(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    x(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    y(args: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
    y(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): TypedGlyphRenderer<Scatter>;
}
//# sourceMappingURL=glyph_api.d.ts.map