/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.core.CoreDescriptor;

class ZkCollectionTerms
implements AutoCloseable {
    private final String collection;
    private final Map<String, ZkShardTerms> terms;
    private final SolrZkClient zkClient;

    ZkCollectionTerms(String collection, SolrZkClient client) {
        this.collection = collection;
        this.terms = new HashMap<String, ZkShardTerms>();
        this.zkClient = client;
        assert (ObjectReleaseTracker.track((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZkShardTerms getShard(String shardId) {
        Map<String, ZkShardTerms> map = this.terms;
        synchronized (map) {
            if (!this.terms.containsKey(shardId)) {
                this.terms.put(shardId, new ZkShardTerms(this.collection, shardId, this.zkClient));
            }
            return this.terms.get(shardId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String shardId, String coreNodeName) {
        Map<String, ZkShardTerms> map = this.terms;
        synchronized (map) {
            this.getShard(shardId).registerTerm(coreNodeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String shardId, CoreDescriptor coreDescriptor) {
        Map<String, ZkShardTerms> map = this.terms;
        synchronized (map) {
            if (this.getShard(shardId).removeTerm(coreDescriptor)) {
                this.terms.remove(shardId).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<String, ZkShardTerms> map = this.terms;
        synchronized (map) {
            this.terms.values().forEach(ZkShardTerms::close);
        }
        assert (ObjectReleaseTracker.release((Object)this));
    }
}

