/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.api.collections.AddReplicaCmd;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.cloud.api.collections.CreateCollectionCmd;
import org.apache.solr.cloud.api.collections.DeleteCollectionCmd;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.solr.util.TimeOut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public MigrateCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
        String targetCollectionName;
        String sourceCollectionName;
        String extSourceCollectionName = message.getStr("collection");
        String splitKey = message.getStr("split.key");
        String extTargetCollectionName = message.getStr("target.collection");
        int timeout = message.getInt("forward.timeout", Integer.valueOf(600)) * 1000;
        boolean followAliases = message.getBool("followAliases", false);
        if (followAliases) {
            sourceCollectionName = this.ccc.getSolrCloudManager().getClusterStateProvider().resolveSimpleAlias(extSourceCollectionName);
            targetCollectionName = this.ccc.getSolrCloudManager().getClusterStateProvider().resolveSimpleAlias(extTargetCollectionName);
        } else {
            sourceCollectionName = extSourceCollectionName;
            targetCollectionName = extTargetCollectionName;
        }
        DocCollection sourceCollection = clusterState.getCollection(sourceCollectionName);
        if (sourceCollection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown source collection: " + sourceCollectionName);
        }
        DocCollection targetCollection = clusterState.getCollection(targetCollectionName);
        if (targetCollection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown target collection: " + sourceCollectionName);
        }
        if (!(sourceCollection.getRouter() instanceof CompositeIdRouter)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source collection must use a compositeId router");
        }
        if (!(targetCollection.getRouter() instanceof CompositeIdRouter)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target collection must use a compositeId router");
        }
        if (splitKey == null || splitKey.trim().length() == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key cannot be null or empty");
        }
        CompositeIdRouter sourceRouter = (CompositeIdRouter)sourceCollection.getRouter();
        CompositeIdRouter targetRouter = (CompositeIdRouter)targetCollection.getRouter();
        Collection sourceSlices = sourceRouter.getSearchSlicesSingle(splitKey, null, sourceCollection);
        if (sourceSlices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active slices available in source collection: " + sourceCollection + "for given split.key: " + splitKey);
        }
        Collection targetSlices = targetRouter.getSearchSlicesSingle(splitKey, null, targetCollection);
        if (targetSlices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active slices available in target collection: " + targetCollection + "for given split.key: " + splitKey);
        }
        String asyncId = null;
        if (message.containsKey("async") && message.get("async") != null) {
            asyncId = message.getStr("async");
        }
        for (Slice sourceSlice : sourceSlices) {
            for (Slice targetSlice : targetSlices) {
                log.info("Migrating source shard: {} to target shard: {} for split.key = {}", new Object[]{sourceSlice, targetSlice, splitKey});
                this.migrateKey(clusterState, sourceCollection, sourceSlice, targetCollection, targetSlice, splitKey, timeout, results, asyncId, message);
            }
        }
    }

    private void migrateKey(ClusterState clusterState, DocCollection sourceCollection, Slice sourceSlice, DocCollection targetCollection, Slice targetSlice, String splitKey, int timeout, NamedList<Object> results, String asyncId, ZkNodeProps message) throws Exception {
        String tempSourceCollectionName = "split_" + sourceSlice.getName() + "_temp_" + targetSlice.getName();
        ZkStateReader zkStateReader = this.ccc.getZkStateReader();
        if (clusterState.hasCollection(tempSourceCollectionName)) {
            log.info("Deleting temporary collection: {}", (Object)tempSourceCollectionName);
            Map<String, CallSite> props = Map.of("operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", tempSourceCollectionName);
            try {
                new DeleteCollectionCmd(this.ccc).call(zkStateReader.getClusterState(), new ZkNodeProps(props), results);
                clusterState = zkStateReader.getClusterState();
            }
            catch (Exception e) {
                log.warn("Unable to clean up existing temporary collection: {}", (Object)tempSourceCollectionName, (Object)e);
            }
        }
        CompositeIdRouter sourceRouter = (CompositeIdRouter)sourceCollection.getRouter();
        DocRouter.Range keyHashRange = sourceRouter.keyHashRange(splitKey);
        ShardHandler shardHandler = this.ccc.newShardHandler();
        log.info("Hash range for split.key: {} is: {}", (Object)splitKey, (Object)keyHashRange);
        DocRouter.Range splitRange = this.intersect(targetSlice.getRange(), this.intersect(sourceSlice.getRange(), keyHashRange));
        if (splitRange == null) {
            if (log.isInfoEnabled()) {
                log.info("No common hashes between source shard: {} and target shard: {}", (Object)sourceSlice.getName(), (Object)targetSlice.getName());
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Common hash range between source shard: {} and target shard: {} = {}", new Object[]{sourceSlice.getName(), targetSlice.getName(), splitRange});
        }
        Replica targetLeader = zkStateReader.getLeaderRetry(targetCollection.getName(), targetSlice.getName(), 10000);
        if (log.isInfoEnabled()) {
            log.info("Asking target leader node: {} core: {} to buffer updates", (Object)targetLeader.getNodeName(), (Object)targetLeader.getStr("core"));
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTBUFFERUPDATES.toString()});
        params.set("name", new String[]{targetLeader.getStr("core")});
        CollectionHandlingUtils.ShardRequestTracker shardRequestTracker = CollectionHandlingUtils.asyncRequestTracker(asyncId, this.ccc);
        shardRequestTracker.sendShardRequest(targetLeader.getNodeName(), params, shardHandler);
        shardRequestTracker.processResponses(results, shardHandler, true, "MIGRATE failed to request node to buffer updates");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", OverseerAction.ADDROUTINGRULE.toLower(), "collection", sourceCollection.getName(), "shard", sourceSlice.getName(), "routeKey", SolrIndexSplitter.getRouteKey(splitKey) + "!", "range", splitRange.toString(), "targetCollection", targetCollection.getName(), "expireAt", RoutingRule.makeExpiryAt((long)timeout)});
        log.info("Adding routing rule: {}", (Object)m);
        if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
            this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.SliceAddRoutingRule, m, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
        } else {
            this.ccc.offerStateUpdate(Utils.toJSON((Object)m));
        }
        log.info("Waiting to see routing rule updated in clusterstate");
        TimeOut waitUntil = new TimeOut(60L, TimeUnit.SECONDS, this.ccc.getSolrCloudManager().getTimeSource());
        boolean added = false;
        while (!waitUntil.hasTimedOut()) {
            RoutingRule rule;
            waitUntil.sleep(100L);
            sourceCollection = zkStateReader.getClusterState().getCollection(sourceCollection.getName());
            sourceSlice = sourceCollection.getSlice(sourceSlice.getName());
            Map rules = sourceSlice.getRoutingRules();
            if (rules == null || (rule = (RoutingRule)rules.get(SolrIndexSplitter.getRouteKey(splitKey) + "!")) == null || !rule.getRouteRanges().contains(splitRange)) continue;
            added = true;
            break;
        }
        if (!added) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not add routing rule: " + m);
        }
        log.info("Routing rule added successfully");
        Replica sourceLeader = zkStateReader.getLeaderRetry(sourceCollection.getName(), sourceSlice.getName(), 10000);
        String configName = sourceCollection.getConfigName();
        Map<String, CallSite> props = Utils.makeMap((Object[])new Object[]{"operation", CollectionParams.CollectionAction.CREATE.toLower(), "name", tempSourceCollectionName, "nrtReplicas", 1, "numShards", 1, "collection.configName", configName, "createNodeSet", sourceLeader.getNodeName()});
        if (asyncId != null) {
            String internalAsyncId = asyncId + Math.abs(System.nanoTime());
            props.put("async", (CallSite)((Object)internalAsyncId));
        }
        log.info("Creating temporary collection: {}", (Object)props);
        new CreateCollectionCmd(this.ccc).call(clusterState, new ZkNodeProps((Map)props), results);
        clusterState = zkStateReader.getClusterState();
        Slice tempSourceSlice = (Slice)clusterState.getCollection(tempSourceCollectionName).getSlices().iterator().next();
        Replica tempSourceLeader = zkStateReader.getLeaderRetry(tempSourceCollectionName, tempSourceSlice.getName(), 120000);
        String tempCollectionReplica1 = tempSourceLeader.getCoreName();
        String coreNodeName = CollectionHandlingUtils.waitForCoreNodeName(tempSourceCollectionName, sourceLeader.getNodeName(), tempCollectionReplica1, this.ccc.getZkStateReader());
        if (log.isInfoEnabled()) {
            log.info("Asking source leader to wait for: {} to be alive on: {}", (Object)tempCollectionReplica1, (Object)sourceLeader.getNodeName());
        }
        CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
        cmd.setCoreName(tempCollectionReplica1);
        cmd.setNodeName(sourceLeader.getNodeName());
        cmd.setCoreNodeName(coreNodeName);
        cmd.setState(Replica.State.ACTIVE);
        cmd.setCheckLive(Boolean.valueOf(true));
        cmd.setOnlyIfLeader(true);
        CollectionHandlingUtils.ShardRequestTracker syncRequestTracker = CollectionHandlingUtils.syncRequestTracker(this.ccc);
        syncRequestTracker.sendShardRequest(tempSourceLeader.getNodeName(), new ModifiableSolrParams(cmd.getParams()), shardHandler);
        syncRequestTracker.processResponses(results, shardHandler, true, "MIGRATE failed to create temp collection leader or timed out waiting for it to come up");
        log.info("Asking source leader to split index");
        params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.SPLIT.toString()});
        params.set("core", new String[]{sourceLeader.getStr("core")});
        params.add("targetCore", new String[]{tempSourceLeader.getStr("core")});
        params.set("ranges", new String[]{splitRange.toString()});
        params.set("split.key", new String[]{splitKey});
        String tempNodeName = sourceLeader.getNodeName();
        CollectionHandlingUtils.ShardRequestTracker shardRequestTracker2 = CollectionHandlingUtils.asyncRequestTracker(asyncId, this.ccc);
        shardRequestTracker2.sendShardRequest(tempNodeName, params, shardHandler);
        shardRequestTracker2.processResponses(results, shardHandler, true, "MIGRATE failed to invoke SPLIT core admin command");
        if (log.isInfoEnabled()) {
            log.info("Creating a replica of temporary collection: {} on the target leader node: {}", (Object)tempSourceCollectionName, (Object)targetLeader.getNodeName());
        }
        String tempCollectionReplica2 = Assign.buildSolrCoreName(this.ccc.getSolrCloudManager().getDistribStateManager(), zkStateReader.getClusterState().getCollection(tempSourceCollectionName), tempSourceSlice.getName(), Replica.Type.NRT);
        props = new HashMap<String, CallSite>();
        props.put("operation", (CallSite)((Object)CollectionParams.CollectionAction.ADDREPLICA.toLower()));
        props.put("collection", (CallSite)((Object)tempSourceCollectionName));
        props.put("shard", (CallSite)((Object)tempSourceSlice.getName()));
        props.put("node", (CallSite)((Object)targetLeader.getNodeName()));
        props.put("name", (CallSite)((Object)tempCollectionReplica2));
        for (String key : message.keySet()) {
            if (!key.startsWith("property.")) continue;
            props.put(key, (CallSite)((Object)message.getStr(key)));
        }
        if (asyncId != null) {
            props.put("async", (CallSite)((Object)asyncId));
        }
        new AddReplicaCmd(this.ccc).addReplica(clusterState, new ZkNodeProps(props), results, null);
        CollectionHandlingUtils.ShardRequestTracker syncRequestTracker2 = CollectionHandlingUtils.syncRequestTracker(this.ccc);
        syncRequestTracker2.processResponses(results, shardHandler, true, "MIGRATE failed to create replica of temporary collection in target leader node.");
        coreNodeName = CollectionHandlingUtils.waitForCoreNodeName(tempSourceCollectionName, targetLeader.getNodeName(), tempCollectionReplica2, this.ccc.getZkStateReader());
        if (log.isInfoEnabled()) {
            log.info("Asking temp source leader to wait for: {} to be alive on: {}", (Object)tempCollectionReplica2, (Object)targetLeader.getNodeName());
        }
        cmd = new CoreAdminRequest.WaitForState();
        cmd.setCoreName(tempSourceLeader.getStr("core"));
        cmd.setNodeName(targetLeader.getNodeName());
        cmd.setCoreNodeName(coreNodeName);
        cmd.setState(Replica.State.ACTIVE);
        cmd.setCheckLive(Boolean.valueOf(true));
        cmd.setOnlyIfLeader(true);
        params = new ModifiableSolrParams(cmd.getParams());
        CollectionHandlingUtils.ShardRequestTracker shardRequestTracker3 = CollectionHandlingUtils.asyncRequestTracker(asyncId, this.ccc);
        shardRequestTracker3.sendShardRequest(tempSourceLeader.getNodeName(), params, shardHandler);
        shardRequestTracker3.processResponses(results, shardHandler, true, "MIGRATE failed to create temp collection replica or timed out waiting for them to come up");
        log.info("Successfully created replica of temp source collection on target leader node");
        log.info("Requesting merge of temp source collection replica to target leader");
        params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.MERGEINDEXES.toString()});
        params.set("core", new String[]{targetLeader.getStr("core")});
        params.set("srcCore", new String[]{tempCollectionReplica2});
        shardRequestTracker3 = CollectionHandlingUtils.asyncRequestTracker(asyncId, this.ccc);
        shardRequestTracker3.sendShardRequest(targetLeader.getNodeName(), params, shardHandler);
        String msg = "MIGRATE failed to merge " + tempCollectionReplica2 + " to " + targetLeader.getStr("core") + " on node: " + targetLeader.getNodeName();
        shardRequestTracker3.processResponses(results, shardHandler, true, msg);
        log.info("Asking target leader to apply buffered updates");
        params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString()});
        params.set("name", new String[]{targetLeader.getStr("core")});
        shardRequestTracker3 = CollectionHandlingUtils.asyncRequestTracker(asyncId, this.ccc);
        shardRequestTracker3.sendShardRequest(targetLeader.getNodeName(), params, shardHandler);
        shardRequestTracker3.processResponses(results, shardHandler, true, "MIGRATE failed to request node to apply buffered updates");
        try {
            log.info("Deleting temporary collection: {}", (Object)tempSourceCollectionName);
            props = Map.of("operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", tempSourceCollectionName);
            new DeleteCollectionCmd(this.ccc).call(zkStateReader.getClusterState(), new ZkNodeProps(props), results);
        }
        catch (Exception e) {
            log.error("Unable to delete temporary collection: {}. Please remove it manually", (Object)tempSourceCollectionName, (Object)e);
        }
    }

    DocRouter.Range intersect(DocRouter.Range a, DocRouter.Range b) {
        if (a == null || b == null || !a.overlaps(b)) {
            return null;
        }
        if (a.isSubsetOf(b)) {
            return a;
        }
        if (b.isSubsetOf(a)) {
            return b;
        }
        if (b.includes(a.max)) {
            return new DocRouter.Range(b.min, a.max);
        }
        return new DocRouter.Range(a.min, b.max);
    }
}

