/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.solr.core.PluginInfo;

public class MetricsConfig {
    private final PluginInfo[] metricReporters;
    private final Set<String> hiddenSysProps;
    private final PluginInfo counterSupplier;
    private final PluginInfo meterSupplier;
    private final PluginInfo timerSupplier;
    private final PluginInfo histogramSupplier;
    private final Object nullNumber;
    private final Object notANumber;
    private final Object nullString;
    private final Object nullObject;
    private final boolean enabled;
    private static final PluginInfo[] NO_OP_REPORTERS = new PluginInfo[0];
    public static final String NOOP_IMPL_CLASS = "__noop__";
    private static final PluginInfo NO_OP_PLUGIN = new PluginInfo("typeUnused", Collections.singletonMap("class", "__noop__"), null, null);

    private MetricsConfig(boolean enabled, PluginInfo[] metricReporters, Set<String> hiddenSysProps, PluginInfo counterSupplier, PluginInfo meterSupplier, PluginInfo timerSupplier, PluginInfo histogramSupplier, Object nullNumber, Object notANumber, Object nullString, Object nullObject) {
        this.enabled = enabled;
        this.metricReporters = metricReporters;
        this.hiddenSysProps = hiddenSysProps;
        this.counterSupplier = counterSupplier;
        this.meterSupplier = meterSupplier;
        this.timerSupplier = timerSupplier;
        this.histogramSupplier = histogramSupplier;
        this.nullNumber = nullNumber;
        this.notANumber = notANumber;
        this.nullString = nullString;
        this.nullObject = nullObject;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public PluginInfo[] getMetricReporters() {
        if (this.enabled) {
            return this.metricReporters;
        }
        return NO_OP_REPORTERS;
    }

    public Object getNullNumber() {
        return this.nullNumber;
    }

    public Object getNotANumber() {
        return this.notANumber;
    }

    public Object getNullString() {
        return this.nullString;
    }

    public Object getNullObject() {
        return this.nullObject;
    }

    public Set<String> getHiddenSysProps() {
        if (this.enabled) {
            return this.hiddenSysProps;
        }
        return Collections.emptySet();
    }

    public PluginInfo getCounterSupplier() {
        if (this.enabled) {
            return this.counterSupplier;
        }
        return NO_OP_PLUGIN;
    }

    public PluginInfo getMeterSupplier() {
        if (this.enabled) {
            return this.meterSupplier;
        }
        return NO_OP_PLUGIN;
    }

    public PluginInfo getTimerSupplier() {
        if (this.enabled) {
            return this.timerSupplier;
        }
        return NO_OP_PLUGIN;
    }

    public PluginInfo getHistogramSupplier() {
        if (this.enabled) {
            return this.histogramSupplier;
        }
        return NO_OP_PLUGIN;
    }

    public static class MetricsConfigBuilder {
        private PluginInfo[] metricReporterPlugins = new PluginInfo[0];
        private Set<String> hiddenSysProps = new HashSet<String>();
        private PluginInfo counterSupplier;
        private PluginInfo meterSupplier;
        private PluginInfo timerSupplier;
        private PluginInfo histogramSupplier;
        private Object nullNumber = null;
        private Object notANumber = null;
        private Object nullString = null;
        private Object nullObject = null;
        private boolean enabled = true;

        public MetricsConfigBuilder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public MetricsConfigBuilder setHiddenSysProps(Set<String> hiddenSysProps) {
            if (hiddenSysProps != null && !hiddenSysProps.isEmpty()) {
                this.hiddenSysProps.clear();
                this.hiddenSysProps.addAll(hiddenSysProps);
            }
            return this;
        }

        public MetricsConfigBuilder setMetricReporterPlugins(PluginInfo[] metricReporterPlugins) {
            this.metricReporterPlugins = metricReporterPlugins != null ? metricReporterPlugins : new PluginInfo[]{};
            return this;
        }

        public MetricsConfigBuilder setCounterSupplier(PluginInfo info) {
            this.counterSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setMeterSupplier(PluginInfo info) {
            this.meterSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setTimerSupplier(PluginInfo info) {
            this.timerSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setHistogramSupplier(PluginInfo info) {
            this.histogramSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setNullNumber(Object nullNumber) {
            this.nullNumber = nullNumber;
            return this;
        }

        public MetricsConfigBuilder setNotANumber(Object notANumber) {
            this.notANumber = notANumber;
            return this;
        }

        public MetricsConfigBuilder setNullString(Object nullString) {
            this.nullString = nullString;
            return this;
        }

        public MetricsConfigBuilder setNullObject(Object nullObject) {
            this.nullObject = nullObject;
            return this;
        }

        public MetricsConfig build() {
            return new MetricsConfig(this.enabled, this.metricReporterPlugins, this.hiddenSysProps, this.counterSupplier, this.meterSupplier, this.timerSupplier, this.histogramSupplier, this.nullNumber, this.notANumber, this.nullString, this.nullObject);
        }
    }
}

