/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup.repository;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.backup.repository.LocalFileSystemRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupRepositoryFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, PluginInfo> backupRepoPluginByName = new HashMap<String, PluginInfo>();
    private PluginInfo defaultBackupRepoPlugin = null;

    public BackupRepositoryFactory(PluginInfo[] backupRepoPlugins) {
        if (backupRepoPlugins != null) {
            for (int i = 0; i < backupRepoPlugins.length; ++i) {
                String name = backupRepoPlugins[i].name;
                boolean isDefault = backupRepoPlugins[i].isDefault();
                if (this.backupRepoPluginByName.containsKey(name)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Duplicate backup repository with name " + name);
                }
                if (isDefault) {
                    if (this.defaultBackupRepoPlugin != null) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "More than one backup repository is configured as default");
                    }
                    this.defaultBackupRepoPlugin = backupRepoPlugins[i];
                }
                this.backupRepoPluginByName.put(name, backupRepoPlugins[i]);
                log.info("Added backup repository with configuration params {}", (Object)backupRepoPlugins[i]);
            }
            if (backupRepoPlugins.length == 1) {
                this.defaultBackupRepoPlugin = backupRepoPlugins[0];
            }
            if (this.defaultBackupRepoPlugin != null) {
                log.info("Default configuration for backup repository is with configuration params {}", (Object)this.defaultBackupRepoPlugin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupRepository newInstance(SolrResourceLoader loader, String name) {
        Objects.requireNonNull(loader);
        Objects.requireNonNull(name);
        PluginInfo repo = Objects.requireNonNull(this.backupRepoPluginByName.get(name), "Could not find a backup repository with name " + name);
        BackupRepository result = loader.newInstance(repo.className, BackupRepository.class);
        if ("trackingBackupRepository".equals(name)) {
            NamedList<Object> namedList = repo.initArgs;
            synchronized (namedList) {
                if (repo.initArgs.get("factory") == null) {
                    repo.initArgs.add("factory", (Object)this);
                    repo.initArgs.add("loader", (Object)loader);
                }
            }
        }
        result.init(repo.initArgs);
        return result;
    }

    public BackupRepository newInstance(SolrResourceLoader loader) {
        if (this.defaultBackupRepoPlugin != null) {
            return this.newInstance(loader, this.defaultBackupRepoPlugin.name);
        }
        LocalFileSystemRepository repo = new LocalFileSystemRepository();
        repo.init(new NamedList());
        return repo;
    }
}

