/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.solr.handler.export.IntComp;
import org.apache.solr.handler.export.SortValue;

class StringValue
implements SortValue {
    private final SortedDocValues globalDocValues;
    private final OrdinalMap ordinalMap;
    private final String field;
    private final IntComp comp;
    protected LongValues toGlobal = LongValues.IDENTITY;
    protected SortedDocValues docValues;
    public int currentOrd;
    protected int lastDocID;
    private boolean present;
    private BytesRef lastBytes;
    private String lastString;
    private int lastOrd = -1;
    private int leafOrd = -1;

    public StringValue(SortedDocValues globalDocValues, String field, IntComp comp) {
        this.globalDocValues = globalDocValues;
        this.docValues = globalDocValues;
        this.ordinalMap = globalDocValues instanceof MultiDocValues.MultiSortedDocValues ? ((MultiDocValues.MultiSortedDocValues)globalDocValues).mapping : null;
        this.field = field;
        this.comp = comp;
        this.currentOrd = comp.resetValue();
        this.present = false;
    }

    public String getLastString() {
        return this.lastString;
    }

    public void setLastString(String lastString) {
        this.lastString = lastString;
    }

    @Override
    public StringValue copy() {
        StringValue copy = new StringValue(this.globalDocValues, this.field, this.comp);
        return copy;
    }

    @Override
    public void setCurrentValue(int docId) throws IOException {
        if (docId > this.docValues.docID()) {
            this.docValues.advance(docId);
        }
        if (docId == this.docValues.docID()) {
            this.present = true;
            this.currentOrd = this.docValues.ordValue();
        } else {
            this.present = false;
            this.currentOrd = -1;
        }
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public void setCurrentValue(SortValue sv) {
        StringValue v = (StringValue)sv;
        this.currentOrd = v.currentOrd;
        this.present = v.present;
        this.leafOrd = v.leafOrd;
        this.lastOrd = v.lastOrd;
        this.toGlobal = v.toGlobal;
    }

    @Override
    public Object getCurrentValue() throws IOException {
        assert (this.present);
        if (this.currentOrd != this.lastOrd) {
            this.lastBytes = this.docValues.lookupOrd(this.currentOrd);
            this.lastOrd = this.currentOrd;
            this.lastString = null;
        }
        return this.lastBytes;
    }

    @Override
    public void toGlobalValue(SortValue previousValue) {
        this.lastOrd = this.currentOrd;
        StringValue sv = (StringValue)previousValue;
        if (sv.lastOrd == this.currentOrd) {
            if (this.currentOrd != -1) {
                this.currentOrd = sv.currentOrd;
            }
        } else if (this.currentOrd > -1) {
            this.currentOrd = (int)this.toGlobal.get((long)this.currentOrd);
        }
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void setNextReader(LeafReaderContext context) throws IOException {
        this.leafOrd = context.ord;
        if (this.ordinalMap != null) {
            this.toGlobal = this.ordinalMap.getGlobalOrds(context.ord);
        }
        this.docValues = DocValues.getSorted((LeafReader)context.reader(), (String)this.field);
        this.lastDocID = 0;
    }

    @Override
    public void reset() {
        this.currentOrd = this.comp.resetValue();
        this.present = false;
        this.lastDocID = 0;
    }

    @Override
    public int compareTo(SortValue o) {
        StringValue sv = (StringValue)o;
        return this.comp.compare(this.currentOrd, sv.currentOrd);
    }

    public String toString() {
        return Integer.toString(this.currentOrd);
    }
}

