/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk9;

import org.apache.sis.util.resources.Errors;

public final class HexFormat {
    private static final HexFormat INSTANCE = new HexFormat();

    private HexFormat() {
    }

    public static HexFormat of() {
        return INSTANCE;
    }

    public byte[] parseHex(CharSequence charSequence) {
        int n = charSequence.length();
        if ((n & 1) != 0) {
            throw new IllegalArgumentException(Errors.format((short)118, "wkb"));
        }
        byte[] byArray = new byte[n >>> 1];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2 >>> 1] = (byte)(HexFormat.fromHexDigit(charSequence.charAt(n2++)) << 4 | HexFormat.fromHexDigit(charSequence.charAt(n2++)));
        }
        return byArray;
    }

    public static int fromHexDigit(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 65 && n <= 70) {
            return n - 55;
        }
        if (n >= 97 && n <= 102) {
            return n - 87;
        }
        throw new NumberFormatException(Errors.format((short)180, String.valueOf(n)));
    }
}

