/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.config.Field;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.WriteLimitReachedException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.odf.OpenDocumentContentParser;
import org.apache.tika.parser.odf.OpenDocumentMacroHandler;
import org.apache.tika.parser.odf.OpenDocumentManifestHandler;
import org.apache.tika.parser.odf.OpenDocumentMetaParser;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.EndDocumentShieldingContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenDocumentParser
extends AbstractParser {
    private static final long serialVersionUID = -6410276875438618287L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"vnd.sun.xml.writer"), MediaType.application((String)"vnd.oasis.opendocument.text"), MediaType.application((String)"vnd.oasis.opendocument.graphics"), MediaType.application((String)"vnd.oasis.opendocument.presentation"), MediaType.application((String)"vnd.oasis.opendocument.spreadsheet"), MediaType.application((String)"vnd.oasis.opendocument.chart"), MediaType.application((String)"vnd.oasis.opendocument.image"), MediaType.application((String)"vnd.oasis.opendocument.formula"), MediaType.application((String)"vnd.oasis.opendocument.text-master"), MediaType.application((String)"vnd.oasis.opendocument.text-web"), MediaType.application((String)"vnd.oasis.opendocument.text-template"), MediaType.application((String)"vnd.oasis.opendocument.graphics-template"), MediaType.application((String)"vnd.oasis.opendocument.presentation-template"), MediaType.application((String)"vnd.oasis.opendocument.spreadsheet-template"), MediaType.application((String)"vnd.oasis.opendocument.chart-template"), MediaType.application((String)"vnd.oasis.opendocument.image-template"), MediaType.application((String)"vnd.oasis.opendocument.formula-template"), MediaType.application((String)"x-vnd.oasis.opendocument.text"), MediaType.application((String)"x-vnd.oasis.opendocument.graphics"), MediaType.application((String)"x-vnd.oasis.opendocument.presentation"), MediaType.application((String)"x-vnd.oasis.opendocument.spreadsheet"), MediaType.application((String)"x-vnd.oasis.opendocument.chart"), MediaType.application((String)"x-vnd.oasis.opendocument.image"), MediaType.application((String)"x-vnd.oasis.opendocument.formula"), MediaType.application((String)"x-vnd.oasis.opendocument.text-master"), MediaType.application((String)"x-vnd.oasis.opendocument.text-web"), MediaType.application((String)"x-vnd.oasis.opendocument.text-template"), MediaType.application((String)"x-vnd.oasis.opendocument.graphics-template"), MediaType.application((String)"x-vnd.oasis.opendocument.presentation-template"), MediaType.application((String)"x-vnd.oasis.opendocument.spreadsheet-template"), MediaType.application((String)"x-vnd.oasis.opendocument.chart-template"), MediaType.application((String)"x-vnd.oasis.opendocument.image-template"), MediaType.application((String)"x-vnd.oasis.opendocument.formula-template"))));
    private static final String META_NAME = "meta.xml";
    private static final String MANIFEST_NAME = "META-INF/manifest.xml";
    private Parser meta = new OpenDocumentMetaParser();
    private Parser content = new OpenDocumentContentParser();
    private boolean extractMacros = false;

    public Parser getMetaParser() {
        return this.meta;
    }

    public void setMetaParser(Parser meta) {
        this.meta = meta;
    }

    public Parser getContentParser() {
        return this.content;
    }

    public void setContentParser(Parser content) {
        this.content = content;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler baseHandler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        EndDocumentShieldingContentHandler handler;
        block17: {
            EmbeddedDocumentUtil embeddedDocumentUtil = new EmbeddedDocumentUtil(context);
            ZipFile zipFile = null;
            ZipInputStream zipStream = null;
            if (stream instanceof TikaInputStream) {
                TikaInputStream tis = (TikaInputStream)stream;
                Object container = ((TikaInputStream)stream).getOpenContainer();
                if (container instanceof ZipFile) {
                    zipFile = (ZipFile)container;
                } else if (tis.hasFile()) {
                    zipFile = new ZipFile(tis.getFile());
                } else {
                    zipStream = new ZipInputStream(stream);
                }
            } else {
                zipStream = new ZipInputStream(stream);
            }
            XHTMLContentHandler xhtml = new XHTMLContentHandler(baseHandler, metadata);
            xhtml.startDocument();
            handler = new EndDocumentShieldingContentHandler((ContentHandler)xhtml);
            try {
                if (zipFile != null) {
                    try {
                        this.handleZipFile(zipFile, metadata, context, handler, embeddedDocumentUtil);
                        break block17;
                    }
                    finally {
                        zipFile.close();
                    }
                }
                try {
                    this.handleZipStream(zipStream, metadata, context, handler, embeddedDocumentUtil);
                }
                finally {
                    zipStream.close();
                }
            }
            catch (SAXException e) {
                if (e.getCause() != null && e.getCause() instanceof EncryptedDocumentException) {
                    throw (EncryptedDocumentException)e.getCause();
                }
                throw e;
            }
        }
        if (handler.getEndDocumentWasCalled()) {
            handler.reallyEndDocument();
        }
    }

    @Field
    public void setExtractMacros(boolean extractMacros) {
        this.extractMacros = extractMacros;
    }

    private void handleZipStream(ZipInputStream zipStream, Metadata metadata, ParseContext context, EndDocumentShieldingContentHandler handler, EmbeddedDocumentUtil embeddedDocumentUtil) throws IOException, TikaException, SAXException {
        ZipEntry entry = zipStream.getNextEntry();
        if (entry == null) {
            throw new IOException("No entries found in ZipInputStream");
        }
        ArrayList<SAXException> saxExceptions = new ArrayList<SAXException>();
        do {
            try {
                this.handleZipEntry(entry, zipStream, metadata, context, (ContentHandler)handler, embeddedDocumentUtil);
            }
            catch (SAXException e) {
                if (WriteLimitReachedException.isWriteLimitReached((Throwable)e)) {
                    throw e;
                }
                if (e.getCause() instanceof EncryptedDocumentException) {
                    throw (EncryptedDocumentException)e.getCause();
                }
                saxExceptions.add(e);
            }
        } while ((entry = zipStream.getNextEntry()) != null);
        if (saxExceptions.size() > 0) {
            throw (SAXException)saxExceptions.get(0);
        }
    }

    private void handleZipFile(ZipFile zipFile, Metadata metadata, ParseContext context, EndDocumentShieldingContentHandler handler, EmbeddedDocumentUtil embeddedDocumentUtil) throws IOException, TikaException, SAXException {
        ZipEntry entry = zipFile.getEntry(MANIFEST_NAME);
        if (entry != null) {
            this.handleZipEntry(entry, zipFile.getInputStream(entry), metadata, context, (ContentHandler)handler, embeddedDocumentUtil);
        }
        if ((entry = zipFile.getEntry(META_NAME)) != null) {
            this.handleZipEntry(entry, zipFile.getInputStream(entry), metadata, context, (ContentHandler)handler, embeddedDocumentUtil);
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (META_NAME.equals(entry.getName())) continue;
            this.handleZipEntry(entry, zipFile.getInputStream(entry), metadata, context, (ContentHandler)handler, embeddedDocumentUtil);
        }
    }

    private void handleZipEntry(ZipEntry entry, InputStream zip, Metadata metadata, ParseContext context, ContentHandler handler, EmbeddedDocumentUtil embeddedDocumentUtil) throws IOException, SAXException, TikaException {
        block23: {
            if (entry == null) {
                return;
            }
            if (entry.getName().contains("manifest.xml")) {
                try {
                    this.checkForEncryption(zip, context);
                }
                catch (SAXException e) {
                    if (e.getCause() == null || !(e.getCause() instanceof EncryptedDocumentException)) break block23;
                    throw e;
                }
            }
        }
        if (entry.getName().equals("mimetype")) {
            String type = IOUtils.toString((InputStream)zip, (Charset)StandardCharsets.UTF_8).trim();
            metadata.set("Content-Type", type);
        } else if (entry.getName().equals(META_NAME)) {
            this.meta.parse(zip, (ContentHandler)new DefaultHandler(), metadata, context);
        } else if (entry.getName().endsWith("content.xml")) {
            if (this.content instanceof OpenDocumentContentParser) {
                ((OpenDocumentContentParser)this.content).parseInternal(zip, handler, metadata, context);
            } else {
                this.content.parse(zip, handler, metadata, context);
            }
        } else if (entry.getName().endsWith("styles.xml")) {
            if (this.content instanceof OpenDocumentContentParser) {
                ((OpenDocumentContentParser)this.content).parseInternal(zip, handler, metadata, context);
            } else {
                this.content.parse(zip, handler, metadata, context);
            }
        } else {
            String embeddedName = entry.getName();
            if (embeddedName.contains("Thumbnails/") || embeddedName.contains("Pictures/")) {
                Metadata embeddedMetadata = new Metadata();
                TikaInputStream stream = TikaInputStream.get((InputStream)zip);
                embeddedMetadata.set("resourceName", entry.getName());
                if (embeddedName.startsWith("Thumbnails/")) {
                    embeddedMetadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.THUMBNAIL.toString());
                }
                if (embeddedName.contains("Pictures/")) {
                    embeddedMetadata.set("embeddedResourceType", TikaCoreProperties.EmbeddedResourceType.INLINE.toString());
                    MediaType embeddedMimeType = embeddedDocumentUtil.getDetector().detect((InputStream)stream, embeddedMetadata);
                    if (embeddedMimeType != null) {
                        embeddedMetadata.set("Content-Type", embeddedMimeType.toString());
                    }
                    stream.reset();
                }
                if (embeddedDocumentUtil.shouldParseEmbedded(embeddedMetadata)) {
                    embeddedDocumentUtil.parseEmbedded((InputStream)stream, (ContentHandler)new EmbeddedContentHandler(handler), embeddedMetadata, false);
                }
            } else if (this.extractMacros && embeddedName.contains("Basic/")) {
                this.maybeHandleMacro(zip, embeddedName, handler, context);
            }
        }
    }

    private void checkForEncryption(InputStream stream, ParseContext context) throws SAXException, TikaException, IOException {
        XMLReaderUtils.parseSAX((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler((ContentHandler)new EmbeddedContentHandler((ContentHandler)((Object)new OpenDocumentManifestHandler()))), (ParseContext)context);
    }

    private void maybeHandleMacro(InputStream is, String embeddedName, ContentHandler handler, ParseContext context) throws TikaException, IOException, SAXException {
        if (this.ignoreScriptFile(embeddedName)) {
            return;
        }
        Metadata embeddedMetadata = new Metadata();
        embeddedMetadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
        handler = new OpenDocumentMacroHandler((ContentHandler)handler, context);
        XMLReaderUtils.parseSAX((InputStream)new CloseShieldInputStream(is), (DefaultHandler)new OfflineContentHandler((ContentHandler)new EmbeddedContentHandler(handler)), (ParseContext)context);
    }

    private boolean ignoreScriptFile(String embeddedName) {
        if (embeddedName.contains("Basic/")) {
            if (embeddedName.contains("script-lb.xml")) {
                return true;
            }
            return embeddedName.contains("script-lc.xml");
        }
        return true;
    }
}

