/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.avatica.util.UnsynchronizedBuffer;

public class AvaticaUtils {
    private static final Map<Class, Class> BOX;
    private static final MethodHandle SET_LARGE_MAX_ROWS;
    private static final MethodHandle GET_LARGE_MAX_ROWS;
    private static final MethodHandle GET_LARGE_UPDATE_COUNT;
    private static final MethodHandle EXECUTE_LARGE_BATCH;
    private static final Set<String> UNIQUE_STRINGS;
    private static final ThreadLocal<byte[]> PER_THREAD_BUFFER;
    private static final int SKIP_BUFFER_SIZE = 4096;

    private AvaticaUtils() {
    }

    private static MethodHandle method(Class returnType, Class targetType, String name, Class ... argTypes) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findVirtual(targetType, name, MethodType.methodType(returnType, targetType, argTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void discard(Object o) {
    }

    public static <T> T remark(T remark) {
        return remark;
    }

    public static boolean upgrade(String remark) {
        AvaticaUtils.discard(remark);
        return false;
    }

    public static List<?> primitiveList(final Object array) {
        return new AbstractList<Object>(){

            @Override
            public Object get(int index) {
                return Array.get(array, index);
            }

            @Override
            public int size() {
                return Array.getLength(array);
            }
        };
    }

    public static String camelToUpper(String name) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buf.append('_');
            } else {
                c = Character.toUpperCase(c);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String toCamelCase(String name) {
        StringBuilder buf = new StringBuilder();
        int nextUpper = -1;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                nextUpper = i + 1;
                continue;
            }
            c = nextUpper == i ? Character.toUpperCase(c) : Character.toLowerCase(c);
            buf.append(c);
        }
        return buf.toString();
    }

    public static Class box(Class clazz) {
        if (clazz.isPrimitive()) {
            return BOX.get(clazz);
        }
        return clazz;
    }

    public static <T> T instantiatePlugin(Class<T> pluginClass, String className) {
        String right = null;
        String left = null;
        try {
            if (className.contains("#")) {
                int i = className.indexOf(35);
                left = className.substring(0, i);
                right = className.substring(i + 1);
                Class<?> clazz = Class.forName(left);
                Field field = clazz.getField(right);
                return pluginClass.cast(field.get(null));
            }
            Class<?> clazz = Class.forName(className);
            try {
                Field field = clazz.getField("INSTANCE");
                return pluginClass.cast(field.get(null));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!pluginClass.isAssignableFrom(clazz)) {
                    throw new RuntimeException("Property '" + className + "' not valid for plugin type " + pluginClass.getName());
                }
                return (T)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Property '" + className + "' not valid as '" + className + "' not found in the classpath", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Property '" + className + "' not valid as there is no '" + right + "' field in the class of '" + left + "'", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Property '" + className + "' not valid as " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Property '" + className + "' not valid as the default constructor is necessary, but not found in the class of '" + className + "'", e);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Property '" + className + "' not valid. The exception info here : " + e.getMessage(), e);
        }
    }

    public static String readFully(InputStream inputStream) throws IOException {
        return AvaticaUtils.readFully(inputStream, new UnsynchronizedBuffer(1024));
    }

    public static String readFully(InputStream inputStream, UnsynchronizedBuffer buffer) throws IOException {
        byte[] bytes = AvaticaUtils._readFully(inputStream, buffer);
        return new String(bytes, 0, bytes.length, StandardCharsets.UTF_8);
    }

    public static byte[] readFullyToBytes(InputStream inputStream) throws IOException {
        return AvaticaUtils.readFullyToBytes(inputStream, new UnsynchronizedBuffer(1024));
    }

    public static byte[] readFullyToBytes(InputStream inputStream, UnsynchronizedBuffer buffer) throws IOException {
        return AvaticaUtils._readFully(inputStream, buffer);
    }

    static byte[] _readFully(InputStream inputStream, UnsynchronizedBuffer buffer) throws IOException {
        int count;
        byte[] bytes = PER_THREAD_BUFFER.get();
        while ((count = inputStream.read(bytes, 0, bytes.length)) >= 0) {
            buffer.write(bytes, 0, count);
        }
        return buffer.toArray();
    }

    public static void skipFully(InputStream inputStream) throws IOException {
        byte[] temp = null;
        while (true) {
            int bytesRead;
            long bytesSkipped;
            if ((bytesSkipped = inputStream.skip(Long.MAX_VALUE)) != 0L) {
                continue;
            }
            if (temp == null) {
                temp = new byte[4096];
            }
            if ((bytesRead = inputStream.read(temp, 0, 4096)) < 0) break;
        }
    }

    public static void setLargeMaxRows(Statement statement, long n) throws SQLException {
        if (SET_LARGE_MAX_ROWS != null) {
            try {
                SET_LARGE_MAX_ROWS.invokeExact(n);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Error | RuntimeException | SQLException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        int i = (int)Math.max(Math.min(n, Integer.MAX_VALUE), Integer.MIN_VALUE);
        statement.setMaxRows(i);
    }

    public static long getLargeMaxRows(Statement statement) throws SQLException {
        if (GET_LARGE_MAX_ROWS != null) {
            try {
                return GET_LARGE_MAX_ROWS.invokeExact();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Error | RuntimeException | SQLException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return statement.getMaxRows();
    }

    public static long getLargeUpdateCount(Statement statement) throws SQLException {
        if (GET_LARGE_UPDATE_COUNT != null) {
            try {
                return GET_LARGE_UPDATE_COUNT.invokeExact();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Error | RuntimeException | SQLException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return statement.getUpdateCount();
    }

    public static long[] executeLargeBatch(Statement statement) throws SQLException {
        if (EXECUTE_LARGE_BATCH != null) {
            try {
                return EXECUTE_LARGE_BATCH.invokeExact();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Error | RuntimeException | SQLException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return AvaticaUtils.toLongs(statement.executeBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unique(String base) {
        Set<String> set = UNIQUE_STRINGS;
        synchronized (set) {
            String s = base;
            while (!UNIQUE_STRINGS.add(s)) {
                s = base + "_" + UNIQUE_STRINGS.size();
            }
            return s;
        }
    }

    public static int toSaturatedInt(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static int[] toSaturatedInts(long[] longs) {
        int[] ints = new int[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            ints[i] = AvaticaUtils.toSaturatedInt(longs[i]);
        }
        return ints;
    }

    public static long[] toLongs(int[] ints) {
        long[] longs = new long[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            longs[i] = ints[i];
        }
        return longs;
    }

    static {
        SET_LARGE_MAX_ROWS = AvaticaUtils.method(Void.TYPE, Statement.class, "setLargeMaxRows", Long.TYPE);
        GET_LARGE_MAX_ROWS = AvaticaUtils.method(Long.TYPE, Statement.class, "getLargeMaxRows", new Class[0]);
        GET_LARGE_UPDATE_COUNT = AvaticaUtils.method(Void.TYPE, Statement.class, "getLargeUpdateCount", new Class[0]);
        EXECUTE_LARGE_BATCH = AvaticaUtils.method(long[].class, Statement.class, "executeLargeBatch", new Class[0]);
        UNIQUE_STRINGS = new HashSet<String>();
        PER_THREAD_BUFFER = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[4096];
            }
        };
        BOX = new HashMap<Class, Class>();
        BOX.put(Boolean.TYPE, Boolean.class);
        BOX.put(Byte.TYPE, Byte.class);
        BOX.put(Character.TYPE, Character.class);
        BOX.put(Short.TYPE, Short.class);
        BOX.put(Integer.TYPE, Integer.class);
        BOX.put(Long.TYPE, Long.class);
        BOX.put(Float.TYPE, Float.class);
        BOX.put(Double.TYPE, Double.class);
    }
}

