/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.IntArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.carrot2.attrs.AttrComposite;
import org.carrot2.attrs.AttrObject;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.CompleteLabelFilter;
import org.carrot2.text.preprocessing.filter.GenitiveLabelFilter;
import org.carrot2.text.preprocessing.filter.MinLengthLabelFilter;
import org.carrot2.text.preprocessing.filter.NumericLabelFilter;
import org.carrot2.text.preprocessing.filter.QueryLabelFilter;
import org.carrot2.text.preprocessing.filter.StopLabelFilter;
import org.carrot2.text.preprocessing.filter.StopWordLabelFilter;

public class LabelFilterProcessor
extends AttrComposite {
    public QueryLabelFilter queryLabelFilter;
    public StopWordLabelFilter stopWordLabelFilter;
    public StopLabelFilter stopLabelFilter;
    public NumericLabelFilter numericLabelFilter;
    public CompleteLabelFilter completeLabelFilter;
    public MinLengthLabelFilter minLengthLabelFilter;
    public GenitiveLabelFilter genitiveLabelFilter;

    public LabelFilterProcessor() {
        this.attributes.register("queryLabelFilter", ((AttrObject.Builder)AttrObject.builder(QueryLabelFilter.class).label("Filters out labels consisting of query hint terms")).getset(() -> this.queryLabelFilter, v -> {
            this.queryLabelFilter = v;
        }).defaultValue(QueryLabelFilter::new));
        this.attributes.register("stopWordLabelFilter", ((AttrObject.Builder)AttrObject.builder(StopWordLabelFilter.class).label("Filters out labels starting or ending with ignorable words")).getset(() -> this.stopWordLabelFilter, v -> {
            this.stopWordLabelFilter = v;
        }).defaultValue(StopWordLabelFilter::new));
        this.attributes.register("stopLabelFilter", ((AttrObject.Builder)AttrObject.builder(StopLabelFilter.class).label("Filters out labels tagged ignorable by the lexical data filters")).getset(() -> this.stopLabelFilter, v -> {
            this.stopLabelFilter = v;
        }).defaultValue(StopLabelFilter::new));
        this.attributes.register("numericLabelFilter", ((AttrObject.Builder)AttrObject.builder(NumericLabelFilter.class).label("Filters out labels that start with numerics")).getset(() -> this.numericLabelFilter, v -> {
            this.numericLabelFilter = v;
        }).defaultValue(NumericLabelFilter::new));
        this.attributes.register("completeLabelFilter", ((AttrObject.Builder)AttrObject.builder(CompleteLabelFilter.class).label("Filters out labels that appear to be sub-sequences of other good candidate phrases")).getset(() -> this.completeLabelFilter, v -> {
            this.completeLabelFilter = v;
        }).defaultValue(CompleteLabelFilter::new));
        this.attributes.register("minLengthLabelFilter", ((AttrObject.Builder)AttrObject.builder(MinLengthLabelFilter.class).label("Filters out labels that are shorter than the provided threshold")).getset(() -> this.minLengthLabelFilter, v -> {
            this.minLengthLabelFilter = v;
        }).defaultValue(MinLengthLabelFilter::new));
        this.attributes.register("genitiveLabelFilter", ((AttrObject.Builder)AttrObject.builder(GenitiveLabelFilter.class).label("Filters out labels ending with Saxon Genitive ('s)")).getset(() -> this.genitiveLabelFilter, v -> {
            this.genitiveLabelFilter = v;
        }).defaultValue(GenitiveLabelFilter::new));
    }

    public void process(PreprocessingContext context) {
        int i;
        int wordCount = context.allWords.image.length;
        boolean[] acceptedStems = new boolean[context.allStems.image.length];
        boolean[] acceptedPhrases = new boolean[context.allPhrases.tf.length];
        Arrays.fill(acceptedStems, true);
        Arrays.fill(acceptedPhrases, true);
        Stream.of(this.minLengthLabelFilter, this.genitiveLabelFilter, this.queryLabelFilter, this.stopWordLabelFilter, this.numericLabelFilter, this.stopLabelFilter, this.completeLabelFilter).forEachOrdered(filter -> {
            if (filter != null && filter.isEnabled()) {
                filter.filter(context, acceptedStems, acceptedPhrases);
            }
        });
        IntArrayList acceptedFeatures = new IntArrayList(acceptedStems.length + acceptedPhrases.length);
        int[] mostFrequentOriginalWordIndex = context.allStems.mostFrequentOriginalWordIndex;
        for (i = 0; i < acceptedStems.length; ++i) {
            if (!acceptedStems[i]) continue;
            acceptedFeatures.add(mostFrequentOriginalWordIndex[i]);
        }
        for (i = 0; i < acceptedPhrases.length; ++i) {
            if (!acceptedPhrases[i]) continue;
            acceptedFeatures.add(i + wordCount);
        }
        context.allLabels.featureIndex = acceptedFeatures.toArray();
        LabelFilterProcessor.updateFirstPhraseIndex(context);
    }

    static void updateFirstPhraseIndex(PreprocessingContext context) {
        int wordCount = context.allWords.image.length;
        int[] labelsFeatureIndex = context.allLabels.featureIndex;
        int firstPhraseIndex = -1;
        for (int i = 0; i < labelsFeatureIndex.length; ++i) {
            if (labelsFeatureIndex[i] < wordCount) continue;
            firstPhraseIndex = i;
            break;
        }
        context.allLabels.firstPhraseIndex = firstPhraseIndex;
    }
}

