/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.xerial.snappy.PureJavaCrc32C;

final class SnappyFramed {
    public static final int COMPRESSED_DATA_FLAG = 0;
    public static final int UNCOMPRESSED_DATA_FLAG = 1;
    public static final int STREAM_IDENTIFIER_FLAG = 255;
    private static final int MASK_DELTA = -1568478504;
    public static final byte[] HEADER_BYTES = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};

    SnappyFramed() {
    }

    public static int maskedCrc32c(byte[] byArray) {
        return SnappyFramed.maskedCrc32c(byArray, 0, byArray.length);
    }

    public static int maskedCrc32c(byte[] byArray, int n, int n2) {
        PureJavaCrc32C pureJavaCrc32C = new PureJavaCrc32C();
        pureJavaCrc32C.update(byArray, n, n2);
        return SnappyFramed.mask(pureJavaCrc32C.getIntegerValue());
    }

    public static int mask(int n) {
        return (n >>> 15 | n << 17) + -1568478504;
    }

    static final int readBytes(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.remaining();
        int n3 = 0;
        n3 = n = readableByteChannel.read(byteBuffer);
        if (n < n2) {
            while (byteBuffer.remaining() != 0 && n != -1) {
                n = readableByteChannel.read(byteBuffer);
                if (n == -1) continue;
                n3 += n;
            }
        }
        if (n3 > 0) {
            byteBuffer.limit(byteBuffer.position());
        } else {
            byteBuffer.position(byteBuffer.limit());
        }
        return n3;
    }

    static int skip(ReadableByteChannel readableByteChannel, int n, ByteBuffer byteBuffer) throws IOException {
        if (n <= 0) {
            return 0;
        }
        int n2 = n;
        int n3 = 0;
        while (n2 > 0 && n3 != -1) {
            byteBuffer.clear();
            if (n2 < byteBuffer.capacity()) {
                byteBuffer.limit(n2);
            }
            if ((n3 = readableByteChannel.read(byteBuffer)) <= 0) continue;
            n2 -= n3;
        }
        byteBuffer.clear();
        return n - n2;
    }
}

