/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import javax.measure.Unit;
import org.apache.sis.util.Numbers;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;

public enum ElementKind {
    NAME,
    IDENTIFIER,
    NUMBER,
    INTEGER,
    UNIT,
    AXIS,
    CODE_LIST,
    PARAMETER,
    METHOD,
    DATUM,
    SCOPE,
    EXTENT,
    CITATION,
    REMARKS,
    ERROR;


    public static ElementKind forType(Class<?> clazz) {
        if (clazz != null) {
            if (Datum.class.isAssignableFrom(clazz)) {
                return DATUM;
            }
            if (OperationMethod.class.isAssignableFrom(clazz)) {
                return METHOD;
            }
            if (GeneralParameterValue.class.isAssignableFrom(clazz)) {
                return PARAMETER;
            }
            if (CoordinateSystemAxis.class.isAssignableFrom(clazz)) {
                return AXIS;
            }
            if (Identifier.class.isAssignableFrom(clazz)) {
                return IDENTIFIER;
            }
            if (Citation.class.isAssignableFrom(clazz)) {
                return CITATION;
            }
            if (CodeList.class.isAssignableFrom(clazz)) {
                return CODE_LIST;
            }
            if (Extent.class.isAssignableFrom(clazz)) {
                return EXTENT;
            }
            if (Unit.class.isAssignableFrom(clazz)) {
                return UNIT;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return Numbers.isInteger(clazz) ? INTEGER : NUMBER;
            }
        }
        return null;
    }
}

