/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import org.apache.sis.internal.util.AbstractMap;
import org.apache.sis.referencing.factory.sql.CloseableReference;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.TableInfo;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.IntegerList;
import org.opengis.referencing.operation.Projection;

final class AuthorityCodes
extends AbstractMap<String, String>
implements Serializable {
    private static final int MAX_CODE = 69999999;
    private static final int ALL = 0;
    private static final int ONE = 1;
    private final transient EPSGDataAccess factory;
    final Class<?> type;
    private final transient boolean isProjection;
    private final transient String[] sql = new String[2];
    private final transient Statement[] statements = new Statement[2];
    private transient ResultSet results;
    private transient IntegerList codes;

    AuthorityCodes(Connection connection, TableInfo tableInfo, Class<?> clazz, EPSGDataAccess ePSGDataAccess) throws SQLException {
        this.factory = ePSGDataAccess;
        StringBuilder stringBuilder = new StringBuilder(100);
        int n = stringBuilder.append("SELECT ").length();
        int n2 = stringBuilder.append(tableInfo.codeColumn).length();
        stringBuilder.append(" FROM ").append(tableInfo.table);
        Class<?> clazz2 = tableInfo.where(clazz, stringBuilder);
        int n3 = stringBuilder.length();
        if (tableInfo.showColumn != null) {
            stringBuilder.append(tableInfo.showColumn).append("<>0 AND ");
        }
        stringBuilder.append("DEPRECATED=0 ORDER BY ").append(tableInfo.codeColumn);
        this.sql[0] = ePSGDataAccess.translator.apply(stringBuilder.toString());
        stringBuilder.setLength(n3);
        if (tableInfo.nameColumn != null) {
            stringBuilder.replace(n, n2, tableInfo.nameColumn);
        }
        stringBuilder.append(tableInfo.codeColumn).append(" = ?");
        this.sql[1] = ePSGDataAccess.translator.apply(stringBuilder.toString());
        this.type = clazz2;
        this.isProjection = Projection.class.isAssignableFrom(clazz2);
    }

    final CloseableReference createReference() {
        return new CloseableReference(this, this.factory, this.statements);
    }

    private boolean filter(int n) throws SQLException {
        assert (Thread.holdsLock(this.factory));
        return !this.isProjection || this.factory.isProjection(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCodeAt(int n) throws SQLException {
        int n2;
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            int n3;
            if (this.codes == null) {
                this.codes = new IntegerList(100, 69999999);
                this.statements[0] = this.factory.connection.createStatement();
                this.results = this.statements[0].executeQuery(this.sql[0]);
                this.sql[0] = null;
            }
            if ((n3 = n - this.codes.size()) < 0) {
                n2 = this.codes.getInt(n);
            } else {
                ResultSet resultSet = this.results;
                if (resultSet == null) {
                    n2 = -1;
                } else {
                    do {
                        if (!resultSet.next()) {
                            this.results = null;
                            resultSet.close();
                            this.statements[0].close();
                            this.statements[0] = null;
                            return -1;
                        }
                        n2 = resultSet.getInt(1);
                        if (!this.filter(n2)) continue;
                        this.codes.addInt(n2);
                        --n3;
                    } while (n3 >= 0);
                }
            }
        }
        return n2;
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.getCodeAt(0) < 0;
        }
        catch (SQLException sQLException) {
            throw this.factoryFailure(sQLException);
        }
    }

    @Override
    public int size() {
        try {
            this.getCodeAt(Integer.MAX_VALUE);
        }
        catch (SQLException sQLException) {
            throw this.factoryFailure(sQLException);
        }
        return this.codes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String get(Object object) {
        int n;
        if (object == null) return null;
        if (object instanceof Number) {
            n = ((Number)object).intValue();
        } else {
            try {
                n = Integer.parseInt(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        try {
            EPSGDataAccess ePSGDataAccess = this.factory;
            synchronized (ePSGDataAccess) {
                if (!this.filter(n)) return null;
                PreparedStatement preparedStatement = (PreparedStatement)this.statements[1];
                if (preparedStatement == null) {
                    preparedStatement = this.factory.connection.prepareStatement(this.sql[1]);
                    this.statements[1] = preparedStatement;
                    this.sql[1] = null;
                }
                preparedStatement.setInt(1, n);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    String string;
                    do {
                        if (!resultSet.next()) return null;
                    } while ((string = resultSet.getString(1)) == null);
                    String string2 = string;
                    return string2;
                }
            }
        }
        catch (SQLException sQLException) {
            throw this.factoryFailure(sQLException);
        }
    }

    @Override
    public AbstractMap.EntryIterator<String, String> entryIterator() {
        return new AbstractMap.EntryIterator<String, String>(){
            private int index = -1;
            private int code;

            @Override
            protected boolean next() {
                try {
                    this.code = AuthorityCodes.this.getCodeAt(++this.index);
                }
                catch (SQLException sQLException) {
                    throw AuthorityCodes.this.factoryFailure(sQLException);
                }
                return this.code >= 0;
            }

            @Override
            protected String getKey() {
                return String.valueOf(this.code);
            }

            @Override
            protected String getValue() {
                return "";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AuthorityCodes[").append(this.type.getSimpleName());
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            if (this.codes != null) {
                stringBuilder.append(", size ").append(this.results != null ? ">= " : "= ").append(this.codes.size());
            }
        }
        return stringBuilder.append(']').toString();
    }

    private BackingStoreException factoryFailure(SQLException sQLException) {
        return new BackingStoreException(sQLException.getLocalizedMessage(), sQLException);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new LinkedHashMap<String, String>(this);
    }
}

