/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.Validator;
import org.apache.sis.internal.util.Cloner;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CorruptedObjectException;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;

final class SparseFeature
extends AbstractFeature
implements Cloneable {
    private static final long serialVersionUID = 2954323576287152427L;
    private static final byte VALUES = 0;
    private static final byte PROPERTIES = 1;
    private static final byte CORRUPTED = 2;
    private final Map<String, Integer> indices;
    private HashMap<Integer, Object> properties;
    private byte valuesKind;

    public SparseFeature(DefaultFeatureType defaultFeatureType) {
        super(defaultFeatureType);
        this.indices = defaultFeatureType.indices();
        this.properties = new HashMap();
    }

    private Integer getIndex(String string) throws IllegalArgumentException {
        Integer n = this.indices.get(string);
        if (n != null) {
            return n;
        }
        throw new IllegalArgumentException(SparseFeature.propertyNotFound(this.type, this.getName(), string));
    }

    private String nameOf(Integer n) {
        for (Map.Entry<String, Integer> entry : this.indices.entrySet()) {
            if (!n.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        throw new AssertionError(n);
    }

    private void requireMapOfProperties() {
        if (this.valuesKind != 1) {
            if (!this.properties.isEmpty()) {
                if (this.valuesKind != 0) {
                    throw new CorruptedObjectException(this.getName());
                }
                this.valuesKind = (byte)2;
                for (Map.Entry<Integer, Object> entry : this.properties.entrySet()) {
                    Object object;
                    String string;
                    if (entry.setValue(this.createProperty(string = this.nameOf(entry.getKey()), object = entry.getValue())) == object) continue;
                    throw new ConcurrentModificationException(string);
                }
            }
            this.valuesKind = 1;
        }
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("name", string);
        this.requireMapOfProperties();
        return this.getPropertyInstance(string);
    }

    private Property getPropertyInstance(String string) throws IllegalArgumentException {
        assert (this.valuesKind == 1) : this.valuesKind;
        Integer n = this.getIndex(string);
        if (n < 0) {
            return (Property)this.getOperationResult(string);
        }
        Property property = (Property)this.properties.get(n);
        if (property == null) {
            property = this.createProperty(string);
            this.replace(n, null, property);
        }
        return property;
    }

    @Override
    public void setProperty(Object object) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("property", object);
        String string = ((Property)object).getName().toString();
        this.verifyPropertyType(string, (Property)object);
        this.requireMapOfProperties();
        this.properties.put(this.indices.get(string), object);
    }

    @Override
    public Object getPropertyValue(String string) throws IllegalArgumentException {
        Object object = this.getValueOrFallback(string, MISSING);
        if (object != MISSING) {
            return object;
        }
        throw new IllegalArgumentException(SparseFeature.propertyNotFound(this.type, this.getName(), string));
    }

    @Override
    public final Object getValueOrFallback(String string, Object object) {
        ArgumentChecks.ensureNonNull("name", string);
        Integer n = this.indices.get(string);
        if (n == null) {
            return object;
        }
        if (n < 0) {
            return this.getOperationValue(string);
        }
        Object object2 = this.properties.get(n);
        if (object2 != null) {
            if (this.valuesKind == 0) {
                return object2;
            }
            if (object2 instanceof AbstractAttribute) {
                return SparseFeature.getAttributeValue((AbstractAttribute)object2);
            }
            if (object2 instanceof AbstractAssociation) {
                return SparseFeature.getAssociationValue((AbstractAssociation)object2);
            }
            if (this.valuesKind == 1) {
                throw new IllegalArgumentException(SparseFeature.unsupportedPropertyType(((Property)object2).getName()));
            }
            throw new CorruptedObjectException(this.getName());
        }
        if (this.properties.containsKey(n)) {
            return null;
        }
        return this.getDefaultValue(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPropertyValue(String string, Object object) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("name", string);
        Integer n = this.getIndex(string);
        if (n < 0) {
            this.setOperationValue(string, object);
            return;
        }
        if (this.valuesKind == 0) {
            Object object2 = this.properties.put(n, object);
            if (!SparseFeature.canSkipVerification(object2, object)) {
                Object object3 = object2;
                try {
                    object3 = this.verifyPropertyValue(string, object);
                }
                finally {
                    if (object3 != object) {
                        this.replace(n, object, object3);
                    }
                }
            }
        } else if (this.valuesKind == 1) {
            SparseFeature.setPropertyValue(this.getPropertyInstance(string), object);
        } else {
            throw new CorruptedObjectException(this.getName());
        }
    }

    private void replace(Integer n, Object object, Object object2) {
        if (this.properties.put(n, object2) != object) {
            throw new ConcurrentModificationException(this.nameOf(n));
        }
    }

    @Override
    public DataQuality quality() {
        if (this.valuesKind == 0) {
            Validator validator = new Validator(ScopeCode.FEATURE);
            for (Map.Entry<String, Integer> entry : this.indices.entrySet()) {
                validator.validateAny(this.type.getProperty(entry.getKey()), this.properties.get(entry.getValue()));
            }
            return validator.quality;
        }
        return super.quality();
    }

    public SparseFeature clone() throws CloneNotSupportedException {
        SparseFeature sparseFeature = (SparseFeature)super.clone();
        sparseFeature.properties = (HashMap)sparseFeature.properties.clone();
        switch (sparseFeature.valuesKind) {
            default: {
                throw new AssertionError(sparseFeature.valuesKind);
            }
            case 2: {
                throw new CorruptedObjectException(sparseFeature.getName());
            }
            case 0: {
                break;
            }
            case 1: {
                Cloner cloner = new Cloner();
                for (Map.Entry<Integer, Object> entry : sparseFeature.properties.entrySet()) {
                    Property property = (Property)entry.getValue();
                    if (!(property instanceof Cloneable)) continue;
                    entry.setValue(cloner.clone(property));
                }
            }
        }
        return sparseFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int n = this.type.hashCode() * 37;
        if (this.comparisonStart()) {
            try {
                if (this.valuesKind == 1) {
                    for (Map.Entry<Integer, Object> entry : this.properties.entrySet()) {
                        Object object = entry.getValue();
                        Object object2 = object instanceof AbstractAttribute ? SparseFeature.getAttributeValue((AbstractAttribute)object) : (object instanceof AbstractAssociation ? SparseFeature.getAssociationValue((AbstractAssociation)object) : null);
                        n += Objects.hashCode(entry.getKey()) ^ Objects.hashCode(object2);
                    }
                } else {
                    n += this.properties.hashCode();
                }
            }
            finally {
                this.comparisonEnd();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SparseFeature) {
            SparseFeature sparseFeature = (SparseFeature)object;
            if (this.type.equals(sparseFeature.type)) {
                boolean bl = this.valuesKind == 1;
                if (bl != (sparseFeature.valuesKind == 1)) {
                    if (bl) {
                        sparseFeature.requireMapOfProperties();
                    } else {
                        this.requireMapOfProperties();
                    }
                }
                if (this.comparisonStart()) {
                    try {
                        boolean bl2 = this.properties.equals(sparseFeature.properties);
                        return bl2;
                    }
                    finally {
                        this.comparisonEnd();
                    }
                }
                return true;
            }
        }
        return false;
    }
}

