/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security.jwt;

import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.http.util.Args;

public class JWTPrincipal
implements Principal {
    final String username;
    String token;
    Map<String, Object> claims;

    public JWTPrincipal(String username, String token, Map<String, Object> claims) {
        Args.notNull((Object)username, (String)"User name");
        Args.notNull((Object)token, (String)"JWT token");
        Args.notNull(claims, (String)"JWT claims");
        this.token = token;
        this.claims = claims;
        this.username = username;
    }

    @Override
    public String getName() {
        return this.username;
    }

    public String getToken() {
        return this.token;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTPrincipal that = (JWTPrincipal)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.token, that.token) && Objects.equals(this.claims, that.claims);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.username, this.token, this.claims);
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "JWTPrincipal{username='%s', token='*****', claims=%s}", this.username, this.claims);
    }
}

