/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MemoryFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Info,
AbstractFileSystem.Change,
AbstractFileSystem.List,
AbstractFileSystem.Attr {
    private static final Logger ERR = Logger.getLogger(MemoryFileSystem.class.getName());
    private Date created = new Date();
    private Map<String, Entry> entries = this.initEntry();

    private void _setSystemName(String string) throws PropertyVetoException {
        this.setSystemName(string);
    }

    public MemoryFileSystem() {
        this.attr = this;
        this.list = this;
        this.change = this;
        this.info = this;
        try {
            this._setSystemName("MemoryFileSystem" + String.valueOf(System.identityHashCode(this)));
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    public MemoryFileSystem(String[] stringArray) {
        this();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            this.getOrCreateEntry((String)stringArray[i]).data = (byte[])(stringArray[i].endsWith("/") ? null : new byte[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getOrCreateEntry(String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        boolean bl = this.isValidEntry(string);
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            Entry entry = this.entries.get(string);
            if (entry == null || !bl) {
                entry = new Entry(string);
                this.entries.put(string, entry);
            }
            return entry;
        }
    }

    private boolean isValidEntry(String string) {
        return this.isValidEntry(string, null);
    }

    private boolean isValidEntry(String string, Boolean bl) {
        Reference<? extends FileObject> reference;
        boolean bl2;
        boolean bl3 = bl2 = string.length() == 0;
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        Entry entry = this.entries.get(string);
        FileObject fileObject = null;
        if (entry != null && (reference = this.findReference(string)) != null) {
            fileObject = reference.get();
            boolean bl4 = bl2 = fileObject != null ? fileObject.isValid() : true;
        }
        if (ERR.isLoggable(Level.FINE) && bl != null && bl2 != bl) {
            MemoryFileSystem.logMessage("entry: " + entry + " isValidReference.fo: " + (fileObject == null ? "null" : (fileObject.isValid() ? "valid" : "invalid")));
        }
        return bl2;
    }

    @Override
    public String getDisplayName() {
        return "MemoryFileSystem";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Enumeration<String> attributes(String string) {
        if (!this.isValidEntry(string)) {
            return Enumerations.empty();
        }
        return Collections.enumeration(this.getOrCreateEntry((String)string).attrs.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] children(String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (string.length() > 0 && !string.endsWith("/")) {
            string = string + "/";
        }
        HashSet<String> hashSet = new HashSet<String>();
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            for (String string2 : this.entries.keySet()) {
                if (!string2.startsWith(string) && string.trim().length() != 0) continue;
                int n = string2.indexOf(47, string.length());
                String string3 = null;
                string3 = n > 0 ? string2.substring(string.length(), n) : string2.substring(string.length());
                if (string3.trim().length() <= 0) continue;
                hashSet.add(string3);
            }
            return hashSet.toArray(new String[0]);
        }
    }

    @Override
    public void createData(String string) throws IOException {
        if (this.isValidEntry(string, Boolean.FALSE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("File already exists: ").append(string);
            throw new IOException(stringBuffer.toString());
        }
        this.getOrCreateEntry((String)string).data = new byte[0];
    }

    @Override
    public void createFolder(String string) throws IOException {
        if (this.isValidEntry(string, Boolean.FALSE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Folder already exists: ").append(string);
            throw new IOException(stringBuffer.toString());
        }
        this.getOrCreateEntry((String)string).data = null;
    }

    @Override
    public void delete(String string) throws IOException {
        if (this.entries.remove(string) == null) {
            throw new IOException("No file to delete: " + string);
        }
    }

    @Override
    public void deleteAttributes(String string) {
    }

    @Override
    public boolean folder(String string) {
        return this.getOrCreateEntry((String)string).data == null;
    }

    @Override
    public InputStream inputStream(String string) throws FileNotFoundException {
        byte[] byArray = this.getOrCreateEntry((String)string).data;
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public Date lastModified(String string) {
        Date date = this.getOrCreateEntry((String)string).last;
        return date == null ? this.created : date;
    }

    @Override
    public void lock(String string) throws IOException {
    }

    @Override
    public void markUnimportant(String string) {
    }

    @Override
    public String mimeType(String string) {
        return (String)this.getOrCreateEntry((String)string).attrs.get("mimeType");
    }

    @Override
    public OutputStream outputStream(final String string) throws IOException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Out
        extends ByteArrayOutputStream {
            Out() {
            }

            @Override
            public void close() throws IOException {
                super.close();
                ((MemoryFileSystem)MemoryFileSystem.this).getOrCreateEntry((String)string).data = this.toByteArray();
                ((MemoryFileSystem)MemoryFileSystem.this).getOrCreateEntry((String)string).last = new Date();
            }
        }
        return new Out();
    }

    @Override
    public Object readAttribute(String string, String string2) {
        return this.isValidEntry(string) ? this.getOrCreateEntry((String)string).attrs.get(string2) : null;
    }

    @Override
    public boolean readOnly(String string) {
        return false;
    }

    @Override
    public void rename(String string, String string2) throws IOException {
        if (!this.isValidEntry(string)) {
            throw new IOException("The file to rename does not exist.");
        }
        if (this.isValidEntry(string2)) {
            throw new IOException("Cannot rename to existing file");
        }
        if (string2.length() > 0 && string2.charAt(0) == '/') {
            string2 = string2.substring(1);
        }
        Entry entry = this.getOrCreateEntry(string);
        this.entries.remove(string);
        this.entries.put(string2, entry);
    }

    @Override
    public void renameAttributes(String string, String string2) {
    }

    @Override
    public long size(String string) {
        byte[] byArray = this.getOrCreateEntry((String)string).data;
        return byArray == null ? 0L : (long)byArray.length;
    }

    @Override
    public void unlock(String string) {
    }

    @Override
    public void writeAttribute(String string, String string2, Object object) throws IOException {
        this.getOrCreateEntry((String)string).attrs.put(string2, object);
    }

    private Map<String, Entry> initEntry() {
        if (!ERR.isLoggable(Level.FINE)) {
            return new ConcurrentHashMap<String, Entry>();
        }
        return new ConcurrentHashMap<String, Entry>(){

            public Entry get(String string) {
                Entry entry = (Entry)super.get(string);
                MemoryFileSystem.logMessage("called: GET key: " + string + " result: " + entry);
                return entry;
            }

            @Override
            public Entry put(String string, Entry entry) {
                Entry entry2 = super.put(string, entry);
                MemoryFileSystem.logMessage("called: PUT key: " + string + " value: " + entry + " result: " + entry2);
                return entry2;
            }

            public Entry remove(String string) {
                Entry entry = (Entry)super.remove(string);
                MemoryFileSystem.logMessage("called: REMOVE key: " + string + " result: " + entry);
                return entry;
            }
        };
    }

    private static void logMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" -> ").append(string);
        ERR.fine(stringBuffer.toString());
    }

    static final class Entry {
        public Map<String, Object> attrs = new HashMap<String, Object>();
        public byte[] data;
        public Date last;
        private final String entryName;

        Entry(String string) {
            this.entryName = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" [").append(this.entryName);
            stringBuffer.append(" -> ").append(super.toString());
            stringBuffer.append("] ");
            return stringBuffer.toString();
        }
    }
}

