/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.CompressorIterator;
import com.sun.java.help.search.ConceptData;
import com.sun.java.help.search.Decompressor;
import com.sun.java.help.search.RoleFiller;

class ConceptGroupGenerator
implements CompressorIterator {
    private static final int NConceptsInGroup = 16;
    private static final int BitsInLabel = 4;
    private int _last;
    private ConceptData[] _table;
    private Decompressor _bits;
    private int _k1;
    private final int _k2 = 4;
    private ConceptData _cData;

    public ConceptGroupGenerator() {
        this._k1 = 0;
        this._table = new ConceptData[16];
        this._last = 0;
        this._bits = null;
    }

    public ConceptGroupGenerator(byte[] byArray, int n, int n2) {
        this._k1 = n2;
        this._table = new ConceptData[16];
        this._last = 0;
        this._bits = new ByteArrayDecompressor(byArray, n);
    }

    public void init(byte[] byArray, int n, int n2) {
        this._k1 = n2;
        this._bits = new ByteArrayDecompressor(byArray, n);
        this._last = 0;
        for (int i = 0; i < 16; ++i) {
            this._table[i] = null;
        }
    }

    public void addTerms(int n, ConceptData conceptData) {
        this._table[n] = conceptData;
    }

    public int decodeConcepts(int n, int n2, int[] nArray) throws Exception {
        return this._bits.ascendingDecode(n, n2, nArray);
    }

    public int position() {
        return this._last;
    }

    public void value(int n) {
        this._last += n;
    }

    boolean next() throws Exception {
        try {
            while (this._bits.readNext(this._k1, this)) {
                this._cData = this._table[this._bits.read(4)];
                if (this._cData == null) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(this._bits);
            System.err.println(this._table);
            throw exception;
        }
    }

    public void generateFillers(RoleFiller[] roleFillerArray) {
        this._cData.generateFillers(roleFillerArray, this._last);
    }
}

