/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.DefaultFontResolver;
import org.apache.fop.render.RendererContext;
import org.w3c.dom.Document;

public abstract class PrintRenderer
extends AbstractRenderer {
    protected FontInfo fontInfo;
    protected List fontList = null;

    public void setupFontInfo(FontInfo inFontInfo) {
        this.fontInfo = inFontInfo;
        DefaultFontResolver resolver = new DefaultFontResolver(this.userAgent);
        FontSetup.setup(this.fontInfo, this.fontList, resolver, this.userAgent.getFactory().isBase14KerningEnabled());
    }

    protected String getInternalFontNameForArea(Area area) {
        FontTriplet triplet = (FontTriplet)area.getTrait(Trait.FONT);
        return this.fontInfo.getInternalFontKey(triplet);
    }

    protected Font getFontFromArea(Area area) {
        FontTriplet triplet = (FontTriplet)area.getTrait(Trait.FONT);
        int size = (Integer)area.getTrait(Trait.FONT_SIZE);
        return this.fontInfo.getFontInstance(triplet, size);
    }

    public static Color lightenColor(Color col, float factor) {
        float[] cols = new float[4];
        cols = col.getRGBComponents(cols);
        if (factor > 0.0f) {
            cols[0] = (float)((double)cols[0] + (1.0 - (double)cols[0]) * (double)factor);
            cols[1] = (float)((double)cols[1] + (1.0 - (double)cols[1]) * (double)factor);
            cols[2] = (float)((double)cols[2] + (1.0 - (double)cols[2]) * (double)factor);
        } else {
            cols[0] = cols[0] - cols[0] * -factor;
            cols[1] = cols[1] - cols[1] * -factor;
            cols[2] = cols[2] - cols[2] * -factor;
        }
        return new Color(cols[0], cols[1], cols[2], cols[3]);
    }

    protected RendererContext createRendererContext(int x, int y, int width, int height, Map foreignAttributes) {
        RendererContext context = new RendererContext(this, this.getMimeType());
        context.setUserAgent(this.userAgent);
        context.setProperty("width", new Integer(width));
        context.setProperty("height", new Integer(height));
        context.setProperty("xpos", new Integer(x));
        context.setProperty("ypos", new Integer(y));
        context.setProperty("pageViewport", this.getCurrentPageViewport());
        if (foreignAttributes != null) {
            context.setProperty("foreign-attributes", foreignAttributes);
        }
        return context;
    }

    public void renderDocument(Document doc, String ns, Rectangle2D pos, Map foreignAttributes) {
        int x = this.currentIPPosition + (int)pos.getX();
        int y = this.currentBPPosition + (int)pos.getY();
        int width = (int)pos.getWidth();
        int height = (int)pos.getHeight();
        RendererContext context = this.createRendererContext(x, y, width, height, foreignAttributes);
        this.renderXML(context, doc, ns);
    }
}

