/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupOp;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.render.pcl.DefaultMonochromeBitmapConverter;
import org.apache.fop.render.pcl.MonochromeBitmapConverter;
import org.apache.fop.util.UnitConv;
import org.apache.xmlgraphics.image.GraphicsUtil;

public class PCLGenerator {
    public static final char ESC = '\u001b';
    public static final int[] PCL_RESOLUTIONS = new int[]{75, 100, 150, 200, 300, 600};
    public static final int DITHER_MATRIX_4X4 = 4;
    public static final int DITHER_MATRIX_8X8 = 8;
    private final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
    private final DecimalFormat df2 = new DecimalFormat("0.##", this.symbols);
    private final DecimalFormat df4 = new DecimalFormat("0.####", this.symbols);
    private OutputStream out;
    private boolean currentSourceTransparency = true;
    private boolean currentPatternTransparency = true;
    private int maxBitmapResolution = PCL_RESOLUTIONS[PCL_RESOLUTIONS.length - 1];
    private boolean usePCLShades = false;
    private static final int[] BAYER_D2 = new int[]{0, 2, 3, 1};
    private static final int[] BAYER_D4 = PCLGenerator.deriveBayerMatrix(BAYER_D2);
    private static final int[] BAYER_D8 = PCLGenerator.deriveBayerMatrix(BAYER_D4);
    private static final byte[] THRESHOLD_TABLE = new byte[256];

    public PCLGenerator(OutputStream out) {
        this.out = out;
    }

    public PCLGenerator(OutputStream out, int maxResolution) {
        this(out);
        boolean found = false;
        for (int i = 0; i < PCL_RESOLUTIONS.length; ++i) {
            if (PCL_RESOLUTIONS[i] != maxResolution) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Illegal value for maximum resolution!");
        }
        this.maxBitmapResolution = maxResolution;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public int getMaximumBitmapResolution() {
        return this.maxBitmapResolution;
    }

    public void writeCommand(String cmd) throws IOException {
        this.out.write(27);
        this.out.write(cmd.getBytes("US-ASCII"));
    }

    public void writeText(String s) throws IOException {
        this.out.write(s.getBytes("ISO-8859-1"));
    }

    public final String formatDouble2(double value) {
        return this.df2.format(value);
    }

    public final String formatDouble4(double value) {
        return this.df4.format(value);
    }

    public void universalEndOfLanguage() throws IOException {
        this.writeCommand("%-12345X");
    }

    public void resetPrinter() throws IOException {
        this.writeCommand("E");
    }

    public void separateJobs() throws IOException {
        this.writeCommand("&l1T");
    }

    public void formFeed() throws IOException {
        this.out.write(12);
    }

    public void setUnitOfMeasure(int value) throws IOException {
        this.writeCommand("&u" + value + "D");
    }

    public void setRasterGraphicsResolution(int value) throws IOException {
        this.writeCommand("*t" + value + "R");
    }

    public void selectPageSize(int selector) throws IOException {
        this.writeCommand("&l" + selector + "A");
    }

    public void selectPaperSource(int selector) throws IOException {
        this.writeCommand("&l" + selector + "H");
    }

    public void clearHorizontalMargins() throws IOException {
        this.writeCommand("9");
    }

    public void setTopMargin(int numberOfLines) throws IOException {
        this.writeCommand("&l" + numberOfLines + "E");
    }

    public void setTextLength(int numberOfLines) throws IOException {
        this.writeCommand("&l" + numberOfLines + "F");
    }

    public void setVMI(double value) throws IOException {
        this.writeCommand("&l" + this.formatDouble4(value) + "C");
    }

    public void setCursorPos(double x, double y) throws IOException {
        if (x < 0.0) {
            this.writeCommand("&a0h" + this.formatDouble2(x / 100.0) + "h" + this.formatDouble2(y / 100.0) + "V");
        } else {
            this.writeCommand("&a" + this.formatDouble2(x / 100.0) + "h" + this.formatDouble2(y / 100.0) + "V");
        }
    }

    public void pushCursorPos() throws IOException {
        this.writeCommand("&f0S");
    }

    public void popCursorPos() throws IOException {
        this.writeCommand("&f1S");
    }

    public void changePrintDirection(int rotate) throws IOException {
        this.writeCommand("&a" + rotate + "P");
    }

    public void enterHPGL2Mode(boolean restorePreviousHPGL2Cursor) throws IOException {
        if (restorePreviousHPGL2Cursor) {
            this.writeCommand("%0B");
        } else {
            this.writeCommand("%1B");
        }
    }

    public void enterPCLMode(boolean restorePreviousPCLCursor) throws IOException {
        if (restorePreviousPCLCursor) {
            this.writeCommand("%0A");
        } else {
            this.writeCommand("%1A");
        }
    }

    protected void fillRect(int w, int h, Color col) throws IOException {
        if (w == 0 || h == 0) {
            return;
        }
        if (h < 0) {
            h *= -1;
        }
        this.setPatternTransparencyMode(false);
        if (this.usePCLShades || Color.black.equals(col) || Color.white.equals(col)) {
            this.writeCommand("*c" + this.formatDouble4(w / 100) + "h" + this.formatDouble4(h / 100) + "V");
            int lineshade = this.convertToPCLShade(col);
            this.writeCommand("*c" + lineshade + "G");
            this.writeCommand("*c2P");
        } else {
            this.defineGrayscalePattern(col, 32, 4);
            this.writeCommand("*c" + this.formatDouble4(w / 100) + "h" + this.formatDouble4(h / 100) + "V");
            this.writeCommand("*c32G");
            this.writeCommand("*c4P");
        }
        this.setPatternTransparencyMode(true);
    }

    private static void setValueInMatrix(int[] dn, int half, int part, int idx, int value) {
        int xoff = (part & 1) * half;
        int yoff = (part & 2) * half * half;
        int matrixIndex = yoff + idx / half * half * 2 + idx % half + xoff;
        dn[matrixIndex] = value;
    }

    private static int[] deriveBayerMatrix(int[] d) {
        int[] dn = new int[d.length * 4];
        int half = (int)Math.sqrt(d.length);
        for (int part = 0; part < 4; ++part) {
            int c = d.length;
            for (int i = 0; i < c; ++i) {
                PCLGenerator.setValueInMatrix(dn, half, part, i, d[i] * 4 + BAYER_D2[part]);
            }
        }
        return dn;
    }

    public void defineGrayscalePattern(Color col, int patternID, int ditherMatrixSize) throws IOException {
        byte[] pattern;
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream((OutputStream)baout);
        data.writeByte(0);
        data.writeByte(0);
        data.writeByte(1);
        data.writeByte(0);
        data.writeShort(8);
        data.writeShort(8);
        int gray255 = this.convertToGray(col.getRed(), col.getGreen(), col.getBlue());
        if (ditherMatrixSize == 8) {
            int gray65 = gray255 * 65 / 255;
            pattern = new byte[BAYER_D8.length / 8];
            int c = BAYER_D8.length;
            for (int i = 0; i < c; ++i) {
                int byteIdx;
                boolean dot;
                boolean bl = dot = BAYER_D8[i] >= gray65 - 1;
                if (!dot) continue;
                int n = byteIdx = i / 8;
                pattern[n] = (byte)(pattern[n] | 1 << i % 8);
            }
        } else {
            int gray17 = gray255 * 17 / 255;
            pattern = new byte[BAYER_D4.length / 8 * 4];
            int c = BAYER_D4.length;
            for (int i = 0; i < c; ++i) {
                int byteIdx;
                boolean dot;
                boolean bl = dot = BAYER_D4[i] >= gray17 - 1;
                if (!dot) continue;
                int n = byteIdx = i / 4;
                pattern[n] = (byte)(pattern[n] | 1 << i % 4);
                int n2 = byteIdx;
                pattern[n2] = (byte)(pattern[n2] | 1 << i % 4 + 4);
                int n3 = byteIdx + 4;
                pattern[n3] = (byte)(pattern[n3] | 1 << i % 4);
                int n4 = byteIdx + 4;
                pattern[n4] = (byte)(pattern[n4] | 1 << i % 4 + 4);
            }
        }
        data.write(pattern);
        if (baout.size() % 2 > 0) {
            baout.write(0);
        }
        this.writeCommand("*c" + patternID + "G");
        this.writeCommand("*c" + baout.size() + "W");
        baout.writeTo(this.out);
        this.writeCommand("*c4Q");
    }

    public void setSourceTransparencyMode(boolean transparent) throws IOException {
        this.setTransparencyMode(transparent, this.currentPatternTransparency);
    }

    public void setPatternTransparencyMode(boolean transparent) throws IOException {
        this.setTransparencyMode(this.currentSourceTransparency, transparent);
    }

    public void setTransparencyMode(boolean source, boolean pattern) throws IOException {
        if (source != this.currentSourceTransparency && pattern != this.currentPatternTransparency) {
            this.writeCommand("*v" + (source ? (char)'0' : '1') + "n" + (pattern ? (char)'0' : '1') + "O");
        } else if (source != this.currentSourceTransparency) {
            this.writeCommand("*v" + (source ? (char)'0' : '1') + "N");
        } else if (pattern != this.currentPatternTransparency) {
            this.writeCommand("*v" + (pattern ? (char)'0' : '1') + "O");
        }
        this.currentSourceTransparency = source;
        this.currentPatternTransparency = pattern;
    }

    public final int convertToGray(int r, int g, int b) {
        return (r * 30 + g * 59 + b * 11) / 100;
    }

    public final int convertToPCLShade(Color col) {
        float gray = (float)this.convertToGray(col.getRed(), col.getGreen(), col.getBlue()) / 255.0f;
        return (int)(100.0f - gray * 100.0f);
    }

    public void selectGrayscale(Color col) throws IOException {
        if (Color.black.equals(col)) {
            this.selectCurrentPattern(0, 0);
        } else if (Color.white.equals(col)) {
            this.selectCurrentPattern(0, 1);
        } else if (this.usePCLShades) {
            this.selectCurrentPattern(this.convertToPCLShade(col), 2);
        } else {
            this.defineGrayscalePattern(col, 32, 4);
            this.selectCurrentPattern(32, 4);
        }
    }

    public void selectCurrentPattern(int patternID, int pattern) throws IOException {
        if (pattern > 1) {
            this.writeCommand("*c" + patternID + "G");
        }
        this.writeCommand("*v" + pattern + "T");
    }

    public static boolean isMonochromeImage(RenderedImage img) {
        ColorModel cm = img.getColorModel();
        if (cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            return icm.getMapSize() == 2;
        }
        return false;
    }

    public static boolean isGrayscaleImage(RenderedImage img) {
        return img.getColorModel().getColorSpace().getNumComponents() == 1;
    }

    private MonochromeBitmapConverter createMonochromeBitmapConverter() {
        MonochromeBitmapConverter converter = null;
        try {
            String clName = "org.apache.fop.render.pcl.JAIMonochromeBitmapConverter";
            Class<?> clazz = Class.forName(clName);
            converter = (MonochromeBitmapConverter)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (LinkageError le) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (converter == null) {
            converter = new DefaultMonochromeBitmapConverter();
        }
        return converter;
    }

    private int calculatePCLResolution(int resolution) {
        return this.calculatePCLResolution(resolution, false);
    }

    private int calculatePCLResolution(int resolution, boolean increased) {
        int choice = -1;
        for (int i = PCL_RESOLUTIONS.length - 2; i >= 0; --i) {
            if (resolution <= PCL_RESOLUTIONS[i]) continue;
            int idx = i + 1;
            if (idx < PCL_RESOLUTIONS.length - 2) {
                idx += increased ? 2 : 0;
            } else if (idx < PCL_RESOLUTIONS.length - 1) {
                idx += increased ? 1 : 0;
            }
            choice = idx;
            break;
        }
        if (choice < 0) {
            int n = choice = increased ? 2 : 0;
        }
        while (choice > 0 && PCL_RESOLUTIONS[choice] > this.getMaximumBitmapResolution()) {
            --choice;
        }
        return PCL_RESOLUTIONS[choice];
    }

    private boolean isValidPCLResolution(int resolution) {
        return resolution == this.calculatePCLResolution(resolution);
    }

    private Dimension getAdjustedDimension(Dimension orgDim, double orgResolution, int pclResolution) {
        if (orgResolution == (double)pclResolution) {
            return orgDim;
        }
        Dimension result = new Dimension();
        result.width = (int)Math.round((double)orgDim.width * (double)pclResolution / orgResolution);
        result.height = (int)Math.round((double)orgDim.height * (double)pclResolution / orgResolution);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderedImage getMask(RenderedImage img, Dimension targetDim) {
        ColorModel cm = img.getColorModel();
        if (cm.hasAlpha()) {
            BufferedImage alpha = new BufferedImage(img.getWidth(), img.getHeight(), 10);
            Raster raster = img.getData();
            GraphicsUtil.copyBand((Raster)raster, (int)cm.getNumColorComponents(), (WritableRaster)alpha.getRaster(), (int)0);
            LookupOp op1 = new LookupOp(new ByteLookupTable(0, THRESHOLD_TABLE), null);
            BufferedImage alphat = op1.filter(alpha, null);
            BufferedImage mask = new BufferedImage(targetDim.width, targetDim.height, 12);
            Graphics2D g2d = mask.createGraphics();
            try {
                AffineTransform at = new AffineTransform();
                double sx = targetDim.getWidth() / (double)img.getWidth();
                double sy = targetDim.getHeight() / (double)img.getHeight();
                at.scale(sx, sy);
                g2d.drawRenderedImage(alphat, at);
            }
            finally {
                g2d.dispose();
            }
            return mask;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBitmap(RenderedImage img, Dimension targetDim, boolean sourceTransparency) throws IOException {
        Dimension effDim;
        double targetResolution = (double)img.getWidth() / UnitConv.mpt2in(targetDim.width);
        int resolution = (int)Math.round(targetResolution);
        int effResolution = this.calculatePCLResolution(resolution, true);
        Dimension orgDim = new Dimension(img.getWidth(), img.getHeight());
        boolean scaled = !orgDim.equals(effDim = this.getAdjustedDimension(orgDim, targetResolution, effResolution));
        boolean monochrome = PCLGenerator.isMonochromeImage(img);
        if (!monochrome) {
            BufferedImage buf;
            boolean transparencyDisabled = true;
            RenderedImage mask = null;
            if (mask != null) {
                this.pushCursorPos();
                this.selectCurrentPattern(0, 1);
                this.setTransparencyMode(true, true);
                this.paintMonochromeBitmap(mask, effResolution);
                this.popCursorPos();
            }
            BufferedImage src = null;
            if (img instanceof BufferedImage && !scaled) {
                if (!PCLGenerator.isGrayscaleImage(img) || img.getColorModel().hasAlpha()) {
                    src = new BufferedImage(effDim.width, effDim.height, 10);
                    ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
                    op.filter((BufferedImage)img, src);
                } else {
                    src = (BufferedImage)img;
                }
            }
            if (src == null) {
                src = new BufferedImage(effDim.width, effDim.height, 10);
                Graphics2D g2d = src.createGraphics();
                try {
                    AffineTransform at = new AffineTransform();
                    double sx = effDim.getWidth() / orgDim.getWidth();
                    double sy = effDim.getHeight() / orgDim.getHeight();
                    at.scale(sx, sy);
                    g2d.drawRenderedImage(img, at);
                }
                finally {
                    g2d.dispose();
                }
            }
            MonochromeBitmapConverter converter = this.createMonochromeBitmapConverter();
            converter.setHint("quality", "false");
            BufferedImage red = buf = (BufferedImage)converter.convertToMonochrome(src);
            this.selectCurrentPattern(0, 0);
            this.setTransparencyMode(sourceTransparency || mask != null, true);
            this.paintMonochromeBitmap(red, effResolution);
        } else {
            RenderedImage effImg = img;
            if (scaled) {
                BufferedImage buf = new BufferedImage(effDim.width, effDim.height, 12);
                Graphics2D g2d = buf.createGraphics();
                try {
                    AffineTransform at = new AffineTransform();
                    double sx = effDim.getWidth() / orgDim.getWidth();
                    double sy = effDim.getHeight() / orgDim.getHeight();
                    at.scale(sx, sy);
                    g2d.drawRenderedImage(img, at);
                }
                finally {
                    g2d.dispose();
                }
                effImg = buf;
            }
            this.setSourceTransparencyMode(sourceTransparency);
            this.selectCurrentPattern(0, 0);
            this.paintMonochromeBitmap(effImg, effResolution);
        }
    }

    public void paintMonochromeBitmap(RenderedImage img, int resolution) throws IOException {
        if (!this.isValidPCLResolution(resolution)) {
            throw new IllegalArgumentException("Invalid PCL resolution: " + resolution);
        }
        this.setRasterGraphicsResolution(resolution);
        this.writeCommand("*r0f" + img.getHeight() + "t" + img.getWidth() + "s1A");
        Raster raster = img.getData();
        boolean monochrome = PCLGenerator.isMonochromeImage(img);
        if (!monochrome) {
            throw new IllegalArgumentException("img must be a monochrome image");
        }
        int x = 0;
        int y = 0;
        int imgw = img.getWidth();
        int imgh = img.getHeight();
        int bytewidth = imgw / 8;
        if (imgw % 8 != 0) {
            ++bytewidth;
        }
        byte[] rle = new byte[bytewidth * 2];
        byte[] uncompressed = new byte[bytewidth];
        int lastcount = -1;
        int lastbyte = 0;
        int rlewidth = 0;
        for (y = 0; y < imgh; ++y) {
            int ib = 0;
            for (x = 0; x < imgw; ++x) {
                int sample = raster.getSample(x, y, 0);
                if (sample == 0) {
                    ib = (byte)(ib | 1 << 7 - x % 8);
                }
                if (x % 8 != 7 && x + 1 != imgw) continue;
                if (rlewidth < bytewidth) {
                    if (lastcount >= 0) {
                        if (ib == lastbyte) {
                            ++lastcount;
                        } else {
                            rle[rlewidth++] = (byte)(lastcount & 0xFF);
                            rle[rlewidth++] = lastbyte;
                            lastbyte = ib;
                            lastcount = 0;
                        }
                    } else {
                        lastbyte = ib;
                        lastcount = 0;
                    }
                    if (lastcount == 255 || x + 1 == imgw) {
                        rle[rlewidth++] = (byte)(lastcount & 0xFF);
                        rle[rlewidth++] = lastbyte;
                        lastbyte = 0;
                        lastcount = -1;
                    }
                }
                uncompressed[x / 8] = ib;
                ib = 0;
            }
            if (rlewidth < bytewidth) {
                this.writeCommand("*b1m" + rlewidth + "W");
                this.out.write(rle, 0, rlewidth);
            } else {
                this.writeCommand("*b0m" + bytewidth + "W");
                this.out.write(uncompressed);
            }
            lastcount = -1;
            rlewidth = 0;
        }
        this.writeCommand("*rB");
    }

    static {
        for (int i = 0; i < 256; ++i) {
            PCLGenerator.THRESHOLD_TABLE[i] = (byte)(i < 240 ? 255 : 0);
        }
    }
}

