/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.swing.TreeNodeData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class TreeTableCellPanel
extends JPanel {
    private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    private final Map<Integer, Component> spacerComponentsCache = new HashMap<Integer, Component>();
    private final JButton expanderButton = new JButton();
    private Component nodeComponent;

    public TreeTableCellPanel() {
        super(new TreeTableCellLayout());
        this.expanderButton.setBorder(BorderFactory.createEmptyBorder());
        this.expanderButton.setContentAreaFilled(false);
        this.expanderButton.setFocusable(false);
    }

    public void configure(TreeNodeData treeNodeData, boolean showExpanderForEmptyParent, Component nodeComponent, boolean hasFocus, int indent, int spacer) {
        boolean showExpanderButton;
        boolean bl = showExpanderButton = treeNodeData.hasChildren() || treeNodeData.allowsChildren() && showExpanderForEmptyParent;
        if (showExpanderButton) {
            this.expanderButton.setIcon(UIManager.getIcon(treeNodeData.isExpanded() ? "Tree.expandedIcon" : "Tree.collapsedIcon"));
        }
        super.setBackground(nodeComponent.getBackground());
        if (nodeComponent instanceof JComponent) {
            JComponent jNodeComponent = (JComponent)nodeComponent;
            this.setToolTipText(jNodeComponent.getToolTipText());
            this.setBorder(hasFocus ? jNodeComponent.getBorder() : NO_FOCUS_BORDER);
            jNodeComponent.setBorder(NO_FOCUS_BORDER);
        }
        this.removeAll();
        this.add(this.getSpacer(indent), TreeTableCellLayout.INDENTER);
        this.add(showExpanderButton ? this.expanderButton : TreeTableCellPanel.createSpacer(UIManager.getIcon("Tree.expandedIcon").getIconWidth()), TreeTableCellLayout.EXPANDER);
        this.add(this.getSpacer(spacer), TreeTableCellLayout.SPACER);
        this.add(nodeComponent, TreeTableCellLayout.NODE_COMPONENT);
        this.nodeComponent = nodeComponent;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.nodeComponent != null) {
            this.nodeComponent.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.nodeComponent != null) {
            this.nodeComponent.setForeground(fg);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.nodeComponent != null) {
            this.nodeComponent.setFont(font);
        }
    }

    public Component getNodeComponent() {
        return this.nodeComponent;
    }

    public boolean isPointOverExpanderButton(Point p) {
        return this.expanderButton.isVisible() && SwingUtilities.getDeepestComponentAt(this, p.x, p.y) == this.expanderButton;
    }

    public boolean isPointOverNodeComponent(Point p) {
        return this.nodeComponent != null && this.nodeComponent.isVisible() && SwingUtilities.getDeepestComponentAt(this, p.x, p.y) == this.nodeComponent;
    }

    private Component getSpacer(int width) {
        Integer key = new Integer(width);
        Component spacer = this.spacerComponentsCache.get(key);
        if (spacer == null) {
            spacer = TreeTableCellPanel.createSpacer(width);
            this.spacerComponentsCache.put(key, spacer);
        }
        return spacer;
    }

    private static Component createSpacer(int width) {
        return Box.createHorizontalStrut(width);
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (!this.nodeComponent.hasFocus()) {
            SwingUtilities.invokeLater(new RequestFocusAndDispatchKeyEventRunnable(e, this.nodeComponent));
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void setNextFocusableComponent(Component aComponent) {
        super.setNextFocusableComponent(aComponent);
        if (this.nodeComponent instanceof JComponent) {
            ((JComponent)this.nodeComponent).setNextFocusableComponent(aComponent);
        }
    }

    private static class TreeTableCellLayout
    implements LayoutManager2 {
        public static final Object INDENTER = new Object();
        public static final Object EXPANDER = new Object();
        public static final Object SPACER = new Object();
        public static final Object NODE_COMPONENT = new Object();
        private Component indenter;
        private Component expander;
        private Component spacer;
        private Component nodeComponent;

        private TreeTableCellLayout() {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
            if (constraints == INDENTER) {
                this.indenter = comp;
            } else if (constraints == EXPANDER) {
                this.expander = comp;
            } else if (constraints == SPACER) {
                this.spacer = comp;
            } else if (constraints == NODE_COMPONENT) {
                this.nodeComponent = comp;
            } else {
                throw new IllegalArgumentException("Unexpected constraints object: " + constraints);
            }
        }

        public void removeLayoutComponent(Component comp) {
            if (comp == this.indenter) {
                this.indenter = null;
            }
            if (comp == this.expander) {
                this.expander = null;
            }
            if (comp == this.spacer) {
                this.spacer = null;
            }
            if (comp == this.nodeComponent) {
                this.nodeComponent = null;
            }
        }

        public void layoutContainer(Container target) {
            Insets insets = target.getInsets();
            int totalWidth = target.getWidth() - insets.left - insets.right;
            int totalHeight = target.getHeight() - insets.top - insets.bottom;
            int availableWidth = totalWidth;
            if (totalHeight <= 0) {
                return;
            }
            if (availableWidth > 0 && this.indenter != null) {
                int spacerWidth = this.indenter.getPreferredSize().width;
                this.indenter.setBounds(0, 0, spacerWidth, totalHeight);
                availableWidth -= spacerWidth;
            }
            if (availableWidth > 0 && this.expander != null) {
                int expanderButtonX = totalWidth - availableWidth;
                int expanderButtonY = insets.top;
                int expanderButtonWidth = this.expander.getPreferredSize().width;
                int expanderButtonHeight = this.expander.getPreferredSize().height;
                if (expanderButtonHeight > totalHeight) {
                    expanderButtonHeight = totalHeight;
                } else if (expanderButtonHeight < totalHeight) {
                    expanderButtonY += (totalHeight - expanderButtonHeight) / 2;
                }
                this.expander.setBounds(expanderButtonX, expanderButtonY, expanderButtonWidth, expanderButtonHeight);
                availableWidth -= expanderButtonWidth;
            }
            if (availableWidth > 0 && this.spacer != null) {
                int spacerX = totalWidth - availableWidth;
                int spacerWidth = this.spacer.getPreferredSize().width;
                this.spacer.setBounds(spacerX, 0, spacerWidth, totalHeight);
                availableWidth -= spacerWidth;
            }
            if (availableWidth > 0 && this.nodeComponent != null) {
                int nodeComponentX = totalWidth - availableWidth;
                int nodeComponentY = insets.top;
                int nodeComponentWidth = availableWidth;
                int nodeComponentHeight = this.nodeComponent.getPreferredSize().height;
                if (nodeComponentHeight > totalHeight) {
                    nodeComponentHeight = totalHeight;
                } else if (nodeComponentHeight < totalHeight) {
                    nodeComponentY += (totalHeight - nodeComponentHeight) / 2;
                }
                this.nodeComponent.setBounds(nodeComponentX, nodeComponentY, nodeComponentWidth, nodeComponentHeight);
            }
        }

        public Dimension preferredLayoutSize(Container target) {
            Dimension preferredSize = new Dimension(0, 0);
            if (this.indenter != null) {
                Dimension indenterSize = this.indenter.getPreferredSize();
                preferredSize.height = Math.max(preferredSize.height, indenterSize.height);
                preferredSize.width += indenterSize.width;
            }
            if (this.expander != null) {
                Dimension expanderSize = this.expander.getPreferredSize();
                preferredSize.height = Math.max(preferredSize.height, expanderSize.height);
                preferredSize.width += expanderSize.width;
            }
            if (this.spacer != null) {
                Dimension spacerSize = this.spacer.getPreferredSize();
                preferredSize.height = Math.max(preferredSize.height, spacerSize.height);
                preferredSize.width += spacerSize.width;
            }
            if (this.nodeComponent != null) {
                Dimension nodeComponentSize = this.nodeComponent.getPreferredSize();
                preferredSize.height = Math.max(preferredSize.height, nodeComponentSize.height);
                preferredSize.width += nodeComponentSize.width;
            }
            Insets insets = target.getInsets();
            preferredSize.height += insets.top + insets.bottom;
            preferredSize.width += insets.left + insets.right;
            return preferredSize;
        }

        public void invalidateLayout(Container target) {
        }

        public float getLayoutAlignmentX(Container target) {
            throw new UnsupportedOperationException();
        }

        public float getLayoutAlignmentY(Container target) {
            throw new UnsupportedOperationException();
        }

        public void addLayoutComponent(String name, Component comp) {
            throw new UnsupportedOperationException();
        }

        public Dimension minimumLayoutSize(Container parent) {
            throw new UnsupportedOperationException();
        }

        public Dimension maximumLayoutSize(Container target) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class RequestFocusAndDispatchKeyEventRunnable
    implements Runnable {
        private final KeyEvent keyEvent;
        private final Component component;

        public RequestFocusAndDispatchKeyEventRunnable(KeyEvent keyEvent, Component component) {
            this.keyEvent = keyEvent;
            this.component = component;
        }

        public void run() {
            this.component.requestFocus();
            this.component.dispatchEvent(this.keyEvent);
        }
    }
}

