/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.filters;

import java.util.logging.Logger;
import tr.swing.date.combo.DateItem;
import tr.swing.date.combo.DateType;
import tr.util.Utils;
import tr.view.actions.screens.filters.ActionsFilter;
import tr.view.filters.FilterCombo;
import tr.view.filters.FilterComboDate;

public abstract class FilterDate
extends ActionsFilter {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    protected FilterComboDate combo;

    protected boolean canExcludeNulls() {
        return true;
    }

    public final FilterCombo getFilterCombo() {
        return this.combo;
    }

    public String[] getSerialValues() {
        if (this.combo == null) {
            return null;
        }
        String selected = "";
        DateItem item = (DateItem)this.combo.getSelectedItem();
        if (item != null && item.type != DateType.NONE) {
            selected = String.valueOf(item.value);
        }
        return new String[]{selected, Boolean.toString(this.excludeNulls)};
    }

    public void setSerialValues(String[] values) {
        if (this.combo == null) {
            return;
        }
        this.combo.stopChangeEvents();
        if (values == null || values.length < 1) {
            this.combo.setSelectedItem(null);
        } else {
            try {
                long value = Long.parseLong(values[0]);
                if (value < 1000L) {
                    this.combo.setSelectedItem((Object)this.combo.getDateItem(DateType.DAYS, value));
                } else {
                    this.combo.setSelectedItem((Object)this.combo.getDateItem(DateType.MS, value));
                }
            }
            catch (Exception ex) {
                this.combo.setSelectedItem(null);
            }
            if (values.length > 1) {
                try {
                    this.excludeNulls = Boolean.parseBoolean(values[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.combo.startChangeEvents();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilterDate)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DateItem thisDateItem = (DateItem)this.combo.getSelectedItem();
        DateItem thatDateItem = (DateItem)((FilterDate)((Object)object)).combo.getSelectedItem();
        return Utils.equal((Object)thisDateItem, (Object)thatDateItem);
    }
}

