; -*- coding: iso-2022-7bit  -*-
;;; u-cns-5.el --- tables between UCS and CNS 11643:1992 plane 5

;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of Mule-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;;; Code:

(put 'chinese-cns11643-5 'unicode-assoc
     'cns11643-5-vs-unicode-assoc)

(defvar cns11643-5-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$(K!!(B . "0x200D1") ; <CJK>
       (?$(K!"(B . "0x200CB") ; <CJK>
       (?$(K!#(B . "0x200C9") ; <CJK>
       (?$(K!$(B . "0x2010C") ; <CJK>
       (?$(K!%(B . "0x20000") ; <CJK>
       (?$(K!&(B . "0x20087") ; <CJK>
       (?$(K!'(B . "0x2010D") ; <CJK>
       (?$(K!((B . "0x2010F") ; <CJK>
       (?$(K!)(B . "0x2F81D") ; <CJK>
       (?$(K!*(B . "0x22398") ; <CJK>
       (?$(K!+(B . "0x200D2") ; <CJK>
       (?$(K!,(B . "0x20111") ; <CJK>
       (?$(K!-(B . "0x2007E") ; <CJK>
       (?$(K!.(B . "0x20AD3") ; <CJK>
       (?$(K!/(B . "0x21552") ; <CJK>
       (?$(K!0(B . "0x21CFE") ; <CJK>
       (?$(K!1(B . "0x225A9") ; <CJK>
       (?$(K!2(B . "0x23942") ; <CJK>
       (?$(K!3(B . "0x20009") ; <CJK>
       (?$(K!4(B . "0x200D6") ; <CJK>
       (?$(K!5(B . "0x204DD") ; <CJK>
       (?$(K!6(B . "0x204DC") ; <CJK>
       (?$(K!7(B . "0x20502") ; <CJK>
       (?$(K!8(B . "0x20573") ; <CJK>
       (?$(K!9(B . "0x20676") ; <CJK>
       (?$(K!:(B . "0x206A7") ; <CJK>
       (?$(K!;(B . "0x206A8") ; <CJK>
       (?$(K!<(B . "0x20833") ; <CJK>
       (?$(K!=(B . "0x208CC") ; <CJK>
       (?$(K!>(B . "0x20A0D") ; <CJK>
       (?$(K!?(B . "0x20A2C") ; <CJK>
       (?$(K!@(B . "0x20B1B") ; <CJK>
       (?$(K!A(B . "0x355A") ; <CJK>
       (?$(K!B(B . "0x20B1D") ; <CJK>
       (?$(K!C(B . "0x20B99") ; <CJK>
       (?$(K!D(B . "0x2123E") ; <CJK>
       (?$(K!E(B . "0x21D2D") ; <CJK>
       (?$(K!F(B . "0x21D2F") ; <CJK>
       (?$(K!G(B . "0x22399") ; <CJK>
       (?$(K!H(B . "0x233B3") ; <CJK>
       (?$(K!H(B . "0x6729") ; <CJK>
       (?$(K!I(B . "0x239B6") ; <CJK>
       (?$(K!J(B . "0x23B1B") ; <CJK>
       (?$(K!K(B . "0x244EF") ; <CJK>
       (?$(K!L(B . "0x248E9") ; <CJK>
       (?$(K!M(B . "0x20014") ; <CJK>
       (?$(K!N(B . "0x20094") ; <CJK>
       (?$(K!O(B . "0x200E1") ; <CJK>
       (?$(K!P(B . "0x20506") ; <CJK>
       (?$(K!Q(B . "0x2054A") ; <CJK>
       (?$(K!R(B . "0x20544") ; <CJK>
       (?$(K!S(B . "0x20631") ; <CJK>
       (?$(K!T(B . "0x2067A") ; <CJK>
       (?$(K!U(B . "0x206AD") ; <CJK>
       (?$(K!V(B . "0x206AE") ; <CJK>
       (?$(K!W(B . "0x206B1") ; <CJK>
       (?$(K!X(B . "0x20838") ; <CJK>
       (?$(K!Y(B . "0x20837") ; <CJK>
       (?$(K!Z(B . "0x2097D") ; <CJK>
       (?$(K![(B . "0x2097E") ; <CJK>
       (?$(K!\(B . "0x20A2D") ; <CJK>
       (?$(K!](B . "0x20A32") ; <CJK>
       (?$(K!^(B . "0x20B23") ; <CJK>
       (?$(K!_(B . "0x20B26") ; <CJK>
       (?$(K!`(B . "0x2F83A") ; <CJK>
       (?$(K!a(B . "0x20BA0") ; <CJK>
       (?$(K!b(B . "0x216A8") ; <CJK>
       (?$(K!c(B . "0x2193F") ; <CJK>
       (?$(K!d(B . "0x219BC") ; <CJK>
       (?$(K!e(B . "0x21BC4") ; <CJK>
       (?$(K!f(B . "0x21D3B") ; <CJK>
       (?$(K!g(B . "0x22019") ; <CJK>
       (?$(K!h(B . "0x22018") ; <CJK>
       (?$(K!i(B . "0x221B3") ; <CJK>
       (?$(K!j(B . "0x223AA") ; <CJK>
       (?$(K!k(B . "0x224BE") ; <CJK>
       (?$(K!l(B . "0x225AC") ; <CJK>
       (?$(K!m(B . "0x22A25") ; <CJK>
       (?$(K!n(B . "0x22A66") ; <CJK>
       (?$(K!o(B . "0x22A6B") ; <CJK>
       (?$(K!p(B . "0x23943") ; <CJK>
       (?$(K!q(B . "0x239B5") ; <CJK>
       (?$(K!r(B . "0x23AEC") ; <CJK>
       (?$(K!s(B . "0x23C76") ; <CJK>
       (?$(K!t(B . "0x3CBC") ; <CJK>
       (?$(K!u(B . "0x24614") ; <CJK>
       (?$(K!v(B . "0x215DC") ; <CJK>
       (?$(K!w(B . "0x2471C") ; <CJK>
       (?$(K!x(B . "0x2471D") ; <CJK>
       (?$(K!y(B . "0x264D0") ; <CJK>
       (?$(K!z(B . "0x26612") ; <CJK>
       (?$(K!{(B . "0x26AF3") ; <CJK>
       (?$(K!|(B . "0x28669") ; <CJK>
       (?$(K!}(B . "0x49B9") ; <CJK>
       (?$(K!~(B . "0x28E11") ; <CJK>
       (?$(K"!(B . "0x28E15") ; <CJK>
       (?$(K""(B . "0x28E10") ; <CJK>
       (?$(K"#(B . "0x28E13") ; <CJK>
       (?$(K"$(B . "0x200A4") ; <CJK>
       (?$(K"%(B . "0x200A5") ; <CJK>
       (?$(K"&(B . "0x201D0") ; <CJK>
       (?$(K"'(B . "0x201BA") ; <CJK>
       (?$(K"((B . "0x201CB") ; <CJK>
       (?$(K")(B . "0x2057B") ; <CJK>
       (?$(K"*(B . "0x20686") ; <CJK>
       (?$(K"+(B . "0x206BB") ; <CJK>
       (?$(K",(B . "0x206BA") ; <CJK>
       (?$(K"-(B . "0x206C3") ; <CJK>
       (?$(K".(B . "0x206B9") ; <CJK>
       (?$(K"/(B . "0x206C0") ; <CJK>
       (?$(K"0(B . "0x34DE") ; <CJK>
       (?$(K"1(B . "0x20839") ; <CJK>
       (?$(K"2(B . "0x2083B") ; <CJK>
       (?$(K"3(B . "0x20841") ; <CJK>
       (?$(K"4(B . "0x208D1") ; <CJK>
       (?$(K"5(B . "0x208CF") ; <CJK>
       (?$(K"6(B . "0x208D2") ; <CJK>
       (?$(K"7(B . "0x2092E") ; <CJK>
       (?$(K"8(B . "0x2096E") ; <CJK>
       (?$(K"9(B . "0x2098C") ; <CJK>
       (?$(K":(B . "0x20988") ; <CJK>
       (?$(K";(B . "0x20A35") ; <CJK>
       (?$(K"<(B . "0x3543") ; <CJK>
       (?$(K"=(B . "0x20A3A") ; <CJK>
       (?$(K">(B . "0x20A3B") ; <CJK>
       (?$(K"?(B . "0x20A38") ; <CJK>
       (?$(K"@(B . "0x20A39") ; <CJK>
       (?$(K"A(B . "0x20B2E") ; <CJK>
       (?$(K"B(B . "0x20B2C") ; <CJK>
       (?$(K"C(B . "0x20BC8") ; <CJK>
       (?$(K"D(B . "0x20BB5") ; <CJK>
       (?$(K"E(B . "0x20BAD") ; <CJK>
       (?$(K"F(B . "0x20BB0") ; <CJK>
       (?$(K"G(B . "0x20BAB") ; <CJK>
       (?$(K"H(B . "0x211B3") ; <CJK>
       (?$(K"I(B . "0x211A9") ; <CJK>
       (?$(K"J(B . "0x216BB") ; <CJK>
       (?$(K"K(B . "0x216B9") ; <CJK>
       (?$(K"L(B . "0x21B5A") ; <CJK>
       (?$(K"M(B . "0x21BCD") ; <CJK>
       (?$(K"N(B . "0x21C2B") ; <CJK>
       (?$(K"O(B . "0x21D05") ; <CJK>
       (?$(K"P(B . "0x37AC") ; <CJK>
       (?$(K"Q(B . "0x37AA") ; <CJK>
       (?$(K"R(B . "0x21D51") ; <CJK>
       (?$(K"S(B . "0x21D4B") ; <CJK>
       (?$(K"T(B . "0x21FEA") ; <CJK>
       (?$(K"U(B . "0x21FED") ; <CJK>
       (?$(K"V(B . "0x22036") ; <CJK>
       (?$(K"W(B . "0x22062") ; <CJK>
       (?$(K"X(B . "0x22056") ; <CJK>
       (?$(K"Y(B . "0x22055") ; <CJK>
       (?$(K"Z(B . "0x22064") ; <CJK>
       (?$(K"[(B . "0x22058") ; <CJK>
       (?$(K"\(B . "0x5E07") ; <CJK>
       (?$(K"](B . "0x221DA") ; <CJK>
       (?$(K"^(B . "0x221D8") ; <CJK>
       (?$(K"_(B . "0x223AD") ; <CJK>
       (?$(K"`(B . "0x223AB") ; <CJK>
       (?$(K"a(B . "0x224C0") ; <CJK>
       (?$(K"b(B . "0x224C3") ; <CJK>
       (?$(K"c(B . "0x225B3") ; <CJK>
       (?$(K"d(B . "0x225B7") ; <CJK>
       (?$(K"e(B . "0x225BA") ; <CJK>
       (?$(K"f(B . "0x5FCB") ; <CJK>
       (?$(K"g(B . "0x38FE") ; <CJK>
       (?$(K"h(B . "0x225C7") ; <CJK>
       (?$(K"i(B . "0x225B5") ; <CJK>
       (?$(K"j(B . "0x2298E") ; <CJK>
       (?$(K"k(B . "0x22A73") ; <CJK>
       (?$(K"l(B . "0x22A6C") ; <CJK>
       (?$(K"m(B . "0x22A74") ; <CJK>
       (?$(K"n(B . "0x2F8B4") ; <CJK>
       (?$(K"o(B . "0x22A72") ; <CJK>
       (?$(K"p(B . "0x22A71") ; <CJK>
       (?$(K"q(B . "0x22A82") ; <CJK>
       (?$(K"r(B . "0x22A70") ; <CJK>
       (?$(K"s(B . "0x2313F") ; <CJK>
       (?$(K"t(B . "0x233BA") ; <CJK>
       (?$(K"u(B . "0x233B8") ; <CJK>
       (?$(K"v(B . "0x239B7") ; <CJK>
       (?$(K"w(B . "0x24723") ; <CJK>
       (?$(K"x(B . "0x24721") ; <CJK>
       (?$(K"y(B . "0x2472B") ; <CJK>
       (?$(K"z(B . "0x24726") ; <CJK>
       (?$(K"{(B . "0x24722") ; <CJK>
       (?$(K"|(B . "0x24D25") ; <CJK>
       (?$(K"}(B . "0x250E4") ; <CJK>
       (?$(K"~(B . "0x25415") ; <CJK>
       (?$(K#!(B . "0x264E4") ; <CJK>
       (?$(K#"(B . "0x26633") ; <CJK>
       (?$(K##(B . "0x2662A") ; <CJK>
       (?$(K#$(B . "0x26632") ; <CJK>
       (?$(K#%(B . "0x26629") ; <CJK>
       (?$(K#&(B . "0x26AFB") ; <CJK>
       (?$(K#'(B . "0x2795B") ; <CJK>
       (?$(K#((B . "0x2795C") ; <CJK>
       (?$(K#)(B . "0x27C28") ; <CJK>
       (?$(K#*(B . "0x2866F") ; <CJK>
       (?$(K#+(B . "0x2866D") ; <CJK>
       (?$(K#,(B . "0x2866B") ; <CJK>
       (?$(K#-(B . "0x2866E") ; <CJK>
       (?$(K#.(B . "0x28E16") ; <CJK>
       (?$(K#/(B . "0x20022") ; <CJK>
       (?$(K#0(B . "0x20116") ; <CJK>
       (?$(K#1(B . "0x20148") ; <CJK>
       (?$(K#2(B . "0x201D8") ; <CJK>
       (?$(K#3(B . "0x20200") ; <CJK>
       (?$(K#4(B . "0x3441") ; <CJK>
       (?$(K#5(B . "0x20480") ; <CJK>
       (?$(K#6(B . "0x204E4") ; <CJK>
       (?$(K#7(B . "0x34B4") ; <CJK>
       (?$(K#8(B . "0x204E7") ; <CJK>
       (?$(K#9(B . "0x2050C") ; <CJK>
       (?$(K#:(B . "0x20553") ; <CJK>
       (?$(K#;(B . "0x205B7") ; <CJK>
       (?$(K#<(B . "0x20AE8") ; <CJK>
       (?$(K#=(B . "0x206D1") ; <CJK>
       (?$(K#>(B . "0x206E5") ; <CJK>
       (?$(K#?(B . "0x206D8") ; <CJK>
       (?$(K#@(B . "0x206D6") ; <CJK>
       (?$(K#A(B . "0x206DA") ; <CJK>
       (?$(K#B(B . "0x206D9") ; <CJK>
       (?$(K#C(B . "0x206D5") ; <CJK>
       (?$(K#D(B . "0x206E6") ; <CJK>
       (?$(K#E(B . "0x206D4") ; <CJK>
       (?$(K#F(B . "0x206D3") ; <CJK>
       (?$(K#G(B . "0x20844") ; <CJK>
       (?$(K#H(B . "0x208D6") ; <CJK>
       (?$(K#I(B . "0x208D7") ; <CJK>
       (?$(K#J(B . "0x20913") ; <CJK>
       (?$(K#K(B . "0x5324") ; <CJK>
       (?$(K#L(B . "0x20970") ; <CJK>
       (?$(K#M(B . "0x20992") ; <CJK>
       (?$(K#N(B . "0x209DB") ; <CJK>
       (?$(K#O(B . "0x209DA") ; <CJK>
       (?$(K#P(B . "0x20A41") ; <CJK>
       (?$(K#Q(B . "0x20A43") ; <CJK>
       (?$(K#R(B . "0x20B33") ; <CJK>
       (?$(K#S(B . "0x20BF6") ; <CJK>
       (?$(K#T(B . "0x20BD4") ; <CJK>
       (?$(K#U(B . "0x20BDD") ; <CJK>
       (?$(K#V(B . "0x20BD0") ; <CJK>
       (?$(K#W(B . "0x20C04") ; <CJK>
       (?$(K#X(B . "0x20BD9") ; <CJK>
       (?$(K#Y(B . "0x20BDB") ; <CJK>
       (?$(K#Z(B . "0x20C05") ; <CJK>
       (?$(K#[(B . "0x20BD3") ; <CJK>
       (?$(K#\(B . "0x20BE1") ; <CJK>
       (?$(K#](B . "0x21280") ; <CJK>
       (?$(K#^(B . "0x21277") ; <CJK>
       (?$(K#_(B . "0x21281") ; <CJK>
       (?$(K#`(B . "0x21282") ; <CJK>
       (?$(K#a(B . "0x21283") ; <CJK>
       (?$(K#b(B . "0x2F85C") ; <CJK>
       (?$(K#c(B . "0x21561") ; <CJK>
       (?$(K#d(B . "0x21560") ; <CJK>
       (?$(K#e(B . "0x216D8") ; <CJK>
       (?$(K#f(B . "0x216D6") ; <CJK>
       (?$(K#g(B . "0x216D7") ; <CJK>
       (?$(K#h(B . "0x24605") ; <CJK>
       (?$(K#i(B . "0x2194D") ; <CJK>
       (?$(K#j(B . "0x21948") ; <CJK>
       (?$(K#k(B . "0x21BD6") ; <CJK>
       (?$(K#l(B . "0x21BCF") ; <CJK>
       (?$(K#m(B . "0x21BD9") ; <CJK>
       (?$(K#n(B . "0x21BD8") ; <CJK>
       (?$(K#o(B . "0x21C3D") ; <CJK>
       (?$(K#p(B . "0x37B3") ; <CJK>
       (?$(K#q(B . "0x21D54") ; <CJK>
       (?$(K#r(B . "0x21D5B") ; <CJK>
       (?$(K#s(B . "0x21D5C") ; <CJK>
       (?$(K#t(B . "0x37B4") ; <CJK>
       (?$(K#u(B . "0x21D59") ; <CJK>
       (?$(K#v(B . "0x21D58") ; <CJK>
       (?$(K#w(B . "0x21D5A") ; <CJK>
       (?$(K#x(B . "0x21D55") ; <CJK>
       (?$(K#y(B . "0x21D56") ; <CJK>
       (?$(K#z(B . "0x21D82") ; <CJK>
       (?$(K#{(B . "0x21FF0") ; <CJK>
       (?$(K#|(B . "0x2201C") ; <CJK>
       (?$(K#}(B . "0x2206A") ; <CJK>
       (?$(K#~(B . "0x22069") ; <CJK>
       (?$(K$!(B . "0x22071") ; <CJK>
       (?$(K$"(B . "0x22067") ; <CJK>
       (?$(K$#(B . "0x2206C") ; <CJK>
       (?$(K$$(B . "0x2206E") ; <CJK>
       (?$(K$%(B . "0x22079") ; <CJK>
       (?$(K$&(B . "0x2218B") ; <CJK>
       (?$(K$'(B . "0x221B8") ; <CJK>
       (?$(K$((B . "0x221E7") ; <CJK>
       (?$(K$)(B . "0x221E8") ; <CJK>
       (?$(K$*(B . "0x221E4") ; <CJK>
       (?$(K$+(B . "0x221E6") ; <CJK>
       (?$(K$,(B . "0x221E5") ; <CJK>
       (?$(K$-(B . "0x221F0") ; <CJK>
       (?$(K$.(B . "0x22383") ; <CJK>
       (?$(K$/(B . "0x223B7") ; <CJK>
       (?$(K$0(B . "0x223BB") ; <CJK>
       (?$(K$1(B . "0x223B9") ; <CJK>
       (?$(K$2(B . "0x223C5") ; <CJK>
       (?$(K$3(B . "0x22453") ; <CJK>
       (?$(K$4(B . "0x224C4") ; <CJK>
       (?$(K$5(B . "0x224C6") ; <CJK>
       (?$(K$6(B . "0x224CB") ; <CJK>
       (?$(K$7(B . "0x225C8") ; <CJK>
       (?$(K$8(B . "0x2F89F") ; <CJK>
       (?$(K$9(B . "0x225C9") ; <CJK>
       (?$(K$:(B . "0x225DB") ; <CJK>
       (?$(K$;(B . "0x22994") ; <CJK>
       (?$(K$<(B . "0x22A95") ; <CJK>
       (?$(K$=(B . "0x22A88") ; <CJK>
       (?$(K$>(B . "0x22A8D") ; <CJK>
       (?$(K$?(B . "0x22EEC") ; <CJK>
       (?$(K$@(B . "0x22EEE") ; <CJK>
       (?$(K$A(B . "0x22EF1") ; <CJK>
       (?$(K$B(B . "0x2312E") ; <CJK>
       (?$(K$C(B . "0x23149") ; <CJK>
       (?$(K$D(B . "0x2335F") ; <CJK>
       (?$(K$E(B . "0x233D1") ; <CJK>
       (?$(K$F(B . "0x233CB") ; <CJK>
       (?$(K$G(B . "0x23885") ; <CJK>
       (?$(K$H(B . "0x3C1D") ; <CJK>
       (?$(K$I(B . "0x2394A") ; <CJK>
       (?$(K$J(B . "0x23947") ; <CJK>
       (?$(K$K(B . "0x2394B") ; <CJK>
       (?$(K$L(B . "0x239BB") ; <CJK>
       (?$(K$M(B . "0x239C4") ; <CJK>
       (?$(K$N(B . "0x3C7C") ; <CJK>
       (?$(K$O(B . "0x23B02") ; <CJK>
       (?$(K$P(B . "0x23C82") ; <CJK>
       (?$(K$Q(B . "0x23C91") ; <CJK>
       (?$(K$R(B . "0x23C8F") ; <CJK>
       (?$(K$S(B . "0x23C92") ; <CJK>
       (?$(K$T(B . "0x2418F") ; <CJK>
       (?$(K$U(B . "0x24191") ; <CJK>
       (?$(K$V(B . "0x241B4") ; <CJK>
       (?$(K$W(B . "0x24192") ; <CJK>
       (?$(K$X(B . "0x244F4") ; <CJK>
       (?$(K$Y(B . "0x245AA") ; <CJK>
       (?$(K$Z(B . "0x24735") ; <CJK>
       (?$(K$[(B . "0x24737") ; <CJK>
       (?$(K$\(B . "0x2473D") ; <CJK>
       (?$(K$](B . "0x2473C") ; <CJK>
       (?$(K$^(B . "0x2472F") ; <CJK>
       (?$(K$_(B . "0x24730") ; <CJK>
       (?$(K$`(B . "0x248F8") ; <CJK>
       (?$(K$a(B . "0x248EF") ; <CJK>
       (?$(K$b(B . "0x24B26") ; <CJK>
       (?$(K$c(B . "0x3F55") ; <CJK>
       (?$(K$d(B . "0x24D26") ; <CJK>
       (?$(K$e(B . "0x24D27") ; <CJK>
       (?$(K$f(B . "0x24F41") ; <CJK>
       (?$(K$g(B . "0x24FC6") ; <CJK>
       (?$(K$h(B . "0x24FC7") ; <CJK>
       (?$(K$i(B . "0x250EB") ; <CJK>
       (?$(K$j(B . "0x250E8") ; <CJK>
       (?$(K$k(B . "0x250EA") ; <CJK>
       (?$(K$l(B . "0x2541A") ; <CJK>
       (?$(K$m(B . "0x25419") ; <CJK>
       (?$(K$n(B . "0x4126") ; <CJK>
       (?$(K$o(B . "0x25923") ; <CJK>
       (?$(K$p(B . "0x25924") ; <CJK>
       (?$(K$q(B . "0x25E25") ; <CJK>
       (?$(K$r(B . "0x26635") ; <CJK>
       (?$(K$s(B . "0x26634") ; <CJK>
       (?$(K$t(B . "0x26A07") ; <CJK>
       (?$(K$u(B . "0x2721D") ; <CJK>
       (?$(K$v(B . "0x277E1") ; <CJK>
       (?$(K$w(B . "0x27BAB") ; <CJK>
       (?$(K$x(B . "0x28460") ; <CJK>
       (?$(K$y(B . "0x28677") ; <CJK>
       (?$(K$z(B . "0x2867D") ; <CJK>
       (?$(K${(B . "0x49BC") ; <CJK>
       (?$(K$|(B . "0x28E1E") ; <CJK>
       (?$(K$}(B . "0x28E1A") ; <CJK>
       (?$(K$~(B . "0x28E1D") ; <CJK>
       (?$(K%!(B . "0x2006B") ; <CJK>
       (?$(K%"(B . "0x2012D") ; <CJK>
       (?$(K%#(B . "0x2014C") ; <CJK>
       (?$(K%$(B . "0x2022A") ; <CJK>
       (?$(K%%(B . "0x344A") ; <CJK>
       (?$(K%&(B . "0x20215") ; <CJK>
       (?$(K%'(B . "0x2022C") ; <CJK>
       (?$(K%((B . "0x20206") ; <CJK>
       (?$(K%)(B . "0x20208") ; <CJK>
       (?$(K%*(B . "0x2020A") ; <CJK>
       (?$(K%+(B . "0x344E") ; <CJK>
       (?$(K%,(B . "0x20556") ; <CJK>
       (?$(K%-(B . "0x20584") ; <CJK>
       (?$(K%.(B . "0x34C9") ; <CJK>
       (?$(K%/(B . "0x205C6") ; <CJK>
       (?$(K%0(B . "0x206F5") ; <CJK>
       (?$(K%1(B . "0x20709") ; <CJK>
       (?$(K%2(B . "0x206F8") ; <CJK>
       (?$(K%3(B . "0x206E8") ; <CJK>
       (?$(K%4(B . "0x206FB") ; <CJK>
       (?$(K%5(B . "0x206E9") ; <CJK>
       (?$(K%6(B . "0x206F6") ; <CJK>
       (?$(K%7(B . "0x52B7") ; <CJK>
       (?$(K%8(B . "0x52B8") ; <CJK>
       (?$(K%9(B . "0x20852") ; <CJK>
       (?$(K%:(B . "0x52B6") ; <CJK>
       (?$(K%;(B . "0x52BA") ; <CJK>
       (?$(K%<(B . "0x20854") ; <CJK>
       (?$(K%=(B . "0x20851") ; <CJK>
       (?$(K%>(B . "0x20939") ; <CJK>
       (?$(K%?(B . "0x2093A") ; <CJK>
       (?$(K%@(B . "0x20998") ; <CJK>
       (?$(K%A(B . "0x20A4E") ; <CJK>
       (?$(K%B(B . "0x357B") ; <CJK>
       (?$(K%C(B . "0x20C36") ; <CJK>
       (?$(K%D(B . "0x20C0C") ; <CJK>
       (?$(K%E(B . "0x20C10") ; <CJK>
       (?$(K%F(B . "0x20C32") ; <CJK>
       (?$(K%G(B . "0x20C11") ; <CJK>
       (?$(K%H(B . "0x20C18") ; <CJK>
       (?$(K%I(B . "0x20C1C") ; <CJK>
       (?$(K%J(B . "0x20C1A") ; <CJK>
       (?$(K%K(B . "0x20C19") ; <CJK>
       (?$(K%L(B . "0x20C0B") ; <CJK>
       (?$(K%M(B . "0x20C0F") ; <CJK>
       (?$(K%N(B . "0x20C1D") ; <CJK>
       (?$(K%O(B . "0x20C21") ; <CJK>
       (?$(K%P(B . "0x20C13") ; <CJK>
       (?$(K%Q(B . "0x20C1B") ; <CJK>
       (?$(K%R(B . "0x20C15") ; <CJK>
       (?$(K%S(B . "0x3620") ; <CJK>
       (?$(K%T(B . "0x211D1") ; <CJK>
       (?$(K%U(B . "0x211C8") ; <CJK>
       (?$(K%V(B . "0x2128D") ; <CJK>
       (?$(K%W(B . "0x212B5") ; <CJK>
       (?$(K%X(B . "0x3689") ; <CJK>
       (?$(K%Y(B . "0x3695") ; <CJK>
       (?$(K%Z(B . "0x215F8") ; <CJK>
       (?$(K%[(B . "0x216E0") ; <CJK>
       (?$(K%\(B . "0x216E1") ; <CJK>
       (?$(K%](B . "0x36BE") ; <CJK>
       (?$(K%^(B . "0x216DE") ; <CJK>
       (?$(K%_(B . "0x216FE") ; <CJK>
       (?$(K%`(B . "0x216DC") ; <CJK>
       (?$(K%a(B . "0x21701") ; <CJK>
       (?$(K%b(B . "0x216FD") ; <CJK>
       (?$(K%c(B . "0x21700") ; <CJK>
       (?$(K%d(B . "0x219D7") ; <CJK>
       (?$(K%e(B . "0x219D6") ; <CJK>
       (?$(K%f(B . "0x219D9") ; <CJK>
       (?$(K%g(B . "0x21B65") ; <CJK>
       (?$(K%h(B . "0x21BD2") ; <CJK>
       (?$(K%i(B . "0x21BDC") ; <CJK>
       (?$(K%j(B . "0x21BE1") ; <CJK>
       (?$(K%k(B . "0x21BDE") ; <CJK>
       (?$(K%l(B . "0x21C42") ; <CJK>
       (?$(K%m(B . "0x21C4B") ; <CJK>
       (?$(K%n(B . "0x37C3") ; <CJK>
       (?$(K%o(B . "0x21D8E") ; <CJK>
       (?$(K%p(B . "0x21D91") ; <CJK>
       (?$(K%q(B . "0x21D8B") ; <CJK>
       (?$(K%r(B . "0x21D90") ; <CJK>
       (?$(K%s(B . "0x21D88") ; <CJK>
       (?$(K%t(B . "0x21D89") ; <CJK>
       (?$(K%u(B . "0x21D84") ; <CJK>
       (?$(K%v(B . "0x21DAA") ; <CJK>
       (?$(K%w(B . "0x2208D") ; <CJK>
       (?$(K%x(B . "0x2208F") ; <CJK>
       (?$(K%y(B . "0x2207D") ; <CJK>
       (?$(K%z(B . "0x2207F") ; <CJK>
       (?$(K%{(B . "0x2207B") ; <CJK>
       (?$(K%|(B . "0x22080") ; <CJK>
       (?$(K%}(B . "0x2207E") ; <CJK>
       (?$(K%~(B . "0x22083") ; <CJK>
       (?$(K&!(B . "0x22081") ; <CJK>
       (?$(K&"(B . "0x22086") ; <CJK>
       (?$(K&#(B . "0x2208A") ; <CJK>
       (?$(K&$(B . "0x221BD") ; <CJK>
       (?$(K&%(B . "0x221BE") ; <CJK>
       (?$(K&&(B . "0x3877") ; <CJK>
       (?$(K&'(B . "0x221F4") ; <CJK>
       (?$(K&((B . "0x221F3") ; <CJK>
       (?$(K&)(B . "0x22202") ; <CJK>
       (?$(K&*(B . "0x221F6") ; <CJK>
       (?$(K&+(B . "0x221F5") ; <CJK>
       (?$(K&,(B . "0x221F2") ; <CJK>
       (?$(K&-(B . "0x22204") ; <CJK>
       (?$(K&.(B . "0x2233D") ; <CJK>
       (?$(K&/(B . "0x223C6") ; <CJK>
       (?$(K&0(B . "0x22489") ; <CJK>
       (?$(K&1(B . "0x224D4") ; <CJK>
       (?$(K&2(B . "0x224D6") ; <CJK>
       (?$(K&3(B . "0x224D2") ; <CJK>
       (?$(K&4(B . "0x225FA") ; <CJK>
       (?$(K&5(B . "0x22606") ; <CJK>
       (?$(K&6(B . "0x2260C") ; <CJK>
       (?$(K&7(B . "0x2260A") ; <CJK>
       (?$(K&8(B . "0x2260F") ; <CJK>
       (?$(K&9(B . "0x22A2F") ; <CJK>
       (?$(K&:(B . "0x39D4") ; <CJK>
       (?$(K&;(B . "0x22AB7") ; <CJK>
       (?$(K&<(B . "0x22ABE") ; <CJK>
       (?$(K&=(B . "0x22ABC") ; <CJK>
       (?$(K&>(B . "0x22AE2") ; <CJK>
       (?$(K&?(B . "0x22F06") ; <CJK>
       (?$(K&@(B . "0x22EF7") ; <CJK>
       (?$(K&A(B . "0x22F07") ; <CJK>
       (?$(K&B(B . "0x22EF6") ; <CJK>
       (?$(K&C(B . "0x23B35") ; <CJK>
       (?$(K&D(B . "0x2315F") ; <CJK>
       (?$(K&E(B . "0x23165") ; <CJK>
       (?$(K&F(B . "0x23164") ; <CJK>
       (?$(K&G(B . "0x23161") ; <CJK>
       (?$(K&H(B . "0x2315A") ; <CJK>
       (?$(K&I(B . "0x2315D") ; <CJK>
       (?$(K&J(B . "0x2F8D7") ; <CJK>
       (?$(K&K(B . "0x233D7") ; <CJK>
       (?$(K&L(B . "0x233D5") ; <CJK>
       (?$(K&M(B . "0x233DE") ; <CJK>
       (?$(K&N(B . "0x233E1") ; <CJK>
       (?$(K&O(B . "0x233E0") ; <CJK>
       (?$(K&P(B . "0x233D9") ; <CJK>
       (?$(K&Q(B . "0x3B4C") ; <CJK>
       (?$(K&R(B . "0x233DA") ; <CJK>
       (?$(K&S(B . "0x233DF") ; <CJK>
       (?$(K&T(B . "0x233F6") ; <CJK>
       (?$(K&U(B . "0x23403") ; <CJK>
       (?$(K&V(B . "0x3C20") ; <CJK>
       (?$(K&W(B . "0x23893") ; <CJK>
       (?$(K&X(B . "0x2388B") ; <CJK>
       (?$(K&Y(B . "0x23891") ; <CJK>
       (?$(K&Z(B . "0x23892") ; <CJK>
       (?$(K&[(B . "0x2388A") ; <CJK>
       (?$(K&\(B . "0x23889") ; <CJK>
       (?$(K&](B . "0x2388F") ; <CJK>
       (?$(K&^(B . "0x23956") ; <CJK>
       (?$(K&_(B . "0x23959") ; <CJK>
       (?$(K&`(B . "0x239CA") ; <CJK>
       (?$(K&a(B . "0x239CC") ; <CJK>
       (?$(K&b(B . "0x3C5B") ; <CJK>
       (?$(K&c(B . "0x239D0") ; <CJK>
       (?$(K&d(B . "0x239CD") ; <CJK>
       (?$(K&e(B . "0x239D6") ; <CJK>
       (?$(K&f(B . "0x239CB") ; <CJK>
       (?$(K&g(B . "0x23A83") ; <CJK>
       (?$(K&h(B . "0x23A82") ; <CJK>
       (?$(K&i(B . "0x23B06") ; <CJK>
       (?$(K&j(B . "0x23B2A") ; <CJK>
       (?$(K&k(B . "0x23B2C") ; <CJK>
       (?$(K&l(B . "0x23B2B") ; <CJK>
       (?$(K&m(B . "0x23B29") ; <CJK>
       (?$(K&n(B . "0x23CBD") ; <CJK>
       (?$(K&o(B . "0x23CB3") ; <CJK>
       (?$(K&p(B . "0x23CBE") ; <CJK>
       (?$(K&q(B . "0x23CC0") ; <CJK>
       (?$(K&r(B . "0x23CB5") ; <CJK>
       (?$(K&s(B . "0x23CB6") ; <CJK>
       (?$(K&t(B . "0x2419D") ; <CJK>
       (?$(K&u(B . "0x2419F") ; <CJK>
       (?$(K&v(B . "0x24620") ; <CJK>
       (?$(K&w(B . "0x3E2D") ; <CJK>
       (?$(K&x(B . "0x2461E") ; <CJK>
       (?$(K&y(B . "0x2461C") ; <CJK>
       (?$(K&z(B . "0x24632") ; <CJK>
       (?$(K&{(B . "0x2461F") ; <CJK>
       (?$(K&|(B . "0x2462B") ; <CJK>
       (?$(K&}(B . "0x24621") ; <CJK>
       (?$(K&~(B . "0x24626") ; <CJK>
       (?$(K'!(B . "0x24624") ; <CJK>
       (?$(K'"(B . "0x2461D") ; <CJK>
       (?$(K'#(B . "0x24627") ; <CJK>
       (?$(K'$(B . "0x2475B") ; <CJK>
       (?$(K'%(B . "0x24759") ; <CJK>
       (?$(K'&(B . "0x24780") ; <CJK>
       (?$(K''(B . "0x24755") ; <CJK>
       (?$(K'((B . "0x24750") ; <CJK>
       (?$(K')(B . "0x2475A") ; <CJK>
       (?$(K'*(B . "0x24756") ; <CJK>
       (?$(K'+(B . "0x24763") ; <CJK>
       (?$(K',(B . "0x24752") ; <CJK>
       (?$(K'-(B . "0x24758") ; <CJK>
       (?$(K'.(B . "0x3E63") ; <CJK>
       (?$(K'/(B . "0x24739") ; <CJK>
       (?$(K'0(B . "0x248F9") ; <CJK>
       (?$(K'1(B . "0x24B28") ; <CJK>
       (?$(K'2(B . "0x3F18") ; <CJK>
       (?$(K'3(B . "0x24BBC") ; <CJK>
       (?$(K'4(B . "0x24BD6") ; <CJK>
       (?$(K'5(B . "0x24C05") ; <CJK>
       (?$(K'6(B . "0x24C20") ; <CJK>
       (?$(K'7(B . "0x3F74") ; <CJK>
       (?$(K'8(B . "0x24D33") ; <CJK>
       (?$(K'9(B . "0x24F46") ; <CJK>
       (?$(K':(B . "0x24F42") ; <CJK>
       (?$(K';(B . "0x24F43") ; <CJK>
       (?$(K'<(B . "0x24F47") ; <CJK>
       (?$(K'=(B . "0x24FCB") ; <CJK>
       (?$(K'>(B . "0x25042") ; <CJK>
       (?$(K'?(B . "0x25045") ; <CJK>
       (?$(K'@(B . "0x250FD") ; <CJK>
       (?$(K'A(B . "0x250F4") ; <CJK>
       (?$(K'B(B . "0x250F9") ; <CJK>
       (?$(K'C(B . "0x250FA") ; <CJK>
       (?$(K'D(B . "0x2535E") ; <CJK>
       (?$(K'E(B . "0x2541D") ; <CJK>
       (?$(K'F(B . "0x4128") ; <CJK>
       (?$(K'G(B . "0x25758") ; <CJK>
       (?$(K'H(B . "0x25755") ; <CJK>
       (?$(K'I(B . "0x25A57") ; <CJK>
       (?$(K'J(B . "0x25A58") ; <CJK>
       (?$(K'K(B . "0x25AD9") ; <CJK>
       (?$(K'L(B . "0x25ADC") ; <CJK>
       (?$(K'M(B . "0x25ADB") ; <CJK>
       (?$(K'N(B . "0x25E27") ; <CJK>
       (?$(K'O(B . "0x25F85") ; <CJK>
       (?$(K'P(B . "0x25F87") ; <CJK>
       (?$(K'Q(B . "0x25F8A") ; <CJK>
       (?$(K'R(B . "0x2628B") ; <CJK>
       (?$(K'S(B . "0x2634F") ; <CJK>
       (?$(K'T(B . "0x26530") ; <CJK>
       (?$(K'U(B . "0x2652F") ; <CJK>
       (?$(K'V(B . "0x26668") ; <CJK>
       (?$(K'W(B . "0x26649") ; <CJK>
       (?$(K'X(B . "0x43DA") ; <CJK>
       (?$(K'Y(B . "0x26648") ; <CJK>
       (?$(K'Z(B . "0x2663F") ; <CJK>
       (?$(K'[(B . "0x2664B") ; <CJK>
       (?$(K'\(B . "0x2665C") ; <CJK>
       (?$(K'](B . "0x26646") ; <CJK>
       (?$(K'^(B . "0x26640") ; <CJK>
       (?$(K'_(B . "0x26A0D") ; <CJK>
       (?$(K'`(B . "0x26B1B") ; <CJK>
       (?$(K'a(B . "0x26B1D") ; <CJK>
       (?$(K'b(B . "0x26B17") ; <CJK>
       (?$(K'c(B . "0x44A4") ; <CJK>
       (?$(K'd(B . "0x26B22") ; <CJK>
       (?$(K'e(B . "0x275A7") ; <CJK>
       (?$(K'f(B . "0x27608") ; <CJK>
       (?$(K'g(B . "0x27806") ; <CJK>
       (?$(K'h(B . "0x2847D") ; <CJK>
       (?$(K'i(B . "0x488E") ; <CJK>
       (?$(K'j(B . "0x28463") ; <CJK>
       (?$(K'k(B . "0x28464") ; <CJK>
       (?$(K'l(B . "0x2847F") ; <CJK>
       (?$(K'm(B . "0x2846B") ; <CJK>
       (?$(K'n(B . "0x2847C") ; <CJK>
       (?$(K'o(B . "0x28468") ; <CJK>
       (?$(K'p(B . "0x28465") ; <CJK>
       (?$(K'q(B . "0x2846A") ; <CJK>
       (?$(K'r(B . "0x28698") ; <CJK>
       (?$(K's(B . "0x28699") ; <CJK>
       (?$(K't(B . "0x286AE") ; <CJK>
       (?$(K'u(B . "0x28E2B") ; <CJK>
       (?$(K'v(B . "0x28E2D") ; <CJK>
       (?$(K'w(B . "0x28E31") ; <CJK>
       (?$(K'x(B . "0x28E2E") ; <CJK>
       (?$(K'y(B . "0x28E2F") ; <CJK>
       (?$(K'z(B . "0x2006D") ; <CJK>
       (?$(K'{(B . "0x20131") ; <CJK>
       (?$(K'|(B . "0x2022D") ; <CJK>
       (?$(K'}(B . "0x20239") ; <CJK>
       (?$(K'~(B . "0x20238") ; <CJK>
       (?$(K(!(B . "0x345B") ; <CJK>
       (?$(K("(B . "0x2023A") ; <CJK>
       (?$(K(#(B . "0x20235") ; <CJK>
       (?$(K($(B . "0x20262") ; <CJK>
       (?$(K(%(B . "0x204EA") ; <CJK>
       (?$(K(&(B . "0x204EB") ; <CJK>
       (?$(K('(B . "0x20515") ; <CJK>
       (?$(K(((B . "0x205CC") ; <CJK>
       (?$(K()(B . "0x205C8") ; <CJK>
       (?$(K(*(B . "0x205CD") ; <CJK>
       (?$(K(+(B . "0x205DB") ; <CJK>
       (?$(K(,(B . "0x205CB") ; <CJK>
       (?$(K(-(B . "0x20711") ; <CJK>
       (?$(K(.(B . "0x20726") ; <CJK>
       (?$(K(/(B . "0x20862") ; <CJK>
       (?$(K(0(B . "0x2085E") ; <CJK>
       (?$(K(1(B . "0x20861") ; <CJK>
       (?$(K(2(B . "0x20941") ; <CJK>
       (?$(K(3(B . "0x2093F") ; <CJK>
       (?$(K(4(B . "0x20975") ; <CJK>
       (?$(K(5(B . "0x23965") ; <CJK>
       (?$(K(6(B . "0x20B49") ; <CJK>
       (?$(K(7(B . "0x209EB") ; <CJK>
       (?$(K(8(B . "0x20A1A") ; <CJK>
       (?$(K(9(B . "0x20A57") ; <CJK>
       (?$(K(:(B . "0x20C6B") ; <CJK>
       (?$(K(;(B . "0x20CA9") ; <CJK>
       (?$(K(<(B . "0x20C54") ; <CJK>
       (?$(K(=(B . "0x20C62") ; <CJK>
       (?$(K(>(B . "0x20CAA") ; <CJK>
       (?$(K(?(B . "0x20C58") ; <CJK>
       (?$(K(@(B . "0x20C72") ; <CJK>
       (?$(K(A(B . "0x20C63") ; <CJK>
       (?$(K(B(B . "0x20C73") ; <CJK>
       (?$(K(C(B . "0x20C8B") ; <CJK>
       (?$(K(D(B . "0x20C8C") ; <CJK>
       (?$(K(E(B . "0x20C5C") ; <CJK>
       (?$(K(F(B . "0x20C51") ; <CJK>
       (?$(K(G(B . "0x20C16") ; <CJK>
       (?$(K(H(B . "0x20C60") ; <CJK>
       (?$(K(I(B . "0x20C61") ; <CJK>
       (?$(K(J(B . "0x20C5E") ; <CJK>
       (?$(K(K(B . "0x20C5D") ; <CJK>
       (?$(K(L(B . "0x20C64") ; <CJK>
       (?$(K(M(B . "0x20C53") ; <CJK>
       (?$(K(N(B . "0x20C5F") ; <CJK>
       (?$(K(O(B . "0x20C5B") ; <CJK>
       (?$(K(P(B . "0x20C6E") ; <CJK>
       (?$(K(Q(B . "0x20C55") ; <CJK>
       (?$(K(R(B . "0x20C52") ; <CJK>
       (?$(K(S(B . "0x20C68") ; <CJK>
       (?$(K(T(B . "0x211D2") ; <CJK>
       (?$(K(U(B . "0x211D6") ; <CJK>
       (?$(K(V(B . "0x211D3") ; <CJK>
       (?$(K(W(B . "0x212B8") ; <CJK>
       (?$(K(X(B . "0x212BB") ; <CJK>
       (?$(K(Y(B . "0x212EB") ; <CJK>
       (?$(K(Z(B . "0x212E8") ; <CJK>
       (?$(K([(B . "0x212B6") ; <CJK>
       (?$(K(\(B . "0x212EA") ; <CJK>
       (?$(K(](B . "0x212E7") ; <CJK>
       (?$(K(^(B . "0x212E9") ; <CJK>
       (?$(K(_(B . "0x21591") ; <CJK>
       (?$(K(`(B . "0x21610") ; <CJK>
       (?$(K(a(B . "0x2160E") ; <CJK>
       (?$(K(b(B . "0x2160F") ; <CJK>
       (?$(K(c(B . "0x2170B") ; <CJK>
       (?$(K(d(B . "0x21703") ; <CJK>
       (?$(K(e(B . "0x2172B") ; <CJK>
       (?$(K(f(B . "0x21709") ; <CJK>
       (?$(K(g(B . "0x21728") ; <CJK>
       (?$(K(h(B . "0x2172C") ; <CJK>
       (?$(K(i(B . "0x21725") ; <CJK>
       (?$(K(j(B . "0x21727") ; <CJK>
       (?$(K(k(B . "0x2170F") ; <CJK>
       (?$(K(l(B . "0x219E9") ; <CJK>
       (?$(K(m(B . "0x219EC") ; <CJK>
       (?$(K(n(B . "0x3753") ; <CJK>
       (?$(K(o(B . "0x21B27") ; <CJK>
       (?$(K(p(B . "0x21B73") ; <CJK>
       (?$(K(q(B . "0x21BE2") ; <CJK>
       (?$(K(r(B . "0x21BE6") ; <CJK>
       (?$(K(s(B . "0x2F876") ; <CJK>
       (?$(K(t(B . "0x21C61") ; <CJK>
       (?$(K(u(B . "0x21C51") ; <CJK>
       (?$(K(v(B . "0x21D12") ; <CJK>
       (?$(K(w(B . "0x21D0E") ; <CJK>
       (?$(K(x(B . "0x21DAD") ; <CJK>
       (?$(K(y(B . "0x21DAF") ; <CJK>
       (?$(K(z(B . "0x21DB1") ; <CJK>
       (?$(K({(B . "0x21DD3") ; <CJK>
       (?$(K(|(B . "0x22094") ; <CJK>
       (?$(K(}(B . "0x22092") ; <CJK>
       (?$(K(~(B . "0x22090") ; <CJK>
       (?$(K)!(B . "0x2209D") ; <CJK>
       (?$(K)"(B . "0x22093") ; <CJK>
       (?$(K)#(B . "0x22095") ; <CJK>
       (?$(K)$(B . "0x22098") ; <CJK>
       (?$(K)%(B . "0x22097") ; <CJK>
       (?$(K)&(B . "0x3880") ; <CJK>
       (?$(K)'(B . "0x2F88A") ; <CJK>
       (?$(K)((B . "0x22207") ; <CJK>
       (?$(K))(B . "0x2220B") ; <CJK>
       (?$(K)*(B . "0x22208") ; <CJK>
       (?$(K)+(B . "0x223D9") ; <CJK>
       (?$(K),(B . "0x223D5") ; <CJK>
       (?$(K)-(B . "0x224D7") ; <CJK>
       (?$(K).(B . "0x224DF") ; <CJK>
       (?$(K)/(B . "0x38DD") ; <CJK>
       (?$(K)0(B . "0x224DE") ; <CJK>
       (?$(K)1(B . "0x224E3") ; <CJK>
       (?$(K)2(B . "0x224E2") ; <CJK>
       (?$(K)3(B . "0x38DE") ; <CJK>
       (?$(K)4(B . "0x22647") ; <CJK>
       (?$(K)5(B . "0x3922") ; <CJK>
       (?$(K)6(B . "0x2263D") ; <CJK>
       (?$(K)7(B . "0x22638") ; <CJK>
       (?$(K)8(B . "0x22A44") ; <CJK>
       (?$(K)9(B . "0x22A3A") ; <CJK>
       (?$(K):(B . "0x22AB8") ; <CJK>
       (?$(K);(B . "0x22B2A") ; <CJK>
       (?$(K)<(B . "0x22B00") ; <CJK>
       (?$(K)=(B . "0x22AF3") ; <CJK>
       (?$(K)>(B . "0x22AF2") ; <CJK>
       (?$(K)?(B . "0x22AEB") ; <CJK>
       (?$(K)@(B . "0x22AFA") ; <CJK>
       (?$(K)A(B . "0x22AED") ; <CJK>
       (?$(K)B(B . "0x22AEC") ; <CJK>
       (?$(K)C(B . "0x22AFF") ; <CJK>
       (?$(K)D(B . "0x22AFB") ; <CJK>
       (?$(K)E(B . "0x6306") ; <CJK>
       (?$(K)F(B . "0x22B4E") ; <CJK>
       (?$(K)G(B . "0x22AEF") ; <CJK>
       (?$(K)H(B . "0x22AF7") ; <CJK>
       (?$(K)I(B . "0x22F10") ; <CJK>
       (?$(K)J(B . "0x22F11") ; <CJK>
       (?$(K)K(B . "0x22F0C") ; <CJK>
       (?$(K)L(B . "0x22F0B") ; <CJK>
       (?$(K)M(B . "0x230DD") ; <CJK>
       (?$(K)N(B . "0x23130") ; <CJK>
       (?$(K)O(B . "0x3ADB") ; <CJK>
       (?$(K)P(B . "0x2317A") ; <CJK>
       (?$(K)Q(B . "0x23177") ; <CJK>
       (?$(K)R(B . "0x23328") ; <CJK>
       (?$(K)S(B . "0x23327") ; <CJK>
       (?$(K)T(B . "0x23365") ; <CJK>
       (?$(K)U(B . "0x2340E") ; <CJK>
       (?$(K)V(B . "0x2340B") ; <CJK>
       (?$(K)W(B . "0x23441") ; <CJK>
       (?$(K)X(B . "0x23413") ; <CJK>
       (?$(K)Y(B . "0x2340F") ; <CJK>
       (?$(K)Z(B . "0x23412") ; <CJK>
       (?$(K)[(B . "0x23430") ; <CJK>
       (?$(K)\(B . "0x238A0") ; <CJK>
       (?$(K)](B . "0x238A3") ; <CJK>
       (?$(K)^(B . "0x2389E") ; <CJK>
       (?$(K)_(B . "0x23897") ; <CJK>
       (?$(K)`(B . "0x238A1") ; <CJK>
       (?$(K)a(B . "0x2389D") ; <CJK>
       (?$(K)b(B . "0x2389B") ; <CJK>
       (?$(K)c(B . "0x23963") ; <CJK>
       (?$(K)d(B . "0x239E3") ; <CJK>
       (?$(K)e(B . "0x239E4") ; <CJK>
       (?$(K)f(B . "0x239E6") ; <CJK>
       (?$(K)g(B . "0x239E7") ; <CJK>
       (?$(K)h(B . "0x239DD") ; <CJK>
       (?$(K)i(B . "0x6B85") ; <CJK>
       (?$(K)j(B . "0x239EC") ; <CJK>
       (?$(K)k(B . "0x239E5") ; <CJK>
       (?$(K)l(B . "0x239F1") ; <CJK>
       (?$(K)m(B . "0x23B3B") ; <CJK>
       (?$(K)n(B . "0x23B39") ; <CJK>
       (?$(K)o(B . "0x23B3A") ; <CJK>
       (?$(K)p(B . "0x23B3C") ; <CJK>
       (?$(K)q(B . "0x23B3D") ; <CJK>
       (?$(K)r(B . "0x23B47") ; <CJK>
       (?$(K)s(B . "0x23B3F") ; <CJK>
       (?$(K)t(B . "0x23B44") ; <CJK>
       (?$(K)u(B . "0x23C48") ; <CJK>
       (?$(K)v(B . "0x23C49") ; <CJK>
       (?$(K)w(B . "0x23C60") ; <CJK>
       (?$(K)x(B . "0x23CE3") ; <CJK>
       (?$(K)y(B . "0x23CE9") ; <CJK>
       (?$(K)z(B . "0x23CF0") ; <CJK>
       (?$(K){(B . "0x3CDA") ; <CJK>
       (?$(K)|(B . "0x3CDB") ; <CJK>
       (?$(K)}(B . "0x23CF2") ; <CJK>
       (?$(K)~(B . "0x23CED") ; <CJK>
       (?$(K*!(B . "0x23CEC") ; <CJK>
       (?$(K*"(B . "0x23CE6") ; <CJK>
       (?$(K*#(B . "0x23D16") ; <CJK>
       (?$(K*$(B . "0x3CD7") ; <CJK>
       (?$(K*%(B . "0x241BC") ; <CJK>
       (?$(K*&(B . "0x241BE") ; <CJK>
       (?$(K*'(B . "0x241C0") ; <CJK>
       (?$(K*((B . "0x241E0") ; <CJK>
       (?$(K*)(B . "0x24500") ; <CJK>
       (?$(K**(B . "0x24502") ; <CJK>
       (?$(K*+(B . "0x244FE") ; <CJK>
       (?$(K*,(B . "0x2455E") ; <CJK>
       (?$(K*-(B . "0x245B3") ; <CJK>
       (?$(K*.(B . "0x245B7") ; <CJK>
       (?$(K*/(B . "0x2463A") ; <CJK>
       (?$(K*0(B . "0x24639") ; <CJK>
       (?$(K*1(B . "0x2463E") ; <CJK>
       (?$(K*2(B . "0x24638") ; <CJK>
       (?$(K*3(B . "0x2463D") ; <CJK>
       (?$(K*4(B . "0x2464F") ; <CJK>
       (?$(K*5(B . "0x2476E") ; <CJK>
       (?$(K*6(B . "0x2475F") ; <CJK>
       (?$(K*7(B . "0x24781") ; <CJK>
       (?$(K*8(B . "0x24782") ; <CJK>
       (?$(K*9(B . "0x24771") ; <CJK>
       (?$(K*:(B . "0x2477B") ; <CJK>
       (?$(K*;(B . "0x24779") ; <CJK>
       (?$(K*<(B . "0x24777") ; <CJK>
       (?$(K*=(B . "0x24773") ; <CJK>
       (?$(K*>(B . "0x2476F") ; <CJK>
       (?$(K*?(B . "0x24797") ; <CJK>
       (?$(K*@(B . "0x2477E") ; <CJK>
       (?$(K*A(B . "0x248FC") ; <CJK>
       (?$(K*B(B . "0x24911") ; <CJK>
       (?$(K*C(B . "0x24932") ; <CJK>
       (?$(K*D(B . "0x24931") ; <CJK>
       (?$(K*E(B . "0x24910") ; <CJK>
       (?$(K*F(B . "0x24AEC") ; <CJK>
       (?$(K*G(B . "0x24AEB") ; <CJK>
       (?$(K*H(B . "0x24B2C") ; <CJK>
       (?$(K*I(B . "0x24B2D") ; <CJK>
       (?$(K*J(B . "0x24BDA") ; <CJK>
       (?$(K*K(B . "0x24C2E") ; <CJK>
       (?$(K*L(B . "0x24C2C") ; <CJK>
       (?$(K*M(B . "0x24C2A") ; <CJK>
       (?$(K*N(B . "0x24C33") ; <CJK>
       (?$(K*O(B . "0x24C4B") ; <CJK>
       (?$(K*P(B . "0x24D18") ; <CJK>
       (?$(K*Q(B . "0x24D42") ; <CJK>
       (?$(K*R(B . "0x24D3B") ; <CJK>
       (?$(K*S(B . "0x24D3F") ; <CJK>
       (?$(K*T(B . "0x24D41") ; <CJK>
       (?$(K*U(B . "0x24D43") ; <CJK>
       (?$(K*V(B . "0x24D3C") ; <CJK>
       (?$(K*W(B . "0x24F4C") ; <CJK>
       (?$(K*X(B . "0x24F4A") ; <CJK>
       (?$(K*Y(B . "0x24F49") ; <CJK>
       (?$(K*Z(B . "0x24F56") ; <CJK>
       (?$(K*[(B . "0x24FCF") ; <CJK>
       (?$(K*\(B . "0x25047") ; <CJK>
       (?$(K*](B . "0x25048") ; <CJK>
       (?$(K*^(B . "0x25046") ; <CJK>
       (?$(K*_(B . "0x2511B") ; <CJK>
       (?$(K*`(B . "0x25111") ; <CJK>
       (?$(K*a(B . "0x25114") ; <CJK>
       (?$(K*b(B . "0x2511D") ; <CJK>
       (?$(K*c(B . "0x25117") ; <CJK>
       (?$(K*d(B . "0x2511E") ; <CJK>
       (?$(K*e(B . "0x2510B") ; <CJK>
       (?$(K*f(B . "0x2511C") ; <CJK>
       (?$(K*g(B . "0x25112") ; <CJK>
       (?$(K*h(B . "0x25116") ; <CJK>
       (?$(K*i(B . "0x2510D") ; <CJK>
       (?$(K*j(B . "0x25115") ; <CJK>
       (?$(K*k(B . "0x25113") ; <CJK>
       (?$(K*l(B . "0x25118") ; <CJK>
       (?$(K*m(B . "0x401A") ; <CJK>
       (?$(K*n(B . "0x253AC") ; <CJK>
       (?$(K*o(B . "0x25444") ; <CJK>
       (?$(K*p(B . "0x2542C") ; <CJK>
       (?$(K*q(B . "0x25445") ; <CJK>
       (?$(K*r(B . "0x25766") ; <CJK>
       (?$(K*s(B . "0x2576E") ; <CJK>
       (?$(K*t(B . "0x25765") ; <CJK>
       (?$(K*u(B . "0x25768") ; <CJK>
       (?$(K*v(B . "0x25784") ; <CJK>
       (?$(K*w(B . "0x25938") ; <CJK>
       (?$(K*x(B . "0x2593B") ; <CJK>
       (?$(K*y(B . "0x2593A") ; <CJK>
       (?$(K*z(B . "0x2593F") ; <CJK>
       (?$(K*{(B . "0x25ADF") ; <CJK>
       (?$(K*|(B . "0x25ADD") ; <CJK>
       (?$(K*}(B . "0x25ADE") ; <CJK>
       (?$(K*~(B . "0x25AE2") ; <CJK>
       (?$(K+!(B . "0x41D6") ; <CJK>
       (?$(K+"(B . "0x25E2C") ; <CJK>
       (?$(K+#(B . "0x25E2F") ; <CJK>
       (?$(K+$(B . "0x25F8F") ; <CJK>
       (?$(K+%(B . "0x25F90") ; <CJK>
       (?$(K+&(B . "0x25F8C") ; <CJK>
       (?$(K+'(B . "0x25F93") ; <CJK>
       (?$(K+((B . "0x26225") ; <CJK>
       (?$(K+)(B . "0x26288") ; <CJK>
       (?$(K+*(B . "0x262A7") ; <CJK>
       (?$(K++(B . "0x263F7") ; <CJK>
       (?$(K+,(B . "0x264BB") ; <CJK>
       (?$(K+-(B . "0x26538") ; <CJK>
       (?$(K+.(B . "0x26539") ; <CJK>
       (?$(K+/(B . "0x26537") ; <CJK>
       (?$(K+0(B . "0x26614") ; <CJK>
       (?$(K+1(B . "0x2666E") ; <CJK>
       (?$(K+2(B . "0x2667B") ; <CJK>
       (?$(K+3(B . "0x43DE") ; <CJK>
       (?$(K+4(B . "0x2666C") ; <CJK>
       (?$(K+5(B . "0x2667F") ; <CJK>
       (?$(K+6(B . "0x26678") ; <CJK>
       (?$(K+7(B . "0x2667A") ; <CJK>
       (?$(K+8(B . "0x2666F") ; <CJK>
       (?$(K+9(B . "0x43E5") ; <CJK>
       (?$(K+:(B . "0x268FE") ; <CJK>
       (?$(K+;(B . "0x26B48") ; <CJK>
       (?$(K+<(B . "0x26B4B") ; <CJK>
       (?$(K+=(B . "0x26B41") ; <CJK>
       (?$(K+>(B . "0x26B49") ; <CJK>
       (?$(K+?(B . "0x26B3B") ; <CJK>
       (?$(K+@(B . "0x2722D") ; <CJK>
       (?$(K+A(B . "0x275E3") ; <CJK>
       (?$(K+B(B . "0x2761A") ; <CJK>
       (?$(K+C(B . "0x2760D") ; <CJK>
       (?$(K+D(B . "0x27613") ; <CJK>
       (?$(K+E(B . "0x27611") ; <CJK>
       (?$(K+F(B . "0x2761C") ; <CJK>
       (?$(K+G(B . "0x4672") ; <CJK>
       (?$(K+H(B . "0x278B5") ; <CJK>
       (?$(K+I(B . "0x46AF") ; <CJK>
       (?$(K+J(B . "0x27C29") ; <CJK>
       (?$(K+K(B . "0x27CA1") ; <CJK>
       (?$(K+L(B . "0x27D24") ; <CJK>
       (?$(K+M(B . "0x27FBB") ; <CJK>
       (?$(K+N(B . "0x282A1") ; <CJK>
       (?$(K+O(B . "0x28483") ; <CJK>
       (?$(K+P(B . "0x2848D") ; <CJK>
       (?$(K+Q(B . "0x28487") ; <CJK>
       (?$(K+R(B . "0x28485") ; <CJK>
       (?$(K+S(B . "0x2848A") ; <CJK>
       (?$(K+T(B . "0x284A3") ; <CJK>
       (?$(K+U(B . "0x28489") ; <CJK>
       (?$(K+V(B . "0x28484") ; <CJK>
       (?$(K+W(B . "0x284A2") ; <CJK>
       (?$(K+X(B . "0x286B1") ; <CJK>
       (?$(K+Y(B . "0x286B0") ; <CJK>
       (?$(K+Z(B . "0x286AF") ; <CJK>
       (?$(K+[(B . "0x286B6") ; <CJK>
       (?$(K+\(B . "0x286C9") ; <CJK>
       (?$(K+](B . "0x286CA") ; <CJK>
       (?$(K+^(B . "0x286C8") ; <CJK>
       (?$(K+_(B . "0x286B4") ; <CJK>
       (?$(K+`(B . "0x28C59") ; <CJK>
       (?$(K+a(B . "0x28CC9") ; <CJK>
       (?$(K+b(B . "0x28E41") ; <CJK>
       (?$(K+c(B . "0x28E4C") ; <CJK>
       (?$(K+d(B . "0x49C4") ; <CJK>
       (?$(K+e(B . "0x28E45") ; <CJK>
       (?$(K+f(B . "0x28E5A") ; <CJK>
       (?$(K+g(B . "0x200B9") ; <CJK>
       (?$(K+h(B . "0x20294") ; <CJK>
       (?$(K+i(B . "0x2026E") ; <CJK>
       (?$(K+j(B . "0x202A2") ; <CJK>
       (?$(K+k(B . "0x20267") ; <CJK>
       (?$(K+l(B . "0x3463") ; <CJK>
       (?$(K+m(B . "0x202A3") ; <CJK>
       (?$(K+n(B . "0x20276") ; <CJK>
       (?$(K+o(B . "0x2026C") ; <CJK>
       (?$(K+p(B . "0x20264") ; <CJK>
       (?$(K+q(B . "0x202A5") ; <CJK>
       (?$(K+r(B . "0x20230") ; <CJK>
       (?$(K+s(B . "0x202A6") ; <CJK>
       (?$(K+t(B . "0x20269") ; <CJK>
       (?$(K+u(B . "0x202A4") ; <CJK>
       (?$(K+v(B . "0x20490") ; <CJK>
       (?$(K+w(B . "0x2055F") ; <CJK>
       (?$(K+x(B . "0x20560") ; <CJK>
       (?$(K+y(B . "0x205DA") ; <CJK>
       (?$(K+z(B . "0x205D8") ; <CJK>
       (?$(K+{(B . "0x205DD") ; <CJK>
       (?$(K+|(B . "0x34EC") ; <CJK>
       (?$(K+}(B . "0x20759") ; <CJK>
       (?$(K+~(B . "0x2075B") ; <CJK>
       (?$(K,!(B . "0x2075A") ; <CJK>
       (?$(K,"(B . "0x20739") ; <CJK>
       (?$(K,#(B . "0x20734") ; <CJK>
       (?$(K,$(B . "0x20744") ; <CJK>
       (?$(K,%(B . "0x20733") ; <CJK>
       (?$(K,&(B . "0x2073C") ; <CJK>
       (?$(K,'(B . "0x20758") ; <CJK>
       (?$(K,((B . "0x2076A") ; <CJK>
       (?$(K,)(B . "0x2086F") ; <CJK>
       (?$(K,*(B . "0x20872") ; <CJK>
       (?$(K,+(B . "0x20870") ; <CJK>
       (?$(K,,(B . "0x20871") ; <CJK>
       (?$(K,-(B . "0x2086E") ; <CJK>
       (?$(K,.(B . "0x208F0") ; <CJK>
       (?$(K,/(B . "0x208EB") ; <CJK>
       (?$(K,0(B . "0x20949") ; <CJK>
       (?$(K,1(B . "0x2094C") ; <CJK>
       (?$(K,2(B . "0x209F5") ; <CJK>
       (?$(K,3(B . "0x20A20") ; <CJK>
       (?$(K,4(B . "0x20A6A") ; <CJK>
       (?$(K,5(B . "0x20A72") ; <CJK>
       (?$(K,6(B . "0x20B4B") ; <CJK>
       (?$(K,7(B . "0x20B5D") ; <CJK>
       (?$(K,8(B . "0x20C50") ; <CJK>
       (?$(K,9(B . "0x20CF9") ; <CJK>
       (?$(K,:(B . "0x20CFA") ; <CJK>
       (?$(K,;(B . "0x20CFB") ; <CJK>
       (?$(K,<(B . "0x20D23") ; <CJK>
       (?$(K,=(B . "0x20CB7") ; <CJK>
       (?$(K,>(B . "0x20D22") ; <CJK>
       (?$(K,?(B . "0x20CB5") ; <CJK>
       (?$(K,@(B . "0x20CC4") ; <CJK>
       (?$(K,A(B . "0x20CB4") ; <CJK>
       (?$(K,B(B . "0x20CEF") ; <CJK>
       (?$(K,C(B . "0x3598") ; <CJK>
       (?$(K,D(B . "0x20CCD") ; <CJK>
       (?$(K,E(B . "0x20CF0") ; <CJK>
       (?$(K,F(B . "0x20CB8") ; <CJK>
       (?$(K,G(B . "0x20CCB") ; <CJK>
       (?$(K,H(B . "0x20CF1") ; <CJK>
       (?$(K,I(B . "0x20CBA") ; <CJK>
       (?$(K,J(B . "0x20D03") ; <CJK>
       (?$(K,K(B . "0x20CF8") ; <CJK>
       (?$(K,L(B . "0x20CB6") ; <CJK>
       (?$(K,M(B . "0x20CBC") ; <CJK>
       (?$(K,N(B . "0x20CB3") ; <CJK>
       (?$(K,O(B . "0x20D21") ; <CJK>
       (?$(K,P(B . "0x20CF7") ; <CJK>
       (?$(K,Q(B . "0x20CC2") ; <CJK>
       (?$(K,R(B . "0x20CBE") ; <CJK>
       (?$(K,S(B . "0x20CC9") ; <CJK>
       (?$(K,T(B . "0x20CBD") ; <CJK>
       (?$(K,U(B . "0x20CCE") ; <CJK>
       (?$(K,V(B . "0x20CB9") ; <CJK>
       (?$(K,W(B . "0x20CC7") ; <CJK>
       (?$(K,X(B . "0x20CCA") ; <CJK>
       (?$(K,Y(B . "0x20CCC") ; <CJK>
       (?$(K,Z(B . "0x20D26") ; <CJK>
       (?$(K,[(B . "0x211E4") ; <CJK>
       (?$(K,\(B . "0x211E0") ; <CJK>
       (?$(K,](B . "0x211F0") ; <CJK>
       (?$(K,^(B . "0x212EC") ; <CJK>
       (?$(K,_(B . "0x21324") ; <CJK>
       (?$(K,`(B . "0x21318") ; <CJK>
       (?$(K,a(B . "0x2132F") ; <CJK>
       (?$(K,b(B . "0x21325") ; <CJK>
       (?$(K,c(B . "0x21528") ; <CJK>
       (?$(K,d(B . "0x21522") ; <CJK>
       (?$(K,e(B . "0x2156A") ; <CJK>
       (?$(K,f(B . "0x20157") ; <CJK>
       (?$(K,g(B . "0x21594") ; <CJK>
       (?$(K,h(B . "0x21592") ; <CJK>
       (?$(K,i(B . "0x2159C") ; <CJK>
       (?$(K,j(B . "0x21622") ; <CJK>
       (?$(K,k(B . "0x21630") ; <CJK>
       (?$(K,l(B . "0x2161D") ; <CJK>
       (?$(K,m(B . "0x21623") ; <CJK>
       (?$(K,n(B . "0x21735") ; <CJK>
       (?$(K,o(B . "0x21733") ; <CJK>
       (?$(K,p(B . "0x2172F") ; <CJK>
       (?$(K,q(B . "0x2174D") ; <CJK>
       (?$(K,r(B . "0x21731") ; <CJK>
       (?$(K,s(B . "0x2175B") ; <CJK>
       (?$(K,t(B . "0x2175A") ; <CJK>
       (?$(K,u(B . "0x21732") ; <CJK>
       (?$(K,v(B . "0x2175C") ; <CJK>
       (?$(K,w(B . "0x21759") ; <CJK>
       (?$(K,x(B . "0x2175D") ; <CJK>
       (?$(K,y(B . "0x21969") ; <CJK>
       (?$(K,z(B . "0x2196D") ; <CJK>
       (?$(K,{(B . "0x22232") ; <CJK>
       (?$(K,|(B . "0x3758") ; <CJK>
       (?$(K,}(B . "0x21A0A") ; <CJK>
       (?$(K,~(B . "0x21A20") ; <CJK>
       (?$(K-!(B . "0x21A1F") ; <CJK>
       (?$(K-"(B . "0x21A0D") ; <CJK>
       (?$(K-#(B . "0x21BE8") ; <CJK>
       (?$(K-$(B . "0x21BEC") ; <CJK>
       (?$(K-%(B . "0x21C77") ; <CJK>
       (?$(K-&(B . "0x21C70") ; <CJK>
       (?$(K-'(B . "0x21C71") ; <CJK>
       (?$(K-((B . "0x21DF8") ; <CJK>
       (?$(K-)(B . "0x21DD6") ; <CJK>
       (?$(K-*(B . "0x21DD9") ; <CJK>
       (?$(K-+(B . "0x21DDE") ; <CJK>
       (?$(K-,(B . "0x21DD5") ; <CJK>
       (?$(K--(B . "0x21DE1") ; <CJK>
       (?$(K-.(B . "0x37D3") ; <CJK>
       (?$(K-/(B . "0x21DE2") ; <CJK>
       (?$(K-0(B . "0x21DDD") ; <CJK>
       (?$(K-1(B . "0x21DE0") ; <CJK>
       (?$(K-2(B . "0x21E0E") ; <CJK>
       (?$(K-3(B . "0x21E08") ; <CJK>
       (?$(K-4(B . "0x21DDC") ; <CJK>
       (?$(K-5(B . "0x21E0A") ; <CJK>
       (?$(K-6(B . "0x21E0C") ; <CJK>
       (?$(K-7(B . "0x220B4") ; <CJK>
       (?$(K-8(B . "0x220B1") ; <CJK>
       (?$(K-9(B . "0x220B6") ; <CJK>
       (?$(K-:(B . "0x220BC") ; <CJK>
       (?$(K-;(B . "0x2221D") ; <CJK>
       (?$(K-<(B . "0x22224") ; <CJK>
       (?$(K-=(B . "0x22219") ; <CJK>
       (?$(K->(B . "0x2221B") ; <CJK>
       (?$(K-?(B . "0x22222") ; <CJK>
       (?$(K-@(B . "0x2221A") ; <CJK>
       (?$(K-A(B . "0x2221C") ; <CJK>
       (?$(K-B(B . "0x22221") ; <CJK>
       (?$(K-C(B . "0x223E6") ; <CJK>
       (?$(K-D(B . "0x223E4") ; <CJK>
       (?$(K-E(B . "0x223E7") ; <CJK>
       (?$(K-F(B . "0x223EA") ; <CJK>
       (?$(K-G(B . "0x38E2") ; <CJK>
       (?$(K-H(B . "0x2F89B") ; <CJK>
       (?$(K-I(B . "0x224F0") ; <CJK>
       (?$(K-J(B . "0x224F5") ; <CJK>
       (?$(K-K(B . "0x224EF") ; <CJK>
       (?$(K-L(B . "0x22642") ; <CJK>
       (?$(K-M(B . "0x2266E") ; <CJK>
       (?$(K-N(B . "0x2263C") ; <CJK>
       (?$(K-O(B . "0x22697") ; <CJK>
       (?$(K-P(B . "0x2268C") ; <CJK>
       (?$(K-Q(B . "0x22681") ; <CJK>
       (?$(K-R(B . "0x22671") ; <CJK>
       (?$(K-S(B . "0x226CE") ; <CJK>
       (?$(K-T(B . "0x226BA") ; <CJK>
       (?$(K-U(B . "0x2267A") ; <CJK>
       (?$(K-V(B . "0x2267E") ; <CJK>
       (?$(K-W(B . "0x3954") ; <CJK>
       (?$(K-X(B . "0x22672") ; <CJK>
       (?$(K-Y(B . "0x226BB") ; <CJK>
       (?$(K-Z(B . "0x392F") ; <CJK>
       (?$(K-[(B . "0x22673") ; <CJK>
       (?$(K-\(B . "0x22682") ; <CJK>
       (?$(K-](B . "0x39B6") ; <CJK>
       (?$(K-^(B . "0x229BA") ; <CJK>
       (?$(K-_(B . "0x229B8") ; <CJK>
       (?$(K-`(B . "0x22A4B") ; <CJK>
       (?$(K-a(B . "0x22A48") ; <CJK>
       (?$(K-b(B . "0x22B2B") ; <CJK>
       (?$(K-c(B . "0x22AF4") ; <CJK>
       (?$(K-d(B . "0x22B2C") ; <CJK>
       (?$(K-e(B . "0x22B42") ; <CJK>
       (?$(K-f(B . "0x22B48") ; <CJK>
       (?$(K-g(B . "0x22B44") ; <CJK>
       (?$(K-h(B . "0x22B45") ; <CJK>
       (?$(K-i(B . "0x22B3C") ; <CJK>
       (?$(K-j(B . "0x22B37") ; <CJK>
       (?$(K-k(B . "0x22B33") ; <CJK>
       (?$(K-l(B . "0x22B41") ; <CJK>
       (?$(K-m(B . "0x22B32") ; <CJK>
       (?$(K-n(B . "0x22B87") ; <CJK>
       (?$(K-o(B . "0x22F27") ; <CJK>
       (?$(K-p(B . "0x22F23") ; <CJK>
       (?$(K-q(B . "0x22F2D") ; <CJK>
       (?$(K-r(B . "0x22F1F") ; <CJK>
       (?$(K-s(B . "0x22F2C") ; <CJK>
       (?$(K-t(B . "0x22F28") ; <CJK>
       (?$(K-u(B . "0x23075") ; <CJK>
       (?$(K-v(B . "0x23074") ; <CJK>
       (?$(K-w(B . "0x230E7") ; <CJK>
       (?$(K-x(B . "0x23132") ; <CJK>
       (?$(K-y(B . "0x23131") ; <CJK>
       (?$(K-z(B . "0x23199") ; <CJK>
       (?$(K-{(B . "0x23196") ; <CJK>
       (?$(K-|(B . "0x23198") ; <CJK>
       (?$(K-}(B . "0x2319D") ; <CJK>
       (?$(K-~(B . "0x23192") ; <CJK>
       (?$(K.!(B . "0x23194") ; <CJK>
       (?$(K."(B . "0x23195") ; <CJK>
       (?$(K.#(B . "0x23197") ; <CJK>
       (?$(K.$(B . "0x266B9") ; <CJK>
       (?$(K.%(B . "0x3B35") ; <CJK>
       (?$(K.&(B . "0x23411") ; <CJK>
       (?$(K.'(B . "0x2343B") ; <CJK>
       (?$(K.((B . "0x23479") ; <CJK>
       (?$(K.)(B . "0x23442") ; <CJK>
       (?$(K.*(B . "0x23443") ; <CJK>
       (?$(K.+(B . "0x3B5D") ; <CJK>
       (?$(K.,(B . "0x23478") ; <CJK>
       (?$(K.-(B . "0x238AC") ; <CJK>
       (?$(K..(B . "0x3C29") ; <CJK>
       (?$(K./(B . "0x238B1") ; <CJK>
       (?$(K.0(B . "0x238B4") ; <CJK>
       (?$(K.1(B . "0x238B3") ; <CJK>
       (?$(K.2(B . "0x238AF") ; <CJK>
       (?$(K.3(B . "0x238AA") ; <CJK>
       (?$(K.4(B . "0x238B2") ; <CJK>
       (?$(K.5(B . "0x23968") ; <CJK>
       (?$(K.6(B . "0x239F2") ; <CJK>
       (?$(K.7(B . "0x239FE") ; <CJK>
       (?$(K.8(B . "0x239F8") ; <CJK>
       (?$(K.9(B . "0x239F9") ; <CJK>
       (?$(K.:(B . "0x239FF") ; <CJK>
       (?$(K.;(B . "0x239F5") ; <CJK>
       (?$(K.<(B . "0x239F7") ; <CJK>
       (?$(K.=(B . "0x239FD") ; <CJK>
       (?$(K.>(B . "0x23A00") ; <CJK>
       (?$(K.?(B . "0x23A88") ; <CJK>
       (?$(K.@(B . "0x23B6E") ; <CJK>
       (?$(K.A(B . "0x23B5D") ; <CJK>
       (?$(K.B(B . "0x23B63") ; <CJK>
       (?$(K.C(B . "0x23B60") ; <CJK>
       (?$(K.D(B . "0x23C61") ; <CJK>
       (?$(K.E(B . "0x23D37") ; <CJK>
       (?$(K.F(B . "0x23D71") ; <CJK>
       (?$(K.G(B . "0x23D23") ; <CJK>
       (?$(K.H(B . "0x23D22") ; <CJK>
       (?$(K.I(B . "0x23D1F") ; <CJK>
       (?$(K.J(B . "0x23D25") ; <CJK>
       (?$(K.K(B . "0x241FD") ; <CJK>
       (?$(K.L(B . "0x24211") ; <CJK>
       (?$(K.M(B . "0x24223") ; <CJK>
       (?$(K.N(B . "0x241F0") ; <CJK>
       (?$(K.O(B . "0x241EF") ; <CJK>
       (?$(K.P(B . "0x2450E") ; <CJK>
       (?$(K.Q(B . "0x2450C") ; <CJK>
       (?$(K.R(B . "0x245BA") ; <CJK>
       (?$(K.S(B . "0x3E1F") ; <CJK>
       (?$(K.T(B . "0x24652") ; <CJK>
       (?$(K.U(B . "0x24655") ; <CJK>
       (?$(K.V(B . "0x24653") ; <CJK>
       (?$(K.W(B . "0x24654") ; <CJK>
       (?$(K.X(B . "0x24651") ; <CJK>
       (?$(K.Y(B . "0x24658") ; <CJK>
       (?$(K.Z(B . "0x247B0") ; <CJK>
       (?$(K.[(B . "0x2479F") ; <CJK>
       (?$(K.\(B . "0x3E72") ; <CJK>
       (?$(K.](B . "0x247A1") ; <CJK>
       (?$(K.^(B . "0x2479A") ; <CJK>
       (?$(K._(B . "0x247BE") ; <CJK>
       (?$(K.`(B . "0x247A0") ; <CJK>
       (?$(K.a(B . "0x24937") ; <CJK>
       (?$(K.b(B . "0x3F0B") ; <CJK>
       (?$(K.c(B . "0x24AF1") ; <CJK>
       (?$(K.d(B . "0x24AF2") ; <CJK>
       (?$(K.e(B . "0x24B34") ; <CJK>
       (?$(K.f(B . "0x24B37") ; <CJK>
       (?$(K.g(B . "0x24B35") ; <CJK>
       (?$(K.h(B . "0x2238C") ; <CJK>
       (?$(K.i(B . "0x24BDF") ; <CJK>
       (?$(K.j(B . "0x24C4C") ; <CJK>
       (?$(K.k(B . "0x24C4E") ; <CJK>
       (?$(K.l(B . "0x24C64") ; <CJK>
       (?$(K.m(B . "0x24C63") ; <CJK>
       (?$(K.n(B . "0x24C36") ; <CJK>
       (?$(K.o(B . "0x24D58") ; <CJK>
       (?$(K.p(B . "0x24D68") ; <CJK>
       (?$(K.q(B . "0x24D5B") ; <CJK>
       (?$(K.r(B . "0x24D5F") ; <CJK>
       (?$(K.s(B . "0x24D59") ; <CJK>
       (?$(K.t(B . "0x24D65") ; <CJK>
       (?$(K.u(B . "0x24D60") ; <CJK>
       (?$(K.v(B . "0x24D5E") ; <CJK>
       (?$(K.w(B . "0x24FD5") ; <CJK>
       (?$(K.x(B . "0x24FD6") ; <CJK>
       (?$(K.y(B . "0x2504E") ; <CJK>
       (?$(K.z(B . "0x25052") ; <CJK>
       (?$(K.{(B . "0x25135") ; <CJK>
       (?$(K.|(B . "0x25139") ; <CJK>
       (?$(K.}(B . "0x25158") ; <CJK>
       (?$(K.~(B . "0x25141") ; <CJK>
       (?$(K/!(B . "0x25157") ; <CJK>
       (?$(K/"(B . "0x25138") ; <CJK>
       (?$(K/#(B . "0x2513D") ; <CJK>
       (?$(K/$(B . "0x25132") ; <CJK>
       (?$(K/%(B . "0x25144") ; <CJK>
       (?$(K/&(B . "0x2F944") ; <CJK>
       (?$(K/'(B . "0x25363") ; <CJK>
       (?$(K/((B . "0x25362") ; <CJK>
       (?$(K/)(B . "0x253B8") ; <CJK>
       (?$(K/*(B . "0x253B0") ; <CJK>
       (?$(K/+(B . "0x253B1") ; <CJK>
       (?$(K/,(B . "0x2544D") ; <CJK>
       (?$(K/-(B . "0x25463") ; <CJK>
       (?$(K/.(B . "0x25470") ; <CJK>
       (?$(K//(B . "0x2544B") ; <CJK>
       (?$(K/0(B . "0x2544F") ; <CJK>
       (?$(K/1(B . "0x2544E") ; <CJK>
       (?$(K/2(B . "0x25453") ; <CJK>
       (?$(K/3(B . "0x25447") ; <CJK>
       (?$(K/4(B . "0x40A2") ; <CJK>
       (?$(K/5(B . "0x25454") ; <CJK>
       (?$(K/6(B . "0x25452") ; <CJK>
       (?$(K/7(B . "0x25459") ; <CJK>
       (?$(K/8(B . "0x2547E") ; <CJK>
       (?$(K/9(B . "0x2562B") ; <CJK>
       (?$(K/:(B . "0x2562E") ; <CJK>
       (?$(K/;(B . "0x2577F") ; <CJK>
       (?$(K/<(B . "0x2577E") ; <CJK>
       (?$(K/=(B . "0x25781") ; <CJK>
       (?$(K/>(B . "0x25783") ; <CJK>
       (?$(K/?(B . "0x25947") ; <CJK>
       (?$(K/@(B . "0x25954") ; <CJK>
       (?$(K/A(B . "0x2594D") ; <CJK>
       (?$(K/B(B . "0x2594C") ; <CJK>
       (?$(K/C(B . "0x2594B") ; <CJK>
       (?$(K/D(B . "0x25957") ; <CJK>
       (?$(K/E(B . "0x25A65") ; <CJK>
       (?$(K/F(B . "0x25A64") ; <CJK>
       (?$(K/G(B . "0x25A61") ; <CJK>
       (?$(K/H(B . "0x25A62") ; <CJK>
       (?$(K/I(B . "0x25AF0") ; <CJK>
       (?$(K/J(B . "0x25AF3") ; <CJK>
       (?$(K/K(B . "0x25AF9") ; <CJK>
       (?$(K/L(B . "0x25AF4") ; <CJK>
       (?$(K/M(B . "0x25AF5") ; <CJK>
       (?$(K/N(B . "0x25AEF") ; <CJK>
       (?$(K/O(B . "0x25AF8") ; <CJK>
       (?$(K/P(B . "0x25AFC") ; <CJK>
       (?$(K/Q(B . "0x25AF7") ; <CJK>
       (?$(K/R(B . "0x25AFD") ; <CJK>
       (?$(K/S(B . "0x25B17") ; <CJK>
       (?$(K/T(B . "0x25E34") ; <CJK>
       (?$(K/U(B . "0x25E36") ; <CJK>
       (?$(K/V(B . "0x25E38") ; <CJK>
       (?$(K/W(B . "0x25FAF") ; <CJK>
       (?$(K/X(B . "0x25FAE") ; <CJK>
       (?$(K/Y(B . "0x25FAC") ; <CJK>
       (?$(K/Z(B . "0x25FA2") ; <CJK>
       (?$(K/[(B . "0x26228") ; <CJK>
       (?$(K/\(B . "0x22EC2") ; <CJK>
       (?$(K/](B . "0x2629C") ; <CJK>
       (?$(K/^(B . "0x262B3") ; <CJK>
       (?$(K/_(B . "0x26290") ; <CJK>
       (?$(K/`(B . "0x26406") ; <CJK>
       (?$(K/a(B . "0x26404") ; <CJK>
       (?$(K/b(B . "0x2640B") ; <CJK>
       (?$(K/c(B . "0x26405") ; <CJK>
       (?$(K/d(B . "0x26540") ; <CJK>
       (?$(K/e(B . "0x2654F") ; <CJK>
       (?$(K/f(B . "0x266AB") ; <CJK>
       (?$(K/g(B . "0x2669D") ; <CJK>
       (?$(K/h(B . "0x266B8") ; <CJK>
       (?$(K/i(B . "0x266B2") ; <CJK>
       (?$(K/j(B . "0x266D2") ; <CJK>
       (?$(K/k(B . "0x266CF") ; <CJK>
       (?$(K/l(B . "0x266A2") ; <CJK>
       (?$(K/m(B . "0x43EC") ; <CJK>
       (?$(K/n(B . "0x266A5") ; <CJK>
       (?$(K/o(B . "0x266A9") ; <CJK>
       (?$(K/p(B . "0x266A7") ; <CJK>
       (?$(K/q(B . "0x266D0") ; <CJK>
       (?$(K/r(B . "0x26902") ; <CJK>
       (?$(K/s(B . "0x269CF") ; <CJK>
       (?$(K/t(B . "0x269D0") ; <CJK>
       (?$(K/u(B . "0x26A16") ; <CJK>
       (?$(K/v(B . "0x26A19") ; <CJK>
       (?$(K/w(B . "0x26B75") ; <CJK>
       (?$(K/x(B . "0x26B71") ; <CJK>
       (?$(K/y(B . "0x26B91") ; <CJK>
       (?$(K/z(B . "0x26B72") ; <CJK>
       (?$(K/{(B . "0x26B8E") ; <CJK>
       (?$(K/|(B . "0x26B6D") ; <CJK>
       (?$(K/}(B . "0x26B88") ; <CJK>
       (?$(K/~(B . "0x26B73") ; <CJK>
       (?$(K0!(B . "0x44BB") ; <CJK>
       (?$(K0"(B . "0x26B81") ; <CJK>
       (?$(K0#(B . "0x26B76") ; <CJK>
       (?$(K0$(B . "0x26B7B") ; <CJK>
       (?$(K0%(B . "0x26B7F") ; <CJK>
       (?$(K0&(B . "0x26B90") ; <CJK>
       (?$(K0'(B . "0x26B78") ; <CJK>
       (?$(K0((B . "0x2724B") ; <CJK>
       (?$(K0)(B . "0x27248") ; <CJK>
       (?$(K0*(B . "0x2725B") ; <CJK>
       (?$(K0+(B . "0x27251") ; <CJK>
       (?$(K0,(B . "0x2723D") ; <CJK>
       (?$(K0-(B . "0x27240") ; <CJK>
       (?$(K0.(B . "0x27246") ; <CJK>
       (?$(K0/(B . "0x2724D") ; <CJK>
       (?$(K00(B . "0x2723B") ; <CJK>
       (?$(K01(B . "0x2724A") ; <CJK>
       (?$(K02(B . "0x27241") ; <CJK>
       (?$(K03(B . "0x2723E") ; <CJK>
       (?$(K04(B . "0x2724E") ; <CJK>
       (?$(K05(B . "0x275AC") ; <CJK>
       (?$(K06(B . "0x275E6") ; <CJK>
       (?$(K07(B . "0x275E9") ; <CJK>
       (?$(K08(B . "0x27629") ; <CJK>
       (?$(K09(B . "0x4621") ; <CJK>
       (?$(K0:(B . "0x27633") ; <CJK>
       (?$(K0;(B . "0x2762E") ; <CJK>
       (?$(K0<(B . "0x2761E") ; <CJK>
       (?$(K0=(B . "0x461F") ; <CJK>
       (?$(K0>(B . "0x2F9C5") ; <CJK>
       (?$(K0?(B . "0x27622") ; <CJK>
       (?$(K0@(B . "0x27627") ; <CJK>
       (?$(K0A(B . "0x277E7") ; <CJK>
       (?$(K0B(B . "0x2780B") ; <CJK>
       (?$(K0C(B . "0x27966") ; <CJK>
       (?$(K0D(B . "0x27BAD") ; <CJK>
       (?$(K0E(B . "0x27BAE") ; <CJK>
       (?$(K0F(B . "0x8C38") ; <CJK>
       (?$(K0G(B . "0x27C2B") ; <CJK>
       (?$(K0H(B . "0x27C2A") ; <CJK>
       (?$(K0I(B . "0x27D2C") ; <CJK>
       (?$(K0J(B . "0x27D2D") ; <CJK>
       (?$(K0K(B . "0x4791") ; <CJK>
       (?$(K0L(B . "0x4796") ; <CJK>
       (?$(K0M(B . "0x27E8F") ; <CJK>
       (?$(K0N(B . "0x27E93") ; <CJK>
       (?$(K0O(B . "0x27FC6") ; <CJK>
       (?$(K0P(B . "0x27FC5") ; <CJK>
       (?$(K0Q(B . "0x28215") ; <CJK>
       (?$(K0R(B . "0x28213") ; <CJK>
       (?$(K0S(B . "0x282B1") ; <CJK>
       (?$(K0T(B . "0x282A9") ; <CJK>
       (?$(K0U(B . "0x8ECE") ; <CJK>
       (?$(K0V(B . "0x284A8") ; <CJK>
       (?$(K0W(B . "0x284AB") ; <CJK>
       (?$(K0X(B . "0x284BE") ; <CJK>
       (?$(K0Y(B . "0x284AC") ; <CJK>
       (?$(K0Z(B . "0x284A9") ; <CJK>
       (?$(K0[(B . "0x284A6") ; <CJK>
       (?$(K0\(B . "0x284C1") ; <CJK>
       (?$(K0](B . "0x286CC") ; <CJK>
       (?$(K0^(B . "0x286D1") ; <CJK>
       (?$(K0_(B . "0x286D3") ; <CJK>
       (?$(K0`(B . "0x286E4") ; <CJK>
       (?$(K0a(B . "0x286CB") ; <CJK>
       (?$(K0b(B . "0x286E1") ; <CJK>
       (?$(K0c(B . "0x286D2") ; <CJK>
       (?$(K0d(B . "0x286E3") ; <CJK>
       (?$(K0e(B . "0x286CF") ; <CJK>
       (?$(K0f(B . "0x286D0") ; <CJK>
       (?$(K0g(B . "0x286E5") ; <CJK>
       (?$(K0h(B . "0x2870E") ; <CJK>
       (?$(K0i(B . "0x28CCC") ; <CJK>
       (?$(K0j(B . "0x28CCA") ; <CJK>
       (?$(K0k(B . "0x28CCB") ; <CJK>
       (?$(K0l(B . "0x28E5C") ; <CJK>
       (?$(K0m(B . "0x28E61") ; <CJK>
       (?$(K0n(B . "0x28E5D") ; <CJK>
       (?$(K0o(B . "0x28E59") ; <CJK>
       (?$(K0p(B . "0x29077") ; <CJK>
       (?$(K0q(B . "0x29684") ; <CJK>
       (?$(K0r(B . "0x20041") ; <CJK>
       (?$(K0s(B . "0x200FD") ; <CJK>
       (?$(K0t(B . "0x2011A") ; <CJK>
       (?$(K0u(B . "0x20163") ; <CJK>
       (?$(K0v(B . "0x202B6") ; <CJK>
       (?$(K0w(B . "0x202B2") ; <CJK>
       (?$(K0x(B . "0x202E9") ; <CJK>
       (?$(K0y(B . "0x202E7") ; <CJK>
       (?$(K0z(B . "0x202D6") ; <CJK>
       (?$(K0{(B . "0x20330") ; <CJK>
       (?$(K0|(B . "0x202EC") ; <CJK>
       (?$(K0}(B . "0x202DD") ; <CJK>
       (?$(K0~(B . "0x202E8") ; <CJK>
       (?$(K1!(B . "0x202B0") ; <CJK>
       (?$(K1"(B . "0x202B5") ; <CJK>
       (?$(K1#(B . "0x202E1") ; <CJK>
       (?$(K1$(B . "0x20498") ; <CJK>
       (?$(K1%(B . "0x20499") ; <CJK>
       (?$(K1&(B . "0x34BC") ; <CJK>
       (?$(K1'(B . "0x20593") ; <CJK>
       (?$(K1((B . "0x205E5") ; <CJK>
       (?$(K1)(B . "0x34D8") ; <CJK>
       (?$(K1*(B . "0x20760") ; <CJK>
       (?$(K1+(B . "0x2075E") ; <CJK>
       (?$(K1,(B . "0x34F4") ; <CJK>
       (?$(K1-(B . "0x2087B") ; <CJK>
       (?$(K1.(B . "0x208F1") ; <CJK>
       (?$(K1/(B . "0x208F3") ; <CJK>
       (?$(K10(B . "0x20A7F") ; <CJK>
       (?$(K11(B . "0x2F838") ; <CJK>
       (?$(K12(B . "0x20B57") ; <CJK>
       (?$(K13(B . "0x20B58") ; <CJK>
       (?$(K14(B . "0x20D39") ; <CJK>
       (?$(K15(B . "0x20DA7") ; <CJK>
       (?$(K16(B . "0x20D35") ; <CJK>
       (?$(K17(B . "0x20D60") ; <CJK>
       (?$(K18(B . "0x20D51") ; <CJK>
       (?$(K19(B . "0x20D62") ; <CJK>
       (?$(K1:(B . "0x20D42") ; <CJK>
       (?$(K1;(B . "0x20D3C") ; <CJK>
       (?$(K1<(B . "0x20D43") ; <CJK>
       (?$(K1=(B . "0x20DAB") ; <CJK>
       (?$(K1>(B . "0x20DA9") ; <CJK>
       (?$(K1?(B . "0x20DB4") ; <CJK>
       (?$(K1@(B . "0x20D79") ; <CJK>
       (?$(K1A(B . "0x20D6A") ; <CJK>
       (?$(K1B(B . "0x20D3B") ; <CJK>
       (?$(K1C(B . "0x20DAA") ; <CJK>
       (?$(K1D(B . "0x20D33") ; <CJK>
       (?$(K1E(B . "0x20D37") ; <CJK>
       (?$(K1F(B . "0x20D27") ; <CJK>
       (?$(K1G(B . "0x20DA8") ; <CJK>
       (?$(K1H(B . "0x20D70") ; <CJK>
       (?$(K1I(B . "0x20D2F") ; <CJK>
       (?$(K1J(B . "0x20D36") ; <CJK>
       (?$(K1K(B . "0x20DB5") ; <CJK>
       (?$(K1L(B . "0x20D30") ; <CJK>
       (?$(K1M(B . "0x20D3A") ; <CJK>
       (?$(K1N(B . "0x20D38") ; <CJK>
       (?$(K1O(B . "0x20DB1") ; <CJK>
       (?$(K1P(B . "0x20DAC") ; <CJK>
       (?$(K1Q(B . "0x20D2E") ; <CJK>
       (?$(K1R(B . "0x20D75") ; <CJK>
       (?$(K1S(B . "0x20DB0") ; <CJK>
       (?$(K1T(B . "0x211F7") ; <CJK>
       (?$(K1U(B . "0x21200") ; <CJK>
       (?$(K1V(B . "0x211F1") ; <CJK>
       (?$(K1W(B . "0x211F3") ; <CJK>
       (?$(K1X(B . "0x21360") ; <CJK>
       (?$(K1Y(B . "0x21361") ; <CJK>
       (?$(K1Z(B . "0x21332") ; <CJK>
       (?$(K1[(B . "0x2132D") ; <CJK>
       (?$(K1\(B . "0x2134A") ; <CJK>
       (?$(K1](B . "0x2132A") ; <CJK>
       (?$(K1^(B . "0x21567") ; <CJK>
       (?$(K1_(B . "0x215A2") ; <CJK>
       (?$(K1`(B . "0x215A3") ; <CJK>
       (?$(K1a(B . "0x2159E") ; <CJK>
       (?$(K1b(B . "0x215A4") ; <CJK>
       (?$(K1c(B . "0x21644") ; <CJK>
       (?$(K1d(B . "0x21632") ; <CJK>
       (?$(K1e(B . "0x2179B") ; <CJK>
       (?$(K1f(B . "0x21798") ; <CJK>
       (?$(K1g(B . "0x21799") ; <CJK>
       (?$(K1h(B . "0x2179A") ; <CJK>
       (?$(K1i(B . "0x21766") ; <CJK>
       (?$(K1j(B . "0x21762") ; <CJK>
       (?$(K1k(B . "0x2176B") ; <CJK>
       (?$(K1l(B . "0x24562") ; <CJK>
       (?$(K1m(B . "0x21767") ; <CJK>
       (?$(K1n(B . "0x21A3B") ; <CJK>
       (?$(K1o(B . "0x21A23") ; <CJK>
       (?$(K1p(B . "0x21A29") ; <CJK>
       (?$(K1q(B . "0x21B7E") ; <CJK>
       (?$(K1r(B . "0x21BF3") ; <CJK>
       (?$(K1s(B . "0x3785") ; <CJK>
       (?$(K1t(B . "0x21BF5") ; <CJK>
       (?$(K1u(B . "0x3783") ; <CJK>
       (?$(K1v(B . "0x21C80") ; <CJK>
       (?$(K1w(B . "0x21C7E") ; <CJK>
       (?$(K1x(B . "0x21C7C") ; <CJK>
       (?$(K1y(B . "0x21C7F") ; <CJK>
       (?$(K1z(B . "0x21C7D") ; <CJK>
       (?$(K1{(B . "0x21C81") ; <CJK>
       (?$(K1|(B . "0x21E25") ; <CJK>
       (?$(K1}(B . "0x21E29") ; <CJK>
       (?$(K1~(B . "0x21E17") ; <CJK>
       (?$(K2!(B . "0x21E63") ; <CJK>
       (?$(K2"(B . "0x21E67") ; <CJK>
       (?$(K2#(B . "0x21E65") ; <CJK>
       (?$(K2$(B . "0x21E2A") ; <CJK>
       (?$(K2%(B . "0x21E68") ; <CJK>
       (?$(K2&(B . "0x21E26") ; <CJK>
       (?$(K2'(B . "0x21E64") ; <CJK>
       (?$(K2((B . "0x21E1B") ; <CJK>
       (?$(K2)(B . "0x21E62") ; <CJK>
       (?$(K2*(B . "0x21E69") ; <CJK>
       (?$(K2+(B . "0x21FFE") ; <CJK>
       (?$(K2,(B . "0x22044") ; <CJK>
       (?$(K2-(B . "0x22042") ; <CJK>
       (?$(K2.(B . "0x220B7") ; <CJK>
       (?$(K2/(B . "0x220D2") ; <CJK>
       (?$(K20(B . "0x220D4") ; <CJK>
       (?$(K21(B . "0x220D7") ; <CJK>
       (?$(K22(B . "0x220DC") ; <CJK>
       (?$(K23(B . "0x220D1") ; <CJK>
       (?$(K24(B . "0x220D5") ; <CJK>
       (?$(K25(B . "0x220CD") ; <CJK>
       (?$(K26(B . "0x220D8") ; <CJK>
       (?$(K27(B . "0x2219A") ; <CJK>
       (?$(K28(B . "0x22242") ; <CJK>
       (?$(K29(B . "0x22235") ; <CJK>
       (?$(K2:(B . "0x22258") ; <CJK>
       (?$(K2;(B . "0x22234") ; <CJK>
       (?$(K2<(B . "0x2223C") ; <CJK>
       (?$(K2=(B . "0x2223B") ; <CJK>
       (?$(K2>(B . "0x2223E") ; <CJK>
       (?$(K2?(B . "0x2223D") ; <CJK>
       (?$(K2@(B . "0x2225A") ; <CJK>
       (?$(K2A(B . "0x22241") ; <CJK>
       (?$(K2B(B . "0x22238") ; <CJK>
       (?$(K2C(B . "0x22245") ; <CJK>
       (?$(K2D(B . "0x22233") ; <CJK>
       (?$(K2E(B . "0x22326") ; <CJK>
       (?$(K2F(B . "0x38BA") ; <CJK>
       (?$(K2G(B . "0x223F7") ; <CJK>
       (?$(K2H(B . "0x223EF") ; <CJK>
       (?$(K2I(B . "0x223F0") ; <CJK>
       (?$(K2J(B . "0x223EE") ; <CJK>
       (?$(K2K(B . "0x2249D") ; <CJK>
       (?$(K2L(B . "0x22506") ; <CJK>
       (?$(K2M(B . "0x22511") ; <CJK>
       (?$(K2N(B . "0x22508") ; <CJK>
       (?$(K2O(B . "0x22502") ; <CJK>
       (?$(K2P(B . "0x2250A") ; <CJK>
       (?$(K2Q(B . "0x22507") ; <CJK>
       (?$(K2R(B . "0x22691") ; <CJK>
       (?$(K2S(B . "0x2268E") ; <CJK>
       (?$(K2T(B . "0x22685") ; <CJK>
       (?$(K2U(B . "0x226E8") ; <CJK>
       (?$(K2V(B . "0x22717") ; <CJK>
       (?$(K2W(B . "0x226D4") ; <CJK>
       (?$(K2X(B . "0x3969") ; <CJK>
       (?$(K2Y(B . "0x226C4") ; <CJK>
       (?$(K2Z(B . "0x226D5") ; <CJK>
       (?$(K2[(B . "0x3945") ; <CJK>
       (?$(K2\(B . "0x226D8") ; <CJK>
       (?$(K2](B . "0x22680") ; <CJK>
       (?$(K2^(B . "0x226DE") ; <CJK>
       (?$(K2_(B . "0x22742") ; <CJK>
       (?$(K2`(B . "0x229C7") ; <CJK>
       (?$(K2a(B . "0x229BF") ; <CJK>
       (?$(K2b(B . "0x22B8D") ; <CJK>
       (?$(K2c(B . "0x22B89") ; <CJK>
       (?$(K2d(B . "0x22B90") ; <CJK>
       (?$(K2e(B . "0x22B9A") ; <CJK>
       (?$(K2f(B . "0x22BC8") ; <CJK>
       (?$(K2g(B . "0x22B92") ; <CJK>
       (?$(K2h(B . "0x22BA1") ; <CJK>
       (?$(K2i(B . "0x22B84") ; <CJK>
       (?$(K2j(B . "0x22F57") ; <CJK>
       (?$(K2k(B . "0x22F47") ; <CJK>
       (?$(K2l(B . "0x22F77") ; <CJK>
       (?$(K2m(B . "0x22F3A") ; <CJK>
       (?$(K2n(B . "0x22F50") ; <CJK>
       (?$(K2o(B . "0x22F42") ; <CJK>
       (?$(K2p(B . "0x22F43") ; <CJK>
       (?$(K2q(B . "0x22FA3") ; <CJK>
       (?$(K2r(B . "0x23077") ; <CJK>
       (?$(K2s(B . "0x231B2") ; <CJK>
       (?$(K2t(B . "0x231E2") ; <CJK>
       (?$(K2u(B . "0x231BD") ; <CJK>
       (?$(K2v(B . "0x23374") ; <CJK>
       (?$(K2w(B . "0x23482") ; <CJK>
       (?$(K2x(B . "0x234B8") ; <CJK>
       (?$(K2y(B . "0x3B6C") ; <CJK>
       (?$(K2z(B . "0x234BA") ; <CJK>
       (?$(K2{(B . "0x234B9") ; <CJK>
       (?$(K2|(B . "0x234BB") ; <CJK>
       (?$(K2}(B . "0x23487") ; <CJK>
       (?$(K2~(B . "0x2F8E4") ; <CJK>
       (?$(K3!(B . "0x23483") ; <CJK>
       (?$(K3"(B . "0x234B7") ; <CJK>
       (?$(K3#(B . "0x20043") ; <CJK>
       (?$(K3$(B . "0x238CE") ; <CJK>
       (?$(K3%(B . "0x238BA") ; <CJK>
       (?$(K3&(B . "0x23973") ; <CJK>
       (?$(K3'(B . "0x23A09") ; <CJK>
       (?$(K3((B . "0x23A0A") ; <CJK>
       (?$(K3)(B . "0x23A0B") ; <CJK>
       (?$(K3*(B . "0x23A07") ; <CJK>
       (?$(K3+(B . "0x23A05") ; <CJK>
       (?$(K3,(B . "0x23A0E") ; <CJK>
       (?$(K3-(B . "0x23A97") ; <CJK>
       (?$(K3.(B . "0x23B77") ; <CJK>
       (?$(K3/(B . "0x23B7B") ; <CJK>
       (?$(K30(B . "0x23B7A") ; <CJK>
       (?$(K31(B . "0x23B74") ; <CJK>
       (?$(K32(B . "0x23B79") ; <CJK>
       (?$(K33(B . "0x23D86") ; <CJK>
       (?$(K34(B . "0x23DF5") ; <CJK>
       (?$(K35(B . "0x23DA5") ; <CJK>
       (?$(K36(B . "0x23D9D") ; <CJK>
       (?$(K37(B . "0x23DBE") ; <CJK>
       (?$(K38(B . "0x23D96") ; <CJK>
       (?$(K39(B . "0x23DE1") ; <CJK>
       (?$(K3:(B . "0x23DA4") ; <CJK>
       (?$(K3;(B . "0x23DA1") ; <CJK>
       (?$(K3<(B . "0x23DF6") ; <CJK>
       (?$(K3=(B . "0x3D04") ; <CJK>
       (?$(K3>(B . "0x23D8D") ; <CJK>
       (?$(K3?(B . "0x23D8B") ; <CJK>
       (?$(K3@(B . "0x23D78") ; <CJK>
       (?$(K3A(B . "0x23D98") ; <CJK>
       (?$(K3B(B . "0x23E0A") ; <CJK>
       (?$(K3C(B . "0x2425D") ; <CJK>
       (?$(K3D(B . "0x24227") ; <CJK>
       (?$(K3E(B . "0x2425F") ; <CJK>
       (?$(K3F(B . "0x245C0") ; <CJK>
       (?$(K3G(B . "0x245C1") ; <CJK>
       (?$(K3H(B . "0x2466D") ; <CJK>
       (?$(K3I(B . "0x2465E") ; <CJK>
       (?$(K3J(B . "0x2468A") ; <CJK>
       (?$(K3K(B . "0x24662") ; <CJK>
       (?$(K3L(B . "0x24664") ; <CJK>
       (?$(K3M(B . "0x3E3A") ; <CJK>
       (?$(K3N(B . "0x247C0") ; <CJK>
       (?$(K3O(B . "0x247CA") ; <CJK>
       (?$(K3P(B . "0x247D1") ; <CJK>
       (?$(K3Q(B . "0x3E79") ; <CJK>
       (?$(K3R(B . "0x247C7") ; <CJK>
       (?$(K3S(B . "0x247CE") ; <CJK>
       (?$(K3T(B . "0x7309") ; <CJK>
       (?$(K3U(B . "0x247C5") ; <CJK>
       (?$(K3V(B . "0x24936") ; <CJK>
       (?$(K3W(B . "0x24957") ; <CJK>
       (?$(K3X(B . "0x24977") ; <CJK>
       (?$(K3Y(B . "0x24AF6") ; <CJK>
       (?$(K3Z(B . "0x24AF7") ; <CJK>
       (?$(K3[(B . "0x24B55") ; <CJK>
       (?$(K3\(B . "0x24B44") ; <CJK>
       (?$(K3](B . "0x24B3E") ; <CJK>
       (?$(K3^(B . "0x24B42") ; <CJK>
       (?$(K3_(B . "0x24B52") ; <CJK>
       (?$(K3`(B . "0x24BE1") ; <CJK>
       (?$(K3a(B . "0x24C08") ; <CJK>
       (?$(K3b(B . "0x24C68") ; <CJK>
       (?$(K3c(B . "0x24C67") ; <CJK>
       (?$(K3d(B . "0x3F5D") ; <CJK>
       (?$(K3e(B . "0x2F937") ; <CJK>
       (?$(K3f(B . "0x24D7E") ; <CJK>
       (?$(K3g(B . "0x24D93") ; <CJK>
       (?$(K3h(B . "0x24D79") ; <CJK>
       (?$(K3i(B . "0x24D81") ; <CJK>
       (?$(K3j(B . "0x24D7D") ; <CJK>
       (?$(K3k(B . "0x24D7B") ; <CJK>
       (?$(K3l(B . "0x24D94") ; <CJK>
       (?$(K3m(B . "0x3F8A") ; <CJK>
       (?$(K3n(B . "0x24F66") ; <CJK>
       (?$(K3o(B . "0x24FD9") ; <CJK>
       (?$(K3p(B . "0x24FE0") ; <CJK>
       (?$(K3q(B . "0x2F93E") ; <CJK>
       (?$(K3r(B . "0x2505F") ; <CJK>
       (?$(K3s(B . "0x2515F") ; <CJK>
       (?$(K3t(B . "0x2515E") ; <CJK>
       (?$(K3u(B . "0x25168") ; <CJK>
       (?$(K3v(B . "0x4027") ; <CJK>
       (?$(K3w(B . "0x25188") ; <CJK>
       (?$(K3x(B . "0x2516A") ; <CJK>
       (?$(K3y(B . "0x2516C") ; <CJK>
       (?$(K3z(B . "0x25166") ; <CJK>
       (?$(K3{(B . "0x25167") ; <CJK>
       (?$(K3|(B . "0x25189") ; <CJK>
       (?$(K3}(B . "0x25160") ; <CJK>
       (?$(K3~(B . "0x25185") ; <CJK>
       (?$(K4!(B . "0x2032A") ; <CJK>
       (?$(K4"(B . "0x25368") ; <CJK>
       (?$(K4#(B . "0x253B9") ; <CJK>
       (?$(K4$(B . "0x253BA") ; <CJK>
       (?$(K4%(B . "0x253BE") ; <CJK>
       (?$(K4&(B . "0x2546F") ; <CJK>
       (?$(K4'(B . "0x25480") ; <CJK>
       (?$(K4((B . "0x25474") ; <CJK>
       (?$(K4)(B . "0x25481") ; <CJK>
       (?$(K4*(B . "0x2547A") ; <CJK>
       (?$(K4+(B . "0x2549C") ; <CJK>
       (?$(K4,(B . "0x25473") ; <CJK>
       (?$(K4-(B . "0x25482") ; <CJK>
       (?$(K4.(B . "0x2547F") ; <CJK>
       (?$(K4/(B . "0x254A7") ; <CJK>
       (?$(K40(B . "0x25479") ; <CJK>
       (?$(K41(B . "0x25478") ; <CJK>
       (?$(K42(B . "0x2547D") ; <CJK>
       (?$(K43(B . "0x254A8") ; <CJK>
       (?$(K44(B . "0x2547C") ; <CJK>
       (?$(K45(B . "0x25668") ; <CJK>
       (?$(K46(B . "0x2564E") ; <CJK>
       (?$(K47(B . "0x2579E") ; <CJK>
       (?$(K48(B . "0x4146") ; <CJK>
       (?$(K49(B . "0x4140") ; <CJK>
       (?$(K4:(B . "0x25798") ; <CJK>
       (?$(K4;(B . "0x413F") ; <CJK>
       (?$(K4<(B . "0x25785") ; <CJK>
       (?$(K4=(B . "0x2579C") ; <CJK>
       (?$(K4>(B . "0x257C5") ; <CJK>
       (?$(K4?(B . "0x2579A") ; <CJK>
       (?$(K4@(B . "0x25968") ; <CJK>
       (?$(K4A(B . "0x25965") ; <CJK>
       (?$(K4B(B . "0x25967") ; <CJK>
       (?$(K4C(B . "0x25961") ; <CJK>
       (?$(K4D(B . "0x25960") ; <CJK>
       (?$(K4E(B . "0x419D") ; <CJK>
       (?$(K4F(B . "0x41CB") ; <CJK>
       (?$(K4G(B . "0x25A7B") ; <CJK>
       (?$(K4H(B . "0x41E1") ; <CJK>
       (?$(K4I(B . "0x25B19") ; <CJK>
       (?$(K4J(B . "0x25B0E") ; <CJK>
       (?$(K4K(B . "0x25B31") ; <CJK>
       (?$(K4L(B . "0x25B12") ; <CJK>
       (?$(K4M(B . "0x25B10") ; <CJK>
       (?$(K4N(B . "0x25B15") ; <CJK>
       (?$(K4O(B . "0x25B3F") ; <CJK>
       (?$(K4P(B . "0x25B1D") ; <CJK>
       (?$(K4Q(B . "0x25B1E") ; <CJK>
       (?$(K4R(B . "0x25E4D") ; <CJK>
       (?$(K4S(B . "0x25E48") ; <CJK>
       (?$(K4T(B . "0x25E45") ; <CJK>
       (?$(K4U(B . "0x25E42") ; <CJK>
       (?$(K4V(B . "0x25E49") ; <CJK>
       (?$(K4W(B . "0x25E4A") ; <CJK>
       (?$(K4X(B . "0x25E47") ; <CJK>
       (?$(K4Y(B . "0x427F") ; <CJK>
       (?$(K4Z(B . "0x25E4C") ; <CJK>
       (?$(K4[(B . "0x25FCD") ; <CJK>
       (?$(K4\(B . "0x25FD5") ; <CJK>
       (?$(K4](B . "0x25FC4") ; <CJK>
       (?$(K4^(B . "0x25FCA") ; <CJK>
       (?$(K4_(B . "0x25FC3") ; <CJK>
       (?$(K4`(B . "0x4346") ; <CJK>
       (?$(K4a(B . "0x26229") ; <CJK>
       (?$(K4b(B . "0x262B4") ; <CJK>
       (?$(K4c(B . "0x2636D") ; <CJK>
       (?$(K4d(B . "0x26366") ; <CJK>
       (?$(K4e(B . "0x2636A") ; <CJK>
       (?$(K4f(B . "0x26415") ; <CJK>
       (?$(K4g(B . "0x264D3") ; <CJK>
       (?$(K4h(B . "0x264EC") ; <CJK>
       (?$(K4i(B . "0x26555") ; <CJK>
       (?$(K4j(B . "0x441A") ; <CJK>
       (?$(K4k(B . "0x266D6") ; <CJK>
       (?$(K4l(B . "0x266D8") ; <CJK>
       (?$(K4m(B . "0x26751") ; <CJK>
       (?$(K4n(B . "0x266E0") ; <CJK>
       (?$(K4o(B . "0x26703") ; <CJK>
       (?$(K4p(B . "0x26704") ; <CJK>
       (?$(K4q(B . "0x266DA") ; <CJK>
       (?$(K4r(B . "0x266EA") ; <CJK>
       (?$(K4s(B . "0x26702") ; <CJK>
       (?$(K4t(B . "0x266D3") ; <CJK>
       (?$(K4u(B . "0x266E4") ; <CJK>
       (?$(K4v(B . "0x266E5") ; <CJK>
       (?$(K4w(B . "0x2693B") ; <CJK>
       (?$(K4x(B . "0x26966") ; <CJK>
       (?$(K4y(B . "0x26A2C") ; <CJK>
       (?$(K4z(B . "0x26A21") ; <CJK>
       (?$(K4{(B . "0x26A26") ; <CJK>
       (?$(K4|(B . "0x26AD4") ; <CJK>
       (?$(K4}(B . "0x26AD5") ; <CJK>
       (?$(K4~(B . "0x26AD9") ; <CJK>
       (?$(K5!(B . "0x26BD5") ; <CJK>
       (?$(K5"(B . "0x26BEB") ; <CJK>
       (?$(K5#(B . "0x26BC5") ; <CJK>
       (?$(K5$(B . "0x44D3") ; <CJK>
       (?$(K5%(B . "0x26C27") ; <CJK>
       (?$(K5&(B . "0x26BF0") ; <CJK>
       (?$(K5'(B . "0x26BB9") ; <CJK>
       (?$(K5((B . "0x26C18") ; <CJK>
       (?$(K5)(B . "0x26BEE") ; <CJK>
       (?$(K5*(B . "0x44D0") ; <CJK>
       (?$(K5+(B . "0x26BB7") ; <CJK>
       (?$(K5,(B . "0x26BBB") ; <CJK>
       (?$(K5-(B . "0x26BEF") ; <CJK>
       (?$(K5.(B . "0x26BB8") ; <CJK>
       (?$(K5/(B . "0x26BDF") ; <CJK>
       (?$(K50(B . "0x26BDA") ; <CJK>
       (?$(K51(B . "0x26BE3") ; <CJK>
       (?$(K52(B . "0x26BC9") ; <CJK>
       (?$(K53(B . "0x26BEC") ; <CJK>
       (?$(K54(B . "0x271A4") ; <CJK>
       (?$(K55(B . "0x458E") ; <CJK>
       (?$(K56(B . "0x271A3") ; <CJK>
       (?$(K57(B . "0x2725E") ; <CJK>
       (?$(K58(B . "0x27261") ; <CJK>
       (?$(K59(B . "0x27262") ; <CJK>
       (?$(K5:(B . "0x27263") ; <CJK>
       (?$(K5;(B . "0x2728E") ; <CJK>
       (?$(K5<(B . "0x27269") ; <CJK>
       (?$(K5=(B . "0x2726B") ; <CJK>
       (?$(K5>(B . "0x27285") ; <CJK>
       (?$(K5?(B . "0x2728D") ; <CJK>
       (?$(K5@(B . "0x27264") ; <CJK>
       (?$(K5A(B . "0x2726D") ; <CJK>
       (?$(K5B(B . "0x2764C") ; <CJK>
       (?$(K5C(B . "0x27649") ; <CJK>
       (?$(K5D(B . "0x27647") ; <CJK>
       (?$(K5E(B . "0x27648") ; <CJK>
       (?$(K5F(B . "0x27642") ; <CJK>
       (?$(K5G(B . "0x27645") ; <CJK>
       (?$(K5H(B . "0x2765B") ; <CJK>
       (?$(K5I(B . "0x2765D") ; <CJK>
       (?$(K5J(B . "0x27646") ; <CJK>
       (?$(K5K(B . "0x27813") ; <CJK>
       (?$(K5L(B . "0x2781A") ; <CJK>
       (?$(K5M(B . "0x2780E") ; <CJK>
       (?$(K5N(B . "0x2780F") ; <CJK>
       (?$(K5O(B . "0x2781B") ; <CJK>
       (?$(K5P(B . "0x27812") ; <CJK>
       (?$(K5Q(B . "0x278C3") ; <CJK>
       (?$(K5R(B . "0x278BE") ; <CJK>
       (?$(K5S(B . "0x278BD") ; <CJK>
       (?$(K5T(B . "0x27979") ; <CJK>
       (?$(K5U(B . "0x2797C") ; <CJK>
       (?$(K5V(B . "0x46C3") ; <CJK>
       (?$(K5W(B . "0x46B6") ; <CJK>
       (?$(K5X(B . "0x27980") ; <CJK>
       (?$(K5Y(B . "0x27975") ; <CJK>
       (?$(K5Z(B . "0x2799B") ; <CJK>
       (?$(K5[(B . "0x8A2F") ; <CJK>
       (?$(K5\(B . "0x27974") ; <CJK>
       (?$(K5](B . "0x46C0") ; <CJK>
       (?$(K5^(B . "0x46B8") ; <CJK>
       (?$(K5_(B . "0x22041") ; <CJK>
       (?$(K5`(B . "0x22494") ; <CJK>
       (?$(K5a(B . "0x27C30") ; <CJK>
       (?$(K5b(B . "0x27CA7") ; <CJK>
       (?$(K5c(B . "0x27CA5") ; <CJK>
       (?$(K5d(B . "0x27CA4") ; <CJK>
       (?$(K5e(B . "0x27D3A") ; <CJK>
       (?$(K5f(B . "0x27E5B") ; <CJK>
       (?$(K5g(B . "0x27E9F") ; <CJK>
       (?$(K5h(B . "0x27EA8") ; <CJK>
       (?$(K5i(B . "0x27EB3") ; <CJK>
       (?$(K5j(B . "0x27EA1") ; <CJK>
       (?$(K5k(B . "0x27EA7") ; <CJK>
       (?$(K5l(B . "0x27EB2") ; <CJK>
       (?$(K5m(B . "0x27E9D") ; <CJK>
       (?$(K5n(B . "0x27EA3") ; <CJK>
       (?$(K5o(B . "0x27EA2") ; <CJK>
       (?$(K5p(B . "0x27FEF") ; <CJK>
       (?$(K5q(B . "0x27FD9") ; <CJK>
       (?$(K5r(B . "0x47D9") ; <CJK>
       (?$(K5s(B . "0x27FD5") ; <CJK>
       (?$(K5t(B . "0x27FDD") ; <CJK>
       (?$(K5u(B . "0x27FDA") ; <CJK>
       (?$(K5v(B . "0x27FEE") ; <CJK>
       (?$(K5w(B . "0x27FD7") ; <CJK>
       (?$(K5x(B . "0x2821A") ; <CJK>
       (?$(K5y(B . "0x28219") ; <CJK>
       (?$(K5z(B . "0x28218") ; <CJK>
       (?$(K5{(B . "0x282B3") ; <CJK>
       (?$(K5|(B . "0x282BF") ; <CJK>
       (?$(K5}(B . "0x282BB") ; <CJK>
       (?$(K5~(B . "0x282C0") ; <CJK>
       (?$(K6!(B . "0x282B9") ; <CJK>
       (?$(K6"(B . "0x282B8") ; <CJK>
       (?$(K6#(B . "0x282D5") ; <CJK>
       (?$(K6$(B . "0x28411") ; <CJK>
       (?$(K6%(B . "0x28410") ; <CJK>
       (?$(K6&(B . "0x284C3") ; <CJK>
       (?$(K6'(B . "0x284C2") ; <CJK>
       (?$(K6((B . "0x284E9") ; <CJK>
       (?$(K6)(B . "0x284CD") ; <CJK>
       (?$(K6*(B . "0x284E5") ; <CJK>
       (?$(K6+(B . "0x284CA") ; <CJK>
       (?$(K6,(B . "0x284C7") ; <CJK>
       (?$(K6-(B . "0x284E8") ; <CJK>
       (?$(K6.(B . "0x286F1") ; <CJK>
       (?$(K6/(B . "0x2870C") ; <CJK>
       (?$(K60(B . "0x286EF") ; <CJK>
       (?$(K61(B . "0x286EE") ; <CJK>
       (?$(K62(B . "0x286F3") ; <CJK>
       (?$(K63(B . "0x2870D") ; <CJK>
       (?$(K64(B . "0x286F6") ; <CJK>
       (?$(K65(B . "0x286F0") ; <CJK>
       (?$(K66(B . "0x48EC") ; <CJK>
       (?$(K67(B . "0x287F5") ; <CJK>
       (?$(K68(B . "0x287F4") ; <CJK>
       (?$(K69(B . "0x287F8") ; <CJK>
       (?$(K6:(B . "0x287FE") ; <CJK>
       (?$(K6;(B . "0x28911") ; <CJK>
       (?$(K6<(B . "0x28922") ; <CJK>
       (?$(K6=(B . "0x28942") ; <CJK>
       (?$(K6>(B . "0x28C5C") ; <CJK>
       (?$(K6?(B . "0x28C5A") ; <CJK>
       (?$(K6@(B . "0x28C5D") ; <CJK>
       (?$(K6A(B . "0x28CD1") ; <CJK>
       (?$(K6B(B . "0x28CD0") ; <CJK>
       (?$(K6C(B . "0x28E75") ; <CJK>
       (?$(K6D(B . "0x28E7B") ; <CJK>
       (?$(K6E(B . "0x28F89") ; <CJK>
       (?$(K6F(B . "0x2944D") ; <CJK>
       (?$(K6G(B . "0x29689") ; <CJK>
       (?$(K6H(B . "0x29692") ; <CJK>
       (?$(K6I(B . "0x2968C") ; <CJK>
       (?$(K6J(B . "0x29688") ; <CJK>
       (?$(K6K(B . "0x29867") ; <CJK>
       (?$(K6L(B . "0x29868") ; <CJK>
       (?$(K6M(B . "0x20321") ; <CJK>
       (?$(K6N(B . "0x202F2") ; <CJK>
       (?$(K6O(B . "0x20309") ; <CJK>
       (?$(K6P(B . "0x202F8") ; <CJK>
       (?$(K6Q(B . "0x202F0") ; <CJK>
       (?$(K6R(B . "0x202F3") ; <CJK>
       (?$(K6S(B . "0x202F5") ; <CJK>
       (?$(K6T(B . "0x202FB") ; <CJK>
       (?$(K6U(B . "0x202F7") ; <CJK>
       (?$(K6V(B . "0x202EF") ; <CJK>
       (?$(K6W(B . "0x2030B") ; <CJK>
       (?$(K6X(B . "0x204A2") ; <CJK>
       (?$(K6Y(B . "0x205F5") ; <CJK>
       (?$(K6Z(B . "0x205F3") ; <CJK>
       (?$(K6[(B . "0x205F4") ; <CJK>
       (?$(K6\(B . "0x205F2") ; <CJK>
       (?$(K6](B . "0x20698") ; <CJK>
       (?$(K6^(B . "0x20768") ; <CJK>
       (?$(K6_(B . "0x20780") ; <CJK>
       (?$(K6`(B . "0x20785") ; <CJK>
       (?$(K6a(B . "0x2078E") ; <CJK>
       (?$(K6b(B . "0x2078F") ; <CJK>
       (?$(K6c(B . "0x202F4") ; <CJK>
       (?$(K6d(B . "0x20786") ; <CJK>
       (?$(K6e(B . "0x207A4") ; <CJK>
       (?$(K6f(B . "0x20886") ; <CJK>
       (?$(K6g(B . "0x20889") ; <CJK>
       (?$(K6h(B . "0x20887") ; <CJK>
       (?$(K6i(B . "0x20885") ; <CJK>
       (?$(K6j(B . "0x52DC") ; <CJK>
       (?$(K6k(B . "0x20888") ; <CJK>
       (?$(K6l(B . "0x20AFF") ; <CJK>
       (?$(K6m(B . "0x20B66") ; <CJK>
       (?$(K6n(B . "0x35CC") ; <CJK>
       (?$(K6o(B . "0x20DC3") ; <CJK>
       (?$(K6p(B . "0x35A2") ; <CJK>
       (?$(K6q(B . "0x20DC4") ; <CJK>
       (?$(K6r(B . "0x20E3B") ; <CJK>
       (?$(K6s(B . "0x20DE7") ; <CJK>
       (?$(K6t(B . "0x20DF8") ; <CJK>
       (?$(K6u(B . "0x20DFB") ; <CJK>
       (?$(K6v(B . "0x35B6") ; <CJK>
       (?$(K6w(B . "0x20DBE") ; <CJK>
       (?$(K6x(B . "0x20DC6") ; <CJK>
       (?$(K6y(B . "0x35C5") ; <CJK>
       (?$(K6z(B . "0x35C6") ; <CJK>
       (?$(K6{(B . "0x20DFC") ; <CJK>
       (?$(K6|(B . "0x20DC0") ; <CJK>
       (?$(K6}(B . "0x20E33") ; <CJK>
       (?$(K6~(B . "0x20DC9") ; <CJK>
       (?$(K7!(B . "0x20DFE") ; <CJK>
       (?$(K7"(B . "0x20DDA") ; <CJK>
       (?$(K7#(B . "0x20DCC") ; <CJK>
       (?$(K7$(B . "0x20DBB") ; <CJK>
       (?$(K7%(B . "0x20DFD") ; <CJK>
       (?$(K7&(B . "0x20DDF") ; <CJK>
       (?$(K7'(B . "0x20DCD") ; <CJK>
       (?$(K7((B . "0x20DC2") ; <CJK>
       (?$(K7)(B . "0x20DC8") ; <CJK>
       (?$(K7*(B . "0x20E32") ; <CJK>
       (?$(K7+(B . "0x20E2D") ; <CJK>
       (?$(K7,(B . "0x20DD2") ; <CJK>
       (?$(K7-(B . "0x20E31") ; <CJK>
       (?$(K7.(B . "0x20DD3") ; <CJK>
       (?$(K7/(B . "0x20E2E") ; <CJK>
       (?$(K70(B . "0x20DCF") ; <CJK>
       (?$(K71(B . "0x211FF") ; <CJK>
       (?$(K72(B . "0x21209") ; <CJK>
       (?$(K73(B . "0x211FC") ; <CJK>
       (?$(K74(B . "0x21372") ; <CJK>
       (?$(K75(B . "0x213AA") ; <CJK>
       (?$(K76(B . "0x213AB") ; <CJK>
       (?$(K77(B . "0x213A7") ; <CJK>
       (?$(K78(B . "0x2137B") ; <CJK>
       (?$(K79(B . "0x21376") ; <CJK>
       (?$(K7:(B . "0x213A8") ; <CJK>
       (?$(K7;(B . "0x213AC") ; <CJK>
       (?$(K7<(B . "0x3683") ; <CJK>
       (?$(K7=(B . "0x5921") ; <CJK>
       (?$(K7>(B . "0x215AA") ; <CJK>
       (?$(K7?(B . "0x20A03") ; <CJK>
       (?$(K7@(B . "0x215AC") ; <CJK>
       (?$(K7A(B . "0x215AD") ; <CJK>
       (?$(K7B(B . "0x215AB") ; <CJK>
       (?$(K7C(B . "0x21650") ; <CJK>
       (?$(K7D(B . "0x21658") ; <CJK>
       (?$(K7E(B . "0x217DD") ; <CJK>
       (?$(K7F(B . "0x36F8") ; <CJK>
       (?$(K7G(B . "0x217AE") ; <CJK>
       (?$(K7H(B . "0x217A2") ; <CJK>
       (?$(K7I(B . "0x217AB") ; <CJK>
       (?$(K7J(B . "0x217E3") ; <CJK>
       (?$(K7K(B . "0x217AF") ; <CJK>
       (?$(K7L(B . "0x217E0") ; <CJK>
       (?$(K7M(B . "0x217E4") ; <CJK>
       (?$(K7N(B . "0x36F6") ; <CJK>
       (?$(K7O(B . "0x217A7") ; <CJK>
       (?$(K7P(B . "0x217AA") ; <CJK>
       (?$(K7Q(B . "0x217E2") ; <CJK>
       (?$(K7R(B . "0x217E1") ; <CJK>
       (?$(K7S(B . "0x217DF") ; <CJK>
       (?$(K7T(B . "0x217AD") ; <CJK>
       (?$(K7U(B . "0x217E5") ; <CJK>
       (?$(K7V(B . "0x217D1") ; <CJK>
       (?$(K7W(B . "0x217AC") ; <CJK>
       (?$(K7X(B . "0x217D5") ; <CJK>
       (?$(K7Y(B . "0x217A3") ; <CJK>
       (?$(K7Z(B . "0x2179F") ; <CJK>
       (?$(K7[(B . "0x21979") ; <CJK>
       (?$(K7\(B . "0x21976") ; <CJK>
       (?$(K7](B . "0x21A43") ; <CJK>
       (?$(K7^(B . "0x21A3D") ; <CJK>
       (?$(K7_(B . "0x21A47") ; <CJK>
       (?$(K7`(B . "0x21A44") ; <CJK>
       (?$(K7a(B . "0x21A3F") ; <CJK>
       (?$(K7b(B . "0x21A5B") ; <CJK>
       (?$(K7c(B . "0x21B7F") ; <CJK>
       (?$(K7d(B . "0x21C9A") ; <CJK>
       (?$(K7e(B . "0x21C9C") ; <CJK>
       (?$(K7f(B . "0x379B") ; <CJK>
       (?$(K7g(B . "0x21D1E") ; <CJK>
       (?$(K7h(B . "0x21E88") ; <CJK>
       (?$(K7i(B . "0x21E6A") ; <CJK>
       (?$(K7j(B . "0x21E76") ; <CJK>
       (?$(K7k(B . "0x21E72") ; <CJK>
       (?$(K7l(B . "0x21E70") ; <CJK>
       (?$(K7m(B . "0x21E7E") ; <CJK>
       (?$(K7n(B . "0x21E6C") ; <CJK>
       (?$(K7o(B . "0x21E6F") ; <CJK>
       (?$(K7p(B . "0x21E75") ; <CJK>
       (?$(K7q(B . "0x21E77") ; <CJK>
       (?$(K7r(B . "0x21E78") ; <CJK>
       (?$(K7s(B . "0x21E8A") ; <CJK>
       (?$(K7t(B . "0x21E79") ; <CJK>
       (?$(K7u(B . "0x21E94") ; <CJK>
       (?$(K7v(B . "0x22001") ; <CJK>
       (?$(K7w(B . "0x22105") ; <CJK>
       (?$(K7x(B . "0x220F1") ; <CJK>
       (?$(K7y(B . "0x220EE") ; <CJK>
       (?$(K7z(B . "0x220EF") ; <CJK>
       (?$(K7{(B . "0x22104") ; <CJK>
       (?$(K7|(B . "0x5E3F") ; <CJK>
       (?$(K7}(B . "0x220FA") ; <CJK>
       (?$(K7~(B . "0x22107") ; <CJK>
       (?$(K8!(B . "0x220F4") ; <CJK>
       (?$(K8"(B . "0x220F5") ; <CJK>
       (?$(K8#(B . "0x2219C") ; <CJK>
       (?$(K8$(B . "0x2226D") ; <CJK>
       (?$(K8%(B . "0x22269") ; <CJK>
       (?$(K8&(B . "0x22266") ; <CJK>
       (?$(K8'(B . "0x22262") ; <CJK>
       (?$(K8((B . "0x22246") ; <CJK>
       (?$(K8)(B . "0x388D") ; <CJK>
       (?$(K8*(B . "0x22265") ; <CJK>
       (?$(K8+(B . "0x2225D") ; <CJK>
       (?$(K8,(B . "0x2225E") ; <CJK>
       (?$(K8-(B . "0x2225F") ; <CJK>
       (?$(K8.(B . "0x2238E") ; <CJK>
       (?$(K8/(B . "0x22402") ; <CJK>
       (?$(K80(B . "0x22406") ; <CJK>
       (?$(K81(B . "0x22404") ; <CJK>
       (?$(K82(B . "0x22403") ; <CJK>
       (?$(K83(B . "0x22462") ; <CJK>
       (?$(K84(B . "0x22527") ; <CJK>
       (?$(K85(B . "0x22521") ; <CJK>
       (?$(K86(B . "0x22520") ; <CJK>
       (?$(K87(B . "0x22524") ; <CJK>
       (?$(K88(B . "0x22529") ; <CJK>
       (?$(K89(B . "0x22531") ; <CJK>
       (?$(K8:(B . "0x22523") ; <CJK>
       (?$(K8;(B . "0x22522") ; <CJK>
       (?$(K8<(B . "0x226DC") ; <CJK>
       (?$(K8=(B . "0x2274D") ; <CJK>
       (?$(K8>(B . "0x226E5") ; <CJK>
       (?$(K8?(B . "0x226D3") ; <CJK>
       (?$(K8@(B . "0x226EE") ; <CJK>
       (?$(K8A(B . "0x226E6") ; <CJK>
       (?$(K8B(B . "0x3956") ; <CJK>
       (?$(K8C(B . "0x22736") ; <CJK>
       (?$(K8D(B . "0x22740") ; <CJK>
       (?$(K8E(B . "0x2283F") ; <CJK>
       (?$(K8F(B . "0x2273D") ; <CJK>
       (?$(K8G(B . "0x22744") ; <CJK>
       (?$(K8H(B . "0x395B") ; <CJK>
       (?$(K8I(B . "0x2275F") ; <CJK>
       (?$(K8J(B . "0x22729") ; <CJK>
       (?$(K8K(B . "0x22749") ; <CJK>
       (?$(K8L(B . "0x2278A") ; <CJK>
       (?$(K8M(B . "0x2272A") ; <CJK>
       (?$(K8N(B . "0x22787") ; <CJK>
       (?$(K8O(B . "0x2274C") ; <CJK>
       (?$(K8P(B . "0x22731") ; <CJK>
       (?$(K8Q(B . "0x22748") ; <CJK>
       (?$(K8R(B . "0x2272B") ; <CJK>
       (?$(K8S(B . "0x2273B") ; <CJK>
       (?$(K8T(B . "0x22741") ; <CJK>
       (?$(K8U(B . "0x226C9") ; <CJK>
       (?$(K8V(B . "0x22734") ; <CJK>
       (?$(K8W(B . "0x22753") ; <CJK>
       (?$(K8X(B . "0x22735") ; <CJK>
       (?$(K8Y(B . "0x22747") ; <CJK>
       (?$(K8Z(B . "0x22738") ; <CJK>
       (?$(K8[(B . "0x229D1") ; <CJK>
       (?$(K8\(B . "0x229D2") ; <CJK>
       (?$(K8](B . "0x22A51") ; <CJK>
       (?$(K8^(B . "0x22A55") ; <CJK>
       (?$(K8_(B . "0x22A52") ; <CJK>
       (?$(K8`(B . "0x22A53") ; <CJK>
       (?$(K8a(B . "0x22B8F") ; <CJK>
       (?$(K8b(B . "0x22BF4") ; <CJK>
       (?$(K8c(B . "0x22C47") ; <CJK>
       (?$(K8d(B . "0x22C0D") ; <CJK>
       (?$(K8e(B . "0x22C1C") ; <CJK>
       (?$(K8f(B . "0x22BFB") ; <CJK>
       (?$(K8g(B . "0x22C19") ; <CJK>
       (?$(K8h(B . "0x22BF7") ; <CJK>
       (?$(K8i(B . "0x22BF9") ; <CJK>
       (?$(K8j(B . "0x22BF5") ; <CJK>
       (?$(K8k(B . "0x22BE9") ; <CJK>
       (?$(K8l(B . "0x22C0A") ; <CJK>
       (?$(K8m(B . "0x22BEE") ; <CJK>
       (?$(K8n(B . "0x22C0B") ; <CJK>
       (?$(K8o(B . "0x22BFD") ; <CJK>
       (?$(K8p(B . "0x22C06") ; <CJK>
       (?$(K8q(B . "0x22C02") ; <CJK>
       (?$(K8r(B . "0x22C16") ; <CJK>
       (?$(K8s(B . "0x22C18") ; <CJK>
       (?$(K8t(B . "0x22BF0") ; <CJK>
       (?$(K8u(B . "0x22ED4") ; <CJK>
       (?$(K8v(B . "0x22F66") ; <CJK>
       (?$(K8w(B . "0x22F6A") ; <CJK>
       (?$(K8x(B . "0x22F75") ; <CJK>
       (?$(K8y(B . "0x22F76") ; <CJK>
       (?$(K8z(B . "0x22F80") ; <CJK>
       (?$(K8{(B . "0x22F6D") ; <CJK>
       (?$(K8|(B . "0x3A96") ; <CJK>
       (?$(K8}(B . "0x22F69") ; <CJK>
       (?$(K8~(B . "0x22F67") ; <CJK>
       (?$(K9!(B . "0x22F68") ; <CJK>
       (?$(K9"(B . "0x22F5D") ; <CJK>
       (?$(K9#(B . "0x230A4") ; <CJK>
       (?$(K9$(B . "0x230FE") ; <CJK>
       (?$(K9%(B . "0x230FD") ; <CJK>
       (?$(K9&(B . "0x231EC") ; <CJK>
       (?$(K9'(B . "0x231E9") ; <CJK>
       (?$(K9((B . "0x23221") ; <CJK>
       (?$(K9)(B . "0x231EB") ; <CJK>
       (?$(K9*(B . "0x231E7") ; <CJK>
       (?$(K9+(B . "0x231F2") ; <CJK>
       (?$(K9,(B . "0x23220") ; <CJK>
       (?$(K9-(B . "0x2337A") ; <CJK>
       (?$(K9.(B . "0x2352D") ; <CJK>
       (?$(K9/(B . "0x2352E") ; <CJK>
       (?$(K90(B . "0x234CA") ; <CJK>
       (?$(K91(B . "0x2352F") ; <CJK>
       (?$(K92(B . "0x234C8") ; <CJK>
       (?$(K93(B . "0x3B7E") ; <CJK>
       (?$(K94(B . "0x234CB") ; <CJK>
       (?$(K95(B . "0x234C3") ; <CJK>
       (?$(K96(B . "0x23484") ; <CJK>
       (?$(K97(B . "0x234D2") ; <CJK>
       (?$(K98(B . "0x234C6") ; <CJK>
       (?$(K99(B . "0x3B81") ; <CJK>
       (?$(K9:(B . "0x234CF") ; <CJK>
       (?$(K9;(B . "0x234D5") ; <CJK>
       (?$(K9<(B . "0x234D4") ; <CJK>
       (?$(K9=(B . "0x234DD") ; <CJK>
       (?$(K9>(B . "0x2352B") ; <CJK>
       (?$(K9?(B . "0x235A3") ; <CJK>
       (?$(K9@(B . "0x234DB") ; <CJK>
       (?$(K9A(B . "0x2352C") ; <CJK>
       (?$(K9B(B . "0x23513") ; <CJK>
       (?$(K9C(B . "0x3C35") ; <CJK>
       (?$(K9D(B . "0x238D1") ; <CJK>
       (?$(K9E(B . "0x238CC") ; <CJK>
       (?$(K9F(B . "0x238D5") ; <CJK>
       (?$(K9G(B . "0x238C9") ; <CJK>
       (?$(K9H(B . "0x238CF") ; <CJK>
       (?$(K9I(B . "0x238D2") ; <CJK>
       (?$(K9J(B . "0x2397B") ; <CJK>
       (?$(K9K(B . "0x2397C") ; <CJK>
       (?$(K9L(B . "0x23A23") ; <CJK>
       (?$(K9M(B . "0x23A1D") ; <CJK>
       (?$(K9N(B . "0x23A1C") ; <CJK>
       (?$(K9O(B . "0x23A1E") ; <CJK>
       (?$(K9P(B . "0x23A22") ; <CJK>
       (?$(K9Q(B . "0x23A24") ; <CJK>
       (?$(K9R(B . "0x23A20") ; <CJK>
       (?$(K9S(B . "0x23A18") ; <CJK>
       (?$(K9T(B . "0x23A21") ; <CJK>
       (?$(K9U(B . "0x23B88") ; <CJK>
       (?$(K9V(B . "0x23B8A") ; <CJK>
       (?$(K9W(B . "0x23B94") ; <CJK>
       (?$(K9X(B . "0x23B8F") ; <CJK>
       (?$(K9Y(B . "0x23B8E") ; <CJK>
       (?$(K9Z(B . "0x23B90") ; <CJK>
       (?$(K9[(B . "0x3C9B") ; <CJK>
       (?$(K9\(B . "0x23BA7") ; <CJK>
       (?$(K9](B . "0x23C64") ; <CJK>
       (?$(K9^(B . "0x3D00") ; <CJK>
       (?$(K9_(B . "0x23E18") ; <CJK>
       (?$(K9`(B . "0x23E14") ; <CJK>
       (?$(K9a(B . "0x23E1D") ; <CJK>
       (?$(K9b(B . "0x23E05") ; <CJK>
       (?$(K9c(B . "0x23DFF") ; <CJK>
       (?$(K9d(B . "0x23E1B") ; <CJK>
       (?$(K9e(B . "0x23E1A") ; <CJK>
       (?$(K9f(B . "0x23E19") ; <CJK>
       (?$(K9g(B . "0x23E03") ; <CJK>
       (?$(K9h(B . "0x23E0E") ; <CJK>
       (?$(K9i(B . "0x23E47") ; <CJK>
       (?$(K9j(B . "0x23E04") ; <CJK>
       (?$(K9k(B . "0x23E5A") ; <CJK>
       (?$(K9l(B . "0x23E07") ; <CJK>
       (?$(K9m(B . "0x23E20") ; <CJK>
       (?$(K9n(B . "0x2426A") ; <CJK>
       (?$(K9o(B . "0x24266") ; <CJK>
       (?$(K9p(B . "0x2427A") ; <CJK>
       (?$(K9q(B . "0x24265") ; <CJK>
       (?$(K9r(B . "0x242AF") ; <CJK>
       (?$(K9s(B . "0x245CD") ; <CJK>
       (?$(K9t(B . "0x245CF") ; <CJK>
       (?$(K9u(B . "0x245D1") ; <CJK>
       (?$(K9v(B . "0x245CE") ; <CJK>
       (?$(K9w(B . "0x2465F") ; <CJK>
       (?$(K9x(B . "0x24677") ; <CJK>
       (?$(K9y(B . "0x24674") ; <CJK>
       (?$(K9z(B . "0x24688") ; <CJK>
       (?$(K9{(B . "0x24675") ; <CJK>
       (?$(K9|(B . "0x24689") ; <CJK>
       (?$(K9}(B . "0x24672") ; <CJK>
       (?$(K9~(B . "0x247C6") ; <CJK>
       (?$(K:!(B . "0x247EA") ; <CJK>
       (?$(K:"(B . "0x247E0") ; <CJK>
       (?$(K:#(B . "0x24807") ; <CJK>
       (?$(K:$(B . "0x247E6") ; <CJK>
       (?$(K:%(B . "0x247E5") ; <CJK>
       (?$(K:&(B . "0x247DD") ; <CJK>
       (?$(K:'(B . "0x247E3") ; <CJK>
       (?$(K:((B . "0x247DA") ; <CJK>
       (?$(K:)(B . "0x249AE") ; <CJK>
       (?$(K:*(B . "0x2497E") ; <CJK>
       (?$(K:+(B . "0x2497D") ; <CJK>
       (?$(K:,(B . "0x2497F") ; <CJK>
       (?$(K:-(B . "0x3ED3") ; <CJK>
       (?$(K:.(B . "0x249D9") ; <CJK>
       (?$(K:/(B . "0x24AFA") ; <CJK>
       (?$(K:0(B . "0x24AFB") ; <CJK>
       (?$(K:1(B . "0x24B4D") ; <CJK>
       (?$(K:2(B . "0x24B54") ; <CJK>
       (?$(K:3(B . "0x24B51") ; <CJK>
       (?$(K:4(B . "0x24B50") ; <CJK>
       (?$(K:5(B . "0x24D98") ; <CJK>
       (?$(K:6(B . "0x24D95") ; <CJK>
       (?$(K:7(B . "0x24D9D") ; <CJK>
       (?$(K:8(B . "0x24DC1") ; <CJK>
       (?$(K:9(B . "0x24D9A") ; <CJK>
       (?$(K::(B . "0x24D9B") ; <CJK>
       (?$(K:;(B . "0x3F9F") ; <CJK>
       (?$(K:<(B . "0x24D9C") ; <CJK>
       (?$(K:=(B . "0x24DD7") ; <CJK>
       (?$(K:>(B . "0x24DA4") ; <CJK>
       (?$(K:?(B . "0x24D96") ; <CJK>
       (?$(K:@(B . "0x24DA0") ; <CJK>
       (?$(K:A(B . "0x24F31") ; <CJK>
       (?$(K:B(B . "0x24FE9") ; <CJK>
       (?$(K:C(B . "0x2506E") ; <CJK>
       (?$(K:D(B . "0x2519A") ; <CJK>
       (?$(K:E(B . "0x251A5") ; <CJK>
       (?$(K:F(B . "0x25194") ; <CJK>
       (?$(K:G(B . "0x251A6") ; <CJK>
       (?$(K:H(B . "0x25199") ; <CJK>
       (?$(K:I(B . "0x2518B") ; <CJK>
       (?$(K:J(B . "0x25198") ; <CJK>
       (?$(K:K(B . "0x25191") ; <CJK>
       (?$(K:L(B . "0x2518C") ; <CJK>
       (?$(K:M(B . "0x251A1") ; <CJK>
       (?$(K:N(B . "0x251A3") ; <CJK>
       (?$(K:O(B . "0x251C6") ; <CJK>
       (?$(K:P(B . "0x2536F") ; <CJK>
       (?$(K:Q(B . "0x2536D") ; <CJK>
       (?$(K:R(B . "0x2536A") ; <CJK>
       (?$(K:S(B . "0x2536C") ; <CJK>
       (?$(K:T(B . "0x25371") ; <CJK>
       (?$(K:U(B . "0x2536E") ; <CJK>
       (?$(K:V(B . "0x253DF") ; <CJK>
       (?$(K:W(B . "0x254AC") ; <CJK>
       (?$(K:X(B . "0x254AA") ; <CJK>
       (?$(K:Y(B . "0x40B1") ; <CJK>
       (?$(K:Z(B . "0x254B5") ; <CJK>
       (?$(K:[(B . "0x254AD") ; <CJK>
       (?$(K:\(B . "0x254B2") ; <CJK>
       (?$(K:](B . "0x254B3") ; <CJK>
       (?$(K:^(B . "0x254AB") ; <CJK>
       (?$(K:_(B . "0x254B6") ; <CJK>
       (?$(K:`(B . "0x254C7") ; <CJK>
       (?$(K:a(B . "0x254C6") ; <CJK>
       (?$(K:b(B . "0x2566C") ; <CJK>
       (?$(K:c(B . "0x25670") ; <CJK>
       (?$(K:d(B . "0x257B3") ; <CJK>
       (?$(K:e(B . "0x414B") ; <CJK>
       (?$(K:f(B . "0x2598C") ; <CJK>
       (?$(K:g(B . "0x25981") ; <CJK>
       (?$(K:h(B . "0x25983") ; <CJK>
       (?$(K:i(B . "0x2597D") ; <CJK>
       (?$(K:j(B . "0x25985") ; <CJK>
       (?$(K:k(B . "0x25990") ; <CJK>
       (?$(K:l(B . "0x259A2") ; <CJK>
       (?$(K:m(B . "0x2598D") ; <CJK>
       (?$(K:n(B . "0x2598F") ; <CJK>
       (?$(K:o(B . "0x2597E") ; <CJK>
       (?$(K:p(B . "0x2598A") ; <CJK>
       (?$(K:q(B . "0x2597F") ; <CJK>
       (?$(K:r(B . "0x25976") ; <CJK>
       (?$(K:s(B . "0x25987") ; <CJK>
       (?$(K:t(B . "0x25978") ; <CJK>
       (?$(K:u(B . "0x25A80") ; <CJK>
       (?$(K:v(B . "0x25A82") ; <CJK>
       (?$(K:w(B . "0x25A81") ; <CJK>
       (?$(K:x(B . "0x25A83") ; <CJK>
       (?$(K:y(B . "0x25B5A") ; <CJK>
       (?$(K:z(B . "0x25B34") ; <CJK>
       (?$(K:{(B . "0x25B2C") ; <CJK>
       (?$(K:|(B . "0x25B2A") ; <CJK>
       (?$(K:}(B . "0x25B40") ; <CJK>
       (?$(K:~(B . "0x25B2D") ; <CJK>
       (?$(K;!(B . "0x25B33") ; <CJK>
       (?$(K;"(B . "0x25B2B") ; <CJK>
       (?$(K;#(B . "0x25B4B") ; <CJK>
       (?$(K;$(B . "0x7B3F") ; <CJK>
       (?$(K;%(B . "0x25B3C") ; <CJK>
       (?$(K;&(B . "0x25E5A") ; <CJK>
       (?$(K;'(B . "0x25E77") ; <CJK>
       (?$(K;((B . "0x25E60") ; <CJK>
       (?$(K;)(B . "0x25FFA") ; <CJK>
       (?$(K;*(B . "0x25FF9") ; <CJK>
       (?$(K;+(B . "0x25FFC") ; <CJK>
       (?$(K;,(B . "0x42D6") ; <CJK>
       (?$(K;-(B . "0x25FF5") ; <CJK>
       (?$(K;.(B . "0x25FE8") ; <CJK>
       (?$(K;/(B . "0x26009") ; <CJK>
       (?$(K;0(B . "0x25FE7") ; <CJK>
       (?$(K;1(B . "0x25FE6") ; <CJK>
       (?$(K;2(B . "0x25FE9") ; <CJK>
       (?$(K;3(B . "0x26232") ; <CJK>
       (?$(K;4(B . "0x2622C") ; <CJK>
       (?$(K;5(B . "0x262BD") ; <CJK>
       (?$(K;6(B . "0x262BC") ; <CJK>
       (?$(K;7(B . "0x2637A") ; <CJK>
       (?$(K;8(B . "0x2637E") ; <CJK>
       (?$(K;9(B . "0x26379") ; <CJK>
       (?$(K;:(B . "0x4389") ; <CJK>
       (?$(K;;(B . "0x26423") ; <CJK>
       (?$(K;<(B . "0x26430") ; <CJK>
       (?$(K;=(B . "0x26428") ; <CJK>
       (?$(K;>(B . "0x264D4") ; <CJK>
       (?$(K;?(B . "0x26ACE") ; <CJK>
       (?$(K;@(B . "0x264F1") ; <CJK>
       (?$(K;A(B . "0x264F0") ; <CJK>
       (?$(K;B(B . "0x26560") ; <CJK>
       (?$(K;C(B . "0x26565") ; <CJK>
       (?$(K;D(B . "0x266A8") ; <CJK>
       (?$(K;E(B . "0x2670A") ; <CJK>
       (?$(K;F(B . "0x2671B") ; <CJK>
       (?$(K;G(B . "0x26712") ; <CJK>
       (?$(K;H(B . "0x26707") ; <CJK>
       (?$(K;I(B . "0x2674F") ; <CJK>
       (?$(K;J(B . "0x2670E") ; <CJK>
       (?$(K;K(B . "0x26752") ; <CJK>
       (?$(K;L(B . "0x26716") ; <CJK>
       (?$(K;M(B . "0x4400") ; <CJK>
       (?$(K;N(B . "0x26753") ; <CJK>
       (?$(K;O(B . "0x26754") ; <CJK>
       (?$(K;P(B . "0x2F984") ; <CJK>
       (?$(K;Q(B . "0x26756") ; <CJK>
       (?$(K;R(B . "0x2696D") ; <CJK>
       (?$(K;S(B . "0x26972") ; <CJK>
       (?$(K;T(B . "0x26A2F") ; <CJK>
       (?$(K;U(B . "0x26C2A") ; <CJK>
       (?$(K;V(B . "0x44DC") ; <CJK>
       (?$(K;W(B . "0x26C63") ; <CJK>
       (?$(K;X(B . "0x26C84") ; <CJK>
       (?$(K;Y(B . "0x26CAF") ; <CJK>
       (?$(K;Z(B . "0x26C45") ; <CJK>
       (?$(K;[(B . "0x26C70") ; <CJK>
       (?$(K;\(B . "0x26C56") ; <CJK>
       (?$(K;](B . "0x26C16") ; <CJK>
       (?$(K;^(B . "0x26C3D") ; <CJK>
       (?$(K;_(B . "0x26C38") ; <CJK>
       (?$(K;`(B . "0x26C6F") ; <CJK>
       (?$(K;a(B . "0x26C77") ; <CJK>
       (?$(K;b(B . "0x26C2E") ; <CJK>
       (?$(K;c(B . "0x26C31") ; <CJK>
       (?$(K;d(B . "0x26C4C") ; <CJK>
       (?$(K;e(B . "0x26C5F") ; <CJK>
       (?$(K;f(B . "0x26C75") ; <CJK>
       (?$(K;g(B . "0x26C39") ; <CJK>
       (?$(K;h(B . "0x26C3A") ; <CJK>
       (?$(K;i(B . "0x26C2C") ; <CJK>
       (?$(K;j(B . "0x26C2D") ; <CJK>
       (?$(K;k(B . "0x26C3F") ; <CJK>
       (?$(K;l(B . "0x26C2F") ; <CJK>
       (?$(K;m(B . "0x26C30") ; <CJK>
       (?$(K;n(B . "0x26C3E") ; <CJK>
       (?$(K;o(B . "0x83D0") ; <CJK>
       (?$(K;p(B . "0x4590") ; <CJK>
       (?$(K;q(B . "0x271B2") ; <CJK>
       (?$(K;r(B . "0x272B7") ; <CJK>
       (?$(K;s(B . "0x2728F") ; <CJK>
       (?$(K;t(B . "0x45B1") ; <CJK>
       (?$(K;u(B . "0x27296") ; <CJK>
       (?$(K;v(B . "0x2729E") ; <CJK>
       (?$(K;w(B . "0x27297") ; <CJK>
       (?$(K;x(B . "0x27295") ; <CJK>
       (?$(K;y(B . "0x272A5") ; <CJK>
       (?$(K;z(B . "0x27298") ; <CJK>
       (?$(K;{(B . "0x86E7") ; <CJK>
       (?$(K;|(B . "0x272A3") ; <CJK>
       (?$(K;}(B . "0x2729A") ; <CJK>
       (?$(K;~(B . "0x272AD") ; <CJK>
       (?$(K<!(B . "0x272A6") ; <CJK>
       (?$(K<"(B . "0x272B6") ; <CJK>
       (?$(K<#(B . "0x27299") ; <CJK>
       (?$(K<$(B . "0x272AF") ; <CJK>
       (?$(K<%(B . "0x272AC") ; <CJK>
       (?$(K<&(B . "0x45AA") ; <CJK>
       (?$(K<'(B . "0x2729F") ; <CJK>
       (?$(K<((B . "0x27294") ; <CJK>
       (?$(K<)(B . "0x275EB") ; <CJK>
       (?$(K<*(B . "0x2766F") ; <CJK>
       (?$(K<+(B . "0x2766D") ; <CJK>
       (?$(K<,(B . "0x2767E") ; <CJK>
       (?$(K<-(B . "0x2766C") ; <CJK>
       (?$(K<.(B . "0x27661") ; <CJK>
       (?$(K</(B . "0x27663") ; <CJK>
       (?$(K<0(B . "0x2766B") ; <CJK>
       (?$(K<1(B . "0x2765E") ; <CJK>
       (?$(K<2(B . "0x2763E") ; <CJK>
       (?$(K<3(B . "0x27664") ; <CJK>
       (?$(K<4(B . "0x276AD") ; <CJK>
       (?$(K<5(B . "0x467D") ; <CJK>
       (?$(K<6(B . "0x27820") ; <CJK>
       (?$(K<7(B . "0x278D1") ; <CJK>
       (?$(K<8(B . "0x278D5") ; <CJK>
       (?$(K<9(B . "0x279AE") ; <CJK>
       (?$(K<:(B . "0x279AF") ; <CJK>
       (?$(K<;(B . "0x2799F") ; <CJK>
       (?$(K<<(B . "0x279A8") ; <CJK>
       (?$(K<=(B . "0x279CA") ; <CJK>
       (?$(K<>(B . "0x27BE1") ; <CJK>
       (?$(K<?(B . "0x27C39") ; <CJK>
       (?$(K<@(B . "0x27C38") ; <CJK>
       (?$(K<A(B . "0x27C3B") ; <CJK>
       (?$(K<B(B . "0x27CAD") ; <CJK>
       (?$(K<C(B . "0x27CB5") ; <CJK>
       (?$(K<D(B . "0x27CAF") ; <CJK>
       (?$(K<E(B . "0x27CB1") ; <CJK>
       (?$(K<F(B . "0x27CAE") ; <CJK>
       (?$(K<G(B . "0x27CB4") ; <CJK>
       (?$(K<H(B . "0x27CB0") ; <CJK>
       (?$(K<I(B . "0x27D4B") ; <CJK>
       (?$(K<J(B . "0x27D51") ; <CJK>
       (?$(K<K(B . "0x27D4C") ; <CJK>
       (?$(K<L(B . "0x4769") ; <CJK>
       (?$(K<M(B . "0x27D60") ; <CJK>
       (?$(K<N(B . "0x27EBE") ; <CJK>
       (?$(K<O(B . "0x27EB9") ; <CJK>
       (?$(K<P(B . "0x27EB7") ; <CJK>
       (?$(K<Q(B . "0x27EB6") ; <CJK>
       (?$(K<R(B . "0x47A1") ; <CJK>
       (?$(K<S(B . "0x27EBD") ; <CJK>
       (?$(K<T(B . "0x27EB8") ; <CJK>
       (?$(K<U(B . "0x27EC1") ; <CJK>
       (?$(K<V(B . "0x27FF7") ; <CJK>
       (?$(K<W(B . "0x27FF3") ; <CJK>
       (?$(K<X(B . "0x27FF4") ; <CJK>
       (?$(K<Y(B . "0x27FFB") ; <CJK>
       (?$(K<Z(B . "0x27FFD") ; <CJK>
       (?$(K<[(B . "0x27FF5") ; <CJK>
       (?$(K<\(B . "0x47E7") ; <CJK>
       (?$(K<](B . "0x27FFA") ; <CJK>
       (?$(K<^(B . "0x28014") ; <CJK>
       (?$(K<_(B . "0x47EC") ; <CJK>
       (?$(K<`(B . "0x27FF2") ; <CJK>
       (?$(K<a(B . "0x27FFC") ; <CJK>
       (?$(K<b(B . "0x28000") ; <CJK>
       (?$(K<c(B . "0x47DF") ; <CJK>
       (?$(K<d(B . "0x2822B") ; <CJK>
       (?$(K<e(B . "0x28229") ; <CJK>
       (?$(K<f(B . "0x2822E") ; <CJK>
       (?$(K<g(B . "0x4833") ; <CJK>
       (?$(K<h(B . "0x282D7") ; <CJK>
       (?$(K<i(B . "0x282DB") ; <CJK>
       (?$(K<j(B . "0x282D9") ; <CJK>
       (?$(K<k(B . "0x282D8") ; <CJK>
       (?$(K<l(B . "0x282E6") ; <CJK>
       (?$(K<m(B . "0x282D6") ; <CJK>
       (?$(K<n(B . "0x282D1") ; <CJK>
       (?$(K<o(B . "0x282E7") ; <CJK>
       (?$(K<p(B . "0x282D0") ; <CJK>
       (?$(K<q(B . "0x282DC") ; <CJK>
       (?$(K<r(B . "0x284ED") ; <CJK>
       (?$(K<s(B . "0x2851A") ; <CJK>
       (?$(K<t(B . "0x28519") ; <CJK>
       (?$(K<u(B . "0x28516") ; <CJK>
       (?$(K<v(B . "0x284EC") ; <CJK>
       (?$(K<w(B . "0x284EF") ; <CJK>
       (?$(K<x(B . "0x284EE") ; <CJK>
       (?$(K<y(B . "0x284F4") ; <CJK>
       (?$(K<z(B . "0x2852F") ; <CJK>
       (?$(K<{(B . "0x28730") ; <CJK>
       (?$(K<|(B . "0x28719") ; <CJK>
       (?$(K<}(B . "0x28718") ; <CJK>
       (?$(K<~(B . "0x28711") ; <CJK>
       (?$(K=!(B . "0x28716") ; <CJK>
       (?$(K="(B . "0x28712") ; <CJK>
       (?$(K=#(B . "0x28710") ; <CJK>
       (?$(K=$(B . "0x28714") ; <CJK>
       (?$(K=%(B . "0x2880C") ; <CJK>
       (?$(K=&(B . "0x2880D") ; <CJK>
       (?$(K='(B . "0x28910") ; <CJK>
       (?$(K=((B . "0x28929") ; <CJK>
       (?$(K=)(B . "0x28928") ; <CJK>
       (?$(K=*(B . "0x28C65") ; <CJK>
       (?$(K=+(B . "0x28C66") ; <CJK>
       (?$(K=,(B . "0x28CDE") ; <CJK>
       (?$(K=-(B . "0x28CDF") ; <CJK>
       (?$(K=.(B . "0x28CE0") ; <CJK>
       (?$(K=/(B . "0x28CD9") ; <CJK>
       (?$(K=0(B . "0x28CDB") ; <CJK>
       (?$(K=1(B . "0x28CD8") ; <CJK>
       (?$(K=2(B . "0x28CE3") ; <CJK>
       (?$(K=3(B . "0x28CD7") ; <CJK>
       (?$(K=4(B . "0x28EA6") ; <CJK>
       (?$(K=5(B . "0x28EA7") ; <CJK>
       (?$(K=6(B . "0x28EBF") ; <CJK>
       (?$(K=7(B . "0x28EA8") ; <CJK>
       (?$(K=8(B . "0x28E9F") ; <CJK>
       (?$(K=9(B . "0x28EA1") ; <CJK>
       (?$(K=:(B . "0x28EA2") ; <CJK>
       (?$(K=;(B . "0x28EAD") ; <CJK>
       (?$(K=<(B . "0x28EA3") ; <CJK>
       (?$(K==(B . "0x28EA0") ; <CJK>
       (?$(K=>(B . "0x29083") ; <CJK>
       (?$(K=?(B . "0x29085") ; <CJK>
       (?$(K=@(B . "0x29082") ; <CJK>
       (?$(K=A(B . "0x29084") ; <CJK>
       (?$(K=B(B . "0x291EE") ; <CJK>
       (?$(K=C(B . "0x2925D") ; <CJK>
       (?$(K=D(B . "0x29392") ; <CJK>
       (?$(K=E(B . "0x29455") ; <CJK>
       (?$(K=F(B . "0x29453") ; <CJK>
       (?$(K=G(B . "0x2F9FC") ; <CJK>
       (?$(K=H(B . "0x29451") ; <CJK>
       (?$(K=I(B . "0x29452") ; <CJK>
       (?$(K=J(B . "0x29450") ; <CJK>
       (?$(K=K(B . "0x2959D") ; <CJK>
       (?$(K=L(B . "0x29687") ; <CJK>
       (?$(K=M(B . "0x29697") ; <CJK>
       (?$(K=N(B . "0x2969B") ; <CJK>
       (?$(K=O(B . "0x2969D") ; <CJK>
       (?$(K=P(B . "0x29869") ; <CJK>
       (?$(K=Q(B . "0x29A11") ; <CJK>
       (?$(K=R(B . "0x4BEE") ; <CJK>
       (?$(K=S(B . "0x29C7A") ; <CJK>
       (?$(K=T(B . "0x4C32") ; <CJK>
       (?$(K=U(B . "0x23244") ; <CJK>
       (?$(K=V(B . "0x200C6") ; <CJK>
       (?$(K=W(B . "0x20340") ; <CJK>
       (?$(K=X(B . "0x2032E") ; <CJK>
       (?$(K=Y(B . "0x20368") ; <CJK>
       (?$(K=Z(B . "0x2032D") ; <CJK>
       (?$(K=[(B . "0x20334") ; <CJK>
       (?$(K=\(B . "0x20332") ; <CJK>
       (?$(K=](B . "0x20369") ; <CJK>
       (?$(K=^(B . "0x20331") ; <CJK>
       (?$(K=_(B . "0x2036A") ; <CJK>
       (?$(K=`(B . "0x2033E") ; <CJK>
       (?$(K=a(B . "0x2036F") ; <CJK>
       (?$(K=b(B . "0x20375") ; <CJK>
       (?$(K=c(B . "0x204F6") ; <CJK>
       (?$(K=d(B . "0x20520") ; <CJK>
       (?$(K=e(B . "0x20528") ; <CJK>
       (?$(K=f(B . "0x20567") ; <CJK>
       (?$(K=g(B . "0x205FB") ; <CJK>
       (?$(K=h(B . "0x205FE") ; <CJK>
       (?$(K=i(B . "0x205FC") ; <CJK>
       (?$(K=j(B . "0x205FD") ; <CJK>
       (?$(K=k(B . "0x205FF") ; <CJK>
       (?$(K=l(B . "0x205FA") ; <CJK>
       (?$(K=m(B . "0x207AC") ; <CJK>
       (?$(K=n(B . "0x207AF") ; <CJK>
       (?$(K=o(B . "0x207B1") ; <CJK>
       (?$(K=p(B . "0x34FC") ; <CJK>
       (?$(K=q(B . "0x207BF") ; <CJK>
       (?$(K=r(B . "0x207BE") ; <CJK>
       (?$(K=s(B . "0x207A7") ; <CJK>
       (?$(K=t(B . "0x207AA") ; <CJK>
       (?$(K=u(B . "0x20894") ; <CJK>
       (?$(K=v(B . "0x20893") ; <CJK>
       (?$(K=w(B . "0x20899") ; <CJK>
       (?$(K=x(B . "0x352A") ; <CJK>
       (?$(K=y(B . "0x208FA") ; <CJK>
       (?$(K=z(B . "0x20956") ; <CJK>
       (?$(K={(B . "0x20A22") ; <CJK>
       (?$(K=|(B . "0x20A91") ; <CJK>
       (?$(K=}(B . "0x20A92") ; <CJK>
       (?$(K=~(B . "0x20B08") ; <CJK>
       (?$(K>!(B . "0x20B06") ; <CJK>
       (?$(K>"(B . "0x20DD6") ; <CJK>
       (?$(K>#(B . "0x20E37") ; <CJK>
       (?$(K>$(B . "0x20E4B") ; <CJK>
       (?$(K>%(B . "0x20ECE") ; <CJK>
       (?$(K>&(B . "0x20ED0") ; <CJK>
       (?$(K>'(B . "0x20E39") ; <CJK>
       (?$(K>((B . "0x20E64") ; <CJK>
       (?$(K>)(B . "0x20ECF") ; <CJK>
       (?$(K>*(B . "0x20E46") ; <CJK>
       (?$(K>+(B . "0x20E66") ; <CJK>
       (?$(K>,(B . "0x20E56") ; <CJK>
       (?$(K>-(B . "0x20E43") ; <CJK>
       (?$(K>.(B . "0x20E4A") ; <CJK>
       (?$(K>/(B . "0x20E58") ; <CJK>
       (?$(K>0(B . "0x20E65") ; <CJK>
       (?$(K>1(B . "0x20E5A") ; <CJK>
       (?$(K>2(B . "0x20E5B") ; <CJK>
       (?$(K>3(B . "0x20E55") ; <CJK>
       (?$(K>4(B . "0x20E50") ; <CJK>
       (?$(K>5(B . "0x20E4C") ; <CJK>
       (?$(K>6(B . "0x20ECD") ; <CJK>
       (?$(K>7(B . "0x20E51") ; <CJK>
       (?$(K>8(B . "0x20E47") ; <CJK>
       (?$(K>9(B . "0x35D3") ; <CJK>
       (?$(K>:(B . "0x20E53") ; <CJK>
       (?$(K>;(B . "0x20E62") ; <CJK>
       (?$(K><(B . "0x20ECC") ; <CJK>
       (?$(K>=(B . "0x35D7") ; <CJK>
       (?$(K>>(B . "0x20E7F") ; <CJK>
       (?$(K>?(B . "0x20E4D") ; <CJK>
       (?$(K>@(B . "0x2120A") ; <CJK>
       (?$(K>A(B . "0x2120C") ; <CJK>
       (?$(K>B(B . "0x2120F") ; <CJK>
       (?$(K>C(B . "0x213BB") ; <CJK>
       (?$(K>D(B . "0x213B9") ; <CJK>
       (?$(K>E(B . "0x213EB") ; <CJK>
       (?$(K>F(B . "0x213AE") ; <CJK>
       (?$(K>G(B . "0x213C1") ; <CJK>
       (?$(K>H(B . "0x213EA") ; <CJK>
       (?$(K>I(B . "0x213BE") ; <CJK>
       (?$(K>J(B . "0x213BF") ; <CJK>
       (?$(K>K(B . "0x213BA") ; <CJK>
       (?$(K>L(B . "0x213B7") ; <CJK>
       (?$(K>M(B . "0x213B3") ; <CJK>
       (?$(K>N(B . "0x213E9") ; <CJK>
       (?$(K>O(B . "0x2156E") ; <CJK>
       (?$(K>P(B . "0x215AF") ; <CJK>
       (?$(K>Q(B . "0x215B3") ; <CJK>
       (?$(K>R(B . "0x215B2") ; <CJK>
       (?$(K>S(B . "0x21668") ; <CJK>
       (?$(K>T(B . "0x21669") ; <CJK>
       (?$(K>U(B . "0x2166A") ; <CJK>
       (?$(K>V(B . "0x217DE") ; <CJK>
       (?$(K>W(B . "0x217EB") ; <CJK>
       (?$(K>X(B . "0x21811") ; <CJK>
       (?$(K>Y(B . "0x217ED") ; <CJK>
       (?$(K>Z(B . "0x217E9") ; <CJK>
       (?$(K>[(B . "0x217F7") ; <CJK>
       (?$(K>\(B . "0x217F4") ; <CJK>
       (?$(K>](B . "0x217EA") ; <CJK>
       (?$(K>^(B . "0x21812") ; <CJK>
       (?$(K>_(B . "0x217E8") ; <CJK>
       (?$(K>`(B . "0x21813") ; <CJK>
       (?$(K>a(B . "0x2198E") ; <CJK>
       (?$(K>b(B . "0x21986") ; <CJK>
       (?$(K>c(B . "0x21A63") ; <CJK>
       (?$(K>d(B . "0x21A65") ; <CJK>
       (?$(K>e(B . "0x21B99") ; <CJK>
       (?$(K>f(B . "0x21CC2") ; <CJK>
       (?$(K>g(B . "0x21CAE") ; <CJK>
       (?$(K>h(B . "0x21CB0") ; <CJK>
       (?$(K>i(B . "0x21CAD") ; <CJK>
       (?$(K>j(B . "0x21EB4") ; <CJK>
       (?$(K>k(B . "0x21ED1") ; <CJK>
       (?$(K>l(B . "0x21EAD") ; <CJK>
       (?$(K>m(B . "0x37F3") ; <CJK>
       (?$(K>n(B . "0x21EBD") ; <CJK>
       (?$(K>o(B . "0x21EB7") ; <CJK>
       (?$(K>p(B . "0x21EAB") ; <CJK>
       (?$(K>q(B . "0x21EAF") ; <CJK>
       (?$(K>r(B . "0x21EC1") ; <CJK>
       (?$(K>s(B . "0x21EB5") ; <CJK>
       (?$(K>t(B . "0x2210F") ; <CJK>
       (?$(K>u(B . "0x2210E") ; <CJK>
       (?$(K>v(B . "0x2211C") ; <CJK>
       (?$(K>w(B . "0x22113") ; <CJK>
       (?$(K>x(B . "0x2210A") ; <CJK>
       (?$(K>y(B . "0x2211E") ; <CJK>
       (?$(K>z(B . "0x22114") ; <CJK>
       (?$(K>{(B . "0x2211A") ; <CJK>
       (?$(K>|(B . "0x221CB") ; <CJK>
       (?$(K>}(B . "0x22287") ; <CJK>
       (?$(K>~(B . "0x22293") ; <CJK>
       (?$(K?!(B . "0x3891") ; <CJK>
       (?$(K?"(B . "0x22284") ; <CJK>
       (?$(K?#(B . "0x22285") ; <CJK>
       (?$(K?$(B . "0x22292") ; <CJK>
       (?$(K?%(B . "0x22280") ; <CJK>
       (?$(K?&(B . "0x2232B") ; <CJK>
       (?$(K?'(B . "0x22363") ; <CJK>
       (?$(K?((B . "0x2240A") ; <CJK>
       (?$(K?)(B . "0x38C0") ; <CJK>
       (?$(K?*(B . "0x22466") ; <CJK>
       (?$(K?+(B . "0x22534") ; <CJK>
       (?$(K?,(B . "0x22533") ; <CJK>
       (?$(K?-(B . "0x2254D") ; <CJK>
       (?$(K?.(B . "0x22789") ; <CJK>
       (?$(K?/(B . "0x22757") ; <CJK>
       (?$(K?0(B . "0x6117") ; <CJK>
       (?$(K?1(B . "0x2274A") ; <CJK>
       (?$(K?2(B . "0x3963") ; <CJK>
       (?$(K?3(B . "0x22739") ; <CJK>
       (?$(K?4(B . "0x2273F") ; <CJK>
       (?$(K?5(B . "0x22790") ; <CJK>
       (?$(K?6(B . "0x2278F") ; <CJK>
       (?$(K?7(B . "0x227B2") ; <CJK>
       (?$(K?8(B . "0x2279F") ; <CJK>
       (?$(K?9(B . "0x22795") ; <CJK>
       (?$(K?:(B . "0x227A1") ; <CJK>
       (?$(K?;(B . "0x2279C") ; <CJK>
       (?$(K?<(B . "0x2278E") ; <CJK>
       (?$(K?=(B . "0x227A0") ; <CJK>
       (?$(K?>(B . "0x227AE") ; <CJK>
       (?$(K??(B . "0x22796") ; <CJK>
       (?$(K?@(B . "0x227CA") ; <CJK>
       (?$(K?A(B . "0x227AC") ; <CJK>
       (?$(K?B(B . "0x3970") ; <CJK>
       (?$(K?C(B . "0x227A6") ; <CJK>
       (?$(K?D(B . "0x22797") ; <CJK>
       (?$(K?E(B . "0x22793") ; <CJK>
       (?$(K?F(B . "0x203B6") ; <CJK>
       (?$(K?G(B . "0x229D6") ; <CJK>
       (?$(K?H(B . "0x229E0") ; <CJK>
       (?$(K?I(B . "0x229D8") ; <CJK>
       (?$(K?J(B . "0x22A56") ; <CJK>
       (?$(K?K(B . "0x22C6E") ; <CJK>
       (?$(K?L(B . "0x22C7E") ; <CJK>
       (?$(K?M(B . "0x22C74") ; <CJK>
       (?$(K?N(B . "0x22C77") ; <CJK>
       (?$(K?O(B . "0x22C80") ; <CJK>
       (?$(K?P(B . "0x22C7A") ; <CJK>
       (?$(K?Q(B . "0x22C6B") ; <CJK>
       (?$(K?R(B . "0x22C5F") ; <CJK>
       (?$(K?S(B . "0x22C76") ; <CJK>
       (?$(K?T(B . "0x22CB0") ; <CJK>
       (?$(K?U(B . "0x22C63") ; <CJK>
       (?$(K?V(B . "0x22F92") ; <CJK>
       (?$(K?W(B . "0x22F82") ; <CJK>
       (?$(K?X(B . "0x22F9D") ; <CJK>
       (?$(K?Y(B . "0x22F94") ; <CJK>
       (?$(K?Z(B . "0x22F83") ; <CJK>
       (?$(K?[(B . "0x22F8B") ; <CJK>
       (?$(K?\(B . "0x22F84") ; <CJK>
       (?$(K?](B . "0x23057") ; <CJK>
       (?$(K?^(B . "0x23084") ; <CJK>
       (?$(K?_(B . "0x230B5") ; <CJK>
       (?$(K?`(B . "0x23109") ; <CJK>
       (?$(K?a(B . "0x231E6") ; <CJK>
       (?$(K?b(B . "0x3B02") ; <CJK>
       (?$(K?c(B . "0x23225") ; <CJK>
       (?$(K?d(B . "0x23251") ; <CJK>
       (?$(K?e(B . "0x2333E") ; <CJK>
       (?$(K?f(B . "0x2F8DA") ; <CJK>
       (?$(K?g(B . "0x23385") ; <CJK>
       (?$(K?h(B . "0x2353F") ; <CJK>
       (?$(K?i(B . "0x23542") ; <CJK>
       (?$(K?j(B . "0x23538") ; <CJK>
       (?$(K?k(B . "0x2353A") ; <CJK>
       (?$(K?l(B . "0x2354E") ; <CJK>
       (?$(K?m(B . "0x23545") ; <CJK>
       (?$(K?n(B . "0x23539") ; <CJK>
       (?$(K?o(B . "0x23537") ; <CJK>
       (?$(K?p(B . "0x23544") ; <CJK>
       (?$(K?q(B . "0x2F8E7") ; <CJK>
       (?$(K?r(B . "0x235A4") ; <CJK>
       (?$(K?s(B . "0x2353D") ; <CJK>
       (?$(K?t(B . "0x23541") ; <CJK>
       (?$(K?u(B . "0x238DF") ; <CJK>
       (?$(K?v(B . "0x238DE") ; <CJK>
       (?$(K?w(B . "0x238CA") ; <CJK>
       (?$(K?x(B . "0x238E9") ; <CJK>
       (?$(K?y(B . "0x238E2") ; <CJK>
       (?$(K?z(B . "0x238E0") ; <CJK>
       (?$(K?{(B . "0x23989") ; <CJK>
       (?$(K?|(B . "0x23987") ; <CJK>
       (?$(K?}(B . "0x23A32") ; <CJK>
       (?$(K?~(B . "0x23A33") ; <CJK>
       (?$(K@!(B . "0x23AAC") ; <CJK>
       (?$(K@"(B . "0x23AF9") ; <CJK>
       (?$(K@#(B . "0x23B0D") ; <CJK>
       (?$(K@$(B . "0x23BB9") ; <CJK>
       (?$(K@%(B . "0x23E5E") ; <CJK>
       (?$(K@&(B . "0x23E6A") ; <CJK>
       (?$(K@'(B . "0x3D35") ; <CJK>
       (?$(K@((B . "0x23E81") ; <CJK>
       (?$(K@)(B . "0x23E69") ; <CJK>
       (?$(K@*(B . "0x23EAC") ; <CJK>
       (?$(K@+(B . "0x23E80") ; <CJK>
       (?$(K@,(B . "0x23E75") ; <CJK>
       (?$(K@-(B . "0x23E71") ; <CJK>
       (?$(K@.(B . "0x23E76") ; <CJK>
       (?$(K@/(B . "0x23E6F") ; <CJK>
       (?$(K@0(B . "0x242B6") ; <CJK>
       (?$(K@1(B . "0x24303") ; <CJK>
       (?$(K@2(B . "0x242BF") ; <CJK>
       (?$(K@3(B . "0x24301") ; <CJK>
       (?$(K@4(B . "0x242B2") ; <CJK>
       (?$(K@5(B . "0x242C4") ; <CJK>
       (?$(K@6(B . "0x245DB") ; <CJK>
       (?$(K@7(B . "0x245DC") ; <CJK>
       (?$(K@8(B . "0x245D8") ; <CJK>
       (?$(K@9(B . "0x29672") ; <CJK>
       (?$(K@:(B . "0x246B5") ; <CJK>
       (?$(K@;(B . "0x246A8") ; <CJK>
       (?$(K@<(B . "0x2468F") ; <CJK>
       (?$(K@=(B . "0x2469E") ; <CJK>
       (?$(K@>(B . "0x2468E") ; <CJK>
       (?$(K@?(B . "0x247DE") ; <CJK>
       (?$(K@@(B . "0x247E2") ; <CJK>
       (?$(K@A(B . "0x24820") ; <CJK>
       (?$(K@B(B . "0x2481D") ; <CJK>
       (?$(K@C(B . "0x2481A") ; <CJK>
       (?$(K@D(B . "0x24819") ; <CJK>
       (?$(K@E(B . "0x2482B") ; <CJK>
       (?$(K@F(B . "0x24818") ; <CJK>
       (?$(K@G(B . "0x24810") ; <CJK>
       (?$(K@H(B . "0x2480E") ; <CJK>
       (?$(K@I(B . "0x24824") ; <CJK>
       (?$(K@J(B . "0x2481F") ; <CJK>
       (?$(K@K(B . "0x24813") ; <CJK>
       (?$(K@L(B . "0x24835") ; <CJK>
       (?$(K@M(B . "0x24983") ; <CJK>
       (?$(K@N(B . "0x3EE0") ; <CJK>
       (?$(K@O(B . "0x249D7") ; <CJK>
       (?$(K@P(B . "0x24B02") ; <CJK>
       (?$(K@Q(B . "0x24B03") ; <CJK>
       (?$(K@R(B . "0x24B5C") ; <CJK>
       (?$(K@S(B . "0x24B5F") ; <CJK>
       (?$(K@T(B . "0x24BC7") ; <CJK>
       (?$(K@U(B . "0x24C9A") ; <CJK>
       (?$(K@V(B . "0x24C97") ; <CJK>
       (?$(K@W(B . "0x24CA3") ; <CJK>
       (?$(K@X(B . "0x24DF7") ; <CJK>
       (?$(K@Y(B . "0x24DC6") ; <CJK>
       (?$(K@Z(B . "0x24DCC") ; <CJK>
       (?$(K@[(B . "0x24DD6") ; <CJK>
       (?$(K@\(B . "0x24DCD") ; <CJK>
       (?$(K@](B . "0x24DF9") ; <CJK>
       (?$(K@^(B . "0x24DD9") ; <CJK>
       (?$(K@_(B . "0x24DD8") ; <CJK>
       (?$(K@`(B . "0x3F9A") ; <CJK>
       (?$(K@a(B . "0x24DD1") ; <CJK>
       (?$(K@b(B . "0x24DCE") ; <CJK>
       (?$(K@c(B . "0x24DD5") ; <CJK>
       (?$(K@d(B . "0x3FA3") ; <CJK>
       (?$(K@e(B . "0x24DD4") ; <CJK>
       (?$(K@f(B . "0x24DF8") ; <CJK>
       (?$(K@g(B . "0x24F7A") ; <CJK>
       (?$(K@h(B . "0x24F79") ; <CJK>
       (?$(K@i(B . "0x24F7F") ; <CJK>
       (?$(K@j(B . "0x24FF3") ; <CJK>
       (?$(K@k(B . "0x24FF5") ; <CJK>
       (?$(K@l(B . "0x24FF6") ; <CJK>
       (?$(K@m(B . "0x24FF4") ; <CJK>
       (?$(K@n(B . "0x24FF7") ; <CJK>
       (?$(K@o(B . "0x4005") ; <CJK>
       (?$(K@p(B . "0x25079") ; <CJK>
       (?$(K@q(B . "0x2519C") ; <CJK>
       (?$(K@r(B . "0x251DF") ; <CJK>
       (?$(K@s(B . "0x251F5") ; <CJK>
       (?$(K@t(B . "0x251FF") ; <CJK>
       (?$(K@u(B . "0x251D1") ; <CJK>
       (?$(K@v(B . "0x251DA") ; <CJK>
       (?$(K@w(B . "0x251CF") ; <CJK>
       (?$(K@x(B . "0x251CD") ; <CJK>
       (?$(K@y(B . "0x251DE") ; <CJK>
       (?$(K@z(B . "0x251D8") ; <CJK>
       (?$(K@{(B . "0x23AAD") ; <CJK>
       (?$(K@|(B . "0x251E0") ; <CJK>
       (?$(K@}(B . "0x251FE") ; <CJK>
       (?$(K@~(B . "0x2519E") ; <CJK>
       (?$(KA!(B . "0x25375") ; <CJK>
       (?$(KA"(B . "0x25373") ; <CJK>
       (?$(KA#(B . "0x25372") ; <CJK>
       (?$(KA$(B . "0x253D8") ; <CJK>
       (?$(KA%(B . "0x254D0") ; <CJK>
       (?$(KA&(B . "0x254D6") ; <CJK>
       (?$(KA'(B . "0x254D7") ; <CJK>
       (?$(KA((B . "0x254CA") ; <CJK>
       (?$(KA)(B . "0x254CD") ; <CJK>
       (?$(KA*(B . "0x2568A") ; <CJK>
       (?$(KA+(B . "0x25689") ; <CJK>
       (?$(KA,(B . "0x2568B") ; <CJK>
       (?$(KA-(B . "0x257D3") ; <CJK>
       (?$(KA.(B . "0x257DA") ; <CJK>
       (?$(KA/(B . "0x257CE") ; <CJK>
       (?$(KA0(B . "0x257D2") ; <CJK>
       (?$(KA1(B . "0x415E") ; <CJK>
       (?$(KA2(B . "0x257D4") ; <CJK>
       (?$(KA3(B . "0x257D7") ; <CJK>
       (?$(KA4(B . "0x257D5") ; <CJK>
       (?$(KA5(B . "0x257FB") ; <CJK>
       (?$(KA6(B . "0x257CD") ; <CJK>
       (?$(KA7(B . "0x257FA") ; <CJK>
       (?$(KA8(B . "0x257D6") ; <CJK>
       (?$(KA9(B . "0x41A6") ; <CJK>
       (?$(KA:(B . "0x2599B") ; <CJK>
       (?$(KA;(B . "0x2599E") ; <CJK>
       (?$(KA<(B . "0x2599D") ; <CJK>
       (?$(KA=(B . "0x259A4") ; <CJK>
       (?$(KA>(B . "0x2599F") ; <CJK>
       (?$(KA?(B . "0x259A5") ; <CJK>
       (?$(KA@(B . "0x259A8") ; <CJK>
       (?$(KAA(B . "0x25A8F") ; <CJK>
       (?$(KAB(B . "0x25A8C") ; <CJK>
       (?$(KAC(B . "0x25A95") ; <CJK>
       (?$(KAD(B . "0x25B60") ; <CJK>
       (?$(KAE(B . "0x25B55") ; <CJK>
       (?$(KAF(B . "0x25B5C") ; <CJK>
       (?$(KAG(B . "0x25B6F") ; <CJK>
       (?$(KAH(B . "0x25B51") ; <CJK>
       (?$(KAI(B . "0x25B61") ; <CJK>
       (?$(KAJ(B . "0x25BA7") ; <CJK>
       (?$(KAK(B . "0x25B5E") ; <CJK>
       (?$(KAL(B . "0x25B62") ; <CJK>
       (?$(KAM(B . "0x25B54") ; <CJK>
       (?$(KAN(B . "0x25B6E") ; <CJK>
       (?$(KAO(B . "0x25B52") ; <CJK>
       (?$(KAP(B . "0x25B58") ; <CJK>
       (?$(KAQ(B . "0x25B6D") ; <CJK>
       (?$(KAR(B . "0x25B5F") ; <CJK>
       (?$(KAS(B . "0x25B6C") ; <CJK>
       (?$(KAT(B . "0x25B50") ; <CJK>
       (?$(KAU(B . "0x25B5D") ; <CJK>
       (?$(KAV(B . "0x25B8E") ; <CJK>
       (?$(KAW(B . "0x25E72") ; <CJK>
       (?$(KAX(B . "0x25E78") ; <CJK>
       (?$(KAY(B . "0x25E75") ; <CJK>
       (?$(KAZ(B . "0x25E76") ; <CJK>
       (?$(KA[(B . "0x25E7C") ; <CJK>
       (?$(KA\(B . "0x25E7E") ; <CJK>
       (?$(KA](B . "0x25E7D") ; <CJK>
       (?$(KA^(B . "0x26015") ; <CJK>
       (?$(KA_(B . "0x26014") ; <CJK>
       (?$(KA`(B . "0x2601D") ; <CJK>
       (?$(KAa(B . "0x2601C") ; <CJK>
       (?$(KAb(B . "0x26023") ; <CJK>
       (?$(KAc(B . "0x26057") ; <CJK>
       (?$(KAd(B . "0x262C8") ; <CJK>
       (?$(KAe(B . "0x435D") ; <CJK>
       (?$(KAf(B . "0x262C9") ; <CJK>
       (?$(KAg(B . "0x262C5") ; <CJK>
       (?$(KAh(B . "0x26387") ; <CJK>
       (?$(KAi(B . "0x2638A") ; <CJK>
       (?$(KAj(B . "0x26394") ; <CJK>
       (?$(KAk(B . "0x26439") ; <CJK>
       (?$(KAl(B . "0x26440") ; <CJK>
       (?$(KAm(B . "0x2643E") ; <CJK>
       (?$(KAn(B . "0x26438") ; <CJK>
       (?$(KAo(B . "0x264D6") ; <CJK>
       (?$(KAp(B . "0x43B8") ; <CJK>
       (?$(KAq(B . "0x26577") ; <CJK>
       (?$(KAr(B . "0x26578") ; <CJK>
       (?$(KAs(B . "0x2657D") ; <CJK>
       (?$(KAt(B . "0x266DD") ; <CJK>
       (?$(KAu(B . "0x2675E") ; <CJK>
       (?$(KAv(B . "0x26777") ; <CJK>
       (?$(KAw(B . "0x267D4") ; <CJK>
       (?$(KAx(B . "0x26766") ; <CJK>
       (?$(KAy(B . "0x2675F") ; <CJK>
       (?$(KAz(B . "0x26773") ; <CJK>
       (?$(KA{(B . "0x26772") ; <CJK>
       (?$(KA|(B . "0x26797") ; <CJK>
       (?$(KA}(B . "0x2675A") ; <CJK>
       (?$(KA~(B . "0x26796") ; <CJK>
       (?$(KB!(B . "0x2675D") ; <CJK>
       (?$(KB"(B . "0x26765") ; <CJK>
       (?$(KB#(B . "0x26770") ; <CJK>
       (?$(KB$(B . "0x26775") ; <CJK>
       (?$(KB%(B . "0x26774") ; <CJK>
       (?$(KB&(B . "0x2675C") ; <CJK>
       (?$(KB'(B . "0x26760") ; <CJK>
       (?$(KB((B . "0x4434") ; <CJK>
       (?$(KB)(B . "0x2676D") ; <CJK>
       (?$(KB*(B . "0x26941") ; <CJK>
       (?$(KB+(B . "0x26A3C") ; <CJK>
       (?$(KB,(B . "0x26A3E") ; <CJK>
       (?$(KB-(B . "0x446F") ; <CJK>
       (?$(KB.(B . "0x26A49") ; <CJK>
       (?$(KB/(B . "0x26BE4") ; <CJK>
       (?$(KB0(B . "0x26D0C") ; <CJK>
       (?$(KB1(B . "0x26D15") ; <CJK>
       (?$(KB2(B . "0x26D0E") ; <CJK>
       (?$(KB3(B . "0x26CD4") ; <CJK>
       (?$(KB4(B . "0x26CC7") ; <CJK>
       (?$(KB5(B . "0x26D14") ; <CJK>
       (?$(KB6(B . "0x26CDB") ; <CJK>
       (?$(KB7(B . "0x26D5F") ; <CJK>
       (?$(KB8(B . "0x26CED") ; <CJK>
       (?$(KB9(B . "0x26D09") ; <CJK>
       (?$(KB:(B . "0x26CCF") ; <CJK>
       (?$(KB;(B . "0x26CFF") ; <CJK>
       (?$(KB<(B . "0x26D1A") ; <CJK>
       (?$(KB=(B . "0x26CF5") ; <CJK>
       (?$(KB>(B . "0x26CEE") ; <CJK>
       (?$(KB?(B . "0x26CE5") ; <CJK>
       (?$(KB@(B . "0x26D0D") ; <CJK>
       (?$(KBA(B . "0x26CDF") ; <CJK>
       (?$(KBB(B . "0x26CEC") ; <CJK>
       (?$(KBC(B . "0x26CD7") ; <CJK>
       (?$(KBD(B . "0x26D2C") ; <CJK>
       (?$(KBE(B . "0x26CCD") ; <CJK>
       (?$(KBF(B . "0x26CE3") ; <CJK>
       (?$(KBG(B . "0x26D00") ; <CJK>
       (?$(KBH(B . "0x26CEB") ; <CJK>
       (?$(KBI(B . "0x26CFD") ; <CJK>
       (?$(KBJ(B . "0x26D0F") ; <CJK>
       (?$(KBK(B . "0x26D2D") ; <CJK>
       (?$(KBL(B . "0x26D50") ; <CJK>
       (?$(KBM(B . "0x26CFE") ; <CJK>
       (?$(KBN(B . "0x26CC4") ; <CJK>
       (?$(KBO(B . "0x26CE1") ; <CJK>
       (?$(KBP(B . "0x26CF9") ; <CJK>
       (?$(KBQ(B . "0x271BB") ; <CJK>
       (?$(KBR(B . "0x271BC") ; <CJK>
       (?$(KBS(B . "0x4594") ; <CJK>
       (?$(KBT(B . "0x4593") ; <CJK>
       (?$(KBU(B . "0x271BA") ; <CJK>
       (?$(KBV(B . "0x272D0") ; <CJK>
       (?$(KBW(B . "0x272D6") ; <CJK>
       (?$(KBX(B . "0x272CE") ; <CJK>
       (?$(KBY(B . "0x272E1") ; <CJK>
       (?$(KBZ(B . "0x272D5") ; <CJK>
       (?$(KB[(B . "0x272CF") ; <CJK>
       (?$(KB\(B . "0x272D3") ; <CJK>
       (?$(KB](B . "0x8714") ; <CJK>
       (?$(KB^(B . "0x272D4") ; <CJK>
       (?$(KB_(B . "0x275B5") ; <CJK>
       (?$(KB`(B . "0x27690") ; <CJK>
       (?$(KBa(B . "0x276A1") ; <CJK>
       (?$(KBb(B . "0x27681") ; <CJK>
       (?$(KBc(B . "0x27685") ; <CJK>
       (?$(KBd(B . "0x2766E") ; <CJK>
       (?$(KBe(B . "0x27688") ; <CJK>
       (?$(KBf(B . "0x27682") ; <CJK>
       (?$(KBg(B . "0x27686") ; <CJK>
       (?$(KBh(B . "0x2768F") ; <CJK>
       (?$(KBi(B . "0x27689") ; <CJK>
       (?$(KBj(B . "0x27680") ; <CJK>
       (?$(KBk(B . "0x27684") ; <CJK>
       (?$(KBl(B . "0x88D1") ; <CJK>
       (?$(KBm(B . "0x27829") ; <CJK>
       (?$(KBn(B . "0x2782B") ; <CJK>
       (?$(KBo(B . "0x2782A") ; <CJK>
       (?$(KBp(B . "0x27830") ; <CJK>
       (?$(KBq(B . "0x278E2") ; <CJK>
       (?$(KBr(B . "0x278E3") ; <CJK>
       (?$(KBs(B . "0x278E1") ; <CJK>
       (?$(KBt(B . "0x279D5") ; <CJK>
       (?$(KBu(B . "0x279C4") ; <CJK>
       (?$(KBv(B . "0x279C9") ; <CJK>
       (?$(KBw(B . "0x279E0") ; <CJK>
       (?$(KBx(B . "0x279DF") ; <CJK>
       (?$(KBy(B . "0x279CB") ; <CJK>
       (?$(KBz(B . "0x279DD") ; <CJK>
       (?$(KB{(B . "0x279E8") ; <CJK>
       (?$(KB|(B . "0x279D4") ; <CJK>
       (?$(KB}(B . "0x27A1C") ; <CJK>
       (?$(KB~(B . "0x27BB5") ; <CJK>
       (?$(KC!(B . "0x27BB6") ; <CJK>
       (?$(KC"(B . "0x27BE5") ; <CJK>
       (?$(KC#(B . "0x27C45") ; <CJK>
       (?$(KC$(B . "0x27C49") ; <CJK>
       (?$(KC%(B . "0x27C40") ; <CJK>
       (?$(KC&(B . "0x27C46") ; <CJK>
       (?$(KC'(B . "0x27C44") ; <CJK>
       (?$(KC((B . "0x27C4A") ; <CJK>
       (?$(KC)(B . "0x27CC9") ; <CJK>
       (?$(KC*(B . "0x27CC4") ; <CJK>
       (?$(KC+(B . "0x27CC2") ; <CJK>
       (?$(KC,(B . "0x27D68") ; <CJK>
       (?$(KC-(B . "0x8CCB") ; <CJK>
       (?$(KC.(B . "0x27D82") ; <CJK>
       (?$(KC/(B . "0x27D6B") ; <CJK>
       (?$(KC0(B . "0x27D67") ; <CJK>
       (?$(KC1(B . "0x27D6C") ; <CJK>
       (?$(KC2(B . "0x27D6D") ; <CJK>
       (?$(KC3(B . "0x27D71") ; <CJK>
       (?$(KC4(B . "0x4792") ; <CJK>
       (?$(KC5(B . "0x27ED7") ; <CJK>
       (?$(KC6(B . "0x27ED2") ; <CJK>
       (?$(KC7(B . "0x27ED9") ; <CJK>
       (?$(KC8(B . "0x47AA") ; <CJK>
       (?$(KC9(B . "0x27EBC") ; <CJK>
       (?$(KC:(B . "0x27EDD") ; <CJK>
       (?$(KC;(B . "0x27ED6") ; <CJK>
       (?$(KC<(B . "0x47A7") ; <CJK>
       (?$(KC=(B . "0x27ED8") ; <CJK>
       (?$(KC>(B . "0x28020") ; <CJK>
       (?$(KC?(B . "0x28016") ; <CJK>
       (?$(KC@(B . "0x28018") ; <CJK>
       (?$(KCA(B . "0x28015") ; <CJK>
       (?$(KCB(B . "0x28019") ; <CJK>
       (?$(KCC(B . "0x28027") ; <CJK>
       (?$(KCD(B . "0x28050") ; <CJK>
       (?$(KCE(B . "0x2801D") ; <CJK>
       (?$(KCF(B . "0x2802C") ; <CJK>
       (?$(KCG(B . "0x2801C") ; <CJK>
       (?$(KCH(B . "0x28029") ; <CJK>
       (?$(KCI(B . "0x2802B") ; <CJK>
       (?$(KCJ(B . "0x28024") ; <CJK>
       (?$(KCK(B . "0x47EF") ; <CJK>
       (?$(KCL(B . "0x28028") ; <CJK>
       (?$(KCM(B . "0x28239") ; <CJK>
       (?$(KCN(B . "0x282F2") ; <CJK>
       (?$(KCO(B . "0x282F0") ; <CJK>
       (?$(KCP(B . "0x8EED") ; <CJK>
       (?$(KCQ(B . "0x282ED") ; <CJK>
       (?$(KCR(B . "0x282EF") ; <CJK>
       (?$(KCS(B . "0x282EA") ; <CJK>
       (?$(KCT(B . "0x28301") ; <CJK>
       (?$(KCU(B . "0x284BC") ; <CJK>
       (?$(KCV(B . "0x2855C") ; <CJK>
       (?$(KCW(B . "0x2855B") ; <CJK>
       (?$(KCX(B . "0x2855A") ; <CJK>
       (?$(KCY(B . "0x28526") ; <CJK>
       (?$(KCZ(B . "0x28743") ; <CJK>
       (?$(KC[(B . "0x28733") ; <CJK>
       (?$(KC\(B . "0x2873A") ; <CJK>
       (?$(KC](B . "0x28737") ; <CJK>
       (?$(KC^(B . "0x28736") ; <CJK>
       (?$(KC_(B . "0x2873C") ; <CJK>
       (?$(KC`(B . "0x28734") ; <CJK>
       (?$(KCa(B . "0x2874A") ; <CJK>
       (?$(KCb(B . "0x2873B") ; <CJK>
       (?$(KCc(B . "0x28735") ; <CJK>
       (?$(KCd(B . "0x2873D") ; <CJK>
       (?$(KCe(B . "0x28740") ; <CJK>
       (?$(KCf(B . "0x2873E") ; <CJK>
       (?$(KCg(B . "0x28717") ; <CJK>
       (?$(KCh(B . "0x28826") ; <CJK>
       (?$(KCi(B . "0x28824") ; <CJK>
       (?$(KCj(B . "0x28810") ; <CJK>
       (?$(KCk(B . "0x28836") ; <CJK>
       (?$(KCl(B . "0x28825") ; <CJK>
       (?$(KCm(B . "0x4922") ; <CJK>
       (?$(KCn(B . "0x28966") ; <CJK>
       (?$(KCo(B . "0x28C7F") ; <CJK>
       (?$(KCp(B . "0x28C7A") ; <CJK>
       (?$(KCq(B . "0x28CFB") ; <CJK>
       (?$(KCr(B . "0x28CFD") ; <CJK>
       (?$(KCs(B . "0x28CFC") ; <CJK>
       (?$(KCt(B . "0x28CFA") ; <CJK>
       (?$(KCu(B . "0x28ED6") ; <CJK>
       (?$(KCv(B . "0x28ED2") ; <CJK>
       (?$(KCw(B . "0x28EC8") ; <CJK>
       (?$(KCx(B . "0x28EC2") ; <CJK>
       (?$(KCy(B . "0x28EC7") ; <CJK>
       (?$(KCz(B . "0x28ECD") ; <CJK>
       (?$(KC{(B . "0x28EC1") ; <CJK>
       (?$(KC|(B . "0x28EC6") ; <CJK>
       (?$(KC}(B . "0x28ECC") ; <CJK>
       (?$(KC~(B . "0x28FA1") ; <CJK>
       (?$(KD!(B . "0x29095") ; <CJK>
       (?$(KD"(B . "0x29094") ; <CJK>
       (?$(KD#(B . "0x29097") ; <CJK>
       (?$(KD$(B . "0x29096") ; <CJK>
       (?$(KD%(B . "0x29093") ; <CJK>
       (?$(KD&(B . "0x290A1") ; <CJK>
       (?$(KD'(B . "0x29209") ; <CJK>
       (?$(KD((B . "0x29208") ; <CJK>
       (?$(KD)(B . "0x29267") ; <CJK>
       (?$(KD*(B . "0x29265") ; <CJK>
       (?$(KD+(B . "0x29262") ; <CJK>
       (?$(KD,(B . "0x29261") ; <CJK>
       (?$(KD-(B . "0x29397") ; <CJK>
       (?$(KD.(B . "0x29401") ; <CJK>
       (?$(KD/(B . "0x29419") ; <CJK>
       (?$(KD0(B . "0x29418") ; <CJK>
       (?$(KD1(B . "0x2945C") ; <CJK>
       (?$(KD2(B . "0x29467") ; <CJK>
       (?$(KD3(B . "0x2946C") ; <CJK>
       (?$(KD4(B . "0x4AB5") ; <CJK>
       (?$(KD5(B . "0x2F9FD") ; <CJK>
       (?$(KD6(B . "0x29466") ; <CJK>
       (?$(KD7(B . "0x29461") ; <CJK>
       (?$(KD8(B . "0x2946E") ; <CJK>
       (?$(KD9(B . "0x2945D") ; <CJK>
       (?$(KD:(B . "0x2945A") ; <CJK>
       (?$(KD;(B . "0x295A2") ; <CJK>
       (?$(KD<(B . "0x295A9") ; <CJK>
       (?$(KD=(B . "0x295A5") ; <CJK>
       (?$(KD>(B . "0x295A6") ; <CJK>
       (?$(KD?(B . "0x295B2") ; <CJK>
       (?$(KD@(B . "0x295A3") ; <CJK>
       (?$(KDA(B . "0x296AC") ; <CJK>
       (?$(KDB(B . "0x296AA") ; <CJK>
       (?$(KDC(B . "0x296AF") ; <CJK>
       (?$(KDD(B . "0x296AB") ; <CJK>
       (?$(KDE(B . "0x296B1") ; <CJK>
       (?$(KDF(B . "0x296C6") ; <CJK>
       (?$(KDG(B . "0x296AD") ; <CJK>
       (?$(KDH(B . "0x296B9") ; <CJK>
       (?$(KDI(B . "0x29870") ; <CJK>
       (?$(KDJ(B . "0x4B75") ; <CJK>
       (?$(KDK(B . "0x29C0C") ; <CJK>
       (?$(KDL(B . "0x29C81") ; <CJK>
       (?$(KDM(B . "0x29C83") ; <CJK>
       (?$(KDN(B . "0x29C7E") ; <CJK>
       (?$(KDO(B . "0x29D51") ; <CJK>
       (?$(KDP(B . "0x29F99") ; <CJK>
       (?$(KDQ(B . "0x29F94") ; <CJK>
       (?$(KDR(B . "0x29F95") ; <CJK>
       (?$(KDS(B . "0x2A2FE") ; <CJK>
       (?$(KDT(B . "0x2A418") ; <CJK>
       (?$(KDU(B . "0x20105") ; <CJK>
       (?$(KDV(B . "0x20372") ; <CJK>
       (?$(KDW(B . "0x3482") ; <CJK>
       (?$(KDX(B . "0x20399") ; <CJK>
       (?$(KDY(B . "0x204AD") ; <CJK>
       (?$(KDZ(B . "0x20606") ; <CJK>
       (?$(KD[(B . "0x207C2") ; <CJK>
       (?$(KD\(B . "0x207CB") ; <CJK>
       (?$(KD](B . "0x207D5") ; <CJK>
       (?$(KD^(B . "0x207D2") ; <CJK>
       (?$(KD_(B . "0x207CC") ; <CJK>
       (?$(KD`(B . "0x207D7") ; <CJK>
       (?$(KDa(B . "0x207C5") ; <CJK>
       (?$(KDb(B . "0x207CA") ; <CJK>
       (?$(KDc(B . "0x52EC") ; <CJK>
       (?$(KDd(B . "0x208A2") ; <CJK>
       (?$(KDe(B . "0x208A3") ; <CJK>
       (?$(KDf(B . "0x208A1") ; <CJK>
       (?$(KDg(B . "0x52E8") ; <CJK>
       (?$(KDh(B . "0x208A6") ; <CJK>
       (?$(KDi(B . "0x208A4") ; <CJK>
       (?$(KDj(B . "0x208FF") ; <CJK>
       (?$(KDk(B . "0x20900") ; <CJK>
       (?$(KDl(B . "0x3535") ; <CJK>
       (?$(KDm(B . "0x20A06") ; <CJK>
       (?$(KDn(B . "0x20A25") ; <CJK>
       (?$(KDo(B . "0x20A9F") ; <CJK>
       (?$(KDp(B . "0x20B7F") ; <CJK>
       (?$(KDq(B . "0x20EEA") ; <CJK>
       (?$(KDr(B . "0x20EEB") ; <CJK>
       (?$(KDs(B . "0x20EDE") ; <CJK>
       (?$(KDt(B . "0x20F18") ; <CJK>
       (?$(KDu(B . "0x20EE0") ; <CJK>
       (?$(KDv(B . "0x20EE8") ; <CJK>
       (?$(KDw(B . "0x20EDF") ; <CJK>
       (?$(KDx(B . "0x20EF1") ; <CJK>
       (?$(KDy(B . "0x20EEC") ; <CJK>
       (?$(KDz(B . "0x20F1A") ; <CJK>
       (?$(KD{(B . "0x20EE6") ; <CJK>
       (?$(KD|(B . "0x20EE1") ; <CJK>
       (?$(KD}(B . "0x20F5D") ; <CJK>
       (?$(KD~(B . "0x20077") ; <CJK>
       (?$(KE!(B . "0x20F1E") ; <CJK>
       (?$(KE"(B . "0x35F0") ; <CJK>
       (?$(KE#(B . "0x20F80") ; <CJK>
       (?$(KE$(B . "0x21217") ; <CJK>
       (?$(KE%(B . "0x2141D") ; <CJK>
       (?$(KE&(B . "0x213F7") ; <CJK>
       (?$(KE'(B . "0x213EF") ; <CJK>
       (?$(KE((B . "0x213EE") ; <CJK>
       (?$(KE)(B . "0x213ED") ; <CJK>
       (?$(KE*(B . "0x213F5") ; <CJK>
       (?$(KE+(B . "0x2141E") ; <CJK>
       (?$(KE,(B . "0x215BD") ; <CJK>
       (?$(KE-(B . "0x257FF") ; <CJK>
       (?$(KE.(B . "0x215BE") ; <CJK>
       (?$(KE/(B . "0x2166D") ; <CJK>
       (?$(KE0(B . "0x21676") ; <CJK>
       (?$(KE1(B . "0x2184C") ; <CJK>
       (?$(KE2(B . "0x21819") ; <CJK>
       (?$(KE3(B . "0x21848") ; <CJK>
       (?$(KE4(B . "0x2181E") ; <CJK>
       (?$(KE5(B . "0x2184A") ; <CJK>
       (?$(KE6(B . "0x21849") ; <CJK>
       (?$(KE7(B . "0x21826") ; <CJK>
       (?$(KE8(B . "0x21995") ; <CJK>
       (?$(KE9(B . "0x21A85") ; <CJK>
       (?$(KE:(B . "0x21A7E") ; <CJK>
       (?$(KE;(B . "0x21A97") ; <CJK>
       (?$(KE<(B . "0x21A7D") ; <CJK>
       (?$(KE=(B . "0x21B42") ; <CJK>
       (?$(KE>(B . "0x21B9E") ; <CJK>
       (?$(KE?(B . "0x21C0C") ; <CJK>
       (?$(KE@(B . "0x21C0B") ; <CJK>
       (?$(KEA(B . "0x21C0E") ; <CJK>
       (?$(KEB(B . "0x21CCF") ; <CJK>
       (?$(KEC(B . "0x21ED8") ; <CJK>
       (?$(KED(B . "0x21EE0") ; <CJK>
       (?$(KEE(B . "0x21EE8") ; <CJK>
       (?$(KEF(B . "0x21EE9") ; <CJK>
       (?$(KEG(B . "0x21EE2") ; <CJK>
       (?$(KEH(B . "0x21EE1") ; <CJK>
       (?$(KEI(B . "0x21EDA") ; <CJK>
       (?$(KEJ(B . "0x21EE3") ; <CJK>
       (?$(KEK(B . "0x21ED9") ; <CJK>
       (?$(KEL(B . "0x21EF0") ; <CJK>
       (?$(KEM(B . "0x21EE7") ; <CJK>
       (?$(KEN(B . "0x21EE4") ; <CJK>
       (?$(KEO(B . "0x22123") ; <CJK>
       (?$(KEP(B . "0x22131") ; <CJK>
       (?$(KEQ(B . "0x22133") ; <CJK>
       (?$(KER(B . "0x2210C") ; <CJK>
       (?$(KES(B . "0x269E0") ; <CJK>
       (?$(KET(B . "0x22126") ; <CJK>
       (?$(KEU(B . "0x22124") ; <CJK>
       (?$(KEV(B . "0x22132") ; <CJK>
       (?$(KEW(B . "0x22127") ; <CJK>
       (?$(KEX(B . "0x22121") ; <CJK>
       (?$(KEY(B . "0x22130") ; <CJK>
       (?$(KEZ(B . "0x221A2") ; <CJK>
       (?$(KE[(B . "0x221CC") ; <CJK>
       (?$(KE\(B . "0x22296") ; <CJK>
       (?$(KE](B . "0x2F88F") ; <CJK>
       (?$(KE^(B . "0x22298") ; <CJK>
       (?$(KE_(B . "0x2229C") ; <CJK>
       (?$(KE`(B . "0x2229B") ; <CJK>
       (?$(KEa(B . "0x2236B") ; <CJK>
       (?$(KEb(B . "0x22412") ; <CJK>
       (?$(KEc(B . "0x22414") ; <CJK>
       (?$(KEd(B . "0x2255A") ; <CJK>
       (?$(KEe(B . "0x22554") ; <CJK>
       (?$(KEf(B . "0x22551") ; <CJK>
       (?$(KEg(B . "0x2255E") ; <CJK>
       (?$(KEh(B . "0x22558") ; <CJK>
       (?$(KEi(B . "0x38F0") ; <CJK>
       (?$(KEj(B . "0x22559") ; <CJK>
       (?$(KEk(B . "0x2279A") ; <CJK>
       (?$(KEl(B . "0x227F2") ; <CJK>
       (?$(KEm(B . "0x227AD") ; <CJK>
       (?$(KEn(B . "0x22820") ; <CJK>
       (?$(KEo(B . "0x227F1") ; <CJK>
       (?$(KEp(B . "0x227F0") ; <CJK>
       (?$(KEq(B . "0x227F3") ; <CJK>
       (?$(KEr(B . "0x227F4") ; <CJK>
       (?$(KEs(B . "0x227E9") ; <CJK>
       (?$(KEt(B . "0x227FE") ; <CJK>
       (?$(KEu(B . "0x2282E") ; <CJK>
       (?$(KEv(B . "0x227E8") ; <CJK>
       (?$(KEw(B . "0x227E7") ; <CJK>
       (?$(KEx(B . "0x227FF") ; <CJK>
       (?$(KEy(B . "0x227F5") ; <CJK>
       (?$(KEz(B . "0x229E5") ; <CJK>
       (?$(KE{(B . "0x229E7") ; <CJK>
       (?$(KE|(B . "0x229E6") ; <CJK>
       (?$(KE}(B . "0x229E9") ; <CJK>
       (?$(KE~(B . "0x22A58") ; <CJK>
       (?$(KF!(B . "0x22C6C") ; <CJK>
       (?$(KF"(B . "0x22CD9") ; <CJK>
       (?$(KF#(B . "0x3A3E") ; <CJK>
       (?$(KF$(B . "0x22CCB") ; <CJK>
       (?$(KF%(B . "0x3A39") ; <CJK>
       (?$(KF&(B . "0x22CBE") ; <CJK>
       (?$(KF'(B . "0x22CB5") ; <CJK>
       (?$(KF((B . "0x22CD1") ; <CJK>
       (?$(KF)(B . "0x22CC2") ; <CJK>
       (?$(KF*(B . "0x22CB6") ; <CJK>
       (?$(KF+(B . "0x22CD3") ; <CJK>
       (?$(KF,(B . "0x2F8C2") ; <CJK>
       (?$(KF-(B . "0x22EDA") ; <CJK>
       (?$(KF.(B . "0x3AA2") ; <CJK>
       (?$(KF/(B . "0x22FAE") ; <CJK>
       (?$(KF0(B . "0x3AA1") ; <CJK>
       (?$(KF1(B . "0x22FAC") ; <CJK>
       (?$(KF2(B . "0x22FA9") ; <CJK>
       (?$(KF3(B . "0x22FBA") ; <CJK>
       (?$(KF4(B . "0x22FA7") ; <CJK>
       (?$(KF5(B . "0x22FB3") ; <CJK>
       (?$(KF6(B . "0x22FBD") ; <CJK>
       (?$(KF7(B . "0x22FB1") ; <CJK>
       (?$(KF8(B . "0x2310E") ; <CJK>
       (?$(KF9(B . "0x23111") ; <CJK>
       (?$(KF:(B . "0x2310F") ; <CJK>
       (?$(KF;(B . "0x23252") ; <CJK>
       (?$(KF<(B . "0x2326A") ; <CJK>
       (?$(KF=(B . "0x23254") ; <CJK>
       (?$(KF>(B . "0x23255") ; <CJK>
       (?$(KF?(B . "0x23253") ; <CJK>
       (?$(KF@(B . "0x23257") ; <CJK>
       (?$(KFA(B . "0x2F8D0") ; <CJK>
       (?$(KFB(B . "0x2325B") ; <CJK>
       (?$(KFC(B . "0x23258") ; <CJK>
       (?$(KFD(B . "0x23259") ; <CJK>
       (?$(KFE(B . "0x3B3B") ; <CJK>
       (?$(KFF(B . "0x235B8") ; <CJK>
       (?$(KFG(B . "0x235B5") ; <CJK>
       (?$(KFH(B . "0x235BF") ; <CJK>
       (?$(KFI(B . "0x235C1") ; <CJK>
       (?$(KFJ(B . "0x235BB") ; <CJK>
       (?$(KFK(B . "0x3BB7") ; <CJK>
       (?$(KFL(B . "0x235C3") ; <CJK>
       (?$(KFM(B . "0x235AD") ; <CJK>
       (?$(KFN(B . "0x235A8") ; <CJK>
       (?$(KFO(B . "0x235AE") ; <CJK>
       (?$(KFP(B . "0x235AA") ; <CJK>
       (?$(KFQ(B . "0x235D0") ; <CJK>
       (?$(KFR(B . "0x235B1") ; <CJK>
       (?$(KFS(B . "0x235BC") ; <CJK>
       (?$(KFT(B . "0x235B7") ; <CJK>
       (?$(KFU(B . "0x235B0") ; <CJK>
       (?$(KFV(B . "0x235FA") ; <CJK>
       (?$(KFW(B . "0x235FB") ; <CJK>
       (?$(KFX(B . "0x235B9") ; <CJK>
       (?$(KFY(B . "0x23907") ; <CJK>
       (?$(KFZ(B . "0x238FC") ; <CJK>
       (?$(KF[(B . "0x238FF") ; <CJK>
       (?$(KF\(B . "0x238F2") ; <CJK>
       (?$(KF](B . "0x238F8") ; <CJK>
       (?$(KF^(B . "0x238F4") ; <CJK>
       (?$(KF_(B . "0x3C57") ; <CJK>
       (?$(KF`(B . "0x3C70") ; <CJK>
       (?$(KFa(B . "0x23AAE") ; <CJK>
       (?$(KFb(B . "0x23B0F") ; <CJK>
       (?$(KFc(B . "0x23B10") ; <CJK>
       (?$(KFd(B . "0x29AC1") ; <CJK>
       (?$(KFe(B . "0x23BC7") ; <CJK>
       (?$(KFf(B . "0x23BC6") ; <CJK>
       (?$(KFg(B . "0x23BCE") ; <CJK>
       (?$(KFh(B . "0x3CA7") ; <CJK>
       (?$(KFi(B . "0x23BDC") ; <CJK>
       (?$(KFj(B . "0x23ED5") ; <CJK>
       (?$(KFk(B . "0x23ED3") ; <CJK>
       (?$(KFl(B . "0x23F20") ; <CJK>
       (?$(KFm(B . "0x23EE2") ; <CJK>
       (?$(KFn(B . "0x23EF1") ; <CJK>
       (?$(KFo(B . "0x23EDB") ; <CJK>
       (?$(KFp(B . "0x23EEA") ; <CJK>
       (?$(KFq(B . "0x23EEB") ; <CJK>
       (?$(KFr(B . "0x23EE1") ; <CJK>
       (?$(KFs(B . "0x23EFF") ; <CJK>
       (?$(KFt(B . "0x23ED6") ; <CJK>
       (?$(KFu(B . "0x23EE0") ; <CJK>
       (?$(KFv(B . "0x23ED7") ; <CJK>
       (?$(KFw(B . "0x23EE5") ; <CJK>
       (?$(KFx(B . "0x3D54") ; <CJK>
       (?$(KFy(B . "0x2431B") ; <CJK>
       (?$(KFz(B . "0x24310") ; <CJK>
       (?$(KF{(B . "0x2430F") ; <CJK>
       (?$(KF|(B . "0x2430E") ; <CJK>
       (?$(KF}(B . "0x24339") ; <CJK>
       (?$(KF~(B . "0x2430A") ; <CJK>
       (?$(KG!(B . "0x24314") ; <CJK>
       (?$(KG"(B . "0x2430C") ; <CJK>
       (?$(KG#(B . "0x24523") ; <CJK>
       (?$(KG$(B . "0x2455A") ; <CJK>
       (?$(KG%(B . "0x245E2") ; <CJK>
       (?$(KG&(B . "0x24693") ; <CJK>
       (?$(KG'(B . "0x246B0") ; <CJK>
       (?$(KG((B . "0x246AB") ; <CJK>
       (?$(KG)(B . "0x246BD") ; <CJK>
       (?$(KG*(B . "0x246B1") ; <CJK>
       (?$(KG+(B . "0x2468D") ; <CJK>
       (?$(KG,(B . "0x246AD") ; <CJK>
       (?$(KG-(B . "0x246AA") ; <CJK>
       (?$(KG.(B . "0x246AC") ; <CJK>
       (?$(KG/(B . "0x246BC") ; <CJK>
       (?$(KG0(B . "0x246C9") ; <CJK>
       (?$(KG1(B . "0x24847") ; <CJK>
       (?$(KG2(B . "0x24862") ; <CJK>
       (?$(KG3(B . "0x24840") ; <CJK>
       (?$(KG4(B . "0x24844") ; <CJK>
       (?$(KG5(B . "0x2483F") ; <CJK>
       (?$(KG6(B . "0x24843") ; <CJK>
       (?$(KG7(B . "0x2483D") ; <CJK>
       (?$(KG8(B . "0x24860") ; <CJK>
       (?$(KG9(B . "0x2485F") ; <CJK>
       (?$(KG:(B . "0x2483A") ; <CJK>
       (?$(KG;(B . "0x24842") ; <CJK>
       (?$(KG<(B . "0x2485E") ; <CJK>
       (?$(KG=(B . "0x2485D") ; <CJK>
       (?$(KG>(B . "0x249BC") ; <CJK>
       (?$(KG?(B . "0x249E0") ; <CJK>
       (?$(KG@(B . "0x249EE") ; <CJK>
       (?$(KGA(B . "0x249EB") ; <CJK>
       (?$(KGB(B . "0x24A0D") ; <CJK>
       (?$(KGC(B . "0x24B09") ; <CJK>
       (?$(KGD(B . "0x24B0C") ; <CJK>
       (?$(KGE(B . "0x24B69") ; <CJK>
       (?$(KGF(B . "0x24B74") ; <CJK>
       (?$(KGG(B . "0x24B67") ; <CJK>
       (?$(KGH(B . "0x3F31") ; <CJK>
       (?$(KGI(B . "0x7527") ; <CJK>
       (?$(KGJ(B . "0x24CAD") ; <CJK>
       (?$(KGK(B . "0x24DFF") ; <CJK>
       (?$(KGL(B . "0x24E16") ; <CJK>
       (?$(KGM(B . "0x24E08") ; <CJK>
       (?$(KGN(B . "0x24E09") ; <CJK>
       (?$(KGO(B . "0x24E00") ; <CJK>
       (?$(KGP(B . "0x24DFC") ; <CJK>
       (?$(KGQ(B . "0x24E13") ; <CJK>
       (?$(KGR(B . "0x24E14") ; <CJK>
       (?$(KGS(B . "0x24E0A") ; <CJK>
       (?$(KGT(B . "0x2983E") ; <CJK>
       (?$(KGU(B . "0x24E29") ; <CJK>
       (?$(KGV(B . "0x24E17") ; <CJK>
       (?$(KGW(B . "0x24E3B") ; <CJK>
       (?$(KGX(B . "0x24DFB") ; <CJK>
       (?$(KGY(B . "0x3FBF") ; <CJK>
       (?$(KGZ(B . "0x24E0E") ; <CJK>
       (?$(KG[(B . "0x3FE4") ; <CJK>
       (?$(KG\(B . "0x25008") ; <CJK>
       (?$(KG](B . "0x2521B") ; <CJK>
       (?$(KG^(B . "0x2521A") ; <CJK>
       (?$(KG_(B . "0x25219") ; <CJK>
       (?$(KG`(B . "0x25202") ; <CJK>
       (?$(KGa(B . "0x404A") ; <CJK>
       (?$(KGb(B . "0x25217") ; <CJK>
       (?$(KGc(B . "0x25207") ; <CJK>
       (?$(KGd(B . "0x25213") ; <CJK>
       (?$(KGe(B . "0x25209") ; <CJK>
       (?$(KGf(B . "0x2520A") ; <CJK>
       (?$(KGg(B . "0x25212") ; <CJK>
       (?$(KGh(B . "0x252AA") ; <CJK>
       (?$(KGi(B . "0x25238") ; <CJK>
       (?$(KGj(B . "0x2537B") ; <CJK>
       (?$(KGk(B . "0x2537C") ; <CJK>
       (?$(KGl(B . "0x2537A") ; <CJK>
       (?$(KGm(B . "0x253EA") ; <CJK>
       (?$(KGn(B . "0x253EB") ; <CJK>
       (?$(KGo(B . "0x253EF") ; <CJK>
       (?$(KGp(B . "0x253F0") ; <CJK>
       (?$(KGq(B . "0x25509") ; <CJK>
       (?$(KGr(B . "0x25502") ; <CJK>
       (?$(KGs(B . "0x25501") ; <CJK>
       (?$(KGt(B . "0x2552B") ; <CJK>
       (?$(KGu(B . "0x25507") ; <CJK>
       (?$(KGv(B . "0x40CF") ; <CJK>
       (?$(KGw(B . "0x25528") ; <CJK>
       (?$(KGx(B . "0x254FB") ; <CJK>
       (?$(KGy(B . "0x2552A") ; <CJK>
       (?$(KGz(B . "0x254FE") ; <CJK>
       (?$(KG{(B . "0x25504") ; <CJK>
       (?$(KG|(B . "0x25529") ; <CJK>
       (?$(KG}(B . "0x2550A") ; <CJK>
       (?$(KG~(B . "0x798C") ; <CJK>
       (?$(KH!(B . "0x256C2") ; <CJK>
       (?$(KH"(B . "0x7991") ; <CJK>
       (?$(KH#(B . "0x256A6") ; <CJK>
       (?$(KH$(B . "0x4114") ; <CJK>
       (?$(KH%(B . "0x22FC6") ; <CJK>
       (?$(KH&(B . "0x21C07") ; <CJK>
       (?$(KH'(B . "0x2580A") ; <CJK>
       (?$(KH((B . "0x257FD") ; <CJK>
       (?$(KH)(B . "0x25806") ; <CJK>
       (?$(KH*(B . "0x2580D") ; <CJK>
       (?$(KH+(B . "0x25809") ; <CJK>
       (?$(KH,(B . "0x2580B") ; <CJK>
       (?$(KH-(B . "0x25800") ; <CJK>
       (?$(KH.(B . "0x25805") ; <CJK>
       (?$(KH/(B . "0x2583D") ; <CJK>
       (?$(KH0(B . "0x259D5") ; <CJK>
       (?$(KH1(B . "0x259BF") ; <CJK>
       (?$(KH2(B . "0x259BA") ; <CJK>
       (?$(KH3(B . "0x259C7") ; <CJK>
       (?$(KH4(B . "0x25A98") ; <CJK>
       (?$(KH5(B . "0x25A9A") ; <CJK>
       (?$(KH6(B . "0x420D") ; <CJK>
       (?$(KH7(B . "0x25BA4") ; <CJK>
       (?$(KH8(B . "0x25B9C") ; <CJK>
       (?$(KH9(B . "0x25B9D") ; <CJK>
       (?$(KH:(B . "0x25BA2") ; <CJK>
       (?$(KH;(B . "0x25B96") ; <CJK>
       (?$(KH<(B . "0x25B95") ; <CJK>
       (?$(KH=(B . "0x25BA5") ; <CJK>
       (?$(KH>(B . "0x25BAA") ; <CJK>
       (?$(KH?(B . "0x25BAD") ; <CJK>
       (?$(KH@(B . "0x25B9A") ; <CJK>
       (?$(KHA(B . "0x25BA3") ; <CJK>
       (?$(KHB(B . "0x25B97") ; <CJK>
       (?$(KHC(B . "0x25B90") ; <CJK>
       (?$(KHD(B . "0x25BAF") ; <CJK>
       (?$(KHE(B . "0x25B8D") ; <CJK>
       (?$(KHF(B . "0x4201") ; <CJK>
       (?$(KHG(B . "0x25BA8") ; <CJK>
       (?$(KHH(B . "0x25BEE") ; <CJK>
       (?$(KHI(B . "0x25EA3") ; <CJK>
       (?$(KHJ(B . "0x25E99") ; <CJK>
       (?$(KHK(B . "0x25EA1") ; <CJK>
       (?$(KHL(B . "0x25E9C") ; <CJK>
       (?$(KHM(B . "0x25EA4") ; <CJK>
       (?$(KHN(B . "0x25ECB") ; <CJK>
       (?$(KHO(B . "0x26056") ; <CJK>
       (?$(KHP(B . "0x26048") ; <CJK>
       (?$(KHQ(B . "0x26059") ; <CJK>
       (?$(KHR(B . "0x2604A") ; <CJK>
       (?$(KHS(B . "0x2605C") ; <CJK>
       (?$(KHT(B . "0x42F1") ; <CJK>
       (?$(KHU(B . "0x2604F") ; <CJK>
       (?$(KHV(B . "0x2604D") ; <CJK>
       (?$(KHW(B . "0x2605D") ; <CJK>
       (?$(KHX(B . "0x2623A") ; <CJK>
       (?$(KHY(B . "0x262E3") ; <CJK>
       (?$(KHZ(B . "0x262E1") ; <CJK>
       (?$(KH[(B . "0x262DE") ; <CJK>
       (?$(KH\(B . "0x26397") ; <CJK>
       (?$(KH](B . "0x2639A") ; <CJK>
       (?$(KH^(B . "0x26448") ; <CJK>
       (?$(KH_(B . "0x2644A") ; <CJK>
       (?$(KH`(B . "0x2644C") ; <CJK>
       (?$(KHa(B . "0x2644E") ; <CJK>
       (?$(KHb(B . "0x2644F") ; <CJK>
       (?$(KHc(B . "0x2644B") ; <CJK>
       (?$(KHd(B . "0x2644D") ; <CJK>
       (?$(KHe(B . "0x26447") ; <CJK>
       (?$(KHf(B . "0x26451") ; <CJK>
       (?$(KHg(B . "0x264DA") ; <CJK>
       (?$(KHh(B . "0x264F9") ; <CJK>
       (?$(KHi(B . "0x264FC") ; <CJK>
       (?$(KHj(B . "0x264FB") ; <CJK>
       (?$(KHk(B . "0x264FD") ; <CJK>
       (?$(KHl(B . "0x264F8") ; <CJK>
       (?$(KHm(B . "0x264FA") ; <CJK>
       (?$(KHn(B . "0x2658A") ; <CJK>
       (?$(KHo(B . "0x2658E") ; <CJK>
       (?$(KHp(B . "0x26588") ; <CJK>
       (?$(KHq(B . "0x26589") ; <CJK>
       (?$(KHr(B . "0x2658D") ; <CJK>
       (?$(KHs(B . "0x26590") ; <CJK>
       (?$(KHt(B . "0x2F97E") ; <CJK>
       (?$(KHu(B . "0x2671C") ; <CJK>
       (?$(KHv(B . "0x267AB") ; <CJK>
       (?$(KHw(B . "0x267A4") ; <CJK>
       (?$(KHx(B . "0x267A8") ; <CJK>
       (?$(KHy(B . "0x267AD") ; <CJK>
       (?$(KHz(B . "0x2679F") ; <CJK>
       (?$(KH{(B . "0x2679A") ; <CJK>
       (?$(KH|(B . "0x267B0") ; <CJK>
       (?$(KH}(B . "0x267A5") ; <CJK>
       (?$(KH~(B . "0x267D5") ; <CJK>
       (?$(KI!(B . "0x267A2") ; <CJK>
       (?$(KI"(B . "0x267B2") ; <CJK>
       (?$(KI#(B . "0x2679D") ; <CJK>
       (?$(KI$(B . "0x267A1") ; <CJK>
       (?$(KI%(B . "0x26915") ; <CJK>
       (?$(KI&(B . "0x26942") ; <CJK>
       (?$(KI'(B . "0x26973") ; <CJK>
       (?$(KI((B . "0x26984") ; <CJK>
       (?$(KI)(B . "0x269DD") ; <CJK>
       (?$(KI*(B . "0x26A5C") ; <CJK>
       (?$(KI+(B . "0x26A4C") ; <CJK>
       (?$(KI,(B . "0x4476") ; <CJK>
       (?$(KI-(B . "0x26A4B") ; <CJK>
       (?$(KI.(B . "0x26C67") ; <CJK>
       (?$(KI/(B . "0x26DA8") ; <CJK>
       (?$(KI0(B . "0x26D7F") ; <CJK>
       (?$(KI1(B . "0x26D8D") ; <CJK>
       (?$(KI2(B . "0x26D8B") ; <CJK>
       (?$(KI3(B . "0x26DF7") ; <CJK>
       (?$(KI4(B . "0x26DA9") ; <CJK>
       (?$(KI5(B . "0x26DF4") ; <CJK>
       (?$(KI6(B . "0x26D9A") ; <CJK>
       (?$(KI7(B . "0x26D8C") ; <CJK>
       (?$(KI8(B . "0x26D95") ; <CJK>
       (?$(KI9(B . "0x26D7E") ; <CJK>
       (?$(KI:(B . "0x26D77") ; <CJK>
       (?$(KI;(B . "0x450A") ; <CJK>
       (?$(KI<(B . "0x4503") ; <CJK>
       (?$(KI=(B . "0x26D71") ; <CJK>
       (?$(KI>(B . "0x26DFD") ; <CJK>
       (?$(KI?(B . "0x26D88") ; <CJK>
       (?$(KI@(B . "0x26D99") ; <CJK>
       (?$(KIA(B . "0x26D6D") ; <CJK>
       (?$(KIB(B . "0x26DD4") ; <CJK>
       (?$(KIC(B . "0x26D91") ; <CJK>
       (?$(KID(B . "0x26D7D") ; <CJK>
       (?$(KIE(B . "0x26D63") ; <CJK>
       (?$(KIF(B . "0x26D75") ; <CJK>
       (?$(KIG(B . "0x26DF9") ; <CJK>
       (?$(KIH(B . "0x26D8E") ; <CJK>
       (?$(KII(B . "0x26D74") ; <CJK>
       (?$(KIJ(B . "0x26DD9") ; <CJK>
       (?$(KIK(B . "0x26D66") ; <CJK>
       (?$(KIL(B . "0x26DFA") ; <CJK>
       (?$(KIM(B . "0x26DF5") ; <CJK>
       (?$(KIN(B . "0x8660") ; <CJK>
       (?$(KIO(B . "0x271C1") ; <CJK>
       (?$(KIP(B . "0x271C9") ; <CJK>
       (?$(KIQ(B . "0x27303") ; <CJK>
       (?$(KIR(B . "0x2732C") ; <CJK>
       (?$(KIS(B . "0x27334") ; <CJK>
       (?$(KIT(B . "0x27317") ; <CJK>
       (?$(KIU(B . "0x27309") ; <CJK>
       (?$(KIV(B . "0x27304") ; <CJK>
       (?$(KIW(B . "0x27306") ; <CJK>
       (?$(KIX(B . "0x2731A") ; <CJK>
       (?$(KIY(B . "0x2730E") ; <CJK>
       (?$(KIZ(B . "0x27327") ; <CJK>
       (?$(KI[(B . "0x27305") ; <CJK>
       (?$(KI\(B . "0x27307") ; <CJK>
       (?$(KI](B . "0x27319") ; <CJK>
       (?$(KI^(B . "0x27314") ; <CJK>
       (?$(KI_(B . "0x2730C") ; <CJK>
       (?$(KI`(B . "0x2731D") ; <CJK>
       (?$(KIa(B . "0x27322") ; <CJK>
       (?$(KIb(B . "0x27323") ; <CJK>
       (?$(KIc(B . "0x275BB") ; <CJK>
       (?$(KId(B . "0x275BC") ; <CJK>
       (?$(KIe(B . "0x275BA") ; <CJK>
       (?$(KIf(B . "0x276A9") ; <CJK>
       (?$(KIg(B . "0x276B5") ; <CJK>
       (?$(KIh(B . "0x276AC") ; <CJK>
       (?$(KIi(B . "0x276AA") ; <CJK>
       (?$(KIj(B . "0x276AF") ; <CJK>
       (?$(KIk(B . "0x276B7") ; <CJK>
       (?$(KIl(B . "0x4635") ; <CJK>
       (?$(KIm(B . "0x4636") ; <CJK>
       (?$(KIn(B . "0x2783D") ; <CJK>
       (?$(KIo(B . "0x27845") ; <CJK>
       (?$(KIp(B . "0x27848") ; <CJK>
       (?$(KIq(B . "0x2783C") ; <CJK>
       (?$(KIr(B . "0x2783E") ; <CJK>
       (?$(KIs(B . "0x278EC") ; <CJK>
       (?$(KIt(B . "0x278ED") ; <CJK>
       (?$(KIu(B . "0x278E9") ; <CJK>
       (?$(KIv(B . "0x27A0A") ; <CJK>
       (?$(KIw(B . "0x27A0B") ; <CJK>
       (?$(KIx(B . "0x279F8") ; <CJK>
       (?$(KIy(B . "0x27A04") ; <CJK>
       (?$(KIz(B . "0x279F6") ; <CJK>
       (?$(KI{(B . "0x279F9") ; <CJK>
       (?$(KI|(B . "0x27C53") ; <CJK>
       (?$(KI}(B . "0x27C52") ; <CJK>
       (?$(KI~(B . "0x27C60") ; <CJK>
       (?$(KJ!(B . "0x27C63") ; <CJK>
       (?$(KJ"(B . "0x27CCE") ; <CJK>
       (?$(KJ#(B . "0x27CCD") ; <CJK>
       (?$(KJ$(B . "0x27CD0") ; <CJK>
       (?$(KJ%(B . "0x27CCC") ; <CJK>
       (?$(KJ&(B . "0x27D87") ; <CJK>
       (?$(KJ'(B . "0x27D8D") ; <CJK>
       (?$(KJ((B . "0x27D9D") ; <CJK>
       (?$(KJ)(B . "0x4773") ; <CJK>
       (?$(KJ*(B . "0x27E63") ; <CJK>
       (?$(KJ+(B . "0x27EF4") ; <CJK>
       (?$(KJ,(B . "0x27EF1") ; <CJK>
       (?$(KJ-(B . "0x27EFF") ; <CJK>
       (?$(KJ.(B . "0x27EF5") ; <CJK>
       (?$(KJ/(B . "0x27EFC") ; <CJK>
       (?$(KJ0(B . "0x27EF2") ; <CJK>
       (?$(KJ1(B . "0x27EF6") ; <CJK>
       (?$(KJ2(B . "0x47B1") ; <CJK>
       (?$(KJ3(B . "0x27EFA") ; <CJK>
       (?$(KJ4(B . "0x47AF") ; <CJK>
       (?$(KJ5(B . "0x2802E") ; <CJK>
       (?$(KJ6(B . "0x28045") ; <CJK>
       (?$(KJ7(B . "0x28043") ; <CJK>
       (?$(KJ8(B . "0x28051") ; <CJK>
       (?$(KJ9(B . "0x2804C") ; <CJK>
       (?$(KJ:(B . "0x28073") ; <CJK>
       (?$(KJ;(B . "0x28047") ; <CJK>
       (?$(KJ<(B . "0x2804B") ; <CJK>
       (?$(KJ=(B . "0x2804F") ; <CJK>
       (?$(KJ>(B . "0x47F4") ; <CJK>
       (?$(KJ?(B . "0x28044") ; <CJK>
       (?$(KJ@(B . "0x2804D") ; <CJK>
       (?$(KJA(B . "0x2804E") ; <CJK>
       (?$(KJB(B . "0x2804A") ; <CJK>
       (?$(KJC(B . "0x28041") ; <CJK>
       (?$(KJD(B . "0x28052") ; <CJK>
       (?$(KJE(B . "0x2809F") ; <CJK>
       (?$(KJF(B . "0x28054") ; <CJK>
       (?$(KJG(B . "0x28059") ; <CJK>
       (?$(KJH(B . "0x280A2") ; <CJK>
       (?$(KJI(B . "0x2824B") ; <CJK>
       (?$(KJJ(B . "0x28248") ; <CJK>
       (?$(KJK(B . "0x2830D") ; <CJK>
       (?$(KJL(B . "0x2831F") ; <CJK>
       (?$(KJM(B . "0x28308") ; <CJK>
       (?$(KJN(B . "0x2830E") ; <CJK>
       (?$(KJO(B . "0x2831D") ; <CJK>
       (?$(KJP(B . "0x28304") ; <CJK>
       (?$(KJQ(B . "0x28418") ; <CJK>
       (?$(KJR(B . "0x2841B") ; <CJK>
       (?$(KJS(B . "0x28566") ; <CJK>
       (?$(KJT(B . "0x28562") ; <CJK>
       (?$(KJU(B . "0x28583") ; <CJK>
       (?$(KJV(B . "0x28567") ; <CJK>
       (?$(KJW(B . "0x28762") ; <CJK>
       (?$(KJX(B . "0x2874F") ; <CJK>
       (?$(KJY(B . "0x2874E") ; <CJK>
       (?$(KJZ(B . "0x28767") ; <CJK>
       (?$(KJ[(B . "0x28753") ; <CJK>
       (?$(KJ\(B . "0x2874D") ; <CJK>
       (?$(KJ](B . "0x2874C") ; <CJK>
       (?$(KJ^(B . "0x28768") ; <CJK>
       (?$(KJ_(B . "0x28751") ; <CJK>
       (?$(KJ`(B . "0x48DC") ; <CJK>
       (?$(KJa(B . "0x28758") ; <CJK>
       (?$(KJb(B . "0x2875B") ; <CJK>
       (?$(KJc(B . "0x28750") ; <CJK>
       (?$(KJd(B . "0x2876A") ; <CJK>
       (?$(KJe(B . "0x28839") ; <CJK>
       (?$(KJf(B . "0x28838") ; <CJK>
       (?$(KJg(B . "0x28982") ; <CJK>
       (?$(KJh(B . "0x28984") ; <CJK>
       (?$(KJi(B . "0x28986") ; <CJK>
       (?$(KJj(B . "0x28C80") ; <CJK>
       (?$(KJk(B . "0x28C86") ; <CJK>
       (?$(KJl(B . "0x28D25") ; <CJK>
       (?$(KJm(B . "0x28D11") ; <CJK>
       (?$(KJn(B . "0x4999") ; <CJK>
       (?$(KJo(B . "0x28D0E") ; <CJK>
       (?$(KJp(B . "0x28D15") ; <CJK>
       (?$(KJq(B . "0x28D0F") ; <CJK>
       (?$(KJr(B . "0x28D18") ; <CJK>
       (?$(KJs(B . "0x28D0D") ; <CJK>
       (?$(KJt(B . "0x28D13") ; <CJK>
       (?$(KJu(B . "0x28D16") ; <CJK>
       (?$(KJv(B . "0x28D19") ; <CJK>
       (?$(KJw(B . "0x28F08") ; <CJK>
       (?$(KJx(B . "0x28EF7") ; <CJK>
       (?$(KJy(B . "0x28EFB") ; <CJK>
       (?$(KJz(B . "0x28EFC") ; <CJK>
       (?$(KJ{(B . "0x28FB4") ; <CJK>
       (?$(KJ|(B . "0x28FBE") ; <CJK>
       (?$(KJ}(B . "0x28FC1") ; <CJK>
       (?$(KJ~(B . "0x290A6") ; <CJK>
       (?$(KK!(B . "0x290A5") ; <CJK>
       (?$(KK"(B . "0x290A2") ; <CJK>
       (?$(KK#(B . "0x290A4") ; <CJK>
       (?$(KK$(B . "0x29212") ; <CJK>
       (?$(KK%(B . "0x2920E") ; <CJK>
       (?$(KK&(B . "0x2927A") ; <CJK>
       (?$(KK'(B . "0x29278") ; <CJK>
       (?$(KK((B . "0x2927D") ; <CJK>
       (?$(KK)(B . "0x2927E") ; <CJK>
       (?$(KK*(B . "0x29281") ; <CJK>
       (?$(KK+(B . "0x29283") ; <CJK>
       (?$(KK,(B . "0x29280") ; <CJK>
       (?$(KK-(B . "0x29282") ; <CJK>
       (?$(KK.(B . "0x2939B") ; <CJK>
       (?$(KK/(B . "0x29399") ; <CJK>
       (?$(KK0(B . "0x2939C") ; <CJK>
       (?$(KK1(B . "0x2939A") ; <CJK>
       (?$(KK2(B . "0x293A1") ; <CJK>
       (?$(KK3(B . "0x2941A") ; <CJK>
       (?$(KK4(B . "0x2941C") ; <CJK>
       (?$(KK5(B . "0x2948A") ; <CJK>
       (?$(KK6(B . "0x29479") ; <CJK>
       (?$(KK7(B . "0x29473") ; <CJK>
       (?$(KK8(B . "0x29475") ; <CJK>
       (?$(KK9(B . "0x2947C") ; <CJK>
       (?$(KK:(B . "0x29478") ; <CJK>
       (?$(KK;(B . "0x29460") ; <CJK>
       (?$(KK<(B . "0x29483") ; <CJK>
       (?$(KK=(B . "0x29470") ; <CJK>
       (?$(KK>(B . "0x4AB6") ; <CJK>
       (?$(KK?(B . "0x4ABD") ; <CJK>
       (?$(KK@(B . "0x29487") ; <CJK>
       (?$(KKA(B . "0x29484") ; <CJK>
       (?$(KKB(B . "0x2947B") ; <CJK>
       (?$(KKC(B . "0x2947E") ; <CJK>
       (?$(KKD(B . "0x29474") ; <CJK>
       (?$(KKE(B . "0x295B9") ; <CJK>
       (?$(KKF(B . "0x295B8") ; <CJK>
       (?$(KKG(B . "0x295B7") ; <CJK>
       (?$(KKH(B . "0x295B5") ; <CJK>
       (?$(KKI(B . "0x296CC") ; <CJK>
       (?$(KKJ(B . "0x296CE") ; <CJK>
       (?$(KKK(B . "0x296D1") ; <CJK>
       (?$(KKL(B . "0x9904") ; <CJK>
       (?$(KKM(B . "0x296CB") ; <CJK>
       (?$(KKN(B . "0x999B") ; <CJK>
       (?$(KKO(B . "0x2987E") ; <CJK>
       (?$(KKP(B . "0x2987A") ; <CJK>
       (?$(KKQ(B . "0x29877") ; <CJK>
       (?$(KKR(B . "0x2988C") ; <CJK>
       (?$(KKS(B . "0x298E1") ; <CJK>
       (?$(KKT(B . "0x29A20") ; <CJK>
       (?$(KKU(B . "0x29A1E") ; <CJK>
       (?$(KKV(B . "0x29AC2") ; <CJK>
       (?$(KKW(B . "0x29B0F") ; <CJK>
       (?$(KKX(B . "0x29B00") ; <CJK>
       (?$(KKY(B . "0x4BF4") ; <CJK>
       (?$(KKZ(B . "0x29B10") ; <CJK>
       (?$(KK[(B . "0x29C0D") ; <CJK>
       (?$(KK\(B . "0x29C0E") ; <CJK>
       (?$(KK](B . "0x29C8E") ; <CJK>
       (?$(KK^(B . "0x29C8D") ; <CJK>
       (?$(KK_(B . "0x29C8A") ; <CJK>
       (?$(KK`(B . "0x29C8B") ; <CJK>
       (?$(KKa(B . "0x29C8C") ; <CJK>
       (?$(KKb(B . "0x29C8F") ; <CJK>
       (?$(KKc(B . "0x29D57") ; <CJK>
       (?$(KKd(B . "0x4C35") ; <CJK>
       (?$(KKe(B . "0x29D55") ; <CJK>
       (?$(KKf(B . "0x29D5B") ; <CJK>
       (?$(KKg(B . "0x29FAC") ; <CJK>
       (?$(KKh(B . "0x29FA7") ; <CJK>
       (?$(KKi(B . "0x29FA0") ; <CJK>
       (?$(KKj(B . "0x29F9E") ; <CJK>
       (?$(KKk(B . "0x4CAA") ; <CJK>
       (?$(KKl(B . "0x2A28D") ; <CJK>
       (?$(KKm(B . "0x4D1F") ; <CJK>
       (?$(KKn(B . "0x2A393") ; <CJK>
       (?$(KKo(B . "0x2A394") ; <CJK>
       (?$(KKp(B . "0x2A392") ; <CJK>
       (?$(KKq(B . "0x20181") ; <CJK>
       (?$(KKr(B . "0x203D6") ; <CJK>
       (?$(KKs(B . "0x203C3") ; <CJK>
       (?$(KKt(B . "0x203E4") ; <CJK>
       (?$(KKu(B . "0x203E2") ; <CJK>
       (?$(KKv(B . "0x20409") ; <CJK>
       (?$(KKw(B . "0x203BF") ; <CJK>
       (?$(KKx(B . "0x203C8") ; <CJK>
       (?$(KKy(B . "0x203C7") ; <CJK>
       (?$(KKz(B . "0x204B5") ; <CJK>
       (?$(KK{(B . "0x204B2") ; <CJK>
       (?$(KK|(B . "0x2060C") ; <CJK>
       (?$(KK}(B . "0x2060B") ; <CJK>
       (?$(KK~(B . "0x2060A") ; <CJK>
       (?$(KL!(B . "0x20605") ; <CJK>
       (?$(KL"(B . "0x207D3") ; <CJK>
       (?$(KL#(B . "0x207E6") ; <CJK>
       (?$(KL$(B . "0x207E9") ; <CJK>
       (?$(KL%(B . "0x207F0") ; <CJK>
       (?$(KL&(B . "0x207EA") ; <CJK>
       (?$(KL'(B . "0x207E7") ; <CJK>
       (?$(KL((B . "0x208B1") ; <CJK>
       (?$(KL)(B . "0x208B3") ; <CJK>
       (?$(KL*(B . "0x208B4") ; <CJK>
       (?$(KL+(B . "0x208B0") ; <CJK>
       (?$(KL,(B . "0x2095C") ; <CJK>
       (?$(KL-(B . "0x2095D") ; <CJK>
       (?$(KL.(B . "0x2095E") ; <CJK>
       (?$(KL/(B . "0x209C0") ; <CJK>
       (?$(KL0(B . "0x20AAF") ; <CJK>
       (?$(KL1(B . "0x3550") ; <CJK>
       (?$(KL2(B . "0x20B86") ; <CJK>
       (?$(KL3(B . "0x20B83") ; <CJK>
       (?$(KL4(B . "0x20B84") ; <CJK>
       (?$(KL5(B . "0x20F5C") ; <CJK>
       (?$(KL6(B . "0x20F70") ; <CJK>
       (?$(KL7(B . "0x20F8C") ; <CJK>
       (?$(KL8(B . "0x20F7B") ; <CJK>
       (?$(KL9(B . "0x20F66") ; <CJK>
       (?$(KL:(B . "0x20F79") ; <CJK>
       (?$(KL;(B . "0x20F63") ; <CJK>
       (?$(KL<(B . "0x20FC5") ; <CJK>
       (?$(KL=(B . "0x20F6B") ; <CJK>
       (?$(KL>(B . "0x20F6D") ; <CJK>
       (?$(KL?(B . "0x20F72") ; <CJK>
       (?$(KL@(B . "0x20F69") ; <CJK>
       (?$(KLA(B . "0x20F75") ; <CJK>
       (?$(KLB(B . "0x20F89") ; <CJK>
       (?$(KLC(B . "0x20FC6") ; <CJK>
       (?$(KLD(B . "0x20FA5") ; <CJK>
       (?$(KLE(B . "0x203E7") ; <CJK>
       (?$(KLF(B . "0x20F6A") ; <CJK>
       (?$(KLG(B . "0x20F97") ; <CJK>
       (?$(KLH(B . "0x2145A") ; <CJK>
       (?$(KLI(B . "0x2145C") ; <CJK>
       (?$(KLJ(B . "0x21459") ; <CJK>
       (?$(KLK(B . "0x21424") ; <CJK>
       (?$(KLL(B . "0x21425") ; <CJK>
       (?$(KLM(B . "0x21430") ; <CJK>
       (?$(KLN(B . "0x21458") ; <CJK>
       (?$(KLO(B . "0x21431") ; <CJK>
       (?$(KLP(B . "0x21576") ; <CJK>
       (?$(KLQ(B . "0x215C1") ; <CJK>
       (?$(KLR(B . "0x21685") ; <CJK>
       (?$(KLS(B . "0x2167D") ; <CJK>
       (?$(KLT(B . "0x21865") ; <CJK>
       (?$(KLU(B . "0x21887") ; <CJK>
       (?$(KLV(B . "0x21852") ; <CJK>
       (?$(KLW(B . "0x21854") ; <CJK>
       (?$(KLX(B . "0x2188A") ; <CJK>
       (?$(KLY(B . "0x21850") ; <CJK>
       (?$(KLZ(B . "0x21886") ; <CJK>
       (?$(KL[(B . "0x2184F") ; <CJK>
       (?$(KL\(B . "0x21868") ; <CJK>
       (?$(KL](B . "0x2199D") ; <CJK>
       (?$(KL^(B . "0x21AA0") ; <CJK>
       (?$(KL_(B . "0x21ABA") ; <CJK>
       (?$(KL`(B . "0x21ABD") ; <CJK>
       (?$(KLa(B . "0x21AB8") ; <CJK>
       (?$(KLb(B . "0x21BA6") ; <CJK>
       (?$(KLc(B . "0x377B") ; <CJK>
       (?$(KLd(B . "0x21CDE") ; <CJK>
       (?$(KLe(B . "0x21CD8") ; <CJK>
       (?$(KLf(B . "0x21CD1") ; <CJK>
       (?$(KLg(B . "0x21F13") ; <CJK>
       (?$(KLh(B . "0x3809") ; <CJK>
       (?$(KLi(B . "0x21F0E") ; <CJK>
       (?$(KLj(B . "0x21F1B") ; <CJK>
       (?$(KLk(B . "0x21F3A") ; <CJK>
       (?$(KLl(B . "0x3807") ; <CJK>
       (?$(KLm(B . "0x21F1C") ; <CJK>
       (?$(KLn(B . "0x21F12") ; <CJK>
       (?$(KLo(B . "0x21F16") ; <CJK>
       (?$(KLp(B . "0x21F1A") ; <CJK>
       (?$(KLq(B . "0x21448") ; <CJK>
       (?$(KLr(B . "0x2214B") ; <CJK>
       (?$(KLs(B . "0x22137") ; <CJK>
       (?$(KLt(B . "0x22136") ; <CJK>
       (?$(KLu(B . "0x22138") ; <CJK>
       (?$(KLv(B . "0x2213A") ; <CJK>
       (?$(KLw(B . "0x22149") ; <CJK>
       (?$(KLx(B . "0x2213C") ; <CJK>
       (?$(KLy(B . "0x2214A") ; <CJK>
       (?$(KLz(B . "0x222B1") ; <CJK>
       (?$(KL{(B . "0x222C2") ; <CJK>
       (?$(KL|(B . "0x222B5") ; <CJK>
       (?$(KL}(B . "0x222C4") ; <CJK>
       (?$(KL~(B . "0x222B6") ; <CJK>
       (?$(KM!(B . "0x2241E") ; <CJK>
       (?$(KM"(B . "0x2241F") ; <CJK>
       (?$(KM#(B . "0x224AF") ; <CJK>
       (?$(KM$(B . "0x2256B") ; <CJK>
       (?$(KM%(B . "0x2256F") ; <CJK>
       (?$(KM&(B . "0x22792") ; <CJK>
       (?$(KM'(B . "0x227E4") ; <CJK>
       (?$(KM((B . "0x2282C") ; <CJK>
       (?$(KM)(B . "0x227EF") ; <CJK>
       (?$(KM*(B . "0x6184") ; <CJK>
       (?$(KM+(B . "0x2284F") ; <CJK>
       (?$(KM,(B . "0x22852") ; <CJK>
       (?$(KM-(B . "0x22850") ; <CJK>
       (?$(KM.(B . "0x2283A") ; <CJK>
       (?$(KM/(B . "0x22837") ; <CJK>
       (?$(KM0(B . "0x22847") ; <CJK>
       (?$(KM1(B . "0x22864") ; <CJK>
       (?$(KM2(B . "0x22840") ; <CJK>
       (?$(KM3(B . "0x2283C") ; <CJK>
       (?$(KM4(B . "0x22845") ; <CJK>
       (?$(KM5(B . "0x22841") ; <CJK>
       (?$(KM6(B . "0x229F3") ; <CJK>
       (?$(KM7(B . "0x39BB") ; <CJK>
       (?$(KM8(B . "0x22CC1") ; <CJK>
       (?$(KM9(B . "0x22CB4") ; <CJK>
       (?$(KM:(B . "0x3A4B") ; <CJK>
       (?$(KM;(B . "0x22D2A") ; <CJK>
       (?$(KM<(B . "0x22D22") ; <CJK>
       (?$(KM=(B . "0x22D29") ; <CJK>
       (?$(KM>(B . "0x3A4D") ; <CJK>
       (?$(KM?(B . "0x22D3E") ; <CJK>
       (?$(KM@(B . "0x22D3C") ; <CJK>
       (?$(KMA(B . "0x22D30") ; <CJK>
       (?$(KMB(B . "0x22FC7") ; <CJK>
       (?$(KMC(B . "0x22FD5") ; <CJK>
       (?$(KMD(B . "0x22FD6") ; <CJK>
       (?$(KME(B . "0x22FD3") ; <CJK>
       (?$(KMF(B . "0x22FCE") ; <CJK>
       (?$(KMG(B . "0x22FC8") ; <CJK>
       (?$(KMH(B . "0x2305C") ; <CJK>
       (?$(KMI(B . "0x2305F") ; <CJK>
       (?$(KMJ(B . "0x23062") ; <CJK>
       (?$(KMK(B . "0x3AC2") ; <CJK>
       (?$(KML(B . "0x230BD") ; <CJK>
       (?$(KMM(B . "0x230BF") ; <CJK>
       (?$(KMN(B . "0x2325C") ; <CJK>
       (?$(KMO(B . "0x232B6") ; <CJK>
       (?$(KMP(B . "0x3B1A") ; <CJK>
       (?$(KMQ(B . "0x2329D") ; <CJK>
       (?$(KMR(B . "0x2327F") ; <CJK>
       (?$(KMS(B . "0x3B12") ; <CJK>
       (?$(KMT(B . "0x23294") ; <CJK>
       (?$(KMU(B . "0x23281") ; <CJK>
       (?$(KMV(B . "0x23347") ; <CJK>
       (?$(KMW(B . "0x23346") ; <CJK>
       (?$(KMX(B . "0x3B3C") ; <CJK>
       (?$(KMY(B . "0x23394") ; <CJK>
       (?$(KMZ(B . "0x23675") ; <CJK>
       (?$(KM[(B . "0x2361A") ; <CJK>
       (?$(KM\(B . "0x2362A") ; <CJK>
       (?$(KM](B . "0x23632") ; <CJK>
       (?$(KM^(B . "0x23617") ; <CJK>
       (?$(KM_(B . "0x23623") ; <CJK>
       (?$(KM`(B . "0x23674") ; <CJK>
       (?$(KMa(B . "0x3BC3") ; <CJK>
       (?$(KMb(B . "0x23676") ; <CJK>
       (?$(KMc(B . "0x2362E") ; <CJK>
       (?$(KMd(B . "0x23625") ; <CJK>
       (?$(KMe(B . "0x23620") ; <CJK>
       (?$(KMf(B . "0x23671") ; <CJK>
       (?$(KMg(B . "0x23616") ; <CJK>
       (?$(KMh(B . "0x23670") ; <CJK>
       (?$(KMi(B . "0x2362C") ; <CJK>
       (?$(KMj(B . "0x2362F") ; <CJK>
       (?$(KMk(B . "0x2361F") ; <CJK>
       (?$(KMl(B . "0x23664") ; <CJK>
       (?$(KMm(B . "0x3BC0") ; <CJK>
       (?$(KMn(B . "0x23908") ; <CJK>
       (?$(KMo(B . "0x23914") ; <CJK>
       (?$(KMp(B . "0x2390A") ; <CJK>
       (?$(KMq(B . "0x2390B") ; <CJK>
       (?$(KMr(B . "0x23A4F") ; <CJK>
       (?$(KMs(B . "0x23A59") ; <CJK>
       (?$(KMt(B . "0x23A54") ; <CJK>
       (?$(KMu(B . "0x23A51") ; <CJK>
       (?$(KMv(B . "0x23AB6") ; <CJK>
       (?$(KMw(B . "0x23BEC") ; <CJK>
       (?$(KMx(B . "0x23BED") ; <CJK>
       (?$(KMy(B . "0x23BEA") ; <CJK>
       (?$(KMz(B . "0x23EEE") ; <CJK>
       (?$(KM{(B . "0x23F5A") ; <CJK>
       (?$(KM|(B . "0x23F73") ; <CJK>
       (?$(KM}(B . "0x23F65") ; <CJK>
       (?$(KM~(B . "0x23F61") ; <CJK>
       (?$(KN!(B . "0x23F55") ; <CJK>
       (?$(KN"(B . "0x23F6B") ; <CJK>
       (?$(KN#(B . "0x23F64") ; <CJK>
       (?$(KN$(B . "0x23F5B") ; <CJK>
       (?$(KN%(B . "0x23F4C") ; <CJK>
       (?$(KN&(B . "0x23F6F") ; <CJK>
       (?$(KN'(B . "0x23F84") ; <CJK>
       (?$(KN((B . "0x23F70") ; <CJK>
       (?$(KN)(B . "0x2435D") ; <CJK>
       (?$(KN*(B . "0x24357") ; <CJK>
       (?$(KN+(B . "0x24366") ; <CJK>
       (?$(KN,(B . "0x24353") ; <CJK>
       (?$(KN-(B . "0x24398") ; <CJK>
       (?$(KN.(B . "0x24397") ; <CJK>
       (?$(KN/(B . "0x24528") ; <CJK>
       (?$(KN0(B . "0x245EB") ; <CJK>
       (?$(KN1(B . "0x245EA") ; <CJK>
       (?$(KN2(B . "0x245E8") ; <CJK>
       (?$(KN3(B . "0x245EC") ; <CJK>
       (?$(KN4(B . "0x245EF") ; <CJK>
       (?$(KN5(B . "0x246D1") ; <CJK>
       (?$(KN6(B . "0x246CA") ; <CJK>
       (?$(KN7(B . "0x729F") ; <CJK>
       (?$(KN8(B . "0x246CF") ; <CJK>
       (?$(KN9(B . "0x246CD") ; <CJK>
       (?$(KN:(B . "0x246CE") ; <CJK>
       (?$(KN;(B . "0x24870") ; <CJK>
       (?$(KN<(B . "0x24867") ; <CJK>
       (?$(KN=(B . "0x24873") ; <CJK>
       (?$(KN>(B . "0x2486D") ; <CJK>
       (?$(KN?(B . "0x24876") ; <CJK>
       (?$(KN@(B . "0x24879") ; <CJK>
       (?$(KNA(B . "0x2486A") ; <CJK>
       (?$(KNB(B . "0x2488B") ; <CJK>
       (?$(KNC(B . "0x24872") ; <CJK>
       (?$(KND(B . "0x24871") ; <CJK>
       (?$(KNE(B . "0x2486E") ; <CJK>
       (?$(KNF(B . "0x2487A") ; <CJK>
       (?$(KNG(B . "0x24A16") ; <CJK>
       (?$(KNH(B . "0x24A39") ; <CJK>
       (?$(KNI(B . "0x24A3B") ; <CJK>
       (?$(KNJ(B . "0x24B10") ; <CJK>
       (?$(KNK(B . "0x24B96") ; <CJK>
       (?$(KNL(B . "0x24B7B") ; <CJK>
       (?$(KNM(B . "0x24B7C") ; <CJK>
       (?$(KNN(B . "0x24B7D") ; <CJK>
       (?$(KNO(B . "0x24CBE") ; <CJK>
       (?$(KNP(B . "0x24E5C") ; <CJK>
       (?$(KNQ(B . "0x24E38") ; <CJK>
       (?$(KNR(B . "0x24E39") ; <CJK>
       (?$(KNS(B . "0x24E2E") ; <CJK>
       (?$(KNT(B . "0x24E34") ; <CJK>
       (?$(KNU(B . "0x24E32") ; <CJK>
       (?$(KNV(B . "0x24E5B") ; <CJK>
       (?$(KNW(B . "0x24E33") ; <CJK>
       (?$(KNX(B . "0x24E3C") ; <CJK>
       (?$(KNY(B . "0x3FE5") ; <CJK>
       (?$(KNZ(B . "0x2500E") ; <CJK>
       (?$(KN[(B . "0x2500F") ; <CJK>
       (?$(KN\(B . "0x25010") ; <CJK>
       (?$(KN](B . "0x25087") ; <CJK>
       (?$(KN^(B . "0x2525B") ; <CJK>
       (?$(KN_(B . "0x25253") ; <CJK>
       (?$(KN`(B . "0x405F") ; <CJK>
       (?$(KNa(B . "0x2525C") ; <CJK>
       (?$(KNb(B . "0x2523F") ; <CJK>
       (?$(KNc(B . "0x25259") ; <CJK>
       (?$(KNd(B . "0x2524A") ; <CJK>
       (?$(KNe(B . "0x25244") ; <CJK>
       (?$(KNf(B . "0x2524C") ; <CJK>
       (?$(KNg(B . "0x25240") ; <CJK>
       (?$(KNh(B . "0x2525F") ; <CJK>
       (?$(KNi(B . "0x2525E") ; <CJK>
       (?$(KNj(B . "0x2524E") ; <CJK>
       (?$(KNk(B . "0x25254") ; <CJK>
       (?$(KNl(B . "0x25243") ; <CJK>
       (?$(KNm(B . "0x25287") ; <CJK>
       (?$(KNn(B . "0x25382") ; <CJK>
       (?$(KNo(B . "0x25385") ; <CJK>
       (?$(KNp(B . "0x25531") ; <CJK>
       (?$(KNq(B . "0x25547") ; <CJK>
       (?$(KNr(B . "0x2552E") ; <CJK>
       (?$(KNs(B . "0x2552F") ; <CJK>
       (?$(KNt(B . "0x25548") ; <CJK>
       (?$(KNu(B . "0x25534") ; <CJK>
       (?$(KNv(B . "0x4118") ; <CJK>
       (?$(KNw(B . "0x2059F") ; <CJK>
       (?$(KNx(B . "0x25832") ; <CJK>
       (?$(KNy(B . "0x25836") ; <CJK>
       (?$(KNz(B . "0x25833") ; <CJK>
       (?$(KN{(B . "0x25831") ; <CJK>
       (?$(KN|(B . "0x25840") ; <CJK>
       (?$(KN}(B . "0x25841") ; <CJK>
       (?$(KN~(B . "0x259DD") ; <CJK>
       (?$(KO!(B . "0x259D2") ; <CJK>
       (?$(KO"(B . "0x259D9") ; <CJK>
       (?$(KO#(B . "0x41AD") ; <CJK>
       (?$(KO$(B . "0x259DF") ; <CJK>
       (?$(KO%(B . "0x259DB") ; <CJK>
       (?$(KO&(B . "0x259D8") ; <CJK>
       (?$(KO'(B . "0x259D3") ; <CJK>
       (?$(KO((B . "0x259DE") ; <CJK>
       (?$(KO)(B . "0x259E0") ; <CJK>
       (?$(KO*(B . "0x259D4") ; <CJK>
       (?$(KO+(B . "0x259D7") ; <CJK>
       (?$(KO,(B . "0x259DA") ; <CJK>
       (?$(KO-(B . "0x25AA7") ; <CJK>
       (?$(KO.(B . "0x25BFE") ; <CJK>
       (?$(KO/(B . "0x25BDD") ; <CJK>
       (?$(KO0(B . "0x25C40") ; <CJK>
       (?$(KO1(B . "0x25BE2") ; <CJK>
       (?$(KO2(B . "0x421E") ; <CJK>
       (?$(KO3(B . "0x25BD6") ; <CJK>
       (?$(KO4(B . "0x25BDE") ; <CJK>
       (?$(KO5(B . "0x25BEF") ; <CJK>
       (?$(KO6(B . "0x4227") ; <CJK>
       (?$(KO7(B . "0x25BEB") ; <CJK>
       (?$(KO8(B . "0x25BEA") ; <CJK>
       (?$(KO9(B . "0x25BE4") ; <CJK>
       (?$(KO:(B . "0x25BD1") ; <CJK>
       (?$(KO;(B . "0x4218") ; <CJK>
       (?$(KO<(B . "0x25BEC") ; <CJK>
       (?$(KO=(B . "0x25BFA") ; <CJK>
       (?$(KO>(B . "0x25BD9") ; <CJK>
       (?$(KO?(B . "0x25BF3") ; <CJK>
       (?$(KO@(B . "0x25BE1") ; <CJK>
       (?$(KOA(B . "0x25BDC") ; <CJK>
       (?$(KOB(B . "0x25BE5") ; <CJK>
       (?$(KOC(B . "0x25BDF") ; <CJK>
       (?$(KOD(B . "0x25BD4") ; <CJK>
       (?$(KOE(B . "0x4220") ; <CJK>
       (?$(KOF(B . "0x25C05") ; <CJK>
       (?$(KOG(B . "0x25ED6") ; <CJK>
       (?$(KOH(B . "0x25ED5") ; <CJK>
       (?$(KOI(B . "0x25ED0") ; <CJK>
       (?$(KOJ(B . "0x25EC8") ; <CJK>
       (?$(KOK(B . "0x25EC4") ; <CJK>
       (?$(KOL(B . "0x25EC9") ; <CJK>
       (?$(KOM(B . "0x25ECD") ; <CJK>
       (?$(KON(B . "0x25ED2") ; <CJK>
       (?$(KOO(B . "0x25ECC") ; <CJK>
       (?$(KOP(B . "0x25ECA") ; <CJK>
       (?$(KOQ(B . "0x260A0") ; <CJK>
       (?$(KOR(B . "0x26092") ; <CJK>
       (?$(KOS(B . "0x42F4") ; <CJK>
       (?$(KOT(B . "0x4302") ; <CJK>
       (?$(KOU(B . "0x2608B") ; <CJK>
       (?$(KOV(B . "0x260A1") ; <CJK>
       (?$(KOW(B . "0x26095") ; <CJK>
       (?$(KOX(B . "0x26088") ; <CJK>
       (?$(KOY(B . "0x26086") ; <CJK>
       (?$(KOZ(B . "0x2608D") ; <CJK>
       (?$(KO[(B . "0x26085") ; <CJK>
       (?$(KO\(B . "0x26091") ; <CJK>
       (?$(KO](B . "0x26089") ; <CJK>
       (?$(KO^(B . "0x260A2") ; <CJK>
       (?$(KO_(B . "0x262F0") ; <CJK>
       (?$(KO`(B . "0x262F3") ; <CJK>
       (?$(KOa(B . "0x262F4") ; <CJK>
       (?$(KOb(B . "0x262EF") ; <CJK>
       (?$(KOc(B . "0x26306") ; <CJK>
       (?$(KOd(B . "0x263A2") ; <CJK>
       (?$(KOe(B . "0x2645E") ; <CJK>
       (?$(KOf(B . "0x26463") ; <CJK>
       (?$(KOg(B . "0x26460") ; <CJK>
       (?$(KOh(B . "0x2645B") ; <CJK>
       (?$(KOi(B . "0x2647B") ; <CJK>
       (?$(KOj(B . "0x26458") ; <CJK>
       (?$(KOk(B . "0x26459") ; <CJK>
       (?$(KOl(B . "0x2645D") ; <CJK>
       (?$(KOm(B . "0x26505") ; <CJK>
       (?$(KOn(B . "0x26506") ; <CJK>
       (?$(KOo(B . "0x26502") ; <CJK>
       (?$(KOp(B . "0x26503") ; <CJK>
       (?$(KOq(B . "0x26504") ; <CJK>
       (?$(KOr(B . "0x265A2") ; <CJK>
       (?$(KOs(B . "0x265A7") ; <CJK>
       (?$(KOt(B . "0x265A6") ; <CJK>
       (?$(KOu(B . "0x265A4") ; <CJK>
       (?$(KOv(B . "0x265AC") ; <CJK>
       (?$(KOw(B . "0x265A9") ; <CJK>
       (?$(KOx(B . "0x267E7") ; <CJK>
       (?$(KOy(B . "0x26801") ; <CJK>
       (?$(KOz(B . "0x267DF") ; <CJK>
       (?$(KO{(B . "0x267D9") ; <CJK>
       (?$(KO|(B . "0x267E3") ; <CJK>
       (?$(KO}(B . "0x2680F") ; <CJK>
       (?$(KO~(B . "0x2691A") ; <CJK>
       (?$(KP!(B . "0x26945") ; <CJK>
       (?$(KP"(B . "0x26948") ; <CJK>
       (?$(KP#(B . "0x2697B") ; <CJK>
       (?$(KP$(B . "0x26985") ; <CJK>
       (?$(KP%(B . "0x26986") ; <CJK>
       (?$(KP&(B . "0x269FE") ; <CJK>
       (?$(KP'(B . "0x269FF") ; <CJK>
       (?$(KP((B . "0x26A64") ; <CJK>
       (?$(KP)(B . "0x26A71") ; <CJK>
       (?$(KP*(B . "0x26A72") ; <CJK>
       (?$(KP+(B . "0x26A61") ; <CJK>
       (?$(KP,(B . "0x26A62") ; <CJK>
       (?$(KP-(B . "0x26A6C") ; <CJK>
       (?$(KP.(B . "0x26A60") ; <CJK>
       (?$(KP/(B . "0x26A5D") ; <CJK>
       (?$(KP0(B . "0x26A63") ; <CJK>
       (?$(KP1(B . "0x26A67") ; <CJK>
       (?$(KP2(B . "0x26E01") ; <CJK>
       (?$(KP3(B . "0x26E2A") ; <CJK>
       (?$(KP4(B . "0x26E30") ; <CJK>
       (?$(KP5(B . "0x26E06") ; <CJK>
       (?$(KP6(B . "0x26E7D") ; <CJK>
       (?$(KP7(B . "0x26E22") ; <CJK>
       (?$(KP8(B . "0x26EB9") ; <CJK>
       (?$(KP9(B . "0x26E0A") ; <CJK>
       (?$(KP:(B . "0x26E10") ; <CJK>
       (?$(KP;(B . "0x26D8F") ; <CJK>
       (?$(KP<(B . "0x26E80") ; <CJK>
       (?$(KP=(B . "0x26E13") ; <CJK>
       (?$(KP>(B . "0x26E2E") ; <CJK>
       (?$(KP?(B . "0x26E18") ; <CJK>
       (?$(KP@(B . "0x26E17") ; <CJK>
       (?$(KPA(B . "0x26E1A") ; <CJK>
       (?$(KPB(B . "0x26E14") ; <CJK>
       (?$(KPC(B . "0x26E47") ; <CJK>
       (?$(KPD(B . "0x26E63") ; <CJK>
       (?$(KPE(B . "0x26E38") ; <CJK>
       (?$(KPF(B . "0x4524") ; <CJK>
       (?$(KPG(B . "0x26E7F") ; <CJK>
       (?$(KPH(B . "0x26E21") ; <CJK>
       (?$(KPI(B . "0x26E37") ; <CJK>
       (?$(KPJ(B . "0x26E31") ; <CJK>
       (?$(KPK(B . "0x26E1B") ; <CJK>
       (?$(KPL(B . "0x26EA5") ; <CJK>
       (?$(KPM(B . "0x26F6C") ; <CJK>
       (?$(KPN(B . "0x271D3") ; <CJK>
       (?$(KPO(B . "0x27388") ; <CJK>
       (?$(KPP(B . "0x2736E") ; <CJK>
       (?$(KPQ(B . "0x2735C") ; <CJK>
       (?$(KPR(B . "0x27374") ; <CJK>
       (?$(KPS(B . "0x27354") ; <CJK>
       (?$(KPT(B . "0x27383") ; <CJK>
       (?$(KPU(B . "0x8770") ; <CJK>
       (?$(KPV(B . "0x27365") ; <CJK>
       (?$(KPW(B . "0x27360") ; <CJK>
       (?$(KPX(B . "0x27370") ; <CJK>
       (?$(KPY(B . "0x2736F") ; <CJK>
       (?$(KPZ(B . "0x2736D") ; <CJK>
       (?$(KP[(B . "0x27372") ; <CJK>
       (?$(KP\(B . "0x2736C") ; <CJK>
       (?$(KP](B . "0x27376") ; <CJK>
       (?$(KP^(B . "0x27375") ; <CJK>
       (?$(KP_(B . "0x27359") ; <CJK>
       (?$(KP`(B . "0x273C7") ; <CJK>
       (?$(KPa(B . "0x275C1") ; <CJK>
       (?$(KPb(B . "0x275F9") ; <CJK>
       (?$(KPc(B . "0x276E3") ; <CJK>
       (?$(KPd(B . "0x276E7") ; <CJK>
       (?$(KPe(B . "0x276D6") ; <CJK>
       (?$(KPf(B . "0x276CF") ; <CJK>
       (?$(KPg(B . "0x276DA") ; <CJK>
       (?$(KPh(B . "0x276E9") ; <CJK>
       (?$(KPi(B . "0x276D2") ; <CJK>
       (?$(KPj(B . "0x27855") ; <CJK>
       (?$(KPk(B . "0x2784F") ; <CJK>
       (?$(KPl(B . "0x2784D") ; <CJK>
       (?$(KPm(B . "0x27851") ; <CJK>
       (?$(KPn(B . "0x27856") ; <CJK>
       (?$(KPo(B . "0x278F9") ; <CJK>
       (?$(KPp(B . "0x278F8") ; <CJK>
       (?$(KPq(B . "0x27906") ; <CJK>
       (?$(KPr(B . "0x27903") ; <CJK>
       (?$(KPs(B . "0x27909") ; <CJK>
       (?$(KPt(B . "0x278F7") ; <CJK>
       (?$(KPu(B . "0x278F5") ; <CJK>
       (?$(KPv(B . "0x27A47") ; <CJK>
       (?$(KPw(B . "0x27A45") ; <CJK>
       (?$(KPx(B . "0x27A3E") ; <CJK>
       (?$(KPy(B . "0x27A46") ; <CJK>
       (?$(KPz(B . "0x27A29") ; <CJK>
       (?$(KP{(B . "0x27A34") ; <CJK>
       (?$(KP|(B . "0x27A3F") ; <CJK>
       (?$(KP}(B . "0x27A44") ; <CJK>
       (?$(KP~(B . "0x27A35") ; <CJK>
       (?$(KQ!(B . "0x27A5A") ; <CJK>
       (?$(KQ"(B . "0x27A2A") ; <CJK>
       (?$(KQ#(B . "0x27A33") ; <CJK>
       (?$(KQ$(B . "0x27A37") ; <CJK>
       (?$(KQ%(B . "0x27A43") ; <CJK>
       (?$(KQ&(B . "0x27A39") ; <CJK>
       (?$(KQ'(B . "0x27A30") ; <CJK>
       (?$(KQ((B . "0x27A5D") ; <CJK>
       (?$(KQ)(B . "0x27A32") ; <CJK>
       (?$(KQ*(B . "0x27A27") ; <CJK>
       (?$(KQ+(B . "0x27BBD") ; <CJK>
       (?$(KQ,(B . "0x27BBA") ; <CJK>
       (?$(KQ-(B . "0x27BBC") ; <CJK>
       (?$(KQ.(B . "0x27BF1") ; <CJK>
       (?$(KQ/(B . "0x27BF0") ; <CJK>
       (?$(KQ0(B . "0x27C61") ; <CJK>
       (?$(KQ1(B . "0x27C5C") ; <CJK>
       (?$(KQ2(B . "0x27C58") ; <CJK>
       (?$(KQ3(B . "0x27C5D") ; <CJK>
       (?$(KQ4(B . "0x27CDA") ; <CJK>
       (?$(KQ5(B . "0x27CD9") ; <CJK>
       (?$(KQ6(B . "0x27CDD") ; <CJK>
       (?$(KQ7(B . "0x27CDC") ; <CJK>
       (?$(KQ8(B . "0x27CDE") ; <CJK>
       (?$(KQ9(B . "0x477D") ; <CJK>
       (?$(KQ:(B . "0x27DA0") ; <CJK>
       (?$(KQ;(B . "0x27DA2") ; <CJK>
       (?$(KQ<(B . "0x27F0F") ; <CJK>
       (?$(KQ=(B . "0x27F13") ; <CJK>
       (?$(KQ>(B . "0x27F12") ; <CJK>
       (?$(KQ?(B . "0x27F11") ; <CJK>
       (?$(KQ@(B . "0x27F14") ; <CJK>
       (?$(KQA(B . "0x27F19") ; <CJK>
       (?$(KQB(B . "0x27F0E") ; <CJK>
       (?$(KQC(B . "0x27F17") ; <CJK>
       (?$(KQD(B . "0x27F21") ; <CJK>
       (?$(KQE(B . "0x27F20") ; <CJK>
       (?$(KQF(B . "0x27F16") ; <CJK>
       (?$(KQG(B . "0x28078") ; <CJK>
       (?$(KQH(B . "0x8E37") ; <CJK>
       (?$(KQI(B . "0x28087") ; <CJK>
       (?$(KQJ(B . "0x28079") ; <CJK>
       (?$(KQK(B . "0x28080") ; <CJK>
       (?$(KQL(B . "0x28077") ; <CJK>
       (?$(KQM(B . "0x28081") ; <CJK>
       (?$(KQN(B . "0x28046") ; <CJK>
       (?$(KQO(B . "0x2807A") ; <CJK>
       (?$(KQP(B . "0x2809C") ; <CJK>
       (?$(KQQ(B . "0x28083") ; <CJK>
       (?$(KQR(B . "0x28084") ; <CJK>
       (?$(KQS(B . "0x280AD") ; <CJK>
       (?$(KQT(B . "0x2809D") ; <CJK>
       (?$(KQU(B . "0x2809E") ; <CJK>
       (?$(KQV(B . "0x28255") ; <CJK>
       (?$(KQW(B . "0x28336") ; <CJK>
       (?$(KQX(B . "0x2832B") ; <CJK>
       (?$(KQY(B . "0x28327") ; <CJK>
       (?$(KQZ(B . "0x28346") ; <CJK>
       (?$(KQ[(B . "0x2832C") ; <CJK>
       (?$(KQ\(B . "0x28345") ; <CJK>
       (?$(KQ](B . "0x28333") ; <CJK>
       (?$(KQ^(B . "0x2832D") ; <CJK>
       (?$(KQ_(B . "0x28334") ; <CJK>
       (?$(KQ`(B . "0x28322") ; <CJK>
       (?$(KQa(B . "0x4864") ; <CJK>
       (?$(KQb(B . "0x2841F") ; <CJK>
       (?$(KQc(B . "0x285B3") ; <CJK>
       (?$(KQd(B . "0x2858C") ; <CJK>
       (?$(KQe(B . "0x2858F") ; <CJK>
       (?$(KQf(B . "0x285AF") ; <CJK>
       (?$(KQg(B . "0x285AD") ; <CJK>
       (?$(KQh(B . "0x2858E") ; <CJK>
       (?$(KQi(B . "0x285AC") ; <CJK>
       (?$(KQj(B . "0x285B0") ; <CJK>
       (?$(KQk(B . "0x285B1") ; <CJK>
       (?$(KQl(B . "0x285AE") ; <CJK>
       (?$(KQm(B . "0x28599") ; <CJK>
       (?$(KQn(B . "0x286EB") ; <CJK>
       (?$(KQo(B . "0x28774") ; <CJK>
       (?$(KQp(B . "0x28775") ; <CJK>
       (?$(KQq(B . "0x2878E") ; <CJK>
       (?$(KQr(B . "0x2876D") ; <CJK>
       (?$(KQs(B . "0x28770") ; <CJK>
       (?$(KQt(B . "0x2878C") ; <CJK>
       (?$(KQu(B . "0x2884F") ; <CJK>
       (?$(KQv(B . "0x28851") ; <CJK>
       (?$(KQw(B . "0x28858") ; <CJK>
       (?$(KQx(B . "0x2884C") ; <CJK>
       (?$(KQy(B . "0x2884E") ; <CJK>
       (?$(KQz(B . "0x28915") ; <CJK>
       (?$(KQ{(B . "0x289BE") ; <CJK>
       (?$(KQ|(B . "0x289DB") ; <CJK>
       (?$(KQ}(B . "0x289B3") ; <CJK>
       (?$(KQ~(B . "0x289AE") ; <CJK>
       (?$(KR!(B . "0x28C87") ; <CJK>
       (?$(KR"(B . "0x28C8A") ; <CJK>
       (?$(KR#(B . "0x28C88") ; <CJK>
       (?$(KR$(B . "0x28C8B") ; <CJK>
       (?$(KR%(B . "0x28C8C") ; <CJK>
       (?$(KR&(B . "0x28D44") ; <CJK>
       (?$(KR'(B . "0x28D2D") ; <CJK>
       (?$(KR((B . "0x28D2A") ; <CJK>
       (?$(KR)(B . "0x28D31") ; <CJK>
       (?$(KR*(B . "0x28D2C") ; <CJK>
       (?$(KR+(B . "0x28D45") ; <CJK>
       (?$(KR,(B . "0x28D30") ; <CJK>
       (?$(KR-(B . "0x28D29") ; <CJK>
       (?$(KR.(B . "0x28D46") ; <CJK>
       (?$(KR/(B . "0x28EF4") ; <CJK>
       (?$(KR0(B . "0x28F14") ; <CJK>
       (?$(KR1(B . "0x28F10") ; <CJK>
       (?$(KR2(B . "0x28F0F") ; <CJK>
       (?$(KR3(B . "0x28F12") ; <CJK>
       (?$(KR4(B . "0x28F0B") ; <CJK>
       (?$(KR5(B . "0x28F0C") ; <CJK>
       (?$(KR6(B . "0x28F0A") ; <CJK>
       (?$(KR7(B . "0x28F13") ; <CJK>
       (?$(KR8(B . "0x28F0E") ; <CJK>
       (?$(KR9(B . "0x28FD9") ; <CJK>
       (?$(KR:(B . "0x28FD0") ; <CJK>
       (?$(KR;(B . "0x9703") ; <CJK>
       (?$(KR<(B . "0x290C1") ; <CJK>
       (?$(KR=(B . "0x290BF") ; <CJK>
       (?$(KR>(B . "0x290BD") ; <CJK>
       (?$(KR?(B . "0x290BC") ; <CJK>
       (?$(KR@(B . "0x290BA") ; <CJK>
       (?$(KRA(B . "0x290BB") ; <CJK>
       (?$(KRB(B . "0x290D1") ; <CJK>
       (?$(KRC(B . "0x290BE") ; <CJK>
       (?$(KRD(B . "0x290D0") ; <CJK>
       (?$(KRE(B . "0x290B9") ; <CJK>
       (?$(KRF(B . "0x2921A") ; <CJK>
       (?$(KRG(B . "0x2921C") ; <CJK>
       (?$(KRH(B . "0x2921B") ; <CJK>
       (?$(KRI(B . "0x29291") ; <CJK>
       (?$(KRJ(B . "0x29296") ; <CJK>
       (?$(KRK(B . "0x2929F") ; <CJK>
       (?$(KRL(B . "0x2929C") ; <CJK>
       (?$(KRM(B . "0x2929A") ; <CJK>
       (?$(KRN(B . "0x2929D") ; <CJK>
       (?$(KRO(B . "0x293AD") ; <CJK>
       (?$(KRP(B . "0x293A5") ; <CJK>
       (?$(KRQ(B . "0x293AE") ; <CJK>
       (?$(KRR(B . "0x29403") ; <CJK>
       (?$(KRS(B . "0x29426") ; <CJK>
       (?$(KRT(B . "0x29420") ; <CJK>
       (?$(KRU(B . "0x29423") ; <CJK>
       (?$(KRV(B . "0x29424") ; <CJK>
       (?$(KRW(B . "0x29421") ; <CJK>
       (?$(KRX(B . "0x29428") ; <CJK>
       (?$(KRY(B . "0x29425") ; <CJK>
       (?$(KRZ(B . "0x2941E") ; <CJK>
       (?$(KR[(B . "0x29494") ; <CJK>
       (?$(KR\(B . "0x29493") ; <CJK>
       (?$(KR](B . "0x2948F") ; <CJK>
       (?$(KR^(B . "0x2949A") ; <CJK>
       (?$(KR_(B . "0x294AD") ; <CJK>
       (?$(KR`(B . "0x4AC2") ; <CJK>
       (?$(KRa(B . "0x295CA") ; <CJK>
       (?$(KRb(B . "0x295C5") ; <CJK>
       (?$(KRc(B . "0x296BB") ; <CJK>
       (?$(KRd(B . "0x296E1") ; <CJK>
       (?$(KRe(B . "0x296EA") ; <CJK>
       (?$(KRf(B . "0x296E4") ; <CJK>
       (?$(KRg(B . "0x296ED") ; <CJK>
       (?$(KRh(B . "0x296E6") ; <CJK>
       (?$(KRi(B . "0x296E0") ; <CJK>
       (?$(KRj(B . "0x296E8") ; <CJK>
       (?$(KRk(B . "0x296E5") ; <CJK>
       (?$(KRl(B . "0x2981A") ; <CJK>
       (?$(KRm(B . "0x29894") ; <CJK>
       (?$(KRn(B . "0x29896") ; <CJK>
       (?$(KRo(B . "0x2989E") ; <CJK>
       (?$(KRp(B . "0x29895") ; <CJK>
       (?$(KRq(B . "0x298A1") ; <CJK>
       (?$(KRr(B . "0x2988E") ; <CJK>
       (?$(KRs(B . "0x2989B") ; <CJK>
       (?$(KRt(B . "0x29892") ; <CJK>
       (?$(KRu(B . "0x29897") ; <CJK>
       (?$(KRv(B . "0x29899") ; <CJK>
       (?$(KRw(B . "0x29893") ; <CJK>
       (?$(KRx(B . "0x29A32") ; <CJK>
       (?$(KRy(B . "0x29A2F") ; <CJK>
       (?$(KRz(B . "0x29A2E") ; <CJK>
       (?$(KR{(B . "0x29A33") ; <CJK>
       (?$(KR|(B . "0x29B1C") ; <CJK>
       (?$(KR}(B . "0x29B1E") ; <CJK>
       (?$(KR~(B . "0x29B11") ; <CJK>
       (?$(KS!(B . "0x29B20") ; <CJK>
       (?$(KS"(B . "0x29B1F") ; <CJK>
       (?$(KS#(B . "0x29B19") ; <CJK>
       (?$(KS$(B . "0x29B16") ; <CJK>
       (?$(KS%(B . "0x29CAC") ; <CJK>
       (?$(KS&(B . "0x29CB9") ; <CJK>
       (?$(KS'(B . "0x29CB3") ; <CJK>
       (?$(KS((B . "0x29CA6") ; <CJK>
       (?$(KS)(B . "0x29CA2") ; <CJK>
       (?$(KS*(B . "0x29CA9") ; <CJK>
       (?$(KS+(B . "0x29CA7") ; <CJK>
       (?$(KS,(B . "0x29D6C") ; <CJK>
       (?$(KS-(B . "0x29D6D") ; <CJK>
       (?$(KS.(B . "0x29D69") ; <CJK>
       (?$(KS/(B . "0x29D80") ; <CJK>
       (?$(KS0(B . "0x29D66") ; <CJK>
       (?$(KS1(B . "0x29D65") ; <CJK>
       (?$(KS2(B . "0x29D71") ; <CJK>
       (?$(KS3(B . "0x29D6B") ; <CJK>
       (?$(KS4(B . "0x29FBD") ; <CJK>
       (?$(KS5(B . "0x29FC1") ; <CJK>
       (?$(KS6(B . "0x29FD3") ; <CJK>
       (?$(KS7(B . "0x29FB6") ; <CJK>
       (?$(KS8(B . "0x4CAC") ; <CJK>
       (?$(KS9(B . "0x29FB9") ; <CJK>
       (?$(KS:(B . "0x29FD4") ; <CJK>
       (?$(KS;(B . "0x29FB7") ; <CJK>
       (?$(KS<(B . "0x29FDB") ; <CJK>
       (?$(KS=(B . "0x29FB8") ; <CJK>
       (?$(KS>(B . "0x29FC0") ; <CJK>
       (?$(KS?(B . "0x29FBC") ; <CJK>
       (?$(KS@(B . "0x29FD5") ; <CJK>
       (?$(KSA(B . "0x29FBF") ; <CJK>
       (?$(KSB(B . "0x29FC3") ; <CJK>
       (?$(KSC(B . "0x29FC9") ; <CJK>
       (?$(KSD(B . "0x2A258") ; <CJK>
       (?$(KSE(B . "0x2A290") ; <CJK>
       (?$(KSF(B . "0x2A295") ; <CJK>
       (?$(KSG(B . "0x2A297") ; <CJK>
       (?$(KSH(B . "0x2A309") ; <CJK>
       (?$(KSI(B . "0x2A308") ; <CJK>
       (?$(KSJ(B . "0x2A306") ; <CJK>
       (?$(KSK(B . "0x2A305") ; <CJK>
       (?$(KSL(B . "0x2A310") ; <CJK>
       (?$(KSM(B . "0x2A397") ; <CJK>
       (?$(KSN(B . "0x2A395") ; <CJK>
       (?$(KSO(B . "0x2A3EE") ; <CJK>
       (?$(KSP(B . "0x2A41F") ; <CJK>
       (?$(KSQ(B . "0x2FA1A") ; <CJK>
       (?$(KSR(B . "0x21B4B") ; <CJK>
       (?$(KSS(B . "0x2018E") ; <CJK>
       (?$(KST(B . "0x203E8") ; <CJK>
       (?$(KSU(B . "0x203F0") ; <CJK>
       (?$(KSV(B . "0x203F4") ; <CJK>
       (?$(KSW(B . "0x20406") ; <CJK>
       (?$(KSX(B . "0x203ED") ; <CJK>
       (?$(KSY(B . "0x349B") ; <CJK>
       (?$(KSZ(B . "0x203E9") ; <CJK>
       (?$(KS[(B . "0x20400") ; <CJK>
       (?$(KS\(B . "0x204B8") ; <CJK>
       (?$(KS](B . "0x2056D") ; <CJK>
       (?$(KS^(B . "0x20804") ; <CJK>
       (?$(KS_(B . "0x20801") ; <CJK>
       (?$(KS`(B . "0x20803") ; <CJK>
       (?$(KSa(B . "0x20802") ; <CJK>
       (?$(KSb(B . "0x52F6") ; <CJK>
       (?$(KSc(B . "0x3526") ; <CJK>
       (?$(KSd(B . "0x20962") ; <CJK>
       (?$(KSe(B . "0x20ABA") ; <CJK>
       (?$(KSf(B . "0x20B13") ; <CJK>
       (?$(KSg(B . "0x20FDE") ; <CJK>
       (?$(KSh(B . "0x20FD7") ; <CJK>
       (?$(KSi(B . "0x20FE4") ; <CJK>
       (?$(KSj(B . "0x20FCE") ; <CJK>
       (?$(KSk(B . "0x20FE3") ; <CJK>
       (?$(KSl(B . "0x20FDD") ; <CJK>
       (?$(KSm(B . "0x2103A") ; <CJK>
       (?$(KSn(B . "0x20FDB") ; <CJK>
       (?$(KSo(B . "0x20FD6") ; <CJK>
       (?$(KSp(B . "0x20FE0") ; <CJK>
       (?$(KSq(B . "0x20FD4") ; <CJK>
       (?$(KSr(B . "0x20FCB") ; <CJK>
       (?$(KSs(B . "0x20FE1") ; <CJK>
       (?$(KSt(B . "0x20FC9") ; <CJK>
       (?$(KSu(B . "0x20FDF") ; <CJK>
       (?$(KSv(B . "0x2103C") ; <CJK>
       (?$(KSw(B . "0x20FFC") ; <CJK>
       (?$(KSx(B . "0x20FCF") ; <CJK>
       (?$(KSy(B . "0x21479") ; <CJK>
       (?$(KSz(B . "0x21476") ; <CJK>
       (?$(KS{(B . "0x21478") ; <CJK>
       (?$(KS|(B . "0x21687") ; <CJK>
       (?$(KS}(B . "0x2189C") ; <CJK>
       (?$(KS~(B . "0x218B1") ; <CJK>
       (?$(KT!(B . "0x218C1") ; <CJK>
       (?$(KT"(B . "0x2189A") ; <CJK>
       (?$(KT#(B . "0x21892") ; <CJK>
       (?$(KT$(B . "0x41AF") ; <CJK>
       (?$(KT%(B . "0x218C2") ; <CJK>
       (?$(KT&(B . "0x21896") ; <CJK>
       (?$(KT'(B . "0x218C0") ; <CJK>
       (?$(KT((B . "0x21891") ; <CJK>
       (?$(KT)(B . "0x21895") ; <CJK>
       (?$(KT*(B . "0x219A2") ; <CJK>
       (?$(KT+(B . "0x21AC3") ; <CJK>
       (?$(KT,(B . "0x21AC0") ; <CJK>
       (?$(KT-(B . "0x21AC2") ; <CJK>
       (?$(KT.(B . "0x20B8A") ; <CJK>
       (?$(KT/(B . "0x21BB0") ; <CJK>
       (?$(KT0(B . "0x21C16") ; <CJK>
       (?$(KT1(B . "0x21F46") ; <CJK>
       (?$(KT2(B . "0x21F4A") ; <CJK>
       (?$(KT3(B . "0x21F3E") ; <CJK>
       (?$(KT4(B . "0x21F45") ; <CJK>
       (?$(KT5(B . "0x21F42") ; <CJK>
       (?$(KT6(B . "0x3815") ; <CJK>
       (?$(KT7(B . "0x21F5B") ; <CJK>
       (?$(KT8(B . "0x21F44") ; <CJK>
       (?$(KT9(B . "0x22004") ; <CJK>
       (?$(KT:(B . "0x24022") ; <CJK>
       (?$(KT;(B . "0x22155") ; <CJK>
       (?$(KT<(B . "0x22157") ; <CJK>
       (?$(KT=(B . "0x22151") ; <CJK>
       (?$(KT>(B . "0x2214E") ; <CJK>
       (?$(KT?(B . "0x2215A") ; <CJK>
       (?$(KT@(B . "0x222C6") ; <CJK>
       (?$(KTA(B . "0x222C3") ; <CJK>
       (?$(KTB(B . "0x389C") ; <CJK>
       (?$(KTC(B . "0x222C5") ; <CJK>
       (?$(KTD(B . "0x222CC") ; <CJK>
       (?$(KTE(B . "0x22371") ; <CJK>
       (?$(KTF(B . "0x22426") ; <CJK>
       (?$(KTG(B . "0x224B2") ; <CJK>
       (?$(KTH(B . "0x2257A") ; <CJK>
       (?$(KTI(B . "0x22584") ; <CJK>
       (?$(KTJ(B . "0x2257B") ; <CJK>
       (?$(KTK(B . "0x22874") ; <CJK>
       (?$(KTL(B . "0x2288C") ; <CJK>
       (?$(KTM(B . "0x22851") ; <CJK>
       (?$(KTN(B . "0x22848") ; <CJK>
       (?$(KTO(B . "0x2288D") ; <CJK>
       (?$(KTP(B . "0x22892") ; <CJK>
       (?$(KTQ(B . "0x22898") ; <CJK>
       (?$(KTR(B . "0x22893") ; <CJK>
       (?$(KTS(B . "0x228B0") ; <CJK>
       (?$(KTT(B . "0x2284E") ; <CJK>
       (?$(KTU(B . "0x22896") ; <CJK>
       (?$(KTV(B . "0x22897") ; <CJK>
       (?$(KTW(B . "0x2289C") ; <CJK>
       (?$(KTX(B . "0x228CA") ; <CJK>
       (?$(KTY(B . "0x22D33") ; <CJK>
       (?$(KTZ(B . "0x22D83") ; <CJK>
       (?$(KT[(B . "0x22D84") ; <CJK>
       (?$(KT\(B . "0x22D9A") ; <CJK>
       (?$(KT](B . "0x22D8C") ; <CJK>
       (?$(KT^(B . "0x64CC") ; <CJK>
       (?$(KT_(B . "0x22D99") ; <CJK>
       (?$(KT`(B . "0x22EE0") ; <CJK>
       (?$(KTa(B . "0x22FE4") ; <CJK>
       (?$(KTb(B . "0x22FF8") ; <CJK>
       (?$(KTc(B . "0x22FED") ; <CJK>
       (?$(KTd(B . "0x22FF3") ; <CJK>
       (?$(KTe(B . "0x22FF4") ; <CJK>
       (?$(KTf(B . "0x22FF5") ; <CJK>
       (?$(KTg(B . "0x22FFD") ; <CJK>
       (?$(KTh(B . "0x23119") ; <CJK>
       (?$(KTi(B . "0x2329E") ; <CJK>
       (?$(KTj(B . "0x232C4") ; <CJK>
       (?$(KTk(B . "0x2329F") ; <CJK>
       (?$(KTl(B . "0x2339B") ; <CJK>
       (?$(KTm(B . "0x2339F") ; <CJK>
       (?$(KTn(B . "0x2339A") ; <CJK>
       (?$(KTo(B . "0x236AA") ; <CJK>
       (?$(KTp(B . "0x2369D") ; <CJK>
       (?$(KTq(B . "0x23692") ; <CJK>
       (?$(KTr(B . "0x236A2") ; <CJK>
       (?$(KTs(B . "0x236AF") ; <CJK>
       (?$(KTt(B . "0x236EB") ; <CJK>
       (?$(KTu(B . "0x236A0") ; <CJK>
       (?$(KTv(B . "0x236A1") ; <CJK>
       (?$(KTw(B . "0x23694") ; <CJK>
       (?$(KTx(B . "0x23698") ; <CJK>
       (?$(KTy(B . "0x2368F") ; <CJK>
       (?$(KTz(B . "0x23687") ; <CJK>
       (?$(KT{(B . "0x23684") ; <CJK>
       (?$(KT|(B . "0x236A9") ; <CJK>
       (?$(KT}(B . "0x2367C") ; <CJK>
       (?$(KT~(B . "0x23918") ; <CJK>
       (?$(KU!(B . "0x23A5F") ; <CJK>
       (?$(KU"(B . "0x23A62") ; <CJK>
       (?$(KU#(B . "0x23A61") ; <CJK>
       (?$(KU$(B . "0x23AC0") ; <CJK>
       (?$(KU%(B . "0x23B15") ; <CJK>
       (?$(KU&(B . "0x23BFC") ; <CJK>
       (?$(KU'(B . "0x23BF9") ; <CJK>
       (?$(KU((B . "0x23FC8") ; <CJK>
       (?$(KU)(B . "0x23FC9") ; <CJK>
       (?$(KU*(B . "0x23FDE") ; <CJK>
       (?$(KU+(B . "0x23FCA") ; <CJK>
       (?$(KU,(B . "0x23FE2") ; <CJK>
       (?$(KU-(B . "0x3D64") ; <CJK>
       (?$(KU.(B . "0x3D6E") ; <CJK>
       (?$(KU/(B . "0x24004") ; <CJK>
       (?$(KU0(B . "0x23FCC") ; <CJK>
       (?$(KU1(B . "0x23FDD") ; <CJK>
       (?$(KU2(B . "0x23FE4") ; <CJK>
       (?$(KU3(B . "0x23FD3") ; <CJK>
       (?$(KU4(B . "0x23FC7") ; <CJK>
       (?$(KU5(B . "0x23FC6") ; <CJK>
       (?$(KU6(B . "0x3D5F") ; <CJK>
       (?$(KU7(B . "0x24037") ; <CJK>
       (?$(KU8(B . "0x243D8") ; <CJK>
       (?$(KU9(B . "0x243EE") ; <CJK>
       (?$(KU:(B . "0x243B2") ; <CJK>
       (?$(KU;(B . "0x243A3") ; <CJK>
       (?$(KU<(B . "0x243B3") ; <CJK>
       (?$(KU=(B . "0x243ED") ; <CJK>
       (?$(KU>(B . "0x243F8") ; <CJK>
       (?$(KU?(B . "0x24531") ; <CJK>
       (?$(KU@(B . "0x2455B") ; <CJK>
       (?$(KUA(B . "0x24566") ; <CJK>
       (?$(KUB(B . "0x24569") ; <CJK>
       (?$(KUC(B . "0x24596") ; <CJK>
       (?$(KUD(B . "0x2459B") ; <CJK>
       (?$(KUE(B . "0x245F7") ; <CJK>
       (?$(KUF(B . "0x245F3") ; <CJK>
       (?$(KUG(B . "0x245F4") ; <CJK>
       (?$(KUH(B . "0x245F5") ; <CJK>
       (?$(KUI(B . "0x246E2") ; <CJK>
       (?$(KUJ(B . "0x246E7") ; <CJK>
       (?$(KUK(B . "0x246E5") ; <CJK>
       (?$(KUL(B . "0x246E9") ; <CJK>
       (?$(KUM(B . "0x246E6") ; <CJK>
       (?$(KUN(B . "0x246E3") ; <CJK>
       (?$(KUO(B . "0x24874") ; <CJK>
       (?$(KUP(B . "0x2487F") ; <CJK>
       (?$(KUQ(B . "0x2488F") ; <CJK>
       (?$(KUR(B . "0x24890") ; <CJK>
       (?$(KUS(B . "0x24897") ; <CJK>
       (?$(KUT(B . "0x248A3") ; <CJK>
       (?$(KUU(B . "0x2488E") ; <CJK>
       (?$(KUV(B . "0x24898") ; <CJK>
       (?$(KUW(B . "0x2488C") ; <CJK>
       (?$(KUX(B . "0x24A42") ; <CJK>
       (?$(KUY(B . "0x24A44") ; <CJK>
       (?$(KUZ(B . "0x24A69") ; <CJK>
       (?$(KU[(B . "0x24A43") ; <CJK>
       (?$(KU\(B . "0x24A68") ; <CJK>
       (?$(KU](B . "0x3EF6") ; <CJK>
       (?$(KU^(B . "0x24B8D") ; <CJK>
       (?$(KU_(B . "0x24B88") ; <CJK>
       (?$(KU`(B . "0x24B8B") ; <CJK>
       (?$(KUa(B . "0x24B89") ; <CJK>
       (?$(KUb(B . "0x24CCC") ; <CJK>
       (?$(KUc(B . "0x24D1F") ; <CJK>
       (?$(KUd(B . "0x24E80") ; <CJK>
       (?$(KUe(B . "0x24E5E") ; <CJK>
       (?$(KUf(B . "0x24E67") ; <CJK>
       (?$(KUg(B . "0x24E68") ; <CJK>
       (?$(KUh(B . "0x24E65") ; <CJK>
       (?$(KUi(B . "0x764A") ; <CJK>
       (?$(KUj(B . "0x24E74") ; <CJK>
       (?$(KUk(B . "0x24E69") ; <CJK>
       (?$(KUl(B . "0x24E61") ; <CJK>
       (?$(KUm(B . "0x24E62") ; <CJK>
       (?$(KUn(B . "0x24E6C") ; <CJK>
       (?$(KUo(B . "0x24E93") ; <CJK>
       (?$(KUp(B . "0x24E86") ; <CJK>
       (?$(KUq(B . "0x24F9D") ; <CJK>
       (?$(KUr(B . "0x24F9B") ; <CJK>
       (?$(KUs(B . "0x2501B") ; <CJK>
       (?$(KUt(B . "0x25016") ; <CJK>
       (?$(KUu(B . "0x25019") ; <CJK>
       (?$(KUv(B . "0x25014") ; <CJK>
       (?$(KUw(B . "0x25018") ; <CJK>
       (?$(KUx(B . "0x25015") ; <CJK>
       (?$(KUy(B . "0x25099") ; <CJK>
       (?$(KUz(B . "0x25098") ; <CJK>
       (?$(KU{(B . "0x2525D") ; <CJK>
       (?$(KU|(B . "0x25289") ; <CJK>
       (?$(KU}(B . "0x2527A") ; <CJK>
       (?$(KU~(B . "0x2527D") ; <CJK>
       (?$(KV!(B . "0x2524B") ; <CJK>
       (?$(KV"(B . "0x4073") ; <CJK>
       (?$(KV#(B . "0x25278") ; <CJK>
       (?$(KV$(B . "0x2527F") ; <CJK>
       (?$(KV%(B . "0x25277") ; <CJK>
       (?$(KV&(B . "0x2527E") ; <CJK>
       (?$(KV'(B . "0x25279") ; <CJK>
       (?$(KV((B . "0x252AB") ; <CJK>
       (?$(KV)(B . "0x2527C") ; <CJK>
       (?$(KV*(B . "0x25274") ; <CJK>
       (?$(KV+(B . "0x25275") ; <CJK>
       (?$(KV,(B . "0x252A7") ; <CJK>
       (?$(KV-(B . "0x2538D") ; <CJK>
       (?$(KV.(B . "0x2554E") ; <CJK>
       (?$(KV/(B . "0x25566") ; <CJK>
       (?$(KV0(B . "0x25561") ; <CJK>
       (?$(KV1(B . "0x2554D") ; <CJK>
       (?$(KV2(B . "0x2554F") ; <CJK>
       (?$(KV3(B . "0x40DD") ; <CJK>
       (?$(KV4(B . "0x25554") ; <CJK>
       (?$(KV5(B . "0x2557C") ; <CJK>
       (?$(KV6(B . "0x256DA") ; <CJK>
       (?$(KV7(B . "0x256DE") ; <CJK>
       (?$(KV8(B . "0x256D8") ; <CJK>
       (?$(KV9(B . "0x256DD") ; <CJK>
       (?$(KV:(B . "0x256DF") ; <CJK>
       (?$(KV;(B . "0x25866") ; <CJK>
       (?$(KV<(B . "0x25862") ; <CJK>
       (?$(KV=(B . "0x2585F") ; <CJK>
       (?$(KV>(B . "0x25864") ; <CJK>
       (?$(KV?(B . "0x25863") ; <CJK>
       (?$(KV@(B . "0x25860") ; <CJK>
       (?$(KVA(B . "0x25888") ; <CJK>
       (?$(KVB(B . "0x2586A") ; <CJK>
       (?$(KVC(B . "0x25867") ; <CJK>
       (?$(KVD(B . "0x25887") ; <CJK>
       (?$(KVE(B . "0x2583F") ; <CJK>
       (?$(KVF(B . "0x2586C") ; <CJK>
       (?$(KVG(B . "0x2586E") ; <CJK>
       (?$(KVH(B . "0x258AD") ; <CJK>
       (?$(KVI(B . "0x259F1") ; <CJK>
       (?$(KVJ(B . "0x259F4") ; <CJK>
       (?$(KVK(B . "0x259F6") ; <CJK>
       (?$(KVL(B . "0x259F5") ; <CJK>
       (?$(KVM(B . "0x259F8") ; <CJK>
       (?$(KVN(B . "0x259FB") ; <CJK>
       (?$(KVO(B . "0x259EC") ; <CJK>
       (?$(KVP(B . "0x259EF") ; <CJK>
       (?$(KVQ(B . "0x259ED") ; <CJK>
       (?$(KVR(B . "0x7AB9") ; <CJK>
       (?$(KVS(B . "0x259F7") ; <CJK>
       (?$(KVT(B . "0x259F9") ; <CJK>
       (?$(KVU(B . "0x259FD") ; <CJK>
       (?$(KVV(B . "0x25AB1") ; <CJK>
       (?$(KVW(B . "0x25C36") ; <CJK>
       (?$(KVX(B . "0x25C1B") ; <CJK>
       (?$(KVY(B . "0x25C32") ; <CJK>
       (?$(KVZ(B . "0x25C42") ; <CJK>
       (?$(KV[(B . "0x25C4D") ; <CJK>
       (?$(KV\(B . "0x25C1F") ; <CJK>
       (?$(KV](B . "0x25C21") ; <CJK>
       (?$(KV^(B . "0x25C1C") ; <CJK>
       (?$(KV_(B . "0x25C31") ; <CJK>
       (?$(KV`(B . "0x25C2E") ; <CJK>
       (?$(KVa(B . "0x25C47") ; <CJK>
       (?$(KVb(B . "0x25C3B") ; <CJK>
       (?$(KVc(B . "0x25C41") ; <CJK>
       (?$(KVd(B . "0x25C18") ; <CJK>
       (?$(KVe(B . "0x25C39") ; <CJK>
       (?$(KVf(B . "0x25C1D") ; <CJK>
       (?$(KVg(B . "0x25C27") ; <CJK>
       (?$(KVh(B . "0x25C23") ; <CJK>
       (?$(KVi(B . "0x7BD7") ; <CJK>
       (?$(KVj(B . "0x25EEE") ; <CJK>
       (?$(KVk(B . "0x25EE8") ; <CJK>
       (?$(KVl(B . "0x25EE5") ; <CJK>
       (?$(KVm(B . "0x25EEF") ; <CJK>
       (?$(KVn(B . "0x25EE4") ; <CJK>
       (?$(KVo(B . "0x25EEC") ; <CJK>
       (?$(KVp(B . "0x25EF0") ; <CJK>
       (?$(KVq(B . "0x260D7") ; <CJK>
       (?$(KVr(B . "0x260D8") ; <CJK>
       (?$(KVs(B . "0x260D4") ; <CJK>
       (?$(KVt(B . "0x260CA") ; <CJK>
       (?$(KVu(B . "0x260D2") ; <CJK>
       (?$(KVv(B . "0x260CB") ; <CJK>
       (?$(KVw(B . "0x260D3") ; <CJK>
       (?$(KVx(B . "0x260E6") ; <CJK>
       (?$(KVy(B . "0x260E2") ; <CJK>
       (?$(KVz(B . "0x26249") ; <CJK>
       (?$(KV{(B . "0x26248") ; <CJK>
       (?$(KV|(B . "0x262FF") ; <CJK>
       (?$(KV}(B . "0x26309") ; <CJK>
       (?$(KV~(B . "0x263B0") ; <CJK>
       (?$(KW!(B . "0x263AF") ; <CJK>
       (?$(KW"(B . "0x2647C") ; <CJK>
       (?$(KW#(B . "0x26478") ; <CJK>
       (?$(KW$(B . "0x2647A") ; <CJK>
       (?$(KW%(B . "0x26472") ; <CJK>
       (?$(KW&(B . "0x26479") ; <CJK>
       (?$(KW'(B . "0x2647E") ; <CJK>
       (?$(KW((B . "0x2650C") ; <CJK>
       (?$(KW)(B . "0x2650B") ; <CJK>
       (?$(KW*(B . "0x265CD") ; <CJK>
       (?$(KW+(B . "0x265BE") ; <CJK>
       (?$(KW,(B . "0x265BC") ; <CJK>
       (?$(KW-(B . "0x265BF") ; <CJK>
       (?$(KW.(B . "0x265C0") ; <CJK>
       (?$(KW/(B . "0x265BD") ; <CJK>
       (?$(KW0(B . "0x26838") ; <CJK>
       (?$(KW1(B . "0x26808") ; <CJK>
       (?$(KW2(B . "0x26805") ; <CJK>
       (?$(KW3(B . "0x2683B") ; <CJK>
       (?$(KW4(B . "0x26810") ; <CJK>
       (?$(KW5(B . "0x2680C") ; <CJK>
       (?$(KW6(B . "0x2680D") ; <CJK>
       (?$(KW7(B . "0x26804") ; <CJK>
       (?$(KW8(B . "0x2683A") ; <CJK>
       (?$(KW9(B . "0x26813") ; <CJK>
       (?$(KW:(B . "0x26837") ; <CJK>
       (?$(KW;(B . "0x26839") ; <CJK>
       (?$(KW<(B . "0x2691F") ; <CJK>
       (?$(KW=(B . "0x2694B") ; <CJK>
       (?$(KW>(B . "0x269EE") ; <CJK>
       (?$(KW?(B . "0x26A75") ; <CJK>
       (?$(KW@(B . "0x26A78") ; <CJK>
       (?$(KWA(B . "0x26A7C") ; <CJK>
       (?$(KWB(B . "0x26A74") ; <CJK>
       (?$(KWC(B . "0x26A76") ; <CJK>
       (?$(KWD(B . "0x26AEA") ; <CJK>
       (?$(KWE(B . "0x26AEB") ; <CJK>
       (?$(KWF(B . "0x26DFB") ; <CJK>
       (?$(KWG(B . "0x26E19") ; <CJK>
       (?$(KWH(B . "0x26EA7") ; <CJK>
       (?$(KWI(B . "0x26E8C") ; <CJK>
       (?$(KWJ(B . "0x26EDC") ; <CJK>
       (?$(KWK(B . "0x26E98") ; <CJK>
       (?$(KWL(B . "0x26EBE") ; <CJK>
       (?$(KWM(B . "0x26E9E") ; <CJK>
       (?$(KWN(B . "0x26F0F") ; <CJK>
       (?$(KWO(B . "0x26E9F") ; <CJK>
       (?$(KWP(B . "0x26EDD") ; <CJK>
       (?$(KWQ(B . "0x26E93") ; <CJK>
       (?$(KWR(B . "0x26EBB") ; <CJK>
       (?$(KWS(B . "0x26EB6") ; <CJK>
       (?$(KWT(B . "0x26E90") ; <CJK>
       (?$(KWU(B . "0x26EA1") ; <CJK>
       (?$(KWV(B . "0x26EBD") ; <CJK>
       (?$(KWW(B . "0x26EDE") ; <CJK>
       (?$(KWX(B . "0x26E3A") ; <CJK>
       (?$(KWY(B . "0x26F22") ; <CJK>
       (?$(KWZ(B . "0x26E97") ; <CJK>
       (?$(KW[(B . "0x26E94") ; <CJK>
       (?$(KW\(B . "0x26EC3") ; <CJK>
       (?$(KW](B . "0x26E8E") ; <CJK>
       (?$(KW^(B . "0x26EA8") ; <CJK>
       (?$(KW_(B . "0x26E99") ; <CJK>
       (?$(KW`(B . "0x26EAD") ; <CJK>
       (?$(KWa(B . "0x26E9B") ; <CJK>
       (?$(KWb(B . "0x26EA2") ; <CJK>
       (?$(KWc(B . "0x26F21") ; <CJK>
       (?$(KWd(B . "0x26EAC") ; <CJK>
       (?$(KWe(B . "0x26F0E") ; <CJK>
       (?$(KWf(B . "0x26F31") ; <CJK>
       (?$(KWg(B . "0x271E1") ; <CJK>
       (?$(KWh(B . "0x271DE") ; <CJK>
       (?$(KWi(B . "0x271DF") ; <CJK>
       (?$(KWj(B . "0x271DC") ; <CJK>
       (?$(KWk(B . "0x271DD") ; <CJK>
       (?$(KWl(B . "0x271EC") ; <CJK>
       (?$(KWm(B . "0x271E7") ; <CJK>
       (?$(KWn(B . "0x27369") ; <CJK>
       (?$(KWo(B . "0x273B8") ; <CJK>
       (?$(KWp(B . "0x273A1") ; <CJK>
       (?$(KWq(B . "0x273A8") ; <CJK>
       (?$(KWr(B . "0x273BA") ; <CJK>
       (?$(KWs(B . "0x273C2") ; <CJK>
       (?$(KWt(B . "0x273A6") ; <CJK>
       (?$(KWu(B . "0x273A4") ; <CJK>
       (?$(KWv(B . "0x273A3") ; <CJK>
       (?$(KWw(B . "0x273AB") ; <CJK>
       (?$(KWx(B . "0x273BC") ; <CJK>
       (?$(KWy(B . "0x273B7") ; <CJK>
       (?$(KWz(B . "0x273BF") ; <CJK>
       (?$(KW{(B . "0x273AD") ; <CJK>
       (?$(KW|(B . "0x273B1") ; <CJK>
       (?$(KW}(B . "0x273CA") ; <CJK>
       (?$(KW~(B . "0x273C4") ; <CJK>
       (?$(KX!(B . "0x273B9") ; <CJK>
       (?$(KX"(B . "0x275C8") ; <CJK>
       (?$(KX#(B . "0x275C6") ; <CJK>
       (?$(KX$(B . "0x275C7") ; <CJK>
       (?$(KX%(B . "0x2770A") ; <CJK>
       (?$(KX&(B . "0x2770D") ; <CJK>
       (?$(KX'(B . "0x276FB") ; <CJK>
       (?$(KX((B . "0x27703") ; <CJK>
       (?$(KX)(B . "0x27702") ; <CJK>
       (?$(KX*(B . "0x276FC") ; <CJK>
       (?$(KX+(B . "0x276F9") ; <CJK>
       (?$(KX,(B . "0x276F8") ; <CJK>
       (?$(KX-(B . "0x2786E") ; <CJK>
       (?$(KX.(B . "0x27863") ; <CJK>
       (?$(KX/(B . "0x27862") ; <CJK>
       (?$(KX0(B . "0x27861") ; <CJK>
       (?$(KX1(B . "0x2786B") ; <CJK>
       (?$(KX2(B . "0x4688") ; <CJK>
       (?$(KX3(B . "0x2786F") ; <CJK>
       (?$(KX4(B . "0x27866") ; <CJK>
       (?$(KX5(B . "0x2786C") ; <CJK>
       (?$(KX6(B . "0x2790E") ; <CJK>
       (?$(KX7(B . "0x27915") ; <CJK>
       (?$(KX8(B . "0x27916") ; <CJK>
       (?$(KX9(B . "0x27910") ; <CJK>
       (?$(KX:(B . "0x27917") ; <CJK>
       (?$(KX;(B . "0x27911") ; <CJK>
       (?$(KX<(B . "0x27A6E") ; <CJK>
       (?$(KX=(B . "0x27A6C") ; <CJK>
       (?$(KX>(B . "0x27A87") ; <CJK>
       (?$(KX?(B . "0x27A83") ; <CJK>
       (?$(KX@(B . "0x27A63") ; <CJK>
       (?$(KXA(B . "0x27ADC") ; <CJK>
       (?$(KXB(B . "0x27BC0") ; <CJK>
       (?$(KXC(B . "0x27BF7") ; <CJK>
       (?$(KXD(B . "0x27BFA") ; <CJK>
       (?$(KXE(B . "0x27C70") ; <CJK>
       (?$(KXF(B . "0x27C6A") ; <CJK>
       (?$(KXG(B . "0x27C68") ; <CJK>
       (?$(KXH(B . "0x27C69") ; <CJK>
       (?$(KXI(B . "0x27C84") ; <CJK>
       (?$(KXJ(B . "0x27CEC") ; <CJK>
       (?$(KXK(B . "0x27CE7") ; <CJK>
       (?$(KXL(B . "0x27CEE") ; <CJK>
       (?$(KXM(B . "0x27DBA") ; <CJK>
       (?$(KXN(B . "0x27DB2") ; <CJK>
       (?$(KXO(B . "0x27DB5") ; <CJK>
       (?$(KXP(B . "0x27DCB") ; <CJK>
       (?$(KXQ(B . "0x2080B") ; <CJK>
       (?$(KXR(B . "0x27DD0") ; <CJK>
       (?$(KXS(B . "0x27E6D") ; <CJK>
       (?$(KXT(B . "0x27E6C") ; <CJK>
       (?$(KXU(B . "0x47BB") ; <CJK>
       (?$(KXV(B . "0x27F45") ; <CJK>
       (?$(KXW(B . "0x27F46") ; <CJK>
       (?$(KXX(B . "0x27F34") ; <CJK>
       (?$(KXY(B . "0x27F2C") ; <CJK>
       (?$(KXZ(B . "0x27F35") ; <CJK>
       (?$(KX[(B . "0x27F44") ; <CJK>
       (?$(KX\(B . "0x47BA") ; <CJK>
       (?$(KX](B . "0x27F76") ; <CJK>
       (?$(KX^(B . "0x280B1") ; <CJK>
       (?$(KX_(B . "0x280AA") ; <CJK>
       (?$(KX`(B . "0x280A1") ; <CJK>
       (?$(KXa(B . "0x280B2") ; <CJK>
       (?$(KXb(B . "0x4812") ; <CJK>
       (?$(KXc(B . "0x280A6") ; <CJK>
       (?$(KXd(B . "0x280B5") ; <CJK>
       (?$(KXe(B . "0x280B4") ; <CJK>
       (?$(KXf(B . "0x280B8") ; <CJK>
       (?$(KXg(B . "0x280AF") ; <CJK>
       (?$(KXh(B . "0x280B0") ; <CJK>
       (?$(KXi(B . "0x280A3") ; <CJK>
       (?$(KXj(B . "0x28262") ; <CJK>
       (?$(KXk(B . "0x28264") ; <CJK>
       (?$(KXl(B . "0x28356") ; <CJK>
       (?$(KXm(B . "0x28351") ; <CJK>
       (?$(KXn(B . "0x2834F") ; <CJK>
       (?$(KXo(B . "0x28368") ; <CJK>
       (?$(KXp(B . "0x2834C") ; <CJK>
       (?$(KXq(B . "0x28350") ; <CJK>
       (?$(KXr(B . "0x4861") ; <CJK>
       (?$(KXs(B . "0x28348") ; <CJK>
       (?$(KXt(B . "0x2834A") ; <CJK>
       (?$(KXu(B . "0x28421") ; <CJK>
       (?$(KXv(B . "0x285E3") ; <CJK>
       (?$(KXw(B . "0x285B9") ; <CJK>
       (?$(KXx(B . "0x285DE") ; <CJK>
       (?$(KXy(B . "0x285B7") ; <CJK>
       (?$(KXz(B . "0x285E1") ; <CJK>
       (?$(KX{(B . "0x285B6") ; <CJK>
       (?$(KX|(B . "0x285B5") ; <CJK>
       (?$(KX}(B . "0x285DF") ; <CJK>
       (?$(KX~(B . "0x48E1") ; <CJK>
       (?$(KY!(B . "0x28797") ; <CJK>
       (?$(KY"(B . "0x2879A") ; <CJK>
       (?$(KY#(B . "0x2879B") ; <CJK>
       (?$(KY$(B . "0x28798") ; <CJK>
       (?$(KY%(B . "0x28792") ; <CJK>
       (?$(KY&(B . "0x28793") ; <CJK>
       (?$(KY'(B . "0x287D7") ; <CJK>
       (?$(KY((B . "0x28773") ; <CJK>
       (?$(KY)(B . "0x2886B") ; <CJK>
       (?$(KY*(B . "0x28874") ; <CJK>
       (?$(KY+(B . "0x28878") ; <CJK>
       (?$(KY,(B . "0x2886D") ; <CJK>
       (?$(KY-(B . "0x28918") ; <CJK>
       (?$(KY.(B . "0x289E9") ; <CJK>
       (?$(KY/(B . "0x289F5") ; <CJK>
       (?$(KY0(B . "0x289EA") ; <CJK>
       (?$(KY1(B . "0x28A2E") ; <CJK>
       (?$(KY2(B . "0x289E7") ; <CJK>
       (?$(KY3(B . "0x289FE") ; <CJK>
       (?$(KY4(B . "0x289E5") ; <CJK>
       (?$(KY5(B . "0x28A36") ; <CJK>
       (?$(KY6(B . "0x289F0") ; <CJK>
       (?$(KY7(B . "0x289E6") ; <CJK>
       (?$(KY8(B . "0x28A2C") ; <CJK>
       (?$(KY9(B . "0x28C89") ; <CJK>
       (?$(KY:(B . "0x28C95") ; <CJK>
       (?$(KY;(B . "0x28C93") ; <CJK>
       (?$(KY<(B . "0x28D4D") ; <CJK>
       (?$(KY=(B . "0x28D4A") ; <CJK>
       (?$(KY>(B . "0x28D4F") ; <CJK>
       (?$(KY?(B . "0x28D50") ; <CJK>
       (?$(KY@(B . "0x28D4B") ; <CJK>
       (?$(KYA(B . "0x28F2A") ; <CJK>
       (?$(KYB(B . "0x28F2B") ; <CJK>
       (?$(KYC(B . "0x28F2F") ; <CJK>
       (?$(KYD(B . "0x28F2E") ; <CJK>
       (?$(KYE(B . "0x28F7C") ; <CJK>
       (?$(KYF(B . "0x28FED") ; <CJK>
       (?$(KYG(B . "0x28FE2") ; <CJK>
       (?$(KYH(B . "0x290E0") ; <CJK>
       (?$(KYI(B . "0x290DC") ; <CJK>
       (?$(KYJ(B . "0x290DA") ; <CJK>
       (?$(KYK(B . "0x290D6") ; <CJK>
       (?$(KYL(B . "0x290F4") ; <CJK>
       (?$(KYM(B . "0x290D9") ; <CJK>
       (?$(KYN(B . "0x290D5") ; <CJK>
       (?$(KYO(B . "0x29222") ; <CJK>
       (?$(KYP(B . "0x29221") ; <CJK>
       (?$(KYQ(B . "0x29224") ; <CJK>
       (?$(KYR(B . "0x29225") ; <CJK>
       (?$(KYS(B . "0x29226") ; <CJK>
       (?$(KYT(B . "0x29223") ; <CJK>
       (?$(KYU(B . "0x292AA") ; <CJK>
       (?$(KYV(B . "0x292AF") ; <CJK>
       (?$(KYW(B . "0x292B0") ; <CJK>
       (?$(KYX(B . "0x292AB") ; <CJK>
       (?$(KYY(B . "0x293AF") ; <CJK>
       (?$(KYZ(B . "0x293B7") ; <CJK>
       (?$(KY[(B . "0x293B5") ; <CJK>
       (?$(KY\(B . "0x293B2") ; <CJK>
       (?$(KY](B . "0x293B3") ; <CJK>
       (?$(KY^(B . "0x2942B") ; <CJK>
       (?$(KY_(B . "0x294D8") ; <CJK>
       (?$(KY`(B . "0x294C2") ; <CJK>
       (?$(KYa(B . "0x294AF") ; <CJK>
       (?$(KYb(B . "0x294BC") ; <CJK>
       (?$(KYc(B . "0x294B8") ; <CJK>
       (?$(KYd(B . "0x294BE") ; <CJK>
       (?$(KYe(B . "0x294B7") ; <CJK>
       (?$(KYf(B . "0x294B4") ; <CJK>
       (?$(KYg(B . "0x294BF") ; <CJK>
       (?$(KYh(B . "0x294B3") ; <CJK>
       (?$(KYi(B . "0x294B1") ; <CJK>
       (?$(KYj(B . "0x294BB") ; <CJK>
       (?$(KYk(B . "0x294BD") ; <CJK>
       (?$(KYl(B . "0x294D6") ; <CJK>
       (?$(KYm(B . "0x294DD") ; <CJK>
       (?$(KYn(B . "0x295D8") ; <CJK>
       (?$(KYo(B . "0x295D3") ; <CJK>
       (?$(KYp(B . "0x295D5") ; <CJK>
       (?$(KYq(B . "0x295E3") ; <CJK>
       (?$(KYr(B . "0x295E2") ; <CJK>
       (?$(KYs(B . "0x295D9") ; <CJK>
       (?$(KYt(B . "0x295DE") ; <CJK>
       (?$(KYu(B . "0x295DF") ; <CJK>
       (?$(KYv(B . "0x295DA") ; <CJK>
       (?$(KYw(B . "0x295D4") ; <CJK>
       (?$(KYx(B . "0x296F3") ; <CJK>
       (?$(KYy(B . "0x296E2") ; <CJK>
       (?$(KYz(B . "0x2970D") ; <CJK>
       (?$(KY{(B . "0x29701") ; <CJK>
       (?$(KY|(B . "0x29705") ; <CJK>
       (?$(KY}(B . "0x2971A") ; <CJK>
       (?$(KY~(B . "0x29703") ; <CJK>
       (?$(KZ!(B . "0x2971F") ; <CJK>
       (?$(KZ"(B . "0x29716") ; <CJK>
       (?$(KZ#(B . "0x296FA") ; <CJK>
       (?$(KZ$(B . "0x296FC") ; <CJK>
       (?$(KZ%(B . "0x2970A") ; <CJK>
       (?$(KZ&(B . "0x999F") ; <CJK>
       (?$(KZ'(B . "0x298BC") ; <CJK>
       (?$(KZ((B . "0x298CA") ; <CJK>
       (?$(KZ)(B . "0x298B6") ; <CJK>
       (?$(KZ*(B . "0x298C7") ; <CJK>
       (?$(KZ+(B . "0x298BF") ; <CJK>
       (?$(KZ,(B . "0x4B89") ; <CJK>
       (?$(KZ-(B . "0x298B9") ; <CJK>
       (?$(KZ.(B . "0x4B8C") ; <CJK>
       (?$(KZ/(B . "0x298B0") ; <CJK>
       (?$(KZ0(B . "0x298B8") ; <CJK>
       (?$(KZ1(B . "0x298BD") ; <CJK>
       (?$(KZ2(B . "0x29891") ; <CJK>
       (?$(KZ3(B . "0x298BB") ; <CJK>
       (?$(KZ4(B . "0x298BE") ; <CJK>
       (?$(KZ5(B . "0x29A3E") ; <CJK>
       (?$(KZ6(B . "0x29A3D") ; <CJK>
       (?$(KZ7(B . "0x29B38") ; <CJK>
       (?$(KZ8(B . "0x29B3D") ; <CJK>
       (?$(KZ9(B . "0x29B39") ; <CJK>
       (?$(KZ:(B . "0x29B33") ; <CJK>
       (?$(KZ;(B . "0x29C33") ; <CJK>
       (?$(KZ<(B . "0x29CBB") ; <CJK>
       (?$(KZ=(B . "0x29CC6") ; <CJK>
       (?$(KZ>(B . "0x29CC5") ; <CJK>
       (?$(KZ?(B . "0x29CC7") ; <CJK>
       (?$(KZ@(B . "0x29CCB") ; <CJK>
       (?$(KZA(B . "0x29CA8") ; <CJK>
       (?$(KZB(B . "0x29CC8") ; <CJK>
       (?$(KZC(B . "0x29CBE") ; <CJK>
       (?$(KZD(B . "0x29CC1") ; <CJK>
       (?$(KZE(B . "0x29CBD") ; <CJK>
       (?$(KZF(B . "0x29D82") ; <CJK>
       (?$(KZG(B . "0x29D9E") ; <CJK>
       (?$(KZH(B . "0x29D81") ; <CJK>
       (?$(KZI(B . "0x29D84") ; <CJK>
       (?$(KZJ(B . "0x9B8D") ; <CJK>
       (?$(KZK(B . "0x29D96") ; <CJK>
       (?$(KZL(B . "0x29D8E") ; <CJK>
       (?$(KZM(B . "0x29D88") ; <CJK>
       (?$(KZN(B . "0x29D87") ; <CJK>
       (?$(KZO(B . "0x29FE0") ; <CJK>
       (?$(KZP(B . "0x2A00D") ; <CJK>
       (?$(KZQ(B . "0x29FDF") ; <CJK>
       (?$(KZR(B . "0x29FE4") ; <CJK>
       (?$(KZS(B . "0x29FE2") ; <CJK>
       (?$(KZT(B . "0x29FDD") ; <CJK>
       (?$(KZU(B . "0x29FEC") ; <CJK>
       (?$(KZV(B . "0x29FDE") ; <CJK>
       (?$(KZW(B . "0x29FE7") ; <CJK>
       (?$(KZX(B . "0x29FEA") ; <CJK>
       (?$(KZY(B . "0x29FE3") ; <CJK>
       (?$(KZZ(B . "0x2A25C") ; <CJK>
       (?$(KZ[(B . "0x9E77") ; <CJK>
       (?$(KZ\(B . "0x2A25D") ; <CJK>
       (?$(KZ](B . "0x2A29C") ; <CJK>
       (?$(KZ^(B . "0x2A31D") ; <CJK>
       (?$(KZ_(B . "0x2A39D") ; <CJK>
       (?$(KZ`(B . "0x2A39E") ; <CJK>
       (?$(KZa(B . "0x2A39B") ; <CJK>
       (?$(KZb(B . "0x2A3B5") ; <CJK>
       (?$(KZc(B . "0x2A3B9") ; <CJK>
       (?$(KZd(B . "0x2A3B6") ; <CJK>
       (?$(KZe(B . "0x2A3F3") ; <CJK>
       (?$(KZf(B . "0x2A3F2") ; <CJK>
       (?$(KZg(B . "0x2A3F4") ; <CJK>
       (?$(KZh(B . "0x2A426") ; <CJK>
       (?$(KZi(B . "0x2A427") ; <CJK>
       (?$(KZj(B . "0x2A425") ; <CJK>
       (?$(KZk(B . "0x2A506") ; <CJK>
       (?$(KZl(B . "0x2A50B") ; <CJK>
       (?$(KZm(B . "0x2A53A") ; <CJK>
       (?$(KZn(B . "0x2A53C") ; <CJK>
       (?$(KZo(B . "0x2040A") ; <CJK>
       (?$(KZp(B . "0x2040B") ; <CJK>
       (?$(KZq(B . "0x204BF") ; <CJK>
       (?$(KZr(B . "0x204FD") ; <CJK>
       (?$(KZs(B . "0x20618") ; <CJK>
       (?$(KZt(B . "0x291DF") ; <CJK>
       (?$(KZu(B . "0x25390") ; <CJK>
       (?$(KZv(B . "0x2069E") ; <CJK>
       (?$(KZw(B . "0x207FC") ; <CJK>
       (?$(KZx(B . "0x20810") ; <CJK>
       (?$(KZy(B . "0x2080F") ; <CJK>
       (?$(KZz(B . "0x2080D") ; <CJK>
       (?$(KZ{(B . "0x208B9") ; <CJK>
       (?$(KZ|(B . "0x208B7") ; <CJK>
       (?$(KZ}(B . "0x208BA") ; <CJK>
       (?$(KZ~(B . "0x2090A") ; <CJK>
       (?$(K[!(B . "0x21041") ; <CJK>
       (?$(K["(B . "0x2108B") ; <CJK>
       (?$(K[#(B . "0x21046") ; <CJK>
       (?$(K[$(B . "0x21053") ; <CJK>
       (?$(K[%(B . "0x210E2") ; <CJK>
       (?$(K[&(B . "0x2103F") ; <CJK>
       (?$(K['(B . "0x20F7C") ; <CJK>
       (?$(K[((B . "0x2104B") ; <CJK>
       (?$(K[)(B . "0x2104E") ; <CJK>
       (?$(K[*(B . "0x2108A") ; <CJK>
       (?$(K[+(B . "0x21047") ; <CJK>
       (?$(K[,(B . "0x21493") ; <CJK>
       (?$(K[-(B . "0x27DCE") ; <CJK>
       (?$(K[.(B . "0x2148C") ; <CJK>
       (?$(K[/(B . "0x214AF") ; <CJK>
       (?$(K[0(B . "0x214C9") ; <CJK>
       (?$(K[1(B . "0x215C6") ; <CJK>
       (?$(K[2(B . "0x215C8") ; <CJK>
       (?$(K[3(B . "0x21691") ; <CJK>
       (?$(K[4(B . "0x218CF") ; <CJK>
       (?$(K[5(B . "0x218D4") ; <CJK>
       (?$(K[6(B . "0x218CE") ; <CJK>
       (?$(K[7(B . "0x21ADD") ; <CJK>
       (?$(K[8(B . "0x21AD4") ; <CJK>
       (?$(K[9(B . "0x21F49") ; <CJK>
       (?$(K[:(B . "0x21F63") ; <CJK>
       (?$(K[;(B . "0x21F5D") ; <CJK>
       (?$(K[<(B . "0x381A") ; <CJK>
       (?$(K[=(B . "0x21F67") ; <CJK>
       (?$(K[>(B . "0x21FBB") ; <CJK>
       (?$(K[?(B . "0x21F60") ; <CJK>
       (?$(K[@(B . "0x21F80") ; <CJK>
       (?$(K[A(B . "0x2215F") ; <CJK>
       (?$(K[B(B . "0x22160") ; <CJK>
       (?$(K[C(B . "0x222DA") ; <CJK>
       (?$(K[D(B . "0x222D2") ; <CJK>
       (?$(K[E(B . "0x222DD") ; <CJK>
       (?$(K[F(B . "0x2258E") ; <CJK>
       (?$(K[G(B . "0x22588") ; <CJK>
       (?$(K[H(B . "0x2256C") ; <CJK>
       (?$(K[I(B . "0x2289E") ; <CJK>
       (?$(K[J(B . "0x228C9") ; <CJK>
       (?$(K[K(B . "0x228A4") ; <CJK>
       (?$(K[L(B . "0x3998") ; <CJK>
       (?$(K[M(B . "0x228D9") ; <CJK>
       (?$(K[N(B . "0x228D2") ; <CJK>
       (?$(K[O(B . "0x228DA") ; <CJK>
       (?$(K[P(B . "0x228DD") ; <CJK>
       (?$(K[Q(B . "0x228CE") ; <CJK>
       (?$(K[R(B . "0x228FC") ; <CJK>
       (?$(K[S(B . "0x22A14") ; <CJK>
       (?$(K[T(B . "0x22A60") ; <CJK>
       (?$(K[U(B . "0x22DD7") ; <CJK>
       (?$(K[V(B . "0x22DCB") ; <CJK>
       (?$(K[W(B . "0x22DCD") ; <CJK>
       (?$(K[X(B . "0x22DD5") ; <CJK>
       (?$(K[Y(B . "0x22EE7") ; <CJK>
       (?$(K[Z(B . "0x23000") ; <CJK>
       (?$(K[[(B . "0x2300A") ; <CJK>
       (?$(K[\(B . "0x2300F") ; <CJK>
       (?$(K[](B . "0x23002") ; <CJK>
       (?$(K[^(B . "0x23001") ; <CJK>
       (?$(K[_(B . "0x2311D") ; <CJK>
       (?$(K[`(B . "0x232CA") ; <CJK>
       (?$(K[a(B . "0x232CB") ; <CJK>
       (?$(K[b(B . "0x232CD") ; <CJK>
       (?$(K[c(B . "0x2334F") ; <CJK>
       (?$(K[d(B . "0x2339C") ; <CJK>
       (?$(K[e(B . "0x23680") ; <CJK>
       (?$(K[f(B . "0x2370D") ; <CJK>
       (?$(K[g(B . "0x23702") ; <CJK>
       (?$(K[h(B . "0x3BF1") ; <CJK>
       (?$(K[i(B . "0x23707") ; <CJK>
       (?$(K[j(B . "0x236F7") ; <CJK>
       (?$(K[k(B . "0x236F8") ; <CJK>
       (?$(K[l(B . "0x236FD") ; <CJK>
       (?$(K[m(B . "0x23724") ; <CJK>
       (?$(K[n(B . "0x236FB") ; <CJK>
       (?$(K[o(B . "0x23739") ; <CJK>
       (?$(K[p(B . "0x2373A") ; <CJK>
       (?$(K[q(B . "0x23922") ; <CJK>
       (?$(K[r(B . "0x6BA9") ; <CJK>
       (?$(K[s(B . "0x23A6A") ; <CJK>
       (?$(K[t(B . "0x23A6D") ; <CJK>
       (?$(K[u(B . "0x23A74") ; <CJK>
       (?$(K[v(B . "0x23C0E") ; <CJK>
       (?$(K[w(B . "0x23FDF") ; <CJK>
       (?$(K[x(B . "0x2402B") ; <CJK>
       (?$(K[y(B . "0x23FE3") ; <CJK>
       (?$(K[z(B . "0x24026") ; <CJK>
       (?$(K[{(B . "0x2402A") ; <CJK>
       (?$(K[|(B . "0x24023") ; <CJK>
       (?$(K[}(B . "0x24035") ; <CJK>
       (?$(K[~(B . "0x2404A") ; <CJK>
       (?$(K\!(B . "0x243FD") ; <CJK>
       (?$(K\"(B . "0x24400") ; <CJK>
       (?$(K\#(B . "0x2441E") ; <CJK>
       (?$(K\$(B . "0x243FF") ; <CJK>
       (?$(K\%(B . "0x2459E") ; <CJK>
       (?$(K\&(B . "0x245FA") ; <CJK>
       (?$(K\'(B . "0x246F1") ; <CJK>
       (?$(K\((B . "0x24895") ; <CJK>
       (?$(K\)(B . "0x248A8") ; <CJK>
       (?$(K\*(B . "0x248A6") ; <CJK>
       (?$(K\+(B . "0x24A6E") ; <CJK>
       (?$(K\,(B . "0x24A83") ; <CJK>
       (?$(K\-(B . "0x24A6D") ; <CJK>
       (?$(K\.(B . "0x24B8F") ; <CJK>
       (?$(K\/(B . "0x3F6A") ; <CJK>
       (?$(K\0(B . "0x24CDF") ; <CJK>
       (?$(K\1(B . "0x24CD5") ; <CJK>
       (?$(K\2(B . "0x24CE0") ; <CJK>
       (?$(K\3(B . "0x24CD3") ; <CJK>
       (?$(K\4(B . "0x24CD8") ; <CJK>
       (?$(K\5(B . "0x24E8C") ; <CJK>
       (?$(K\6(B . "0x764B") ; <CJK>
       (?$(K\7(B . "0x24E94") ; <CJK>
       (?$(K\8(B . "0x24E96") ; <CJK>
       (?$(K\9(B . "0x24E85") ; <CJK>
       (?$(K\:(B . "0x24E8F") ; <CJK>
       (?$(K\;(B . "0x24EA9") ; <CJK>
       (?$(K\<(B . "0x24E8E") ; <CJK>
       (?$(K\=(B . "0x24E90") ; <CJK>
       (?$(K\>(B . "0x24EB8") ; <CJK>
       (?$(K\?(B . "0x24EC3") ; <CJK>
       (?$(K\@(B . "0x24EBB") ; <CJK>
       (?$(K\A(B . "0x24FA5") ; <CJK>
       (?$(K\B(B . "0x24FA2") ; <CJK>
       (?$(K\C(B . "0x76A2") ; <CJK>
       (?$(K\D(B . "0x24FA3") ; <CJK>
       (?$(K\E(B . "0x250B5") ; <CJK>
       (?$(K\F(B . "0x250AC") ; <CJK>
       (?$(K\G(B . "0x250A8") ; <CJK>
       (?$(K\H(B . "0x252AD") ; <CJK>
       (?$(K\I(B . "0x252B8") ; <CJK>
       (?$(K\J(B . "0x252B4") ; <CJK>
       (?$(K\K(B . "0x252AE") ; <CJK>
       (?$(K\L(B . "0x252B6") ; <CJK>
       (?$(K\M(B . "0x4485") ; <CJK>
       (?$(K\N(B . "0x252C1") ; <CJK>
       (?$(K\O(B . "0x252BF") ; <CJK>
       (?$(K\P(B . "0x25392") ; <CJK>
       (?$(K\Q(B . "0x25400") ; <CJK>
       (?$(K\R(B . "0x25401") ; <CJK>
       (?$(K\S(B . "0x25575") ; <CJK>
       (?$(K\T(B . "0x25572") ; <CJK>
       (?$(K\U(B . "0x25578") ; <CJK>
       (?$(K\V(B . "0x25570") ; <CJK>
       (?$(K\W(B . "0x2557E") ; <CJK>
       (?$(K\X(B . "0x2557D") ; <CJK>
       (?$(K\Y(B . "0x2557F") ; <CJK>
       (?$(K\Z(B . "0x256EF") ; <CJK>
       (?$(K\[(B . "0x2586D") ; <CJK>
       (?$(K\\(B . "0x2588E") ; <CJK>
       (?$(K\](B . "0x2588F") ; <CJK>
       (?$(K\^(B . "0x2588A") ; <CJK>
       (?$(K\_(B . "0x2588D") ; <CJK>
       (?$(K\`(B . "0x25895") ; <CJK>
       (?$(K\a(B . "0x2588B") ; <CJK>
       (?$(K\b(B . "0x2588C") ; <CJK>
       (?$(K\c(B . "0x258B0") ; <CJK>
       (?$(K\d(B . "0x25893") ; <CJK>
       (?$(K\e(B . "0x259FC") ; <CJK>
       (?$(K\f(B . "0x25A15") ; <CJK>
       (?$(K\g(B . "0x25A0E") ; <CJK>
       (?$(K\h(B . "0x25A18") ; <CJK>
       (?$(K\i(B . "0x25A11") ; <CJK>
       (?$(K\j(B . "0x25A0D") ; <CJK>
       (?$(K\k(B . "0x25ABB") ; <CJK>
       (?$(K\l(B . "0x25AB3") ; <CJK>
       (?$(K\m(B . "0x4239") ; <CJK>
       (?$(K\n(B . "0x25CA1") ; <CJK>
       (?$(K\o(B . "0x25C9A") ; <CJK>
       (?$(K\p(B . "0x25C84") ; <CJK>
       (?$(K\q(B . "0x25CA0") ; <CJK>
       (?$(K\r(B . "0x25C86") ; <CJK>
       (?$(K\s(B . "0x25C9D") ; <CJK>
       (?$(K\t(B . "0x25CAA") ; <CJK>
       (?$(K\u(B . "0x25C78") ; <CJK>
       (?$(K\v(B . "0x25C8D") ; <CJK>
       (?$(K\w(B . "0x25C8A") ; <CJK>
       (?$(K\x(B . "0x25CA6") ; <CJK>
       (?$(K\y(B . "0x25C7A") ; <CJK>
       (?$(K\z(B . "0x25C97") ; <CJK>
       (?$(K\{(B . "0x25C88") ; <CJK>
       (?$(K\|(B . "0x25C8E") ; <CJK>
       (?$(K\}(B . "0x423D") ; <CJK>
       (?$(K\~(B . "0x4244") ; <CJK>
       (?$(K]!(B . "0x25C76") ; <CJK>
       (?$(K]"(B . "0x25C81") ; <CJK>
       (?$(K]#(B . "0x25C85") ; <CJK>
       (?$(K]$(B . "0x25C75") ; <CJK>
       (?$(K]%(B . "0x25CA8") ; <CJK>
       (?$(K]&(B . "0x25C8F") ; <CJK>
       (?$(K]'(B . "0x25C91") ; <CJK>
       (?$(K]((B . "0x25CA2") ; <CJK>
       (?$(K])(B . "0x25C9C") ; <CJK>
       (?$(K]*(B . "0x25C89") ; <CJK>
       (?$(K]+(B . "0x25C7F") ; <CJK>
       (?$(K],(B . "0x25C96") ; <CJK>
       (?$(K]-(B . "0x25C79") ; <CJK>
       (?$(K].(B . "0x25C9F") ; <CJK>
       (?$(K]/(B . "0x25CA7") ; <CJK>
       (?$(K]0(B . "0x4246") ; <CJK>
       (?$(K]1(B . "0x25C87") ; <CJK>
       (?$(K]2(B . "0x25C9B") ; <CJK>
       (?$(K]3(B . "0x25CA5") ; <CJK>
       (?$(K]4(B . "0x25C8B") ; <CJK>
       (?$(K]5(B . "0x25CC9") ; <CJK>
       (?$(K]6(B . "0x25EFF") ; <CJK>
       (?$(K]7(B . "0x25F03") ; <CJK>
       (?$(K]8(B . "0x25F00") ; <CJK>
       (?$(K]9(B . "0x25F02") ; <CJK>
       (?$(K]:(B . "0x25F04") ; <CJK>
       (?$(K];(B . "0x25F05") ; <CJK>
       (?$(K]<(B . "0x25EE6") ; <CJK>
       (?$(K]=(B . "0x25F1F") ; <CJK>
       (?$(K]>(B . "0x26114") ; <CJK>
       (?$(K]?(B . "0x430E") ; <CJK>
       (?$(K]@(B . "0x2610C") ; <CJK>
       (?$(K]A(B . "0x2610F") ; <CJK>
       (?$(K]B(B . "0x26119") ; <CJK>
       (?$(K]C(B . "0x2610B") ; <CJK>
       (?$(K]D(B . "0x26113") ; <CJK>
       (?$(K]E(B . "0x260D5") ; <CJK>
       (?$(K]F(B . "0x4310") ; <CJK>
       (?$(K]G(B . "0x2611C") ; <CJK>
       (?$(K]H(B . "0x26250") ; <CJK>
       (?$(K]I(B . "0x2624E") ; <CJK>
       (?$(K]J(B . "0x26312") ; <CJK>
       (?$(K]K(B . "0x263B9") ; <CJK>
       (?$(K]L(B . "0x26485") ; <CJK>
       (?$(K]M(B . "0x26488") ; <CJK>
       (?$(K]N(B . "0x26490") ; <CJK>
       (?$(K]O(B . "0x26513") ; <CJK>
       (?$(K]P(B . "0x265D0") ; <CJK>
       (?$(K]Q(B . "0x265D1") ; <CJK>
       (?$(K]R(B . "0x265D2") ; <CJK>
       (?$(K]S(B . "0x265D7") ; <CJK>
       (?$(K]T(B . "0x265D6") ; <CJK>
       (?$(K]U(B . "0x265E5") ; <CJK>
       (?$(K]V(B . "0x26846") ; <CJK>
       (?$(K]W(B . "0x2686B") ; <CJK>
       (?$(K]X(B . "0x26845") ; <CJK>
       (?$(K]Y(B . "0x2683F") ; <CJK>
       (?$(K]Z(B . "0x2683E") ; <CJK>
       (?$(K][(B . "0x443E") ; <CJK>
       (?$(K]\(B . "0x2686A") ; <CJK>
       (?$(K]](B . "0x26868") ; <CJK>
       (?$(K]^(B . "0x2684C") ; <CJK>
       (?$(K]_(B . "0x26923") ; <CJK>
       (?$(K]`(B . "0x26922") ; <CJK>
       (?$(K]a(B . "0x26997") ; <CJK>
       (?$(K]b(B . "0x26991") ; <CJK>
       (?$(K]c(B . "0x25AB5") ; <CJK>
       (?$(K]d(B . "0x26998") ; <CJK>
       (?$(K]e(B . "0x2699C") ; <CJK>
       (?$(K]f(B . "0x26A89") ; <CJK>
       (?$(K]g(B . "0x4484") ; <CJK>
       (?$(K]h(B . "0x26A8B") ; <CJK>
       (?$(K]i(B . "0x26A8A") ; <CJK>
       (?$(K]j(B . "0x26A8D") ; <CJK>
       (?$(K]k(B . "0x26A8E") ; <CJK>
       (?$(K]l(B . "0x26A88") ; <CJK>
       (?$(K]m(B . "0x26F4E") ; <CJK>
       (?$(K]n(B . "0x26F44") ; <CJK>
       (?$(K]o(B . "0x26F37") ; <CJK>
       (?$(K]p(B . "0x26F75") ; <CJK>
       (?$(K]q(B . "0x26F54") ; <CJK>
       (?$(K]r(B . "0x26F76") ; <CJK>
       (?$(K]s(B . "0x26F34") ; <CJK>
       (?$(K]t(B . "0x26F6B") ; <CJK>
       (?$(K]u(B . "0x26F32") ; <CJK>
       (?$(K]v(B . "0x26F57") ; <CJK>
       (?$(K]w(B . "0x26F52") ; <CJK>
       (?$(K]x(B . "0x26F45") ; <CJK>
       (?$(K]y(B . "0x4549") ; <CJK>
       (?$(K]z(B . "0x26EB1") ; <CJK>
       (?$(K]{(B . "0x26F4B") ; <CJK>
       (?$(K]|(B . "0x26F47") ; <CJK>
       (?$(K]}(B . "0x26F33") ; <CJK>
       (?$(K]~(B . "0x26F40") ; <CJK>
       (?$(K^!(B . "0x26F3C") ; <CJK>
       (?$(K^"(B . "0x26F43") ; <CJK>
       (?$(K^#(B . "0x26F4F") ; <CJK>
       (?$(K^$(B . "0x26F55") ; <CJK>
       (?$(K^%(B . "0x26F41") ; <CJK>
       (?$(K^&(B . "0x26FB2") ; <CJK>
       (?$(K^'(B . "0x26FC0") ; <CJK>
       (?$(K^((B . "0x27434") ; <CJK>
       (?$(K^)(B . "0x273F9") ; <CJK>
       (?$(K^*(B . "0x27419") ; <CJK>
       (?$(K^+(B . "0x2740D") ; <CJK>
       (?$(K^,(B . "0x273FA") ; <CJK>
       (?$(K^-(B . "0x2741E") ; <CJK>
       (?$(K^.(B . "0x2741F") ; <CJK>
       (?$(K^/(B . "0x2740E") ; <CJK>
       (?$(K^0(B . "0x27440") ; <CJK>
       (?$(K^1(B . "0x27408") ; <CJK>
       (?$(K^2(B . "0x45DF") ; <CJK>
       (?$(K^3(B . "0x27413") ; <CJK>
       (?$(K^4(B . "0x2744C") ; <CJK>
       (?$(K^5(B . "0x45F0") ; <CJK>
       (?$(K^6(B . "0x275CC") ; <CJK>
       (?$(K^7(B . "0x275CB") ; <CJK>
       (?$(K^8(B . "0x27724") ; <CJK>
       (?$(K^9(B . "0x27725") ; <CJK>
       (?$(K^:(B . "0x2773D") ; <CJK>
       (?$(K^;(B . "0x27720") ; <CJK>
       (?$(K^<(B . "0x27727") ; <CJK>
       (?$(K^=(B . "0x27726") ; <CJK>
       (?$(K^>(B . "0x2771D") ; <CJK>
       (?$(K^?(B . "0x2771E") ; <CJK>
       (?$(K^@(B . "0x27732") ; <CJK>
       (?$(K^A(B . "0x2776C") ; <CJK>
       (?$(K^B(B . "0x27759") ; <CJK>
       (?$(K^C(B . "0x468A") ; <CJK>
       (?$(K^D(B . "0x2787A") ; <CJK>
       (?$(K^E(B . "0x27879") ; <CJK>
       (?$(K^F(B . "0x2791B") ; <CJK>
       (?$(K^G(B . "0x2792E") ; <CJK>
       (?$(K^H(B . "0x27923") ; <CJK>
       (?$(K^I(B . "0x27920") ; <CJK>
       (?$(K^J(B . "0x2791F") ; <CJK>
       (?$(K^K(B . "0x27AB6") ; <CJK>
       (?$(K^L(B . "0x27AB9") ; <CJK>
       (?$(K^M(B . "0x27AA1") ; <CJK>
       (?$(K^N(B . "0x27AA3") ; <CJK>
       (?$(K^O(B . "0x27AA8") ; <CJK>
       (?$(K^P(B . "0x27AAF") ; <CJK>
       (?$(K^Q(B . "0x27A9A") ; <CJK>
       (?$(K^R(B . "0x27A99") ; <CJK>
       (?$(K^S(B . "0x27AA2") ; <CJK>
       (?$(K^T(B . "0x27A9D") ; <CJK>
       (?$(K^U(B . "0x4702") ; <CJK>
       (?$(K^V(B . "0x27AAB") ; <CJK>
       (?$(K^W(B . "0x27BC9") ; <CJK>
       (?$(K^X(B . "0x27BFE") ; <CJK>
       (?$(K^Y(B . "0x27C00") ; <CJK>
       (?$(K^Z(B . "0x27BFC") ; <CJK>
       (?$(K^[(B . "0x27C07") ; <CJK>
       (?$(K^\(B . "0x27C75") ; <CJK>
       (?$(K^](B . "0x27C72") ; <CJK>
       (?$(K^^(B . "0x27C73") ; <CJK>
       (?$(K^_(B . "0x27C74") ; <CJK>
       (?$(K^`(B . "0x27CFA") ; <CJK>
       (?$(K^a(B . "0x27CFC") ; <CJK>
       (?$(K^b(B . "0x27CF8") ; <CJK>
       (?$(K^c(B . "0x27CF6") ; <CJK>
       (?$(K^d(B . "0x27CFB") ; <CJK>
       (?$(K^e(B . "0x27DCD") ; <CJK>
       (?$(K^f(B . "0x27DD1") ; <CJK>
       (?$(K^g(B . "0x27DCF") ; <CJK>
       (?$(K^h(B . "0x27E74") ; <CJK>
       (?$(K^i(B . "0x27E72") ; <CJK>
       (?$(K^j(B . "0x27E73") ; <CJK>
       (?$(K^k(B . "0x27F54") ; <CJK>
       (?$(K^l(B . "0x27F51") ; <CJK>
       (?$(K^m(B . "0x47C0") ; <CJK>
       (?$(K^n(B . "0x27F53") ; <CJK>
       (?$(K^o(B . "0x27F49") ; <CJK>
       (?$(K^p(B . "0x27F4C") ; <CJK>
       (?$(K^q(B . "0x27F4A") ; <CJK>
       (?$(K^r(B . "0x27F4F") ; <CJK>
       (?$(K^s(B . "0x27F56") ; <CJK>
       (?$(K^t(B . "0x28100") ; <CJK>
       (?$(K^u(B . "0x280D5") ; <CJK>
       (?$(K^v(B . "0x280D7") ; <CJK>
       (?$(K^w(B . "0x280FF") ; <CJK>
       (?$(K^x(B . "0x280D9") ; <CJK>
       (?$(K^y(B . "0x280E3") ; <CJK>
       (?$(K^z(B . "0x280D3") ; <CJK>
       (?$(K^{(B . "0x4815") ; <CJK>
       (?$(K^|(B . "0x280D8") ; <CJK>
       (?$(K^}(B . "0x280D4") ; <CJK>
       (?$(K^~(B . "0x280DE") ; <CJK>
       (?$(K_!(B . "0x28271") ; <CJK>
       (?$(K_"(B . "0x28374") ; <CJK>
       (?$(K_#(B . "0x28388") ; <CJK>
       (?$(K_$(B . "0x2837F") ; <CJK>
       (?$(K_%(B . "0x2836B") ; <CJK>
       (?$(K_&(B . "0x28387") ; <CJK>
       (?$(K_'(B . "0x28379") ; <CJK>
       (?$(K_((B . "0x28378") ; <CJK>
       (?$(K_)(B . "0x28389") ; <CJK>
       (?$(K_*(B . "0x28380") ; <CJK>
       (?$(K_+(B . "0x28376") ; <CJK>
       (?$(K_,(B . "0x28429") ; <CJK>
       (?$(K_-(B . "0x28428") ; <CJK>
       (?$(K_.(B . "0x2842F") ; <CJK>
       (?$(K_/(B . "0x285E5") ; <CJK>
       (?$(K_0(B . "0x28604") ; <CJK>
       (?$(K_1(B . "0x28603") ; <CJK>
       (?$(K_2(B . "0x285F0") ; <CJK>
       (?$(K_3(B . "0x285E8") ; <CJK>
       (?$(K_4(B . "0x285EA") ; <CJK>
       (?$(K_5(B . "0x285F1") ; <CJK>
       (?$(K_6(B . "0x28601") ; <CJK>
       (?$(K_7(B . "0x28602") ; <CJK>
       (?$(K_8(B . "0x287A9") ; <CJK>
       (?$(K_9(B . "0x287AB") ; <CJK>
       (?$(K_:(B . "0x287B7") ; <CJK>
       (?$(K_;(B . "0x287B6") ; <CJK>
       (?$(K_<(B . "0x48E2") ; <CJK>
       (?$(K_=(B . "0x288A0") ; <CJK>
       (?$(K_>(B . "0x2888E") ; <CJK>
       (?$(K_?(B . "0x28886") ; <CJK>
       (?$(K_@(B . "0x28887") ; <CJK>
       (?$(K_A(B . "0x28885") ; <CJK>
       (?$(K_B(B . "0x2888B") ; <CJK>
       (?$(K_C(B . "0x28888") ; <CJK>
       (?$(K_D(B . "0x28890") ; <CJK>
       (?$(K_E(B . "0x2891A") ; <CJK>
       (?$(K_F(B . "0x28934") ; <CJK>
       (?$(K_G(B . "0x28A37") ; <CJK>
       (?$(K_H(B . "0x28A2F") ; <CJK>
       (?$(K_I(B . "0x28A30") ; <CJK>
       (?$(K_J(B . "0x28A39") ; <CJK>
       (?$(K_K(B . "0x28A34") ; <CJK>
       (?$(K_L(B . "0x28A33") ; <CJK>
       (?$(K_M(B . "0x28A85") ; <CJK>
       (?$(K_N(B . "0x28A84") ; <CJK>
       (?$(K_O(B . "0x28A3A") ; <CJK>
       (?$(K_P(B . "0x28C9F") ; <CJK>
       (?$(K_Q(B . "0x28D69") ; <CJK>
       (?$(K_R(B . "0x28D6C") ; <CJK>
       (?$(K_S(B . "0x28D6A") ; <CJK>
       (?$(K_T(B . "0x28D67") ; <CJK>
       (?$(K_U(B . "0x28D6B") ; <CJK>
       (?$(K_V(B . "0x28F3F") ; <CJK>
       (?$(K_W(B . "0x28F40") ; <CJK>
       (?$(K_X(B . "0x2900B") ; <CJK>
       (?$(K_Y(B . "0x290D2") ; <CJK>
       (?$(K_Z(B . "0x290F8") ; <CJK>
       (?$(K_[(B . "0x29101") ; <CJK>
       (?$(K_\(B . "0x290FA") ; <CJK>
       (?$(K_](B . "0x29116") ; <CJK>
       (?$(K_^(B . "0x2F9F6") ; <CJK>
       (?$(K__(B . "0x2922C") ; <CJK>
       (?$(K_`(B . "0x2922D") ; <CJK>
       (?$(K_a(B . "0x2922F") ; <CJK>
       (?$(K_b(B . "0x2922E") ; <CJK>
       (?$(K_c(B . "0x292C1") ; <CJK>
       (?$(K_d(B . "0x292F5") ; <CJK>
       (?$(K_e(B . "0x292C4") ; <CJK>
       (?$(K_f(B . "0x292DE") ; <CJK>
       (?$(K_g(B . "0x292CC") ; <CJK>
       (?$(K_h(B . "0x292D2") ; <CJK>
       (?$(K_i(B . "0x292C2") ; <CJK>
       (?$(K_j(B . "0x292CD") ; <CJK>
       (?$(K_k(B . "0x292CF") ; <CJK>
       (?$(K_l(B . "0x292DD") ; <CJK>
       (?$(K_m(B . "0x292C8") ; <CJK>
       (?$(K_n(B . "0x293BA") ; <CJK>
       (?$(K_o(B . "0x293BE") ; <CJK>
       (?$(K_p(B . "0x293BF") ; <CJK>
       (?$(K_q(B . "0x2942E") ; <CJK>
       (?$(K_r(B . "0x29430") ; <CJK>
       (?$(K_s(B . "0x294E7") ; <CJK>
       (?$(K_t(B . "0x294EE") ; <CJK>
       (?$(K_u(B . "0x294E8") ; <CJK>
       (?$(K_v(B . "0x294E6") ; <CJK>
       (?$(K_w(B . "0x294E2") ; <CJK>
       (?$(K_x(B . "0x294E4") ; <CJK>
       (?$(K_y(B . "0x294FB") ; <CJK>
       (?$(K_z(B . "0x294FC") ; <CJK>
       (?$(K_{(B . "0x294EA") ; <CJK>
       (?$(K_|(B . "0x295ED") ; <CJK>
       (?$(K_}(B . "0x295F6") ; <CJK>
       (?$(K_~(B . "0x295F3") ; <CJK>
       (?$(K`!(B . "0x295F4") ; <CJK>
       (?$(K`"(B . "0x295F1") ; <CJK>
       (?$(K`#(B . "0x295F7") ; <CJK>
       (?$(K`$(B . "0x295F5") ; <CJK>
       (?$(K`%(B . "0x295EA") ; <CJK>
       (?$(K`&(B . "0x295EB") ; <CJK>
       (?$(K`'(B . "0x29700") ; <CJK>
       (?$(K`((B . "0x2972C") ; <CJK>
       (?$(K`)(B . "0x29712") ; <CJK>
       (?$(K`*(B . "0x2973D") ; <CJK>
       (?$(K`+(B . "0x29733") ; <CJK>
       (?$(K`,(B . "0x4B4D") ; <CJK>
       (?$(K`-(B . "0x29730") ; <CJK>
       (?$(K`.(B . "0x29740") ; <CJK>
       (?$(K`/(B . "0x29731") ; <CJK>
       (?$(K`0(B . "0x29757") ; <CJK>
       (?$(K`1(B . "0x4B4A") ; <CJK>
       (?$(K`2(B . "0x29735") ; <CJK>
       (?$(K`3(B . "0x29732") ; <CJK>
       (?$(K`4(B . "0x2972D") ; <CJK>
       (?$(K`5(B . "0x29736") ; <CJK>
       (?$(K`6(B . "0x29738") ; <CJK>
       (?$(K`7(B . "0x29762") ; <CJK>
       (?$(K`8(B . "0x2975F") ; <CJK>
       (?$(K`9(B . "0x2978A") ; <CJK>
       (?$(K`:(B . "0x298D6") ; <CJK>
       (?$(K`;(B . "0x298D8") ; <CJK>
       (?$(K`<(B . "0x298DD") ; <CJK>
       (?$(K`=(B . "0x298E4") ; <CJK>
       (?$(K`>(B . "0x298E3") ; <CJK>
       (?$(K`?(B . "0x29A4D") ; <CJK>
       (?$(K`@(B . "0x29AD7") ; <CJK>
       (?$(K`A(B . "0x29B4A") ; <CJK>
       (?$(K`B(B . "0x29B4C") ; <CJK>
       (?$(K`C(B . "0x29B50") ; <CJK>
       (?$(K`D(B . "0x29B4B") ; <CJK>
       (?$(K`E(B . "0x29B4E") ; <CJK>
       (?$(K`F(B . "0x29B4F") ; <CJK>
       (?$(K`G(B . "0x29C39") ; <CJK>
       (?$(K`H(B . "0x29CD2") ; <CJK>
       (?$(K`I(B . "0x29CCD") ; <CJK>
       (?$(K`J(B . "0x29CD3") ; <CJK>
       (?$(K`K(B . "0x29CE1") ; <CJK>
       (?$(K`L(B . "0x29CCE") ; <CJK>
       (?$(K`M(B . "0x29CD5") ; <CJK>
       (?$(K`N(B . "0x29CDD") ; <CJK>
       (?$(K`O(B . "0x29CD4") ; <CJK>
       (?$(K`P(B . "0x29CCF") ; <CJK>
       (?$(K`Q(B . "0x29DCB") ; <CJK>
       (?$(K`R(B . "0x29DA6") ; <CJK>
       (?$(K`S(B . "0x29DC2") ; <CJK>
       (?$(K`T(B . "0x29DA5") ; <CJK>
       (?$(K`U(B . "0x29DA9") ; <CJK>
       (?$(K`V(B . "0x29DA2") ; <CJK>
       (?$(K`W(B . "0x29DA4") ; <CJK>
       (?$(K`X(B . "0x29DB0") ; <CJK>
       (?$(K`Y(B . "0x29DCC") ; <CJK>
       (?$(K`Z(B . "0x29DAF") ; <CJK>
       (?$(K`[(B . "0x29DBF") ; <CJK>
       (?$(K`\(B . "0x2A024") ; <CJK>
       (?$(K`](B . "0x2A01A") ; <CJK>
       (?$(K`^(B . "0x2A014") ; <CJK>
       (?$(K`_(B . "0x2A03A") ; <CJK>
       (?$(K``(B . "0x2A020") ; <CJK>
       (?$(K`a(B . "0x2A01B") ; <CJK>
       (?$(K`b(B . "0x2A021") ; <CJK>
       (?$(K`c(B . "0x2A025") ; <CJK>
       (?$(K`d(B . "0x2A01E") ; <CJK>
       (?$(K`e(B . "0x2A03F") ; <CJK>
       (?$(K`f(B . "0x2A040") ; <CJK>
       (?$(K`g(B . "0x2A018") ; <CJK>
       (?$(K`h(B . "0x2A02C") ; <CJK>
       (?$(K`i(B . "0x2A015") ; <CJK>
       (?$(K`j(B . "0x2A02D") ; <CJK>
       (?$(K`k(B . "0x2A01F") ; <CJK>
       (?$(K`l(B . "0x2A029") ; <CJK>
       (?$(K`m(B . "0x2A04B") ; <CJK>
       (?$(K`n(B . "0x2A2B3") ; <CJK>
       (?$(K`o(B . "0x2A2A5") ; <CJK>
       (?$(K`p(B . "0x2A2A7") ; <CJK>
       (?$(K`q(B . "0x2A2AB") ; <CJK>
       (?$(K`r(B . "0x2A2A6") ; <CJK>
       (?$(K`s(B . "0x2A2AA") ; <CJK>
       (?$(K`t(B . "0x2A322") ; <CJK>
       (?$(K`u(B . "0x2A323") ; <CJK>
       (?$(K`v(B . "0x2A3A1") ; <CJK>
       (?$(K`w(B . "0x2A3A3") ; <CJK>
       (?$(K`x(B . "0x2A3A0") ; <CJK>
       (?$(K`y(B . "0x2A3BD") ; <CJK>
       (?$(K`z(B . "0x2A3BA") ; <CJK>
       (?$(K`{(B . "0x2A3FA") ; <CJK>
       (?$(K`|(B . "0x2A3F8") ; <CJK>
       (?$(K`}(B . "0x2A3FC") ; <CJK>
       (?$(K`~(B . "0x2A3F6") ; <CJK>
       (?$(Ka!(B . "0x2A434") ; <CJK>
       (?$(Ka"(B . "0x2A443") ; <CJK>
       (?$(Ka#(B . "0x4D63") ; <CJK>
       (?$(Ka$(B . "0x2A4D4") ; <CJK>
       (?$(Ka%(B . "0x2A50D") ; <CJK>
       (?$(Ka&(B . "0x2A543") ; <CJK>
       (?$(Ka'(B . "0x2A541") ; <CJK>
       (?$(Ka((B . "0x2A53D") ; <CJK>
       (?$(Ka)(B . "0x2A540") ; <CJK>
       (?$(Ka*(B . "0x2A53E") ; <CJK>
       (?$(Ka+(B . "0x2A53F") ; <CJK>
       (?$(Ka,(B . "0x2A546") ; <CJK>
       (?$(Ka-(B . "0x4D93") ; <CJK>
       (?$(Ka.(B . "0x2A5D4") ; <CJK>
       (?$(Ka/(B . "0x20435") ; <CJK>
       (?$(Ka0(B . "0x20436") ; <CJK>
       (?$(Ka1(B . "0x20432") ; <CJK>
       (?$(Ka2(B . "0x2043A") ; <CJK>
       (?$(Ka3(B . "0x204C8") ; <CJK>
       (?$(Ka4(B . "0x20536") ; <CJK>
       (?$(Ka5(B . "0x2061E") ; <CJK>
       (?$(Ka6(B . "0x2061D") ; <CJK>
       (?$(Ka7(B . "0x2061F") ; <CJK>
       (?$(Ka8(B . "0x2081C") ; <CJK>
       (?$(Ka9(B . "0x2081D") ; <CJK>
       (?$(Ka:(B . "0x20820") ; <CJK>
       (?$(Ka;(B . "0x350E") ; <CJK>
       (?$(Ka<(B . "0x208C0") ; <CJK>
       (?$(Ka=(B . "0x2109A") ; <CJK>
       (?$(Ka>(B . "0x21093") ; <CJK>
       (?$(Ka?(B . "0x210DD") ; <CJK>
       (?$(Ka@(B . "0x360A") ; <CJK>
       (?$(KaA(B . "0x210A3") ; <CJK>
       (?$(KaB(B . "0x210A9") ; <CJK>
       (?$(KaC(B . "0x2109C") ; <CJK>
       (?$(KaD(B . "0x2109B") ; <CJK>
       (?$(KaE(B . "0x360D") ; <CJK>
       (?$(KaF(B . "0x21097") ; <CJK>
       (?$(KaG(B . "0x214B1") ; <CJK>
       (?$(KaH(B . "0x214CA") ; <CJK>
       (?$(KaI(B . "0x214B3") ; <CJK>
       (?$(KaJ(B . "0x214CD") ; <CJK>
       (?$(KaK(B . "0x218EA") ; <CJK>
       (?$(KaL(B . "0x218EE") ; <CJK>
       (?$(KaM(B . "0x218EF") ; <CJK>
       (?$(KaN(B . "0x21ADF") ; <CJK>
       (?$(KaO(B . "0x21B50") ; <CJK>
       (?$(KaP(B . "0x21BBB") ; <CJK>
       (?$(KaQ(B . "0x21F88") ; <CJK>
       (?$(KaR(B . "0x21F89") ; <CJK>
       (?$(KaS(B . "0x21F8C") ; <CJK>
       (?$(KaT(B . "0x21F85") ; <CJK>
       (?$(KaU(B . "0x21F5E") ; <CJK>
       (?$(KaV(B . "0x21F94") ; <CJK>
       (?$(KaW(B . "0x21F95") ; <CJK>
       (?$(KaX(B . "0x2216B") ; <CJK>
       (?$(KaY(B . "0x2216A") ; <CJK>
       (?$(KaZ(B . "0x22169") ; <CJK>
       (?$(Ka[(B . "0x222E3") ; <CJK>
       (?$(Ka\(B . "0x222F1") ; <CJK>
       (?$(Ka](B . "0x22437") ; <CJK>
       (?$(Ka^(B . "0x22433") ; <CJK>
       (?$(Ka_(B . "0x22591") ; <CJK>
       (?$(Ka`(B . "0x2258F") ; <CJK>
       (?$(Kaa(B . "0x22597") ; <CJK>
       (?$(Kab(B . "0x228D4") ; <CJK>
       (?$(Kac(B . "0x228DE") ; <CJK>
       (?$(Kad(B . "0x228D3") ; <CJK>
       (?$(Kae(B . "0x228E0") ; <CJK>
       (?$(Kaf(B . "0x22943") ; <CJK>
       (?$(Kag(B . "0x2290B") ; <CJK>
       (?$(Kah(B . "0x228FF") ; <CJK>
       (?$(Kai(B . "0x22904") ; <CJK>
       (?$(Kaj(B . "0x22907") ; <CJK>
       (?$(Kak(B . "0x22DF9") ; <CJK>
       (?$(Kal(B . "0x22DFA") ; <CJK>
       (?$(Kam(B . "0x22DFB") ; <CJK>
       (?$(Kan(B . "0x22DF8") ; <CJK>
       (?$(Kao(B . "0x23012") ; <CJK>
       (?$(Kap(B . "0x23010") ; <CJK>
       (?$(Kaq(B . "0x2311F") ; <CJK>
       (?$(Kar(B . "0x232DF") ; <CJK>
       (?$(Kas(B . "0x232E3") ; <CJK>
       (?$(Kat(B . "0x23352") ; <CJK>
       (?$(Kau(B . "0x233A9") ; <CJK>
       (?$(Kav(B . "0x23765") ; <CJK>
       (?$(Kaw(B . "0x23787") ; <CJK>
       (?$(Kax(B . "0x23742") ; <CJK>
       (?$(Kay(B . "0x23752") ; <CJK>
       (?$(Kaz(B . "0x2374C") ; <CJK>
       (?$(Ka{(B . "0x2369F") ; <CJK>
       (?$(Ka|(B . "0x23701") ; <CJK>
       (?$(Ka}(B . "0x23748") ; <CJK>
       (?$(Ka~(B . "0x2374F") ; <CJK>
       (?$(Kb!(B . "0x2377E") ; <CJK>
       (?$(Kb"(B . "0x2374D") ; <CJK>
       (?$(Kb#(B . "0x23758") ; <CJK>
       (?$(Kb$(B . "0x23747") ; <CJK>
       (?$(Kb%(B . "0x2375E") ; <CJK>
       (?$(Kb&(B . "0x23749") ; <CJK>
       (?$(Kb'(B . "0x2374E") ; <CJK>
       (?$(Kb((B . "0x2375D") ; <CJK>
       (?$(Kb)(B . "0x2375A") ; <CJK>
       (?$(Kb*(B . "0x23786") ; <CJK>
       (?$(Kb+(B . "0x23751") ; <CJK>
       (?$(Kb,(B . "0x23929") ; <CJK>
       (?$(Kb-(B . "0x239A6") ; <CJK>
       (?$(Kb.(B . "0x239A7") ; <CJK>
       (?$(Kb/(B . "0x23A70") ; <CJK>
       (?$(Kb0(B . "0x23A6F") ; <CJK>
       (?$(Kb1(B . "0x23AD3") ; <CJK>
       (?$(Kb2(B . "0x23AD2") ; <CJK>
       (?$(Kb3(B . "0x23C28") ; <CJK>
       (?$(Kb4(B . "0x23C1B") ; <CJK>
       (?$(Kb5(B . "0x23C1A") ; <CJK>
       (?$(Kb6(B . "0x23C1C") ; <CJK>
       (?$(Kb7(B . "0x23C21") ; <CJK>
       (?$(Kb8(B . "0x24032") ; <CJK>
       (?$(Kb9(B . "0x24066") ; <CJK>
       (?$(Kb:(B . "0x2407D") ; <CJK>
       (?$(Kb;(B . "0x24073") ; <CJK>
       (?$(Kb<(B . "0x2407F") ; <CJK>
       (?$(Kb=(B . "0x24065") ; <CJK>
       (?$(Kb>(B . "0x24080") ; <CJK>
       (?$(Kb?(B . "0x24061") ; <CJK>
       (?$(Kb@(B . "0x24075") ; <CJK>
       (?$(KbA(B . "0x2406E") ; <CJK>
       (?$(KbB(B . "0x24067") ; <CJK>
       (?$(KbC(B . "0x24071") ; <CJK>
       (?$(KbD(B . "0x2406C") ; <CJK>
       (?$(KbE(B . "0x24063") ; <CJK>
       (?$(KbF(B . "0x24062") ; <CJK>
       (?$(KbG(B . "0x24083") ; <CJK>
       (?$(KbH(B . "0x240B2") ; <CJK>
       (?$(KbI(B . "0x24081") ; <CJK>
       (?$(KbJ(B . "0x2406F") ; <CJK>
       (?$(KbK(B . "0x2406B") ; <CJK>
       (?$(KbL(B . "0x24082") ; <CJK>
       (?$(KbM(B . "0x2408A") ; <CJK>
       (?$(KbN(B . "0x24429") ; <CJK>
       (?$(KbO(B . "0x24430") ; <CJK>
       (?$(KbP(B . "0x24431") ; <CJK>
       (?$(KbQ(B . "0x24597") ; <CJK>
       (?$(KbR(B . "0x24600") ; <CJK>
       (?$(KbS(B . "0x245FF") ; <CJK>
       (?$(KbT(B . "0x248B6") ; <CJK>
       (?$(KbU(B . "0x248B5") ; <CJK>
       (?$(KbV(B . "0x248C3") ; <CJK>
       (?$(KbW(B . "0x24A8D") ; <CJK>
       (?$(KbX(B . "0x24B18") ; <CJK>
       (?$(KbY(B . "0x24B9C") ; <CJK>
       (?$(KbZ(B . "0x24B9A") ; <CJK>
       (?$(Kb[(B . "0x24B99") ; <CJK>
       (?$(Kb\(B . "0x24EB7") ; <CJK>
       (?$(Kb](B . "0x24EC4") ; <CJK>
       (?$(Kb^(B . "0x24EC6") ; <CJK>
       (?$(Kb_(B . "0x24EC7") ; <CJK>
       (?$(Kb`(B . "0x24EBC") ; <CJK>
       (?$(Kba(B . "0x24EC0") ; <CJK>
       (?$(Kbb(B . "0x24EC5") ; <CJK>
       (?$(Kbc(B . "0x24ECD") ; <CJK>
       (?$(Kbd(B . "0x24EC1") ; <CJK>
       (?$(Kbe(B . "0x24EBE") ; <CJK>
       (?$(Kbf(B . "0x24FA7") ; <CJK>
       (?$(Kbg(B . "0x24FB8") ; <CJK>
       (?$(Kbh(B . "0x25023") ; <CJK>
       (?$(Kbi(B . "0x4074") ; <CJK>
       (?$(Kbj(B . "0x252E8") ; <CJK>
       (?$(Kbk(B . "0x252DE") ; <CJK>
       (?$(Kbl(B . "0x252E3") ; <CJK>
       (?$(Kbm(B . "0x252EF") ; <CJK>
       (?$(Kbn(B . "0x252DC") ; <CJK>
       (?$(Kbo(B . "0x252E4") ; <CJK>
       (?$(Kbp(B . "0x252E1") ; <CJK>
       (?$(Kbq(B . "0x252E5") ; <CJK>
       (?$(Kbr(B . "0x25395") ; <CJK>
       (?$(Kbs(B . "0x25394") ; <CJK>
       (?$(Kbt(B . "0x25393") ; <CJK>
       (?$(Kbu(B . "0x2538E") ; <CJK>
       (?$(Kbv(B . "0x25598") ; <CJK>
       (?$(Kbw(B . "0x2559C") ; <CJK>
       (?$(Kbx(B . "0x25599") ; <CJK>
       (?$(Kby(B . "0x255A0") ; <CJK>
       (?$(Kbz(B . "0x2559E") ; <CJK>
       (?$(Kb{(B . "0x25704") ; <CJK>
       (?$(Kb|(B . "0x258D3") ; <CJK>
       (?$(Kb}(B . "0x258B4") ; <CJK>
       (?$(Kb~(B . "0x258BB") ; <CJK>
       (?$(Kc!(B . "0x258B7") ; <CJK>
       (?$(Kc"(B . "0x258B8") ; <CJK>
       (?$(Kc#(B . "0x258BD") ; <CJK>
       (?$(Kc$(B . "0x258B6") ; <CJK>
       (?$(Kc%(B . "0x258B9") ; <CJK>
       (?$(Kc&(B . "0x258B5") ; <CJK>
       (?$(Kc'(B . "0x25A22") ; <CJK>
       (?$(Kc((B . "0x25A21") ; <CJK>
       (?$(Kc)(B . "0x25AC3") ; <CJK>
       (?$(Kc*(B . "0x25ABC") ; <CJK>
       (?$(Kc+(B . "0x25CFF") ; <CJK>
       (?$(Kc,(B . "0x25CE5") ; <CJK>
       (?$(Kc-(B . "0x25CF7") ; <CJK>
       (?$(Kc.(B . "0x25CD2") ; <CJK>
       (?$(Kc/(B . "0x25D00") ; <CJK>
       (?$(Kc0(B . "0x25CDB") ; <CJK>
       (?$(Kc1(B . "0x25CF0") ; <CJK>
       (?$(Kc2(B . "0x25CE2") ; <CJK>
       (?$(Kc3(B . "0x25CCD") ; <CJK>
       (?$(Kc4(B . "0x4256") ; <CJK>
       (?$(Kc5(B . "0x25CE1") ; <CJK>
       (?$(Kc6(B . "0x25CF2") ; <CJK>
       (?$(Kc7(B . "0x25CDC") ; <CJK>
       (?$(Kc8(B . "0x25CCC") ; <CJK>
       (?$(Kc9(B . "0x25CD6") ; <CJK>
       (?$(Kc:(B . "0x25CF3") ; <CJK>
       (?$(Kc;(B . "0x25CFA") ; <CJK>
       (?$(Kc<(B . "0x25CF6") ; <CJK>
       (?$(Kc=(B . "0x25CEC") ; <CJK>
       (?$(Kc>(B . "0x25CEA") ; <CJK>
       (?$(Kc?(B . "0x25CE3") ; <CJK>
       (?$(Kc@(B . "0x25CD0") ; <CJK>
       (?$(KcA(B . "0x425A") ; <CJK>
       (?$(KcB(B . "0x25C95") ; <CJK>
       (?$(KcC(B . "0x25CD5") ; <CJK>
       (?$(KcD(B . "0x25CF4") ; <CJK>
       (?$(KcE(B . "0x25CCB") ; <CJK>
       (?$(KcF(B . "0x25CDA") ; <CJK>
       (?$(KcG(B . "0x25CC8") ; <CJK>
       (?$(KcH(B . "0x25CDF") ; <CJK>
       (?$(KcI(B . "0x25CF5") ; <CJK>
       (?$(KcJ(B . "0x25CCF") ; <CJK>
       (?$(KcK(B . "0x25CC7") ; <CJK>
       (?$(KcL(B . "0x25CD7") ; <CJK>
       (?$(KcM(B . "0x25F24") ; <CJK>
       (?$(KcN(B . "0x42A3") ; <CJK>
       (?$(KcO(B . "0x25F1C") ; <CJK>
       (?$(KcP(B . "0x25F21") ; <CJK>
       (?$(KcQ(B . "0x25F1E") ; <CJK>
       (?$(KcR(B . "0x25F18") ; <CJK>
       (?$(KcS(B . "0x25F1B") ; <CJK>
       (?$(KcT(B . "0x42A8") ; <CJK>
       (?$(KcU(B . "0x26146") ; <CJK>
       (?$(KcV(B . "0x2614B") ; <CJK>
       (?$(KcW(B . "0x26148") ; <CJK>
       (?$(KcX(B . "0x26147") ; <CJK>
       (?$(KcY(B . "0x26167") ; <CJK>
       (?$(KcZ(B . "0x26154") ; <CJK>
       (?$(Kc[(B . "0x26315") ; <CJK>
       (?$(Kc\(B . "0x26322") ; <CJK>
       (?$(Kc](B . "0x263C5") ; <CJK>
       (?$(Kc^(B . "0x26329") ; <CJK>
       (?$(Kc_(B . "0x263C7") ; <CJK>
       (?$(Kc`(B . "0x2648D") ; <CJK>
       (?$(Kca(B . "0x2651B") ; <CJK>
       (?$(Kcb(B . "0x26520") ; <CJK>
       (?$(Kcc(B . "0x265E2") ; <CJK>
       (?$(Kcd(B . "0x265E7") ; <CJK>
       (?$(Kce(B . "0x265E8") ; <CJK>
       (?$(Kcf(B . "0x265E1") ; <CJK>
       (?$(Kcg(B . "0x26872") ; <CJK>
       (?$(Kch(B . "0x2687B") ; <CJK>
       (?$(Kci(B . "0x26874") ; <CJK>
       (?$(Kcj(B . "0x26871") ; <CJK>
       (?$(Kck(B . "0x26879") ; <CJK>
       (?$(Kcl(B . "0x26875") ; <CJK>
       (?$(Kcm(B . "0x26890") ; <CJK>
       (?$(Kcn(B . "0x26877") ; <CJK>
       (?$(Kco(B . "0x2687D") ; <CJK>
       (?$(Kcp(B . "0x2694F") ; <CJK>
       (?$(Kcq(B . "0x26950") ; <CJK>
       (?$(Kcr(B . "0x269A3") ; <CJK>
       (?$(Kcs(B . "0x269A2") ; <CJK>
       (?$(Kct(B . "0x269F4") ; <CJK>
       (?$(Kcu(B . "0x26A94") ; <CJK>
       (?$(Kcv(B . "0x26A9A") ; <CJK>
       (?$(Kcw(B . "0x26A9B") ; <CJK>
       (?$(Kcx(B . "0x26AA7") ; <CJK>
       (?$(Kcy(B . "0x26A97") ; <CJK>
       (?$(Kcz(B . "0x26A95") ; <CJK>
       (?$(Kc{(B . "0x26A92") ; <CJK>
       (?$(Kc|(B . "0x26A9C") ; <CJK>
       (?$(Kc}(B . "0x26A96") ; <CJK>
       (?$(Kc~(B . "0x26FB6") ; <CJK>
       (?$(Kd!(B . "0x26FB8") ; <CJK>
       (?$(Kd"(B . "0x26FB0") ; <CJK>
       (?$(Kd#(B . "0x27018") ; <CJK>
       (?$(Kd$(B . "0x26FC5") ; <CJK>
       (?$(Kd%(B . "0x26FB5") ; <CJK>
       (?$(Kd&(B . "0x26FC2") ; <CJK>
       (?$(Kd'(B . "0x27006") ; <CJK>
       (?$(Kd((B . "0x27019") ; <CJK>
       (?$(Kd)(B . "0x26FB9") ; <CJK>
       (?$(Kd*(B . "0x27015") ; <CJK>
       (?$(Kd+(B . "0x26FD6") ; <CJK>
       (?$(Kd,(B . "0x26FAC") ; <CJK>
       (?$(Kd-(B . "0x453C") ; <CJK>
       (?$(Kd.(B . "0x26FC6") ; <CJK>
       (?$(Kd/(B . "0x26FB3") ; <CJK>
       (?$(Kd0(B . "0x26FC3") ; <CJK>
       (?$(Kd1(B . "0x26FCA") ; <CJK>
       (?$(Kd2(B . "0x26FCF") ; <CJK>
       (?$(Kd3(B . "0x26FBD") ; <CJK>
       (?$(Kd4(B . "0x26FCE") ; <CJK>
       (?$(Kd5(B . "0x27014") ; <CJK>
       (?$(Kd6(B . "0x26FBA") ; <CJK>
       (?$(Kd7(B . "0x2701A") ; <CJK>
       (?$(Kd8(B . "0x26FC1") ; <CJK>
       (?$(Kd9(B . "0x26FBB") ; <CJK>
       (?$(Kd:(B . "0x459B") ; <CJK>
       (?$(Kd;(B . "0x459A") ; <CJK>
       (?$(Kd<(B . "0x27201") ; <CJK>
       (?$(Kd=(B . "0x271FC") ; <CJK>
       (?$(Kd>(B . "0x2745A") ; <CJK>
       (?$(Kd?(B . "0x27454") ; <CJK>
       (?$(Kd@(B . "0x27461") ; <CJK>
       (?$(KdA(B . "0x2745C") ; <CJK>
       (?$(KdB(B . "0x27455") ; <CJK>
       (?$(KdC(B . "0x2744A") ; <CJK>
       (?$(KdD(B . "0x2744B") ; <CJK>
       (?$(KdE(B . "0x27451") ; <CJK>
       (?$(KdF(B . "0x27469") ; <CJK>
       (?$(KdG(B . "0x2746B") ; <CJK>
       (?$(KdH(B . "0x87F1") ; <CJK>
       (?$(KdI(B . "0x27466") ; <CJK>
       (?$(KdJ(B . "0x27458") ; <CJK>
       (?$(KdK(B . "0x2745D") ; <CJK>
       (?$(KdL(B . "0x27467") ; <CJK>
       (?$(KdM(B . "0x27456") ; <CJK>
       (?$(KdN(B . "0x27488") ; <CJK>
       (?$(KdO(B . "0x27464") ; <CJK>
       (?$(KdP(B . "0x2744E") ; <CJK>
       (?$(KdQ(B . "0x27757") ; <CJK>
       (?$(KdR(B . "0x2775A") ; <CJK>
       (?$(KdS(B . "0x27751") ; <CJK>
       (?$(KdT(B . "0x2774A") ; <CJK>
       (?$(KdU(B . "0x2774B") ; <CJK>
       (?$(KdV(B . "0x465E") ; <CJK>
       (?$(KdW(B . "0x27747") ; <CJK>
       (?$(KdX(B . "0x2776F") ; <CJK>
       (?$(KdY(B . "0x2776A") ; <CJK>
       (?$(KdZ(B . "0x2776B") ; <CJK>
       (?$(Kd[(B . "0x27746") ; <CJK>
       (?$(Kd\(B . "0x2776D") ; <CJK>
       (?$(Kd](B . "0x27754") ; <CJK>
       (?$(Kd^(B . "0x2776E") ; <CJK>
       (?$(Kd_(B . "0x2774C") ; <CJK>
       (?$(Kd`(B . "0x27878") ; <CJK>
       (?$(Kda(B . "0x27886") ; <CJK>
       (?$(Kdb(B . "0x27882") ; <CJK>
       (?$(Kdc(B . "0x46A7") ; <CJK>
       (?$(Kdd(B . "0x27AE1") ; <CJK>
       (?$(Kde(B . "0x27AE5") ; <CJK>
       (?$(Kdf(B . "0x27ADB") ; <CJK>
       (?$(Kdg(B . "0x27ADE") ; <CJK>
       (?$(Kdh(B . "0x27AD7") ; <CJK>
       (?$(Kdi(B . "0x27C03") ; <CJK>
       (?$(Kdj(B . "0x27C7C") ; <CJK>
       (?$(Kdk(B . "0x27C7E") ; <CJK>
       (?$(Kdl(B . "0x27D05") ; <CJK>
       (?$(Kdm(B . "0x27D07") ; <CJK>
       (?$(Kdn(B . "0x27DE6") ; <CJK>
       (?$(Kdo(B . "0x27DE1") ; <CJK>
       (?$(Kdp(B . "0x27DFB") ; <CJK>
       (?$(Kdq(B . "0x27DE5") ; <CJK>
       (?$(Kdr(B . "0x27DE7") ; <CJK>
       (?$(Kds(B . "0x27DDF") ; <CJK>
       (?$(Kdt(B . "0x27DFF") ; <CJK>
       (?$(Kdu(B . "0x27E76") ; <CJK>
       (?$(Kdv(B . "0x27F63") ; <CJK>
       (?$(Kdw(B . "0x27F66") ; <CJK>
       (?$(Kdx(B . "0x27F65") ; <CJK>
       (?$(Kdy(B . "0x27F5E") ; <CJK>
       (?$(Kdz(B . "0x27F64") ; <CJK>
       (?$(Kd{(B . "0x27F6B") ; <CJK>
       (?$(Kd|(B . "0x27F5F") ; <CJK>
       (?$(Kd}(B . "0x27F67") ; <CJK>
       (?$(Kd~(B . "0x27F68") ; <CJK>
       (?$(Ke!(B . "0x28108") ; <CJK>
       (?$(Ke"(B . "0x28109") ; <CJK>
       (?$(Ke#(B . "0x28117") ; <CJK>
       (?$(Ke$(B . "0x28115") ; <CJK>
       (?$(Ke%(B . "0x2811B") ; <CJK>
       (?$(Ke&(B . "0x2810B") ; <CJK>
       (?$(Ke'(B . "0x28128") ; <CJK>
       (?$(Ke((B . "0x2810E") ; <CJK>
       (?$(Ke)(B . "0x28118") ; <CJK>
       (?$(Ke*(B . "0x28153") ; <CJK>
       (?$(Ke+(B . "0x28145") ; <CJK>
       (?$(Ke,(B . "0x2810D") ; <CJK>
       (?$(Ke-(B . "0x2810A") ; <CJK>
       (?$(Ke.(B . "0x28113") ; <CJK>
       (?$(Ke/(B . "0x2814A") ; <CJK>
       (?$(Ke0(B . "0x28279") ; <CJK>
       (?$(Ke1(B . "0x283A1") ; <CJK>
       (?$(Ke2(B . "0x2838D") ; <CJK>
       (?$(Ke3(B . "0x283A2") ; <CJK>
       (?$(Ke4(B . "0x28390") ; <CJK>
       (?$(Ke5(B . "0x486E") ; <CJK>
       (?$(Ke6(B . "0x28431") ; <CJK>
       (?$(Ke7(B . "0x28430") ; <CJK>
       (?$(Ke8(B . "0x2861F") ; <CJK>
       (?$(Ke9(B . "0x28619") ; <CJK>
       (?$(Ke:(B . "0x2860C") ; <CJK>
       (?$(Ke;(B . "0x2861E") ; <CJK>
       (?$(Ke<(B . "0x2861D") ; <CJK>
       (?$(Ke=(B . "0x28607") ; <CJK>
       (?$(Ke>(B . "0x28766") ; <CJK>
       (?$(Ke?(B . "0x287C5") ; <CJK>
       (?$(Ke@(B . "0x287BA") ; <CJK>
       (?$(KeA(B . "0x287BD") ; <CJK>
       (?$(KeB(B . "0x287C2") ; <CJK>
       (?$(KeC(B . "0x287C3") ; <CJK>
       (?$(KeD(B . "0x287BF") ; <CJK>
       (?$(KeE(B . "0x490D") ; <CJK>
       (?$(KeF(B . "0x288A1") ; <CJK>
       (?$(KeG(B . "0x288A2") ; <CJK>
       (?$(KeH(B . "0x288A8") ; <CJK>
       (?$(KeI(B . "0x288A3") ; <CJK>
       (?$(KeJ(B . "0x288AA") ; <CJK>
       (?$(KeK(B . "0x288AF") ; <CJK>
       (?$(KeL(B . "0x288B9") ; <CJK>
       (?$(KeM(B . "0x28937") ; <CJK>
       (?$(KeN(B . "0x28A8F") ; <CJK>
       (?$(KeO(B . "0x4943") ; <CJK>
       (?$(KeP(B . "0x28A8E") ; <CJK>
       (?$(KeQ(B . "0x28A87") ; <CJK>
       (?$(KeR(B . "0x28A8A") ; <CJK>
       (?$(KeS(B . "0x28A92") ; <CJK>
       (?$(KeT(B . "0x28A97") ; <CJK>
       (?$(KeU(B . "0x28A9F") ; <CJK>
       (?$(KeV(B . "0x28B05") ; <CJK>
       (?$(KeW(B . "0x28CA9") ; <CJK>
       (?$(KeX(B . "0x28CA7") ; <CJK>
       (?$(KeY(B . "0x28D8A") ; <CJK>
       (?$(KeZ(B . "0x28D82") ; <CJK>
       (?$(Ke[(B . "0x28D85") ; <CJK>
       (?$(Ke\(B . "0x28D8B") ; <CJK>
       (?$(Ke](B . "0x28D89") ; <CJK>
       (?$(Ke^(B . "0x28D81") ; <CJK>
       (?$(Ke_(B . "0x28D80") ; <CJK>
       (?$(Ke`(B . "0x28D87") ; <CJK>
       (?$(Kea(B . "0x28D86") ; <CJK>
       (?$(Keb(B . "0x28F4D") ; <CJK>
       (?$(Kec(B . "0x2901C") ; <CJK>
       (?$(Ked(B . "0x2901F") ; <CJK>
       (?$(Kee(B . "0x29121") ; <CJK>
       (?$(Kef(B . "0x2911D") ; <CJK>
       (?$(Keg(B . "0x29122") ; <CJK>
       (?$(Keh(B . "0x290FE") ; <CJK>
       (?$(Kei(B . "0x2911B") ; <CJK>
       (?$(Kej(B . "0x2913A") ; <CJK>
       (?$(Kek(B . "0x29137") ; <CJK>
       (?$(Kel(B . "0x29117") ; <CJK>
       (?$(Kem(B . "0x29138") ; <CJK>
       (?$(Ken(B . "0x29126") ; <CJK>
       (?$(Keo(B . "0x29118") ; <CJK>
       (?$(Kep(B . "0x29234") ; <CJK>
       (?$(Keq(B . "0x29235") ; <CJK>
       (?$(Ker(B . "0x29232") ; <CJK>
       (?$(Kes(B . "0x4A73") ; <CJK>
       (?$(Ket(B . "0x292E1") ; <CJK>
       (?$(Keu(B . "0x292FD") ; <CJK>
       (?$(Kev(B . "0x292E3") ; <CJK>
       (?$(Kew(B . "0x292E8") ; <CJK>
       (?$(Kex(B . "0x292F9") ; <CJK>
       (?$(Key(B . "0x292FF") ; <CJK>
       (?$(Kez(B . "0x292FE") ; <CJK>
       (?$(Ke{(B . "0x4A74") ; <CJK>
       (?$(Ke|(B . "0x292E0") ; <CJK>
       (?$(Ke}(B . "0x29300") ; <CJK>
       (?$(Ke~(B . "0x4A70") ; <CJK>
       (?$(Kf!(B . "0x292EC") ; <CJK>
       (?$(Kf"(B . "0x292E4") ; <CJK>
       (?$(Kf#(B . "0x292EF") ; <CJK>
       (?$(Kf$(B . "0x292FA") ; <CJK>
       (?$(Kf%(B . "0x293CA") ; <CJK>
       (?$(Kf&(B . "0x29431") ; <CJK>
       (?$(Kf'(B . "0x29432") ; <CJK>
       (?$(Kf((B . "0x29434") ; <CJK>
       (?$(Kf)(B . "0x29441") ; <CJK>
       (?$(Kf*(B . "0x29500") ; <CJK>
       (?$(Kf+(B . "0x29506") ; <CJK>
       (?$(Kf,(B . "0x29508") ; <CJK>
       (?$(Kf-(B . "0x29505") ; <CJK>
       (?$(Kf.(B . "0x29503") ; <CJK>
       (?$(Kf/(B . "0x2950B") ; <CJK>
       (?$(Kf0(B . "0x29502") ; <CJK>
       (?$(Kf1(B . "0x2950A") ; <CJK>
       (?$(Kf2(B . "0x295F0") ; <CJK>
       (?$(Kf3(B . "0x29613") ; <CJK>
       (?$(Kf4(B . "0x2960A") ; <CJK>
       (?$(Kf5(B . "0x2960F") ; <CJK>
       (?$(Kf6(B . "0x29611") ; <CJK>
       (?$(Kf7(B . "0x29608") ; <CJK>
       (?$(Kf8(B . "0x2960B") ; <CJK>
       (?$(Kf9(B . "0x29612") ; <CJK>
       (?$(Kf:(B . "0x2960D") ; <CJK>
       (?$(Kf;(B . "0x2975B") ; <CJK>
       (?$(Kf<(B . "0x29763") ; <CJK>
       (?$(Kf=(B . "0x29761") ; <CJK>
       (?$(Kf>(B . "0x29768") ; <CJK>
       (?$(Kf?(B . "0x2975A") ; <CJK>
       (?$(Kf@(B . "0x2984E") ; <CJK>
       (?$(KfA(B . "0x2984D") ; <CJK>
       (?$(KfB(B . "0x29850") ; <CJK>
       (?$(KfC(B . "0x298FC") ; <CJK>
       (?$(KfD(B . "0x29912") ; <CJK>
       (?$(KfE(B . "0x298F5") ; <CJK>
       (?$(KfF(B . "0x2991E") ; <CJK>
       (?$(KfG(B . "0x298F0") ; <CJK>
       (?$(KfH(B . "0x298F3") ; <CJK>
       (?$(KfI(B . "0x298F2") ; <CJK>
       (?$(KfJ(B . "0x29901") ; <CJK>
       (?$(KfK(B . "0x298EF") ; <CJK>
       (?$(KfL(B . "0x298EE") ; <CJK>
       (?$(KfM(B . "0x29916") ; <CJK>
       (?$(KfN(B . "0x298F6") ; <CJK>
       (?$(KfO(B . "0x298FB") ; <CJK>
       (?$(KfP(B . "0x2991C") ; <CJK>
       (?$(KfQ(B . "0x4BDB") ; <CJK>
       (?$(KfR(B . "0x29A5D") ; <CJK>
       (?$(KfS(B . "0x29A60") ; <CJK>
       (?$(KfT(B . "0x29A66") ; <CJK>
       (?$(KfU(B . "0x29A5F") ; <CJK>
       (?$(KfV(B . "0x29A61") ; <CJK>
       (?$(KfW(B . "0x29A5B") ; <CJK>
       (?$(KfX(B . "0x29A62") ; <CJK>
       (?$(KfY(B . "0x29A57") ; <CJK>
       (?$(KfZ(B . "0x29B69") ; <CJK>
       (?$(Kf[(B . "0x29B6B") ; <CJK>
       (?$(Kf\(B . "0x29B61") ; <CJK>
       (?$(Kf](B . "0x29B77") ; <CJK>
       (?$(Kf^(B . "0x29B5F") ; <CJK>
       (?$(Kf_(B . "0x29B63") ; <CJK>
       (?$(Kf`(B . "0x29B62") ; <CJK>
       (?$(Kfa(B . "0x29B65") ; <CJK>
       (?$(Kfb(B . "0x29CEF") ; <CJK>
       (?$(Kfc(B . "0x29CE2") ; <CJK>
       (?$(Kfd(B . "0x29D00") ; <CJK>
       (?$(Kfe(B . "0x29CE8") ; <CJK>
       (?$(Kff(B . "0x29CF2") ; <CJK>
       (?$(Kfg(B . "0x29CE7") ; <CJK>
       (?$(Kfh(B . "0x4C29") ; <CJK>
       (?$(Kfi(B . "0x29CE5") ; <CJK>
       (?$(Kfj(B . "0x29DD5") ; <CJK>
       (?$(Kfk(B . "0x29DD0") ; <CJK>
       (?$(Kfl(B . "0x29DDA") ; <CJK>
       (?$(Kfm(B . "0x29DD3") ; <CJK>
       (?$(Kfn(B . "0x4C51") ; <CJK>
       (?$(Kfo(B . "0x29DD9") ; <CJK>
       (?$(Kfp(B . "0x29DCF") ; <CJK>
       (?$(Kfq(B . "0x29DD6") ; <CJK>
       (?$(Kfr(B . "0x29DD8") ; <CJK>
       (?$(Kfs(B . "0x29DF5") ; <CJK>
       (?$(Kft(B . "0x29DCE") ; <CJK>
       (?$(Kfu(B . "0x29DD7") ; <CJK>
       (?$(Kfv(B . "0x29DF4") ; <CJK>
       (?$(Kfw(B . "0x29DCD") ; <CJK>
       (?$(Kfx(B . "0x29E01") ; <CJK>
       (?$(Kfy(B . "0x9BBA") ; <CJK>
       (?$(Kfz(B . "0x2A052") ; <CJK>
       (?$(Kf{(B . "0x2A055") ; <CJK>
       (?$(Kf|(B . "0x2A05A") ; <CJK>
       (?$(Kf}(B . "0x2A04D") ; <CJK>
       (?$(Kf~(B . "0x2A054") ; <CJK>
       (?$(Kg!(B . "0x2A053") ; <CJK>
       (?$(Kg"(B . "0x2A05E") ; <CJK>
       (?$(Kg#(B . "0x2A067") ; <CJK>
       (?$(Kg$(B . "0x2A065") ; <CJK>
       (?$(Kg%(B . "0x2A04E") ; <CJK>
       (?$(Kg&(B . "0x4CDB") ; <CJK>
       (?$(Kg'(B . "0x2A04F") ; <CJK>
       (?$(Kg((B . "0x2A061") ; <CJK>
       (?$(Kg)(B . "0x2A06E") ; <CJK>
       (?$(Kg*(B . "0x2A051") ; <CJK>
       (?$(Kg+(B . "0x2A05B") ; <CJK>
       (?$(Kg,(B . "0x2A263") ; <CJK>
       (?$(Kg-(B . "0x2A2B7") ; <CJK>
       (?$(Kg.(B . "0x2A2B6") ; <CJK>
       (?$(Kg/(B . "0x2A2C3") ; <CJK>
       (?$(Kg0(B . "0x2A2BB") ; <CJK>
       (?$(Kg1(B . "0x2A2B5") ; <CJK>
       (?$(Kg2(B . "0x2A32E") ; <CJK>
       (?$(Kg3(B . "0x2A330") ; <CJK>
       (?$(Kg4(B . "0x2A333") ; <CJK>
       (?$(Kg5(B . "0x2A331") ; <CJK>
       (?$(Kg6(B . "0x2A3A4") ; <CJK>
       (?$(Kg7(B . "0x2A3C1") ; <CJK>
       (?$(Kg8(B . "0x2A3BB") ; <CJK>
       (?$(Kg9(B . "0x2A3BE") ; <CJK>
       (?$(Kg:(B . "0x2A400") ; <CJK>
       (?$(Kg;(B . "0x2A3FF") ; <CJK>
       (?$(Kg<(B . "0x2A440") ; <CJK>
       (?$(Kg=(B . "0x4D65") ; <CJK>
       (?$(Kg>(B . "0x2A43F") ; <CJK>
       (?$(Kg?(B . "0x2A444") ; <CJK>
       (?$(Kg@(B . "0x4D64") ; <CJK>
       (?$(KgA(B . "0x4D67") ; <CJK>
       (?$(KgB(B . "0x2A4DB") ; <CJK>
       (?$(KgC(B . "0x2A50F") ; <CJK>
       (?$(KgD(B . "0x2A511") ; <CJK>
       (?$(KgE(B . "0x2A54E") ; <CJK>
       (?$(KgF(B . "0x2A54D") ; <CJK>
       (?$(KgG(B . "0x2A54B") ; <CJK>
       (?$(KgH(B . "0x2A54C") ; <CJK>
       (?$(KgI(B . "0x2A595") ; <CJK>
       (?$(KgJ(B . "0x2043B") ; <CJK>
       (?$(KgK(B . "0x20445") ; <CJK>
       (?$(KgL(B . "0x20444") ; <CJK>
       (?$(KgM(B . "0x2043E") ; <CJK>
       (?$(KgN(B . "0x2043C") ; <CJK>
       (?$(KgO(B . "0x2043F") ; <CJK>
       (?$(KgP(B . "0x204CC") ; <CJK>
       (?$(KgQ(B . "0x204CE") ; <CJK>
       (?$(KgR(B . "0x20622") ; <CJK>
       (?$(KgS(B . "0x20623") ; <CJK>
       (?$(KgT(B . "0x2069F") ; <CJK>
       (?$(KgU(B . "0x208C5") ; <CJK>
       (?$(KgV(B . "0x208C4") ; <CJK>
       (?$(KgW(B . "0x210E9") ; <CJK>
       (?$(KgX(B . "0x21099") ; <CJK>
       (?$(KgY(B . "0x3611") ; <CJK>
       (?$(KgZ(B . "0x210E6") ; <CJK>
       (?$(Kg[(B . "0x210E7") ; <CJK>
       (?$(Kg\(B . "0x210F7") ; <CJK>
       (?$(Kg](B . "0x214D2") ; <CJK>
       (?$(Kg^(B . "0x3733") ; <CJK>
       (?$(Kg_(B . "0x218FD") ; <CJK>
       (?$(Kg`(B . "0x2190C") ; <CJK>
       (?$(Kga(B . "0x2190B") ; <CJK>
       (?$(Kgb(B . "0x21CED") ; <CJK>
       (?$(Kgc(B . "0x3821") ; <CJK>
       (?$(Kgd(B . "0x3822") ; <CJK>
       (?$(Kge(B . "0x21F9B") ; <CJK>
       (?$(Kgf(B . "0x2200A") ; <CJK>
       (?$(Kgg(B . "0x2216F") ; <CJK>
       (?$(Kgh(B . "0x22175") ; <CJK>
       (?$(Kgi(B . "0x222F2") ; <CJK>
       (?$(Kgj(B . "0x222F8") ; <CJK>
       (?$(Kgk(B . "0x2243E") ; <CJK>
       (?$(Kgl(B . "0x22924") ; <CJK>
       (?$(Kgm(B . "0x2290E") ; <CJK>
       (?$(Kgn(B . "0x22916") ; <CJK>
       (?$(Kgo(B . "0x22918") ; <CJK>
       (?$(Kgp(B . "0x22910") ; <CJK>
       (?$(Kgq(B . "0x22931") ; <CJK>
       (?$(Kgr(B . "0x22944") ; <CJK>
       (?$(Kgs(B . "0x39A6") ; <CJK>
       (?$(Kgt(B . "0x22929") ; <CJK>
       (?$(Kgu(B . "0x2292F") ; <CJK>
       (?$(Kgv(B . "0x2294B") ; <CJK>
       (?$(Kgw(B . "0x22936") ; <CJK>
       (?$(Kgx(B . "0x39A3") ; <CJK>
       (?$(Kgy(B . "0x22E34") ; <CJK>
       (?$(Kgz(B . "0x22E00") ; <CJK>
       (?$(Kg{(B . "0x22E2B") ; <CJK>
       (?$(Kg|(B . "0x23020") ; <CJK>
       (?$(Kg}(B . "0x23021") ; <CJK>
       (?$(Kg~(B . "0x2301E") ; <CJK>
       (?$(Kh!(B . "0x2301D") ; <CJK>
       (?$(Kh"(B . "0x232F5") ; <CJK>
       (?$(Kh#(B . "0x232F2") ; <CJK>
       (?$(Kh$(B . "0x232F6") ; <CJK>
       (?$(Kh%(B . "0x23790") ; <CJK>
       (?$(Kh&(B . "0x2379D") ; <CJK>
       (?$(Kh'(B . "0x2379C") ; <CJK>
       (?$(Kh((B . "0x23792") ; <CJK>
       (?$(Kh)(B . "0x23794") ; <CJK>
       (?$(Kh*(B . "0x237D1") ; <CJK>
       (?$(Kh+(B . "0x23793") ; <CJK>
       (?$(Kh,(B . "0x237B7") ; <CJK>
       (?$(Kh-(B . "0x23797") ; <CJK>
       (?$(Kh.(B . "0x237B0") ; <CJK>
       (?$(Kh/(B . "0x2379F") ; <CJK>
       (?$(Kh0(B . "0x237C9") ; <CJK>
       (?$(Kh1(B . "0x2392D") ; <CJK>
       (?$(Kh2(B . "0x2392C") ; <CJK>
       (?$(Kh3(B . "0x23A77") ; <CJK>
       (?$(Kh4(B . "0x23C2C") ; <CJK>
       (?$(Kh5(B . "0x240C0") ; <CJK>
       (?$(Kh6(B . "0x240B9") ; <CJK>
       (?$(Kh7(B . "0x24453") ; <CJK>
       (?$(Kh8(B . "0x24540") ; <CJK>
       (?$(Kh9(B . "0x24702") ; <CJK>
       (?$(Kh:(B . "0x246FB") ; <CJK>
       (?$(Kh;(B . "0x3EA1") ; <CJK>
       (?$(Kh<(B . "0x24A8B") ; <CJK>
       (?$(Kh=(B . "0x24AAE") ; <CJK>
       (?$(Kh>(B . "0x24AAB") ; <CJK>
       (?$(Kh?(B . "0x24BA1") ; <CJK>
       (?$(Kh@(B . "0x2A2CD") ; <CJK>
       (?$(KhA(B . "0x24CEA") ; <CJK>
       (?$(KhB(B . "0x24EDD") ; <CJK>
       (?$(KhC(B . "0x24EDC") ; <CJK>
       (?$(KhD(B . "0x24ED9") ; <CJK>
       (?$(KhE(B . "0x24FAB") ; <CJK>
       (?$(KhF(B . "0x24FAC") ; <CJK>
       (?$(KhG(B . "0x24FAD") ; <CJK>
       (?$(KhH(B . "0x24FB2") ; <CJK>
       (?$(KhI(B . "0x2502C") ; <CJK>
       (?$(KhJ(B . "0x2502B") ; <CJK>
       (?$(KhK(B . "0x250C2") ; <CJK>
       (?$(KhL(B . "0x25300") ; <CJK>
       (?$(KhM(B . "0x2530D") ; <CJK>
       (?$(KhN(B . "0x25306") ; <CJK>
       (?$(KhO(B . "0x252FF") ; <CJK>
       (?$(KhP(B . "0x25303") ; <CJK>
       (?$(KhQ(B . "0x25301") ; <CJK>
       (?$(KhR(B . "0x25310") ; <CJK>
       (?$(KhS(B . "0x2530F") ; <CJK>
       (?$(KhT(B . "0x25305") ; <CJK>
       (?$(KhU(B . "0x25398") ; <CJK>
       (?$(KhV(B . "0x25397") ; <CJK>
       (?$(KhW(B . "0x25396") ; <CJK>
       (?$(KhX(B . "0x25399") ; <CJK>
       (?$(KhY(B . "0x255AC") ; <CJK>
       (?$(KhZ(B . "0x255AB") ; <CJK>
       (?$(Kh[(B . "0x25712") ; <CJK>
       (?$(Kh\(B . "0x258D8") ; <CJK>
       (?$(Kh](B . "0x258DF") ; <CJK>
       (?$(Kh^(B . "0x258D6") ; <CJK>
       (?$(Kh_(B . "0x25A2D") ; <CJK>
       (?$(Kh`(B . "0x25A32") ; <CJK>
       (?$(Kha(B . "0x25D3F") ; <CJK>
       (?$(Khb(B . "0x25D2F") ; <CJK>
       (?$(Khc(B . "0x25D26") ; <CJK>
       (?$(Khd(B . "0x25D3A") ; <CJK>
       (?$(Khe(B . "0x25D39") ; <CJK>
       (?$(Khf(B . "0x425F") ; <CJK>
       (?$(Khg(B . "0x25D3B") ; <CJK>
       (?$(Khh(B . "0x25D35") ; <CJK>
       (?$(Khi(B . "0x25D2A") ; <CJK>
       (?$(Khj(B . "0x25D21") ; <CJK>
       (?$(Khk(B . "0x25D38") ; <CJK>
       (?$(Khl(B . "0x25D37") ; <CJK>
       (?$(Khm(B . "0x25D34") ; <CJK>
       (?$(Khn(B . "0x425C") ; <CJK>
       (?$(Kho(B . "0x25D22") ; <CJK>
       (?$(Khp(B . "0x25D36") ; <CJK>
       (?$(Khq(B . "0x25D44") ; <CJK>
       (?$(Khr(B . "0x25F45") ; <CJK>
       (?$(Khs(B . "0x25F3B") ; <CJK>
       (?$(Kht(B . "0x25F36") ; <CJK>
       (?$(Khu(B . "0x25F42") ; <CJK>
       (?$(Khv(B . "0x2617A") ; <CJK>
       (?$(Khw(B . "0x26186") ; <CJK>
       (?$(Khx(B . "0x2618B") ; <CJK>
       (?$(Khy(B . "0x2617F") ; <CJK>
       (?$(Khz(B . "0x26181") ; <CJK>
       (?$(Kh{(B . "0x2632A") ; <CJK>
       (?$(Kh|(B . "0x263D5") ; <CJK>
       (?$(Kh}(B . "0x2649F") ; <CJK>
       (?$(Kh~(B . "0x2649D") ; <CJK>
       (?$(Ki!(B . "0x26526") ; <CJK>
       (?$(Ki"(B . "0x265F4") ; <CJK>
       (?$(Ki#(B . "0x265F5") ; <CJK>
       (?$(Ki$(B . "0x26815") ; <CJK>
       (?$(Ki%(B . "0x2688E") ; <CJK>
       (?$(Ki&(B . "0x2688F") ; <CJK>
       (?$(Ki'(B . "0x26926") ; <CJK>
       (?$(Ki((B . "0x269A7") ; <CJK>
       (?$(Ki)(B . "0x269AF") ; <CJK>
       (?$(Ki*(B . "0x26AAD") ; <CJK>
       (?$(Ki+(B . "0x26AAC") ; <CJK>
       (?$(Ki,(B . "0x26AAB") ; <CJK>
       (?$(Ki-(B . "0x26AAA") ; <CJK>
       (?$(Ki.(B . "0x2702F") ; <CJK>
       (?$(Ki/(B . "0x27021") ; <CJK>
       (?$(Ki0(B . "0x27023") ; <CJK>
       (?$(Ki1(B . "0x270A3") ; <CJK>
       (?$(Ki2(B . "0x27049") ; <CJK>
       (?$(Ki3(B . "0x2703A") ; <CJK>
       (?$(Ki4(B . "0x27048") ; <CJK>
       (?$(Ki5(B . "0x2702D") ; <CJK>
       (?$(Ki6(B . "0x27025") ; <CJK>
       (?$(Ki7(B . "0x27029") ; <CJK>
       (?$(Ki8(B . "0x27032") ; <CJK>
       (?$(Ki9(B . "0x27034") ; <CJK>
       (?$(Ki:(B . "0x27024") ; <CJK>
       (?$(Ki;(B . "0x2702C") ; <CJK>
       (?$(Ki<(B . "0x2704B") ; <CJK>
       (?$(Ki=(B . "0x2703B") ; <CJK>
       (?$(Ki>(B . "0x27020") ; <CJK>
       (?$(Ki?(B . "0x27028") ; <CJK>
       (?$(Ki@(B . "0x27498") ; <CJK>
       (?$(KiA(B . "0x45F5") ; <CJK>
       (?$(KiB(B . "0x27497") ; <CJK>
       (?$(KiC(B . "0x8804") ; <CJK>
       (?$(KiD(B . "0x2749D") ; <CJK>
       (?$(KiE(B . "0x274A8") ; <CJK>
       (?$(KiF(B . "0x275D5") ; <CJK>
       (?$(KiG(B . "0x27777") ; <CJK>
       (?$(KiH(B . "0x27778") ; <CJK>
       (?$(KiI(B . "0x27772") ; <CJK>
       (?$(KiJ(B . "0x27773") ; <CJK>
       (?$(KiK(B . "0x27802") ; <CJK>
       (?$(KiL(B . "0x2793B") ; <CJK>
       (?$(KiM(B . "0x27AFE") ; <CJK>
       (?$(KiN(B . "0x27B0B") ; <CJK>
       (?$(KiO(B . "0x27AFF") ; <CJK>
       (?$(KiP(B . "0x27B07") ; <CJK>
       (?$(KiQ(B . "0x4711") ; <CJK>
       (?$(KiR(B . "0x470C") ; <CJK>
       (?$(KiS(B . "0x27B30") ; <CJK>
       (?$(KiT(B . "0x27BCD") ; <CJK>
       (?$(KiU(B . "0x27BCF") ; <CJK>
       (?$(KiV(B . "0x27C10") ; <CJK>
       (?$(KiW(B . "0x27C0A") ; <CJK>
       (?$(KiX(B . "0x27C83") ; <CJK>
       (?$(KiY(B . "0x27D15") ; <CJK>
       (?$(KiZ(B . "0x27D0E") ; <CJK>
       (?$(Ki[(B . "0x27D0C") ; <CJK>
       (?$(Ki\(B . "0x27E02") ; <CJK>
       (?$(Ki](B . "0x27DFE") ; <CJK>
       (?$(Ki^(B . "0x27E05") ; <CJK>
       (?$(Ki_(B . "0x27E15") ; <CJK>
       (?$(Ki`(B . "0x27E08") ; <CJK>
       (?$(Kia(B . "0x27F7F") ; <CJK>
       (?$(Kib(B . "0x27F77") ; <CJK>
       (?$(Kic(B . "0x27F7C") ; <CJK>
       (?$(Kid(B . "0x27F82") ; <CJK>
       (?$(Kie(B . "0x27F7E") ; <CJK>
       (?$(Kif(B . "0x27F78") ; <CJK>
       (?$(Kig(B . "0x27F7D") ; <CJK>
       (?$(Kih(B . "0x27F79") ; <CJK>
       (?$(Kii(B . "0x27F81") ; <CJK>
       (?$(Kij(B . "0x2814B") ; <CJK>
       (?$(Kik(B . "0x28163") ; <CJK>
       (?$(Kil(B . "0x28164") ; <CJK>
       (?$(Kim(B . "0x28156") ; <CJK>
       (?$(Kin(B . "0x28154") ; <CJK>
       (?$(Kio(B . "0x2814E") ; <CJK>
       (?$(Kip(B . "0x28110") ; <CJK>
       (?$(Kiq(B . "0x2814F") ; <CJK>
       (?$(Kir(B . "0x28157") ; <CJK>
       (?$(Kis(B . "0x2815E") ; <CJK>
       (?$(Kit(B . "0x28151") ; <CJK>
       (?$(Kiu(B . "0x2816A") ; <CJK>
       (?$(Kiv(B . "0x28169") ; <CJK>
       (?$(Kiw(B . "0x283AD") ; <CJK>
       (?$(Kix(B . "0x283A4") ; <CJK>
       (?$(Kiy(B . "0x283AC") ; <CJK>
       (?$(Kiz(B . "0x283A9") ; <CJK>
       (?$(Ki{(B . "0x283AE") ; <CJK>
       (?$(Ki|(B . "0x2044C") ; <CJK>
       (?$(Ki}(B . "0x28650") ; <CJK>
       (?$(Ki~(B . "0x28635") ; <CJK>
       (?$(Kj!(B . "0x28632") ; <CJK>
       (?$(Kj"(B . "0x287D8") ; <CJK>
       (?$(Kj#(B . "0x287D1") ; <CJK>
       (?$(Kj$(B . "0x287CF") ; <CJK>
       (?$(Kj%(B . "0x287BE") ; <CJK>
       (?$(Kj&(B . "0x288D5") ; <CJK>
       (?$(Kj'(B . "0x288C1") ; <CJK>
       (?$(Kj((B . "0x288C6") ; <CJK>
       (?$(Kj)(B . "0x288C3") ; <CJK>
       (?$(Kj*(B . "0x288C2") ; <CJK>
       (?$(Kj+(B . "0x288C0") ; <CJK>
       (?$(Kj,(B . "0x288C5") ; <CJK>
       (?$(Kj-(B . "0x288C7") ; <CJK>
       (?$(Kj.(B . "0x288BF") ; <CJK>
       (?$(Kj/(B . "0x288C4") ; <CJK>
       (?$(Kj0(B . "0x288D4") ; <CJK>
       (?$(Kj1(B . "0x28A90") ; <CJK>
       (?$(Kj2(B . "0x28AD2") ; <CJK>
       (?$(Kj3(B . "0x494E") ; <CJK>
       (?$(Kj4(B . "0x28AD4") ; <CJK>
       (?$(Kj5(B . "0x28CAF") ; <CJK>
       (?$(Kj6(B . "0x28CAE") ; <CJK>
       (?$(Kj7(B . "0x28CB2") ; <CJK>
       (?$(Kj8(B . "0x28CAD") ; <CJK>
       (?$(Kj9(B . "0x28D9C") ; <CJK>
       (?$(Kj:(B . "0x28DA0") ; <CJK>
       (?$(Kj;(B . "0x28DB6") ; <CJK>
       (?$(Kj<(B . "0x28F3D") ; <CJK>
       (?$(Kj=(B . "0x28F56") ; <CJK>
       (?$(Kj>(B . "0x28F82") ; <CJK>
       (?$(Kj?(B . "0x29028") ; <CJK>
       (?$(Kj@(B . "0x2902B") ; <CJK>
       (?$(KjA(B . "0x2913C") ; <CJK>
       (?$(KjB(B . "0x2913E") ; <CJK>
       (?$(KjC(B . "0x2913F") ; <CJK>
       (?$(KjD(B . "0x29142") ; <CJK>
       (?$(KjE(B . "0x2913D") ; <CJK>
       (?$(KjF(B . "0x29141") ; <CJK>
       (?$(KjG(B . "0x2913B") ; <CJK>
       (?$(KjH(B . "0x29149") ; <CJK>
       (?$(KjI(B . "0x29143") ; <CJK>
       (?$(KjJ(B . "0x29239") ; <CJK>
       (?$(KjK(B . "0x29238") ; <CJK>
       (?$(KjL(B . "0x29322") ; <CJK>
       (?$(KjM(B . "0x29308") ; <CJK>
       (?$(KjN(B . "0x2930C") ; <CJK>
       (?$(KjO(B . "0x29306") ; <CJK>
       (?$(KjP(B . "0x29313") ; <CJK>
       (?$(KjQ(B . "0x29304") ; <CJK>
       (?$(KjR(B . "0x29320") ; <CJK>
       (?$(KjS(B . "0x2931D") ; <CJK>
       (?$(KjT(B . "0x29305") ; <CJK>
       (?$(KjU(B . "0x2930A") ; <CJK>
       (?$(KjV(B . "0x293D6") ; <CJK>
       (?$(KjW(B . "0x293D7") ; <CJK>
       (?$(KjX(B . "0x29436") ; <CJK>
       (?$(KjY(B . "0x29437") ; <CJK>
       (?$(KjZ(B . "0x29523") ; <CJK>
       (?$(Kj[(B . "0x29522") ; <CJK>
       (?$(Kj\(B . "0x29520") ; <CJK>
       (?$(Kj](B . "0x2951A") ; <CJK>
       (?$(Kj^(B . "0x2951D") ; <CJK>
       (?$(Kj_(B . "0x2961C") ; <CJK>
       (?$(Kj`(B . "0x29620") ; <CJK>
       (?$(Kja(B . "0x29677") ; <CJK>
       (?$(Kjb(B . "0x2977F") ; <CJK>
       (?$(Kjc(B . "0x2978B") ; <CJK>
       (?$(Kjd(B . "0x2977D") ; <CJK>
       (?$(Kje(B . "0x29799") ; <CJK>
       (?$(Kjf(B . "0x29784") ; <CJK>
       (?$(Kjg(B . "0x29789") ; <CJK>
       (?$(Kjh(B . "0x29785") ; <CJK>
       (?$(Kji(B . "0x29783") ; <CJK>
       (?$(Kjj(B . "0x29786") ; <CJK>
       (?$(Kjk(B . "0x2979E") ; <CJK>
       (?$(Kjl(B . "0x29853") ; <CJK>
       (?$(Kjm(B . "0x29917") ; <CJK>
       (?$(Kjn(B . "0x4B94") ; <CJK>
       (?$(Kjo(B . "0x29919") ; <CJK>
       (?$(Kjp(B . "0x29920") ; <CJK>
       (?$(Kjq(B . "0x2991F") ; <CJK>
       (?$(Kjr(B . "0x29923") ; <CJK>
       (?$(Kjs(B . "0x29918") ; <CJK>
       (?$(Kjt(B . "0x29921") ; <CJK>
       (?$(Kju(B . "0x29929") ; <CJK>
       (?$(Kjv(B . "0x29924") ; <CJK>
       (?$(Kjw(B . "0x29926") ; <CJK>
       (?$(Kjx(B . "0x29A5E") ; <CJK>
       (?$(Kjy(B . "0x29A6F") ; <CJK>
       (?$(Kjz(B . "0x29A6E") ; <CJK>
       (?$(Kj{(B . "0x29A74") ; <CJK>
       (?$(Kj|(B . "0x29A72") ; <CJK>
       (?$(Kj}(B . "0x29A73") ; <CJK>
       (?$(Kj~(B . "0x29B7D") ; <CJK>
       (?$(Kk!(B . "0x29B7E") ; <CJK>
       (?$(Kk"(B . "0x29B85") ; <CJK>
       (?$(Kk#(B . "0x29B7F") ; <CJK>
       (?$(Kk$(B . "0x29B84") ; <CJK>
       (?$(Kk%(B . "0x29C44") ; <CJK>
       (?$(Kk&(B . "0x29CF5") ; <CJK>
       (?$(Kk'(B . "0x29CF8") ; <CJK>
       (?$(Kk((B . "0x29D03") ; <CJK>
       (?$(Kk)(B . "0x29CF6") ; <CJK>
       (?$(Kk*(B . "0x29E28") ; <CJK>
       (?$(Kk+(B . "0x4C63") ; <CJK>
       (?$(Kk,(B . "0x29E39") ; <CJK>
       (?$(Kk-(B . "0x29DFB") ; <CJK>
       (?$(Kk.(B . "0x29E0E") ; <CJK>
       (?$(Kk/(B . "0x29DFD") ; <CJK>
       (?$(Kk0(B . "0x29E1F") ; <CJK>
       (?$(Kk1(B . "0x4C61") ; <CJK>
       (?$(Kk2(B . "0x29E03") ; <CJK>
       (?$(Kk3(B . "0x9BD8") ; <CJK>
       (?$(Kk4(B . "0x29E10") ; <CJK>
       (?$(Kk5(B . "0x4C5A") ; <CJK>
       (?$(Kk6(B . "0x29E0D") ; <CJK>
       (?$(Kk7(B . "0x29E27") ; <CJK>
       (?$(Kk8(B . "0x29E41") ; <CJK>
       (?$(Kk9(B . "0x2A072") ; <CJK>
       (?$(Kk:(B . "0x2A078") ; <CJK>
       (?$(Kk;(B . "0x2A080") ; <CJK>
       (?$(Kk<(B . "0x4CE3") ; <CJK>
       (?$(Kk=(B . "0x2A085") ; <CJK>
       (?$(Kk>(B . "0x2A07B") ; <CJK>
       (?$(Kk?(B . "0x9D7C") ; <CJK>
       (?$(Kk@(B . "0x2A07D") ; <CJK>
       (?$(KkA(B . "0x2A091") ; <CJK>
       (?$(KkB(B . "0x2A088") ; <CJK>
       (?$(KkC(B . "0x2A0AA") ; <CJK>
       (?$(KkD(B . "0x2A08D") ; <CJK>
       (?$(KkE(B . "0x2A089") ; <CJK>
       (?$(KkF(B . "0x2A095") ; <CJK>
       (?$(KkG(B . "0x2A09B") ; <CJK>
       (?$(KkH(B . "0x2A08C") ; <CJK>
       (?$(KkI(B . "0x2A09E") ; <CJK>
       (?$(KkJ(B . "0x2A07C") ; <CJK>
       (?$(KkK(B . "0x2A086") ; <CJK>
       (?$(KkL(B . "0x2A084") ; <CJK>
       (?$(KkM(B . "0x2A268") ; <CJK>
       (?$(KkN(B . "0x2A2C5") ; <CJK>
       (?$(KkO(B . "0x2A2C4") ; <CJK>
       (?$(KkP(B . "0x2A2C9") ; <CJK>
       (?$(KkQ(B . "0x2A2C6") ; <CJK>
       (?$(KkR(B . "0x2A342") ; <CJK>
       (?$(KkS(B . "0x2A345") ; <CJK>
       (?$(KkT(B . "0x2A341") ; <CJK>
       (?$(KkU(B . "0x2A344") ; <CJK>
       (?$(KkV(B . "0x2A3A6") ; <CJK>
       (?$(KkW(B . "0x2A3C2") ; <CJK>
       (?$(KkX(B . "0x2A442") ; <CJK>
       (?$(KkY(B . "0x2A449") ; <CJK>
       (?$(KkZ(B . "0x2A448") ; <CJK>
       (?$(Kk[(B . "0x2A44A") ; <CJK>
       (?$(Kk\(B . "0x2A44C") ; <CJK>
       (?$(Kk](B . "0x2A44B") ; <CJK>
       (?$(Kk^(B . "0x2A517") ; <CJK>
       (?$(Kk_(B . "0x2A518") ; <CJK>
       (?$(Kk`(B . "0x2A515") ; <CJK>
       (?$(Kka(B . "0x2A552") ; <CJK>
       (?$(Kkb(B . "0x2A554") ; <CJK>
       (?$(Kkc(B . "0x2A553") ; <CJK>
       (?$(Kkd(B . "0x2A59A") ; <CJK>
       (?$(Kke(B . "0x2A59B") ; <CJK>
       (?$(Kkf(B . "0x2A5DC") ; <CJK>
       (?$(Kkg(B . "0x2A5E4") ; <CJK>
       (?$(Kkh(B . "0x2A691") ; <CJK>
       (?$(Kki(B . "0x4DAF") ; <CJK>
       (?$(Kkj(B . "0x2A6BA") ; <CJK>
       (?$(Kkk(B . "0x20451") ; <CJK>
       (?$(Kkl(B . "0x2045B") ; <CJK>
       (?$(Kkm(B . "0x204CF") ; <CJK>
       (?$(Kkn(B . "0x23305") ; <CJK>
       (?$(Kko(B . "0x21113") ; <CJK>
       (?$(Kkp(B . "0x21115") ; <CJK>
       (?$(Kkq(B . "0x21114") ; <CJK>
       (?$(Kkr(B . "0x21123") ; <CJK>
       (?$(Kks(B . "0x3613") ; <CJK>
       (?$(Kkt(B . "0x21111") ; <CJK>
       (?$(Kku(B . "0x21112") ; <CJK>
       (?$(Kkv(B . "0x3680") ; <CJK>
       (?$(Kkw(B . "0x214F0") ; <CJK>
       (?$(Kkx(B . "0x2169B") ; <CJK>
       (?$(Kky(B . "0x21912") ; <CJK>
       (?$(Kkz(B . "0x21916") ; <CJK>
       (?$(Kk{(B . "0x21917") ; <CJK>
       (?$(Kk|(B . "0x219B5") ; <CJK>
       (?$(Kk}(B . "0x21CF4") ; <CJK>
       (?$(Kk~(B . "0x21FB1") ; <CJK>
       (?$(Kl!(B . "0x22179") ; <CJK>
       (?$(Kl"(B . "0x222FF") ; <CJK>
       (?$(Kl#(B . "0x222FC") ; <CJK>
       (?$(Kl$(B . "0x222FB") ; <CJK>
       (?$(Kl%(B . "0x2243F") ; <CJK>
       (?$(Kl&(B . "0x22444") ; <CJK>
       (?$(Kl'(B . "0x2259D") ; <CJK>
       (?$(Kl((B . "0x22932") ; <CJK>
       (?$(Kl)(B . "0x2294C") ; <CJK>
       (?$(Kl*(B . "0x2292B") ; <CJK>
       (?$(Kl+(B . "0x2295A") ; <CJK>
       (?$(Kl,(B . "0x22A1F") ; <CJK>
       (?$(Kl-(B . "0x22E01") ; <CJK>
       (?$(Kl.(B . "0x22E2D") ; <CJK>
       (?$(Kl/(B . "0x22E27") ; <CJK>
       (?$(Kl0(B . "0x22E59") ; <CJK>
       (?$(Kl1(B . "0x22E5A") ; <CJK>
       (?$(Kl2(B . "0x22E4D") ; <CJK>
       (?$(Kl3(B . "0x22E58") ; <CJK>
       (?$(Kl4(B . "0x23023") ; <CJK>
       (?$(Kl5(B . "0x23025") ; <CJK>
       (?$(Kl6(B . "0x2302B") ; <CJK>
       (?$(Kl7(B . "0x232FF") ; <CJK>
       (?$(Kl8(B . "0x233AE") ; <CJK>
       (?$(Kl9(B . "0x237CB") ; <CJK>
       (?$(Kl:(B . "0x237CA") ; <CJK>
       (?$(Kl;(B . "0x237D0") ; <CJK>
       (?$(Kl<(B . "0x237CE") ; <CJK>
       (?$(Kl=(B . "0x237CC") ; <CJK>
       (?$(Kl>(B . "0x237D8") ; <CJK>
       (?$(Kl?(B . "0x237C6") ; <CJK>
       (?$(Kl@(B . "0x237D2") ; <CJK>
       (?$(KlA(B . "0x237CF") ; <CJK>
       (?$(KlB(B . "0x237C8") ; <CJK>
       (?$(KlC(B . "0x23B17") ; <CJK>
       (?$(KlD(B . "0x4DB0") ; <CJK>
       (?$(KlE(B . "0x240C4") ; <CJK>
       (?$(KlF(B . "0x29240") ; <CJK>
       (?$(KlG(B . "0x240E9") ; <CJK>
       (?$(KlH(B . "0x240F2") ; <CJK>
       (?$(KlI(B . "0x240FC") ; <CJK>
       (?$(KlJ(B . "0x240EA") ; <CJK>
       (?$(KlK(B . "0x240EB") ; <CJK>
       (?$(KlL(B . "0x240FD") ; <CJK>
       (?$(KlM(B . "0x24478") ; <CJK>
       (?$(KlN(B . "0x24477") ; <CJK>
       (?$(KlO(B . "0x24473") ; <CJK>
       (?$(KlP(B . "0x2449E") ; <CJK>
       (?$(KlQ(B . "0x24479") ; <CJK>
       (?$(KlR(B . "0x245A2") ; <CJK>
       (?$(KlS(B . "0x24603") ; <CJK>
       (?$(KlT(B . "0x24704") ; <CJK>
       (?$(KlU(B . "0x24705") ; <CJK>
       (?$(KlV(B . "0x248CE") ; <CJK>
       (?$(KlW(B . "0x24ABF") ; <CJK>
       (?$(KlX(B . "0x24EF6") ; <CJK>
       (?$(KlY(B . "0x24EF7") ; <CJK>
       (?$(KlZ(B . "0x25031") ; <CJK>
       (?$(Kl[(B . "0x25030") ; <CJK>
       (?$(Kl\(B . "0x250C9") ; <CJK>
       (?$(Kl](B . "0x250C7") ; <CJK>
       (?$(Kl^(B . "0x2531C") ; <CJK>
       (?$(Kl_(B . "0x25328") ; <CJK>
       (?$(Kl`(B . "0x2531A") ; <CJK>
       (?$(Kla(B . "0x2531E") ; <CJK>
       (?$(Klb(B . "0x2531B") ; <CJK>
       (?$(Klc(B . "0x2531F") ; <CJK>
       (?$(Kld(B . "0x255BF") ; <CJK>
       (?$(Kle(B . "0x255BB") ; <CJK>
       (?$(Klf(B . "0x255BC") ; <CJK>
       (?$(Klg(B . "0x255C0") ; <CJK>
       (?$(Klh(B . "0x2571A") ; <CJK>
       (?$(Kli(B . "0x258EF") ; <CJK>
       (?$(Klj(B . "0x258EC") ; <CJK>
       (?$(Klk(B . "0x258E9") ; <CJK>
       (?$(Kll(B . "0x258F0") ; <CJK>
       (?$(Klm(B . "0x258FE") ; <CJK>
       (?$(Kln(B . "0x25A34") ; <CJK>
       (?$(Klo(B . "0x25D6A") ; <CJK>
       (?$(Klp(B . "0x25D95") ; <CJK>
       (?$(Klq(B . "0x25D6C") ; <CJK>
       (?$(Klr(B . "0x25D72") ; <CJK>
       (?$(Kls(B . "0x25D67") ; <CJK>
       (?$(Klt(B . "0x25D60") ; <CJK>
       (?$(Klu(B . "0x25D6B") ; <CJK>
       (?$(Klv(B . "0x25D5E") ; <CJK>
       (?$(Klw(B . "0x25D6F") ; <CJK>
       (?$(Klx(B . "0x25D66") ; <CJK>
       (?$(Kly(B . "0x7C46") ; <CJK>
       (?$(Klz(B . "0x25D62") ; <CJK>
       (?$(Kl{(B . "0x25D5D") ; <CJK>
       (?$(Kl|(B . "0x25D5C") ; <CJK>
       (?$(Kl}(B . "0x2F965") ; <CJK>
       (?$(Kl~(B . "0x25F50") ; <CJK>
       (?$(Km!(B . "0x2619F") ; <CJK>
       (?$(Km"(B . "0x4323") ; <CJK>
       (?$(Km#(B . "0x2619E") ; <CJK>
       (?$(Km$(B . "0x261A6") ; <CJK>
       (?$(Km%(B . "0x26335") ; <CJK>
       (?$(Km&(B . "0x26338") ; <CJK>
       (?$(Km'(B . "0x26336") ; <CJK>
       (?$(Km((B . "0x2633A") ; <CJK>
       (?$(Km)(B . "0x263DC") ; <CJK>
       (?$(Km*(B . "0x2687C") ; <CJK>
       (?$(Km+(B . "0x268AB") ; <CJK>
       (?$(Km,(B . "0x4449") ; <CJK>
       (?$(Km-(B . "0x268A8") ; <CJK>
       (?$(Km.(B . "0x268A7") ; <CJK>
       (?$(Km/(B . "0x2692B") ; <CJK>
       (?$(Km0(B . "0x2692C") ; <CJK>
       (?$(Km1(B . "0x26928") ; <CJK>
       (?$(Km2(B . "0x2092B") ; <CJK>
       (?$(Km3(B . "0x269A9") ; <CJK>
       (?$(Km4(B . "0x269AA") ; <CJK>
       (?$(Km5(B . "0x269AB") ; <CJK>
       (?$(Km6(B . "0x269F8") ; <CJK>
       (?$(Km7(B . "0x26AB1") ; <CJK>
       (?$(Km8(B . "0x26AF0") ; <CJK>
       (?$(Km9(B . "0x26AEF") ; <CJK>
       (?$(Km:(B . "0x270A8") ; <CJK>
       (?$(Km;(B . "0x2708B") ; <CJK>
       (?$(Km<(B . "0x27094") ; <CJK>
       (?$(Km=(B . "0x2709E") ; <CJK>
       (?$(Km>(B . "0x2708F") ; <CJK>
       (?$(Km?(B . "0x27088") ; <CJK>
       (?$(Km@(B . "0x2707E") ; <CJK>
       (?$(KmA(B . "0x27081") ; <CJK>
       (?$(KmB(B . "0x27030") ; <CJK>
       (?$(KmC(B . "0x2709B") ; <CJK>
       (?$(KmD(B . "0x27082") ; <CJK>
       (?$(KmE(B . "0x27090") ; <CJK>
       (?$(KmF(B . "0x27085") ; <CJK>
       (?$(KmG(B . "0x2707F") ; <CJK>
       (?$(KmH(B . "0x270A9") ; <CJK>
       (?$(KmI(B . "0x270DE") ; <CJK>
       (?$(KmJ(B . "0x2720D") ; <CJK>
       (?$(KmK(B . "0x45FA") ; <CJK>
       (?$(KmL(B . "0x274CF") ; <CJK>
       (?$(KmM(B . "0x274CB") ; <CJK>
       (?$(KmN(B . "0x274D8") ; <CJK>
       (?$(KmO(B . "0x274DD") ; <CJK>
       (?$(KmP(B . "0x274D3") ; <CJK>
       (?$(KmQ(B . "0x274D0") ; <CJK>
       (?$(KmR(B . "0x274D5") ; <CJK>
       (?$(KmS(B . "0x274D6") ; <CJK>
       (?$(KmT(B . "0x275D6") ; <CJK>
       (?$(KmU(B . "0x27792") ; <CJK>
       (?$(KmV(B . "0x27795") ; <CJK>
       (?$(KmW(B . "0x2A5CB") ; <CJK>
       (?$(KmX(B . "0x2778D") ; <CJK>
       (?$(KmY(B . "0x2779B") ; <CJK>
       (?$(KmZ(B . "0x2779D") ; <CJK>
       (?$(Km[(B . "0x2778F") ; <CJK>
       (?$(Km\(B . "0x2779E") ; <CJK>
       (?$(Km](B . "0x277A6") ; <CJK>
       (?$(Km^(B . "0x27896") ; <CJK>
       (?$(Km_(B . "0x27892") ; <CJK>
       (?$(Km`(B . "0x27B16") ; <CJK>
       (?$(Kma(B . "0x27B2A") ; <CJK>
       (?$(Kmb(B . "0x27B29") ; <CJK>
       (?$(Kmc(B . "0x27B2C") ; <CJK>
       (?$(Kmd(B . "0x27C15") ; <CJK>
       (?$(Kme(B . "0x27C12") ; <CJK>
       (?$(Kmf(B . "0x27C11") ; <CJK>
       (?$(Kmg(B . "0x27C13") ; <CJK>
       (?$(Kmh(B . "0x27C88") ; <CJK>
       (?$(Kmi(B . "0x27C8B") ; <CJK>
       (?$(Kmj(B . "0x27C8A") ; <CJK>
       (?$(Kmk(B . "0x27C87") ; <CJK>
       (?$(Kml(B . "0x27D17") ; <CJK>
       (?$(Kmm(B . "0x27D16") ; <CJK>
       (?$(Kmn(B . "0x27D1A") ; <CJK>
       (?$(Kmo(B . "0x27E19") ; <CJK>
       (?$(Kmp(B . "0x27E17") ; <CJK>
       (?$(Kmq(B . "0x27F91") ; <CJK>
       (?$(Kmr(B . "0x27F94") ; <CJK>
       (?$(Kms(B . "0x2818B") ; <CJK>
       (?$(Kmt(B . "0x28190") ; <CJK>
       (?$(Kmu(B . "0x2818F") ; <CJK>
       (?$(Kmv(B . "0x28186") ; <CJK>
       (?$(Kmw(B . "0x28183") ; <CJK>
       (?$(Kmx(B . "0x2818E") ; <CJK>
       (?$(Kmy(B . "0x28187") ; <CJK>
       (?$(Kmz(B . "0x281A8") ; <CJK>
       (?$(Km{(B . "0x28185") ; <CJK>
       (?$(Km|(B . "0x281A6") ; <CJK>
       (?$(Km}(B . "0x28182") ; <CJK>
       (?$(Km~(B . "0x281A7") ; <CJK>
       (?$(Kn!(B . "0x283B9") ; <CJK>
       (?$(Kn"(B . "0x283B7") ; <CJK>
       (?$(Kn#(B . "0x283B4") ; <CJK>
       (?$(Kn$(B . "0x283B6") ; <CJK>
       (?$(Kn%(B . "0x283B3") ; <CJK>
       (?$(Kn&(B . "0x283C6") ; <CJK>
       (?$(Kn'(B . "0x2863C") ; <CJK>
       (?$(Kn((B . "0x28640") ; <CJK>
       (?$(Kn)(B . "0x28638") ; <CJK>
       (?$(Kn*(B . "0x28791") ; <CJK>
       (?$(Kn+(B . "0x287A6") ; <CJK>
       (?$(Kn,(B . "0x287DA") ; <CJK>
       (?$(Kn-(B . "0x288DA") ; <CJK>
       (?$(Kn.(B . "0x288D8") ; <CJK>
       (?$(Kn/(B . "0x288D9") ; <CJK>
       (?$(Kn0(B . "0x288DB") ; <CJK>
       (?$(Kn1(B . "0x288D7") ; <CJK>
       (?$(Kn2(B . "0x28B16") ; <CJK>
       (?$(Kn3(B . "0x28B12") ; <CJK>
       (?$(Kn4(B . "0x28B1F") ; <CJK>
       (?$(Kn5(B . "0x4959") ; <CJK>
       (?$(Kn6(B . "0x28B14") ; <CJK>
       (?$(Kn7(B . "0x28B1A") ; <CJK>
       (?$(Kn8(B . "0x28B10") ; <CJK>
       (?$(Kn9(B . "0x28CB3") ; <CJK>
       (?$(Kn:(B . "0x28DAE") ; <CJK>
       (?$(Kn;(B . "0x28DC1") ; <CJK>
       (?$(Kn<(B . "0x28DB0") ; <CJK>
       (?$(Kn=(B . "0x28DAF") ; <CJK>
       (?$(Kn>(B . "0x28DB1") ; <CJK>
       (?$(Kn?(B . "0x28DAD") ; <CJK>
       (?$(Kn@(B . "0x28DB2") ; <CJK>
       (?$(KnA(B . "0x28DC4") ; <CJK>
       (?$(KnB(B . "0x2903C") ; <CJK>
       (?$(KnC(B . "0x2903F") ; <CJK>
       (?$(KnD(B . "0x29161") ; <CJK>
       (?$(KnE(B . "0x29166") ; <CJK>
       (?$(KnF(B . "0x2923C") ; <CJK>
       (?$(KnG(B . "0x2923B") ; <CJK>
       (?$(KnH(B . "0x2932C") ; <CJK>
       (?$(KnI(B . "0x4A7E") ; <CJK>
       (?$(KnJ(B . "0x2932A") ; <CJK>
       (?$(KnK(B . "0x2933E") ; <CJK>
       (?$(KnL(B . "0x2932F") ; <CJK>
       (?$(KnM(B . "0x29332") ; <CJK>
       (?$(KnN(B . "0x29327") ; <CJK>
       (?$(KnO(B . "0x29329") ; <CJK>
       (?$(KnP(B . "0x29340") ; <CJK>
       (?$(KnQ(B . "0x293DF") ; <CJK>
       (?$(KnR(B . "0x293DE") ; <CJK>
       (?$(KnS(B . "0x2943C") ; <CJK>
       (?$(KnT(B . "0x2943B") ; <CJK>
       (?$(KnU(B . "0x2943E") ; <CJK>
       (?$(KnV(B . "0x29521") ; <CJK>
       (?$(KnW(B . "0x29546") ; <CJK>
       (?$(KnX(B . "0x2953C") ; <CJK>
       (?$(KnY(B . "0x29536") ; <CJK>
       (?$(KnZ(B . "0x29538") ; <CJK>
       (?$(Kn[(B . "0x29535") ; <CJK>
       (?$(Kn\(B . "0x29631") ; <CJK>
       (?$(Kn](B . "0x29636") ; <CJK>
       (?$(Kn^(B . "0x2962D") ; <CJK>
       (?$(Kn_(B . "0x29633") ; <CJK>
       (?$(Kn`(B . "0x2962F") ; <CJK>
       (?$(Kna(B . "0x2962E") ; <CJK>
       (?$(Knb(B . "0x29635") ; <CJK>
       (?$(Knc(B . "0x297AC") ; <CJK>
       (?$(Knd(B . "0x297A9") ; <CJK>
       (?$(Kne(B . "0x297A6") ; <CJK>
       (?$(Knf(B . "0x4BA8") ; <CJK>
       (?$(Kng(B . "0x2994C") ; <CJK>
       (?$(Knh(B . "0x29943") ; <CJK>
       (?$(Kni(B . "0x29941") ; <CJK>
       (?$(Knj(B . "0x2994F") ; <CJK>
       (?$(Knk(B . "0x29942") ; <CJK>
       (?$(Knl(B . "0x29951") ; <CJK>
       (?$(Knm(B . "0x4BA9") ; <CJK>
       (?$(Knn(B . "0x29940") ; <CJK>
       (?$(Kno(B . "0x29950") ; <CJK>
       (?$(Knp(B . "0x29945") ; <CJK>
       (?$(Knq(B . "0x2994A") ; <CJK>
       (?$(Knr(B . "0x2994B") ; <CJK>
       (?$(Kns(B . "0x29A83") ; <CJK>
       (?$(Knt(B . "0x29A82") ; <CJK>
       (?$(Knu(B . "0x29A81") ; <CJK>
       (?$(Knv(B . "0x29AE0") ; <CJK>
       (?$(Knw(B . "0x29B98") ; <CJK>
       (?$(Knx(B . "0x29B9F") ; <CJK>
       (?$(Kny(B . "0x29B9B") ; <CJK>
       (?$(Knz(B . "0x29B9A") ; <CJK>
       (?$(Kn{(B . "0x29B99") ; <CJK>
       (?$(Kn|(B . "0x29B96") ; <CJK>
       (?$(Kn}(B . "0x29BAE") ; <CJK>
       (?$(Kn~(B . "0x29B9E") ; <CJK>
       (?$(Ko!(B . "0x29D09") ; <CJK>
       (?$(Ko"(B . "0x29D0D") ; <CJK>
       (?$(Ko#(B . "0x29E4E") ; <CJK>
       (?$(Ko$(B . "0x29E4A") ; <CJK>
       (?$(Ko%(B . "0x29E4D") ; <CJK>
       (?$(Ko&(B . "0x29E40") ; <CJK>
       (?$(Ko'(B . "0x29E3E") ; <CJK>
       (?$(Ko((B . "0x29E48") ; <CJK>
       (?$(Ko)(B . "0x29E42") ; <CJK>
       (?$(Ko*(B . "0x29E62") ; <CJK>
       (?$(Ko+(B . "0x29E45") ; <CJK>
       (?$(Ko,(B . "0x29E51") ; <CJK>
       (?$(Ko-(B . "0x2A0C6") ; <CJK>
       (?$(Ko.(B . "0x2A0D0") ; <CJK>
       (?$(Ko/(B . "0x2A0C0") ; <CJK>
       (?$(Ko0(B . "0x2A0B7") ; <CJK>
       (?$(Ko1(B . "0x2A0C2") ; <CJK>
       (?$(Ko2(B . "0x2A0BC") ; <CJK>
       (?$(Ko3(B . "0x2A0C5") ; <CJK>
       (?$(Ko4(B . "0x2A0DC") ; <CJK>
       (?$(Ko5(B . "0x2A0DB") ; <CJK>
       (?$(Ko6(B . "0x2A0D2") ; <CJK>
       (?$(Ko7(B . "0x2A0C7") ; <CJK>
       (?$(Ko8(B . "0x2A0B6") ; <CJK>
       (?$(Ko9(B . "0x2A0C9") ; <CJK>
       (?$(Ko:(B . "0x2A0CC") ; <CJK>
       (?$(Ko:(B . "0x9D8D") ; <CJK>
       (?$(Ko;(B . "0x2A0D1") ; <CJK>
       (?$(Ko<(B . "0x2A0CD") ; <CJK>
       (?$(Ko=(B . "0x2A0DA") ; <CJK>
       (?$(Ko>(B . "0x2A0BA") ; <CJK>
       (?$(Ko?(B . "0x2A0D3") ; <CJK>
       (?$(Ko@(B . "0x2A0CE") ; <CJK>
       (?$(KoA(B . "0x2A0F6") ; <CJK>
       (?$(KoB(B . "0x2A0BD") ; <CJK>
       (?$(KoC(B . "0x2A0DD") ; <CJK>
       (?$(KoD(B . "0x2A0C8") ; <CJK>
       (?$(KoE(B . "0x2A10D") ; <CJK>
       (?$(KoF(B . "0x2A135") ; <CJK>
       (?$(KoG(B . "0x2A271") ; <CJK>
       (?$(KoH(B . "0x2A26E") ; <CJK>
       (?$(KoI(B . "0x2A26F") ; <CJK>
       (?$(KoJ(B . "0x2A2D6") ; <CJK>
       (?$(KoK(B . "0x2A34C") ; <CJK>
       (?$(KoL(B . "0x2A34F") ; <CJK>
       (?$(KoM(B . "0x2A354") ; <CJK>
       (?$(KoN(B . "0x2A353") ; <CJK>
       (?$(KoO(B . "0x2A3C9") ; <CJK>
       (?$(KoP(B . "0x2A3C8") ; <CJK>
       (?$(KoQ(B . "0x2A403") ; <CJK>
       (?$(KoR(B . "0x4D54") ; <CJK>
       (?$(KoS(B . "0x2A404") ; <CJK>
       (?$(KoT(B . "0x4D56") ; <CJK>
       (?$(KoU(B . "0x2A457") ; <CJK>
       (?$(KoV(B . "0x2A452") ; <CJK>
       (?$(KoW(B . "0x2A453") ; <CJK>
       (?$(KoX(B . "0x4D6D") ; <CJK>
       (?$(KoY(B . "0x2A456") ; <CJK>
       (?$(KoZ(B . "0x2A45C") ; <CJK>
       (?$(Ko[(B . "0x2A455") ; <CJK>
       (?$(Ko\(B . "0x2A564") ; <CJK>
       (?$(Ko](B . "0x2A55D") ; <CJK>
       (?$(Ko^(B . "0x2A55E") ; <CJK>
       (?$(Ko_(B . "0x2A5A2") ; <CJK>
       (?$(Ko`(B . "0x2A5A3") ; <CJK>
       (?$(Koa(B . "0x4D8E") ; <CJK>
       (?$(Kob(B . "0x2A5E7") ; <CJK>
       (?$(Koc(B . "0x2A5E6") ; <CJK>
       (?$(Kod(B . "0x2A698") ; <CJK>
       (?$(Koe(B . "0x2A6AC") ; <CJK>
       (?$(Kof(B . "0x2A6AF") ; <CJK>
       (?$(Kog(B . "0x2A6AE") ; <CJK>
       (?$(Koh(B . "0x20459") ; <CJK>
       (?$(Koi(B . "0x205A9") ; <CJK>
       (?$(Koj(B . "0x2082A") ; <CJK>
       (?$(Kok(B . "0x208C7") ; <CJK>
       (?$(Kol(B . "0x21141") ; <CJK>
       (?$(Kom(B . "0x21137") ; <CJK>
       (?$(Kon(B . "0x21135") ; <CJK>
       (?$(Koo(B . "0x21133") ; <CJK>
       (?$(Kop(B . "0x21139") ; <CJK>
       (?$(Koq(B . "0x21132") ; <CJK>
       (?$(Kor(B . "0x214FF") ; <CJK>
       (?$(Kos(B . "0x21501") ; <CJK>
       (?$(Kot(B . "0x214F8") ; <CJK>
       (?$(Kou(B . "0x2191B") ; <CJK>
       (?$(Kov(B . "0x21919") ; <CJK>
       (?$(Kow(B . "0x21BBF") ; <CJK>
       (?$(Kox(B . "0x21FBC") ; <CJK>
       (?$(Koy(B . "0x21FBE") ; <CJK>
       (?$(Koz(B . "0x21FBD") ; <CJK>
       (?$(Ko{(B . "0x2217D") ; <CJK>
       (?$(Ko|(B . "0x22446") ; <CJK>
       (?$(Ko}(B . "0x22447") ; <CJK>
       (?$(Ko~(B . "0x225A4") ; <CJK>
       (?$(Kp!(B . "0x22A21") ; <CJK>
       (?$(Kp"(B . "0x22A62") ; <CJK>
       (?$(Kp#(B . "0x22E86") ; <CJK>
       (?$(Kp$(B . "0x3A72") ; <CJK>
       (?$(Kp%(B . "0x2302F") ; <CJK>
       (?$(Kp&(B . "0x23031") ; <CJK>
       (?$(Kp'(B . "0x3C14") ; <CJK>
       (?$(Kp((B . "0x237F8") ; <CJK>
       (?$(Kp)(B . "0x237F5") ; <CJK>
       (?$(Kp*(B . "0x237F9") ; <CJK>
       (?$(Kp+(B . "0x237F2") ; <CJK>
       (?$(Kp,(B . "0x237FA") ; <CJK>
       (?$(Kp-(B . "0x237F3") ; <CJK>
       (?$(Kp.(B . "0x23814") ; <CJK>
       (?$(Kp/(B . "0x237FD") ; <CJK>
       (?$(Kp0(B . "0x2380F") ; <CJK>
       (?$(Kp1(B . "0x2380E") ; <CJK>
       (?$(Kp2(B . "0x23801") ; <CJK>
       (?$(Kp3(B . "0x23937") ; <CJK>
       (?$(Kp4(B . "0x23935") ; <CJK>
       (?$(Kp5(B . "0x23934") ; <CJK>
       (?$(Kp6(B . "0x23931") ; <CJK>
       (?$(Kp7(B . "0x23A7A") ; <CJK>
       (?$(Kp8(B . "0x23A7B") ; <CJK>
       (?$(Kp9(B . "0x23C37") ; <CJK>
       (?$(Kp:(B . "0x2412B") ; <CJK>
       (?$(Kp;(B . "0x240FB") ; <CJK>
       (?$(Kp<(B . "0x24116") ; <CJK>
       (?$(Kp=(B . "0x24113") ; <CJK>
       (?$(Kp>(B . "0x3D93") ; <CJK>
       (?$(Kp?(B . "0x24111") ; <CJK>
       (?$(Kp@(B . "0x2410F") ; <CJK>
       (?$(KpA(B . "0x2411B") ; <CJK>
       (?$(KpB(B . "0x24138") ; <CJK>
       (?$(KpC(B . "0x244A4") ; <CJK>
       (?$(KpD(B . "0x24709") ; <CJK>
       (?$(KpE(B . "0x24707") ; <CJK>
       (?$(KpF(B . "0x2470B") ; <CJK>
       (?$(KpG(B . "0x248D3") ; <CJK>
       (?$(KpH(B . "0x248D1") ; <CJK>
       (?$(KpI(B . "0x248D8") ; <CJK>
       (?$(KpJ(B . "0x24B1D") ; <CJK>
       (?$(KpK(B . "0x24BA9") ; <CJK>
       (?$(KpL(B . "0x24BD0") ; <CJK>
       (?$(KpM(B . "0x27215") ; <CJK>
       (?$(KpN(B . "0x24F02") ; <CJK>
       (?$(KpO(B . "0x24F05") ; <CJK>
       (?$(KpP(B . "0x24F01") ; <CJK>
       (?$(KpQ(B . "0x24F00") ; <CJK>
       (?$(KpR(B . "0x2532E") ; <CJK>
       (?$(KpS(B . "0x25330") ; <CJK>
       (?$(KpT(B . "0x2532F") ; <CJK>
       (?$(KpU(B . "0x25331") ; <CJK>
       (?$(KpV(B . "0x255D2") ; <CJK>
       (?$(KpW(B . "0x255D3") ; <CJK>
       (?$(KpX(B . "0x25902") ; <CJK>
       (?$(KpY(B . "0x25A40") ; <CJK>
       (?$(KpZ(B . "0x25A42") ; <CJK>
       (?$(Kp[(B . "0x25A3B") ; <CJK>
       (?$(Kp\(B . "0x25ACE") ; <CJK>
       (?$(Kp](B . "0x25D98") ; <CJK>
       (?$(Kp^(B . "0x25D8F") ; <CJK>
       (?$(Kp_(B . "0x25D94") ; <CJK>
       (?$(Kp`(B . "0x25D91") ; <CJK>
       (?$(Kpa(B . "0x426F") ; <CJK>
       (?$(Kpb(B . "0x25DBA") ; <CJK>
       (?$(Kpc(B . "0x25D90") ; <CJK>
       (?$(Kpd(B . "0x25D86") ; <CJK>
       (?$(Kpe(B . "0x25D9A") ; <CJK>
       (?$(Kpf(B . "0x25D8C") ; <CJK>
       (?$(Kpg(B . "0x25D93") ; <CJK>
       (?$(Kph(B . "0x25D87") ; <CJK>
       (?$(Kpi(B . "0x25D88") ; <CJK>
       (?$(Kpj(B . "0x25D97") ; <CJK>
       (?$(Kpk(B . "0x25D8D") ; <CJK>
       (?$(Kpl(B . "0x25D9C") ; <CJK>
       (?$(Kpm(B . "0x25DBD") ; <CJK>
       (?$(Kpn(B . "0x25F3C") ; <CJK>
       (?$(Kpo(B . "0x25F59") ; <CJK>
       (?$(Kpp(B . "0x42B0") ; <CJK>
       (?$(Kpq(B . "0x261D1") ; <CJK>
       (?$(Kpr(B . "0x261BB") ; <CJK>
       (?$(Kps(B . "0x261BE") ; <CJK>
       (?$(Kpt(B . "0x2625D") ; <CJK>
       (?$(Kpu(B . "0x263E2") ; <CJK>
       (?$(Kpv(B . "0x26605") ; <CJK>
       (?$(Kpw(B . "0x268BA") ; <CJK>
       (?$(Kpx(B . "0x352E") ; <CJK>
       (?$(Kpy(B . "0x268F4") ; <CJK>
       (?$(Kpz(B . "0x269B2") ; <CJK>
       (?$(Kp{(B . "0x269F9") ; <CJK>
       (?$(Kp|(B . "0x26AB7") ; <CJK>
       (?$(Kp}(B . "0x26AB6") ; <CJK>
       (?$(Kp~(B . "0x27089") ; <CJK>
       (?$(Kq!(B . "0x270F9") ; <CJK>
       (?$(Kq"(B . "0x270D9") ; <CJK>
       (?$(Kq#(B . "0x270E8") ; <CJK>
       (?$(Kq$(B . "0x270D4") ; <CJK>
       (?$(Kq%(B . "0x270DB") ; <CJK>
       (?$(Kq&(B . "0x270E2") ; <CJK>
       (?$(Kq'(B . "0x270DF") ; <CJK>
       (?$(Kq((B . "0x270D1") ; <CJK>
       (?$(Kq)(B . "0x270E9") ; <CJK>
       (?$(Kq*(B . "0x270EA") ; <CJK>
       (?$(Kq+(B . "0x27213") ; <CJK>
       (?$(Kq,(B . "0x27211") ; <CJK>
       (?$(Kq-(B . "0x274FA") ; <CJK>
       (?$(Kq.(B . "0x274F8") ; <CJK>
       (?$(Kq/(B . "0x274F4") ; <CJK>
       (?$(Kq0(B . "0x274FB") ; <CJK>
       (?$(Kq1(B . "0x2750E") ; <CJK>
       (?$(Kq2(B . "0x27502") ; <CJK>
       (?$(Kq3(B . "0x2750F") ; <CJK>
       (?$(Kq4(B . "0x27790") ; <CJK>
       (?$(Kq5(B . "0x277AD") ; <CJK>
       (?$(Kq6(B . "0x277A9") ; <CJK>
       (?$(Kq7(B . "0x27948") ; <CJK>
       (?$(Kq8(B . "0x27B5A") ; <CJK>
       (?$(Kq9(B . "0x27B4F") ; <CJK>
       (?$(Kq:(B . "0x27B4E") ; <CJK>
       (?$(Kq;(B . "0x27B55") ; <CJK>
       (?$(Kq<(B . "0x27B54") ; <CJK>
       (?$(Kq=(B . "0x27B4A") ; <CJK>
       (?$(Kq>(B . "0x27BD5") ; <CJK>
       (?$(Kq?(B . "0x27C18") ; <CJK>
       (?$(Kq@(B . "0x27C8D") ; <CJK>
       (?$(KqA(B . "0x27D1D") ; <CJK>
       (?$(KqB(B . "0x27D19") ; <CJK>
       (?$(KqC(B . "0x27E26") ; <CJK>
       (?$(KqD(B . "0x27E28") ; <CJK>
       (?$(KqE(B . "0x27E2B") ; <CJK>
       (?$(KqF(B . "0x27E7D") ; <CJK>
       (?$(KqG(B . "0x27FA0") ; <CJK>
       (?$(KqH(B . "0x27F9A") ; <CJK>
       (?$(KqI(B . "0x27F9B") ; <CJK>
       (?$(KqJ(B . "0x281B5") ; <CJK>
       (?$(KqK(B . "0x281AD") ; <CJK>
       (?$(KqL(B . "0x281B2") ; <CJK>
       (?$(KqM(B . "0x28294") ; <CJK>
       (?$(KqN(B . "0x283C9") ; <CJK>
       (?$(KqO(B . "0x2864E") ; <CJK>
       (?$(KqP(B . "0x2864F") ; <CJK>
       (?$(KqQ(B . "0x28644") ; <CJK>
       (?$(KqR(B . "0x28652") ; <CJK>
       (?$(KqS(B . "0x288E9") ; <CJK>
       (?$(KqT(B . "0x28939") ; <CJK>
       (?$(KqU(B . "0x4969") ; <CJK>
       (?$(KqV(B . "0x957E") ; <CJK>
       (?$(KqW(B . "0x28DC7") ; <CJK>
       (?$(KqX(B . "0x28DD3") ; <CJK>
       (?$(KqY(B . "0x28DC6") ; <CJK>
       (?$(KqZ(B . "0x28DC3") ; <CJK>
       (?$(Kq[(B . "0x49B4") ; <CJK>
       (?$(Kq\(B . "0x28DD2") ; <CJK>
       (?$(Kq](B . "0x28F66") ; <CJK>
       (?$(Kq^(B . "0x2917F") ; <CJK>
       (?$(Kq_(B . "0x29180") ; <CJK>
       (?$(Kq`(B . "0x29184") ; <CJK>
       (?$(Kqa(B . "0x29185") ; <CJK>
       (?$(Kqb(B . "0x291E3") ; <CJK>
       (?$(Kqc(B . "0x4A4D") ; <CJK>
       (?$(Kqd(B . "0x29241") ; <CJK>
       (?$(Kqe(B . "0x29244") ; <CJK>
       (?$(Kqf(B . "0x29243") ; <CJK>
       (?$(Kqg(B . "0x2934E") ; <CJK>
       (?$(Kqh(B . "0x2934F") ; <CJK>
       (?$(Kqi(B . "0x4A83") ; <CJK>
       (?$(Kqj(B . "0x29349") ; <CJK>
       (?$(Kqk(B . "0x2934A") ; <CJK>
       (?$(Kql(B . "0x2934B") ; <CJK>
       (?$(Kqm(B . "0x29343") ; <CJK>
       (?$(Kqn(B . "0x293E0") ; <CJK>
       (?$(Kqo(B . "0x293E5") ; <CJK>
       (?$(Kqp(B . "0x293E1") ; <CJK>
       (?$(Kqq(B . "0x293E6") ; <CJK>
       (?$(Kqr(B . "0x293E2") ; <CJK>
       (?$(Kqs(B . "0x2940C") ; <CJK>
       (?$(Kqt(B . "0x29440") ; <CJK>
       (?$(Kqu(B . "0x29549") ; <CJK>
       (?$(Kqv(B . "0x2954A") ; <CJK>
       (?$(Kqw(B . "0x29554") ; <CJK>
       (?$(Kqx(B . "0x2954C") ; <CJK>
       (?$(Kqy(B . "0x29555") ; <CJK>
       (?$(Kqz(B . "0x29556") ; <CJK>
       (?$(Kq{(B . "0x2963B") ; <CJK>
       (?$(Kq|(B . "0x2963D") ; <CJK>
       (?$(Kq}(B . "0x297A4") ; <CJK>
       (?$(Kq~(B . "0x297A8") ; <CJK>
       (?$(Kr!(B . "0x297C3") ; <CJK>
       (?$(Kr"(B . "0x297BF") ; <CJK>
       (?$(Kr#(B . "0x297C8") ; <CJK>
       (?$(Kr$(B . "0x297C2") ; <CJK>
       (?$(Kr%(B . "0x297CA") ; <CJK>
       (?$(Kr&(B . "0x297CC") ; <CJK>
       (?$(Kr'(B . "0x297C9") ; <CJK>
       (?$(Kr((B . "0x297BE") ; <CJK>
       (?$(Kr)(B . "0x297CD") ; <CJK>
       (?$(Kr*(B . "0x297C7") ; <CJK>
       (?$(Kr+(B . "0x297C5") ; <CJK>
       (?$(Kr,(B . "0x2985D") ; <CJK>
       (?$(Kr-(B . "0x4BB0") ; <CJK>
       (?$(Kr.(B . "0x2996C") ; <CJK>
       (?$(Kr/(B . "0x2996B") ; <CJK>
       (?$(Kr0(B . "0x29970") ; <CJK>
       (?$(Kr1(B . "0x2996D") ; <CJK>
       (?$(Kr2(B . "0x2996F") ; <CJK>
       (?$(Kr3(B . "0x29989") ; <CJK>
       (?$(Kr4(B . "0x29984") ; <CJK>
       (?$(Kr5(B . "0x29A8D") ; <CJK>
       (?$(Kr6(B . "0x29A8A") ; <CJK>
       (?$(Kr7(B . "0x29A8E") ; <CJK>
       (?$(Kr8(B . "0x29A91") ; <CJK>
       (?$(Kr9(B . "0x29BB5") ; <CJK>
       (?$(Kr:(B . "0x29BB1") ; <CJK>
       (?$(Kr;(B . "0x29BAF") ; <CJK>
       (?$(Kr<(B . "0x29BB9") ; <CJK>
       (?$(Kr=(B . "0x29BB7") ; <CJK>
       (?$(Kr>(B . "0x29BB0") ; <CJK>
       (?$(Kr?(B . "0x4C0C") ; <CJK>
       (?$(Kr@(B . "0x29C17") ; <CJK>
       (?$(KrA(B . "0x4C18") ; <CJK>
       (?$(KrB(B . "0x29C4F") ; <CJK>
       (?$(KrC(B . "0x29D19") ; <CJK>
       (?$(KrD(B . "0x29D10") ; <CJK>
       (?$(KrE(B . "0x29D18") ; <CJK>
       (?$(KrF(B . "0x29D11") ; <CJK>
       (?$(KrG(B . "0x29D1C") ; <CJK>
       (?$(KrH(B . "0x29D12") ; <CJK>
       (?$(KrI(B . "0x29E76") ; <CJK>
       (?$(KrJ(B . "0x29E71") ; <CJK>
       (?$(KrK(B . "0x9C20") ; <CJK>
       (?$(KrL(B . "0x29E7A") ; <CJK>
       (?$(KrM(B . "0x29E7F") ; <CJK>
       (?$(KrN(B . "0x9C22") ; <CJK>
       (?$(KrO(B . "0x29E73") ; <CJK>
       (?$(KrP(B . "0x29EAB") ; <CJK>
       (?$(KrQ(B . "0x9C1E") ; <CJK>
       (?$(KrR(B . "0x29E77") ; <CJK>
       (?$(KrS(B . "0x29E74") ; <CJK>
       (?$(KrT(B . "0x29E7E") ; <CJK>
       (?$(KrU(B . "0x29E9B") ; <CJK>
       (?$(KrV(B . "0x29E84") ; <CJK>
       (?$(KrW(B . "0x29E7C") ; <CJK>
       (?$(KrX(B . "0x2A129") ; <CJK>
       (?$(KrY(B . "0x2A12B") ; <CJK>
       (?$(KrZ(B . "0x2A10E") ; <CJK>
       (?$(Kr[(B . "0x2A100") ; <CJK>
       (?$(Kr\(B . "0x2A10B") ; <CJK>
       (?$(Kr](B . "0x2A0FE") ; <CJK>
       (?$(Kr^(B . "0x2A0FA") ; <CJK>
       (?$(Kr_(B . "0x2A117") ; <CJK>
       (?$(Kr`(B . "0x2A0FF") ; <CJK>
       (?$(Kra(B . "0x2A10C") ; <CJK>
       (?$(Krb(B . "0x2A10F") ; <CJK>
       (?$(Krc(B . "0x4CF5") ; <CJK>
       (?$(Krd(B . "0x2A102") ; <CJK>
       (?$(Kre(B . "0x2A101") ; <CJK>
       (?$(Krf(B . "0x2A0FC") ; <CJK>
       (?$(Krg(B . "0x2A149") ; <CJK>
       (?$(Krh(B . "0x2A106") ; <CJK>
       (?$(Kri(B . "0x2A112") ; <CJK>
       (?$(Krj(B . "0x2A113") ; <CJK>
       (?$(Krk(B . "0x2A278") ; <CJK>
       (?$(Krl(B . "0x2A35B") ; <CJK>
       (?$(Krm(B . "0x2A362") ; <CJK>
       (?$(Krn(B . "0x2A35F") ; <CJK>
       (?$(Kro(B . "0x2A35D") ; <CJK>
       (?$(Krp(B . "0x2A3AB") ; <CJK>
       (?$(Krq(B . "0x2A3D5") ; <CJK>
       (?$(Krr(B . "0x2A3D4") ; <CJK>
       (?$(Krs(B . "0x2A3D3") ; <CJK>
       (?$(Krt(B . "0x2A407") ; <CJK>
       (?$(Kru(B . "0x2A46C") ; <CJK>
       (?$(Krv(B . "0x2A470") ; <CJK>
       (?$(Krw(B . "0x2A46E") ; <CJK>
       (?$(Krx(B . "0x2A468") ; <CJK>
       (?$(Kry(B . "0x2A46D") ; <CJK>
       (?$(Krz(B . "0x2A477") ; <CJK>
       (?$(Kr{(B . "0x2A46A") ; <CJK>
       (?$(Kr|(B . "0x2A4CE") ; <CJK>
       (?$(Kr}(B . "0x2A4EC") ; <CJK>
       (?$(Kr~(B . "0x2A569") ; <CJK>
       (?$(Ks!(B . "0x2A568") ; <CJK>
       (?$(Ks"(B . "0x2A5A6") ; <CJK>
       (?$(Ks#(B . "0x2A5A9") ; <CJK>
       (?$(Ks$(B . "0x2A5AA") ; <CJK>
       (?$(Ks%(B . "0x2A600") ; <CJK>
       (?$(Ks&(B . "0x2A60D") ; <CJK>
       (?$(Ks'(B . "0x2A5F8") ; <CJK>
       (?$(Ks((B . "0x2A5FC") ; <CJK>
       (?$(Ks)(B . "0x2A60A") ; <CJK>
       (?$(Ks*(B . "0x2A5F7") ; <CJK>
       (?$(Ks+(B . "0x2A601") ; <CJK>
       (?$(Ks,(B . "0x2A6B6") ; <CJK>
       (?$(Ks-(B . "0x2A6BB") ; <CJK>
       (?$(Ks.(B . "0x2A6B7") ; <CJK>
       (?$(Ks/(B . "0x2A6B9") ; <CJK>
       (?$(Ks0(B . "0x2A6CA") ; <CJK>
       (?$(Ks1(B . "0x20469") ; <CJK>
       (?$(Ks2(B . "0x20625") ; <CJK>
       (?$(Ks3(B . "0x21159") ; <CJK>
       (?$(Ks4(B . "0x21507") ; <CJK>
       (?$(Ks5(B . "0x21509") ; <CJK>
       (?$(Ks6(B . "0x21922") ; <CJK>
       (?$(Ks7(B . "0x21B07") ; <CJK>
       (?$(Ks8(B . "0x21B04") ; <CJK>
       (?$(Ks9(B . "0x2330F") ; <CJK>
       (?$(Ks:(B . "0x21CF8") ; <CJK>
       (?$(Ks;(B . "0x21FC7") ; <CJK>
       (?$(Ks<(B . "0x21FD1") ; <CJK>
       (?$(Ks=(B . "0x2217E") ; <CJK>
       (?$(Ks>(B . "0x22308") ; <CJK>
       (?$(Ks?(B . "0x2244A") ; <CJK>
       (?$(Ks@(B . "0x2F898") ; <CJK>
       (?$(KsA(B . "0x224B9") ; <CJK>
       (?$(KsB(B . "0x22E88") ; <CJK>
       (?$(KsC(B . "0x22E91") ; <CJK>
       (?$(KsD(B . "0x22E84") ; <CJK>
       (?$(KsE(B . "0x22E73") ; <CJK>
       (?$(KsF(B . "0x22E89") ; <CJK>
       (?$(KsG(B . "0x22E85") ; <CJK>
       (?$(KsH(B . "0x23033") ; <CJK>
       (?$(KsI(B . "0x23313") ; <CJK>
       (?$(KsJ(B . "0x2381D") ; <CJK>
       (?$(KsK(B . "0x2381F") ; <CJK>
       (?$(KsL(B . "0x2381C") ; <CJK>
       (?$(KsM(B . "0x23820") ; <CJK>
       (?$(KsN(B . "0x2381A") ; <CJK>
       (?$(KsO(B . "0x2381B") ; <CJK>
       (?$(KsP(B . "0x23939") ; <CJK>
       (?$(KsQ(B . "0x239AF") ; <CJK>
       (?$(KsR(B . "0x23AE5") ; <CJK>
       (?$(KsS(B . "0x23C3C") ; <CJK>
       (?$(KsT(B . "0x24137") ; <CJK>
       (?$(KsU(B . "0x2413A") ; <CJK>
       (?$(KsV(B . "0x244BB") ; <CJK>
       (?$(KsW(B . "0x3E0E") ; <CJK>
       (?$(KsX(B . "0x24710") ; <CJK>
       (?$(KsY(B . "0x2470D") ; <CJK>
       (?$(KsZ(B . "0x24BAF") ; <CJK>
       (?$(Ks[(B . "0x24C11") ; <CJK>
       (?$(Ks\(B . "0x3FD8") ; <CJK>
       (?$(Ks](B . "0x24F0D") ; <CJK>
       (?$(Ks^(B . "0x24F0C") ; <CJK>
       (?$(Ks_(B . "0x24F0B") ; <CJK>
       (?$(Ks`(B . "0x250D4") ; <CJK>
       (?$(Ksa(B . "0x2533D") ; <CJK>
       (?$(Ksb(B . "0x2533E") ; <CJK>
       (?$(Ksc(B . "0x2533B") ; <CJK>
       (?$(Ksd(B . "0x25343") ; <CJK>
       (?$(Kse(B . "0x25340") ; <CJK>
       (?$(Ksf(B . "0x25346") ; <CJK>
       (?$(Ksg(B . "0x25411") ; <CJK>
       (?$(Ksh(B . "0x255DD") ; <CJK>
       (?$(Ksi(B . "0x255DF") ; <CJK>
       (?$(Ksj(B . "0x255EA") ; <CJK>
       (?$(Ksk(B . "0x2574A") ; <CJK>
       (?$(Ksl(B . "0x25906") ; <CJK>
       (?$(Ksm(B . "0x25DC1") ; <CJK>
       (?$(Ksn(B . "0x25DB9") ; <CJK>
       (?$(Kso(B . "0x25DC6") ; <CJK>
       (?$(Ksp(B . "0x25DB8") ; <CJK>
       (?$(Ksq(B . "0x25DBB") ; <CJK>
       (?$(Ksr(B . "0x25DC8") ; <CJK>
       (?$(Kss(B . "0x25DC5") ; <CJK>
       (?$(Kst(B . "0x25DBF") ; <CJK>
       (?$(Ksu(B . "0x25DC7") ; <CJK>
       (?$(Ksv(B . "0x25DC4") ; <CJK>
       (?$(Ksw(B . "0x25F65") ; <CJK>
       (?$(Ksx(B . "0x25F67") ; <CJK>
       (?$(Ksy(B . "0x261D7") ; <CJK>
       (?$(Ksz(B . "0x261DB") ; <CJK>
       (?$(Ks{(B . "0x261D4") ; <CJK>
       (?$(Ks|(B . "0x261D6") ; <CJK>
       (?$(Ks}(B . "0x263E8") ; <CJK>
       (?$(Ks~(B . "0x2660A") ; <CJK>
       (?$(Kt!(B . "0x26ABD") ; <CJK>
       (?$(Kt"(B . "0x26ABE") ; <CJK>
       (?$(Kt#(B . "0x2711A") ; <CJK>
       (?$(Kt$(B . "0x2710D") ; <CJK>
       (?$(Kt%(B . "0x2710F") ; <CJK>
       (?$(Kt&(B . "0x2711B") ; <CJK>
       (?$(Kt'(B . "0x27110") ; <CJK>
       (?$(Kt((B . "0x27111") ; <CJK>
       (?$(Kt)(B . "0x27113") ; <CJK>
       (?$(Kt*(B . "0x27218") ; <CJK>
       (?$(Kt+(B . "0x27520") ; <CJK>
       (?$(Kt,(B . "0x2751F") ; <CJK>
       (?$(Kt-(B . "0x27523") ; <CJK>
       (?$(Kt.(B . "0x2751D") ; <CJK>
       (?$(Kt/(B . "0x27537") ; <CJK>
       (?$(Kt0(B . "0x27525") ; <CJK>
       (?$(Kt1(B . "0x27524") ; <CJK>
       (?$(Kt2(B . "0x2752A") ; <CJK>
       (?$(Kt3(B . "0x27527") ; <CJK>
       (?$(Kt4(B . "0x27533") ; <CJK>
       (?$(Kt5(B . "0x27528") ; <CJK>
       (?$(Kt6(B . "0x27534") ; <CJK>
       (?$(Kt7(B . "0x277BA") ; <CJK>
       (?$(Kt8(B . "0x8970") ; <CJK>
       (?$(Kt9(B . "0x2789D") ; <CJK>
       (?$(Kt:(B . "0x2794C") ; <CJK>
       (?$(Kt;(B . "0x27B5C") ; <CJK>
       (?$(Kt<(B . "0x27B6A") ; <CJK>
       (?$(Kt=(B . "0x27B5D") ; <CJK>
       (?$(Kt>(B . "0x27B65") ; <CJK>
       (?$(Kt?(B . "0x27B63") ; <CJK>
       (?$(Kt@(B . "0x27B5E") ; <CJK>
       (?$(KtA(B . "0x27C19") ; <CJK>
       (?$(KtB(B . "0x27C97") ; <CJK>
       (?$(KtC(B . "0x27E3F") ; <CJK>
       (?$(KtD(B . "0x27E33") ; <CJK>
       (?$(KtE(B . "0x27E32") ; <CJK>
       (?$(KtF(B . "0x27FA1") ; <CJK>
       (?$(KtG(B . "0x27FA5") ; <CJK>
       (?$(KtH(B . "0x27FA4") ; <CJK>
       (?$(KtI(B . "0x27FA2") ; <CJK>
       (?$(KtJ(B . "0x281C1") ; <CJK>
       (?$(KtK(B . "0x482C") ; <CJK>
       (?$(KtL(B . "0x281C7") ; <CJK>
       (?$(KtM(B . "0x281C4") ; <CJK>
       (?$(KtN(B . "0x281C6") ; <CJK>
       (?$(KtO(B . "0x281C5") ; <CJK>
       (?$(KtP(B . "0x281D4") ; <CJK>
       (?$(KtQ(B . "0x281CA") ; <CJK>
       (?$(KtR(B . "0x28653") ; <CJK>
       (?$(KtS(B . "0x288F1") ; <CJK>
       (?$(KtT(B . "0x28921") ; <CJK>
       (?$(KtU(B . "0x496E") ; <CJK>
       (?$(KtV(B . "0x28BB7") ; <CJK>
       (?$(KtW(B . "0x28B92") ; <CJK>
       (?$(KtX(B . "0x28DD4") ; <CJK>
       (?$(KtY(B . "0x28F44") ; <CJK>
       (?$(KtZ(B . "0x29198") ; <CJK>
       (?$(Kt[(B . "0x2919B") ; <CJK>
       (?$(Kt\(B . "0x29191") ; <CJK>
       (?$(Kt](B . "0x29195") ; <CJK>
       (?$(Kt^(B . "0x2919A") ; <CJK>
       (?$(Kt_(B . "0x29192") ; <CJK>
       (?$(Kt`(B . "0x29353") ; <CJK>
       (?$(Kta(B . "0x29357") ; <CJK>
       (?$(Ktb(B . "0x4A86") ; <CJK>
       (?$(Ktc(B . "0x2935C") ; <CJK>
       (?$(Ktd(B . "0x2935D") ; <CJK>
       (?$(Kte(B . "0x29364") ; <CJK>
       (?$(Ktf(B . "0x293EA") ; <CJK>
       (?$(Ktg(B . "0x293ED") ; <CJK>
       (?$(Kth(B . "0x29442") ; <CJK>
       (?$(Kti(B . "0x29443") ; <CJK>
       (?$(Ktj(B . "0x29564") ; <CJK>
       (?$(Ktk(B . "0x29561") ; <CJK>
       (?$(Ktl(B . "0x29560") ; <CJK>
       (?$(Ktm(B . "0x2967D") ; <CJK>
       (?$(Ktn(B . "0x297D4") ; <CJK>
       (?$(Kto(B . "0x297D5") ; <CJK>
       (?$(Ktp(B . "0x297D9") ; <CJK>
       (?$(Ktq(B . "0x29987") ; <CJK>
       (?$(Ktr(B . "0x29999") ; <CJK>
       (?$(Kts(B . "0x2998C") ; <CJK>
       (?$(Ktt(B . "0x2998A") ; <CJK>
       (?$(Ktu(B . "0x2998F") ; <CJK>
       (?$(Ktv(B . "0x4BB3") ; <CJK>
       (?$(Ktw(B . "0x2998B") ; <CJK>
       (?$(Ktx(B . "0x29982") ; <CJK>
       (?$(Kty(B . "0x2999B") ; <CJK>
       (?$(Ktz(B . "0x4BEB") ; <CJK>
       (?$(Kt{(B . "0x29BC8") ; <CJK>
       (?$(Kt|(B . "0x29BC4") ; <CJK>
       (?$(Kt}(B . "0x29BCC") ; <CJK>
       (?$(Kt~(B . "0x29BC7") ; <CJK>
       (?$(Ku!(B . "0x29BC3") ; <CJK>
       (?$(Ku"(B . "0x29BC6") ; <CJK>
       (?$(Ku#(B . "0x29BCB") ; <CJK>
       (?$(Ku$(B . "0x29BCA") ; <CJK>
       (?$(Ku%(B . "0x29BC9") ; <CJK>
       (?$(Ku&(B . "0x29BCD") ; <CJK>
       (?$(Ku'(B . "0x29C53") ; <CJK>
       (?$(Ku((B . "0x29D21") ; <CJK>
       (?$(Ku)(B . "0x29D29") ; <CJK>
       (?$(Ku*(B . "0x29D1D") ; <CJK>
       (?$(Ku+(B . "0x29D24") ; <CJK>
       (?$(Ku,(B . "0x29D28") ; <CJK>
       (?$(Ku-(B . "0x9C43") ; <CJK>
       (?$(Ku.(B . "0x29EB1") ; <CJK>
       (?$(Ku/(B . "0x29EB2") ; <CJK>
       (?$(Ku0(B . "0x29EB5") ; <CJK>
       (?$(Ku1(B . "0x29ED6") ; <CJK>
       (?$(Ku2(B . "0x29EAF") ; <CJK>
       (?$(Ku3(B . "0x29ECA") ; <CJK>
       (?$(Ku4(B . "0x29EB8") ; <CJK>
       (?$(Ku5(B . "0x2FA12") ; <CJK>
       (?$(Ku6(B . "0x2FA11") ; <CJK>
       (?$(Ku7(B . "0x2A145") ; <CJK>
       (?$(Ku8(B . "0x2A147") ; <CJK>
       (?$(Ku9(B . "0x2A134") ; <CJK>
       (?$(Ku:(B . "0x2A16E") ; <CJK>
       (?$(Ku;(B . "0x2A142") ; <CJK>
       (?$(Ku<(B . "0x2A131") ; <CJK>
       (?$(Ku=(B . "0x2A12E") ; <CJK>
       (?$(Ku>(B . "0x2A156") ; <CJK>
       (?$(Ku?(B . "0x2A138") ; <CJK>
       (?$(Ku@(B . "0x2A137") ; <CJK>
       (?$(KuA(B . "0x2A14B") ; <CJK>
       (?$(KuB(B . "0x2A12D") ; <CJK>
       (?$(KuC(B . "0x2A133") ; <CJK>
       (?$(KuD(B . "0x2A136") ; <CJK>
       (?$(KuE(B . "0x9DE0") ; <CJK>
       (?$(KuF(B . "0x2A148") ; <CJK>
       (?$(KuG(B . "0x2A2DC") ; <CJK>
       (?$(KuH(B . "0x4D42") ; <CJK>
       (?$(KuI(B . "0x2A366") ; <CJK>
       (?$(KuJ(B . "0x2A36D") ; <CJK>
       (?$(KuK(B . "0x2A363") ; <CJK>
       (?$(KuL(B . "0x2A364") ; <CJK>
       (?$(KuM(B . "0x4D41") ; <CJK>
       (?$(KuN(B . "0x2A367") ; <CJK>
       (?$(KuO(B . "0x2A3D9") ; <CJK>
       (?$(KuP(B . "0x2A40B") ; <CJK>
       (?$(KuQ(B . "0x2A47E") ; <CJK>
       (?$(KuR(B . "0x2A48B") ; <CJK>
       (?$(KuS(B . "0x2A526") ; <CJK>
       (?$(KuT(B . "0x2A52C") ; <CJK>
       (?$(KuU(B . "0x2A529") ; <CJK>
       (?$(KuV(B . "0x2A56F") ; <CJK>
       (?$(KuW(B . "0x2A56B") ; <CJK>
       (?$(KuX(B . "0x2A56D") ; <CJK>
       (?$(KuY(B . "0x2A56E") ; <CJK>
       (?$(KuZ(B . "0x2A61C") ; <CJK>
       (?$(Ku[(B . "0x2A611") ; <CJK>
       (?$(Ku\(B . "0x2A610") ; <CJK>
       (?$(Ku](B . "0x2A624") ; <CJK>
       (?$(Ku^(B . "0x2A612") ; <CJK>
       (?$(Ku_(B . "0x2A615") ; <CJK>
       (?$(Ku`(B . "0x2A617") ; <CJK>
       (?$(Kua(B . "0x4DAC") ; <CJK>
       (?$(Kub(B . "0x2046F") ; <CJK>
       (?$(Kuc(B . "0x205AB") ; <CJK>
       (?$(Kud(B . "0x2082E") ; <CJK>
       (?$(Kue(B . "0x208C9") ; <CJK>
       (?$(Kuf(B . "0x20B96") ; <CJK>
       (?$(Kug(B . "0x21185") ; <CJK>
       (?$(Kuh(B . "0x216A0") ; <CJK>
       (?$(Kui(B . "0x2192B") ; <CJK>
       (?$(Kuj(B . "0x2230D") ; <CJK>
       (?$(Kuk(B . "0x23036") ; <CJK>
       (?$(Kul(B . "0x29572") ; <CJK>
       (?$(Kum(B . "0x3B2F") ; <CJK>
       (?$(Kun(B . "0x3B2E") ; <CJK>
       (?$(Kuo(B . "0x233B1") ; <CJK>
       (?$(Kup(B . "0x2384A") ; <CJK>
       (?$(Kuq(B . "0x23837") ; <CJK>
       (?$(Kur(B . "0x2383C") ; <CJK>
       (?$(Kus(B . "0x23838") ; <CJK>
       (?$(Kut(B . "0x2383A") ; <CJK>
       (?$(Kuu(B . "0x2383E") ; <CJK>
       (?$(Kuv(B . "0x23849") ; <CJK>
       (?$(Kuw(B . "0x3C4D") ; <CJK>
       (?$(Kux(B . "0x3C7B") ; <CJK>
       (?$(Kuy(B . "0x23A80") ; <CJK>
       (?$(Kuz(B . "0x23A7F") ; <CJK>
       (?$(Ku{(B . "0x23AE3") ; <CJK>
       (?$(Ku|(B . "0x23C3F") ; <CJK>
       (?$(Ku}(B . "0x24152") ; <CJK>
       (?$(Ku~(B . "0x2414E") ; <CJK>
       (?$(Kv!(B . "0x2414A") ; <CJK>
       (?$(Kv"(B . "0x2414B") ; <CJK>
       (?$(Kv#(B . "0x244D5") ; <CJK>
       (?$(Kv$(B . "0x24AD8") ; <CJK>
       (?$(Kv%(B . "0x24B20") ; <CJK>
       (?$(Kv&(B . "0x24BB3") ; <CJK>
       (?$(Kv'(B . "0x24BB1") ; <CJK>
       (?$(Kv((B . "0x24BB0") ; <CJK>
       (?$(Kv)(B . "0x24F17") ; <CJK>
       (?$(Kv*(B . "0x250D9") ; <CJK>
       (?$(Kv+(B . "0x25349") ; <CJK>
       (?$(Kv,(B . "0x25413") ; <CJK>
       (?$(Kv-(B . "0x255ED") ; <CJK>
       (?$(Kv.(B . "0x255EB") ; <CJK>
       (?$(Kv/(B . "0x255EE") ; <CJK>
       (?$(Kv0(B . "0x2590A") ; <CJK>
       (?$(Kv1(B . "0x2590B") ; <CJK>
       (?$(Kv2(B . "0x25A4A") ; <CJK>
       (?$(Kv3(B . "0x25DD5") ; <CJK>
       (?$(Kv4(B . "0x25DD7") ; <CJK>
       (?$(Kv5(B . "0x25DDE") ; <CJK>
       (?$(Kv6(B . "0x25DDC") ; <CJK>
       (?$(Kv7(B . "0x25DEE") ; <CJK>
       (?$(Kv8(B . "0x25F70") ; <CJK>
       (?$(Kv9(B . "0x42B2") ; <CJK>
       (?$(Kv:(B . "0x261D9") ; <CJK>
       (?$(Kv;(B . "0x263D7") ; <CJK>
       (?$(Kv<(B . "0x268CB") ; <CJK>
       (?$(Kv=(B . "0x268C7") ; <CJK>
       (?$(Kv>(B . "0x269FC") ; <CJK>
       (?$(Kv?(B . "0x2713B") ; <CJK>
       (?$(Kv@(B . "0x27139") ; <CJK>
       (?$(KvA(B . "0x2714B") ; <CJK>
       (?$(KvB(B . "0x27143") ; <CJK>
       (?$(KvC(B . "0x27140") ; <CJK>
       (?$(KvD(B . "0x27146") ; <CJK>
       (?$(KvE(B . "0x2754D") ; <CJK>
       (?$(KvF(B . "0x27543") ; <CJK>
       (?$(KvG(B . "0x27547") ; <CJK>
       (?$(KvH(B . "0x2754B") ; <CJK>
       (?$(KvI(B . "0x27555") ; <CJK>
       (?$(KvJ(B . "0x27552") ; <CJK>
       (?$(KvK(B . "0x27B5F") ; <CJK>
       (?$(KvL(B . "0x4722") ; <CJK>
       (?$(KvM(B . "0x27B7C") ; <CJK>
       (?$(KvN(B . "0x27B7B") ; <CJK>
       (?$(KvO(B . "0x27FA8") ; <CJK>
       (?$(KvP(B . "0x27FA9") ; <CJK>
       (?$(KvQ(B . "0x281DE") ; <CJK>
       (?$(KvR(B . "0x281D7") ; <CJK>
       (?$(KvS(B . "0x281DD") ; <CJK>
       (?$(KvT(B . "0x281D6") ; <CJK>
       (?$(KvU(B . "0x281D8") ; <CJK>
       (?$(KvV(B . "0x2829B") ; <CJK>
       (?$(KvW(B . "0x283E0") ; <CJK>
       (?$(KvX(B . "0x283E8") ; <CJK>
       (?$(KvY(B . "0x283E6") ; <CJK>
       (?$(KvZ(B . "0x288F8") ; <CJK>
       (?$(Kv[(B . "0x288FB") ; <CJK>
       (?$(Kv\(B . "0x28BBB") ; <CJK>
       (?$(Kv](B . "0x9459") ; <CJK>
       (?$(Kv^(B . "0x28BB8") ; <CJK>
       (?$(Kv_(B . "0x4970") ; <CJK>
       (?$(Kv`(B . "0x28CC1") ; <CJK>
       (?$(Kva(B . "0x28CC0") ; <CJK>
       (?$(Kvb(B . "0x291A4") ; <CJK>
       (?$(Kvc(B . "0x291AB") ; <CJK>
       (?$(Kvd(B . "0x2924D") ; <CJK>
       (?$(Kve(B . "0x29365") ; <CJK>
       (?$(Kvf(B . "0x29367") ; <CJK>
       (?$(Kvg(B . "0x2936A") ; <CJK>
       (?$(Kvh(B . "0x29366") ; <CJK>
       (?$(Kvi(B . "0x29369") ; <CJK>
       (?$(Kvj(B . "0x29573") ; <CJK>
       (?$(Kvk(B . "0x29580") ; <CJK>
       (?$(Kvl(B . "0x2956F") ; <CJK>
       (?$(Kvm(B . "0x29571") ; <CJK>
       (?$(Kvn(B . "0x297E4") ; <CJK>
       (?$(Kvo(B . "0x297E6") ; <CJK>
       (?$(Kvp(B . "0x297E7") ; <CJK>
       (?$(Kvq(B . "0x299A0") ; <CJK>
       (?$(Kvr(B . "0x299A4") ; <CJK>
       (?$(Kvs(B . "0x29AA2") ; <CJK>
       (?$(Kvt(B . "0x29AA7") ; <CJK>
       (?$(Kvu(B . "0x29AA4") ; <CJK>
       (?$(Kvv(B . "0x29BDE") ; <CJK>
       (?$(Kvw(B . "0x29BDB") ; <CJK>
       (?$(Kvx(B . "0x29C58") ; <CJK>
       (?$(Kvy(B . "0x29C5C") ; <CJK>
       (?$(Kvz(B . "0x29D2F") ; <CJK>
       (?$(Kv{(B . "0x29D2E") ; <CJK>
       (?$(Kv|(B . "0x29EDD") ; <CJK>
       (?$(Kv}(B . "0x29EE4") ; <CJK>
       (?$(Kv~(B . "0x29ED8") ; <CJK>
       (?$(Kw!(B . "0x29EE7") ; <CJK>
       (?$(Kw"(B . "0x29EDA") ; <CJK>
       (?$(Kw#(B . "0x29E75") ; <CJK>
       (?$(Kw$(B . "0x4C95") ; <CJK>
       (?$(Kw%(B . "0x2A179") ; <CJK>
       (?$(Kw&(B . "0x2A180") ; <CJK>
       (?$(Kw'(B . "0x2A17F") ; <CJK>
       (?$(Kw((B . "0x2A17C") ; <CJK>
       (?$(Kw)(B . "0x2A175") ; <CJK>
       (?$(Kw*(B . "0x2A17B") ; <CJK>
       (?$(Kw+(B . "0x2A182") ; <CJK>
       (?$(Kw,(B . "0x4D00") ; <CJK>
       (?$(Kw-(B . "0x2A189") ; <CJK>
       (?$(Kw.(B . "0x2A174") ; <CJK>
       (?$(Kw/(B . "0x2A17D") ; <CJK>
       (?$(Kw0(B . "0x2A17A") ; <CJK>
       (?$(Kw1(B . "0x2A186") ; <CJK>
       (?$(Kw2(B . "0x2A1A8") ; <CJK>
       (?$(Kw3(B . "0x2A172") ; <CJK>
       (?$(Kw4(B . "0x4D02") ; <CJK>
       (?$(Kw5(B . "0x2A18B") ; <CJK>
       (?$(Kw6(B . "0x2A191") ; <CJK>
       (?$(Kw7(B . "0x2A1B3") ; <CJK>
       (?$(Kw8(B . "0x2A181") ; <CJK>
       (?$(Kw9(B . "0x2A282") ; <CJK>
       (?$(Kw:(B . "0x2A2E1") ; <CJK>
       (?$(Kw;(B . "0x2A2E3") ; <CJK>
       (?$(Kw<(B . "0x2A2E2") ; <CJK>
       (?$(Kw=(B . "0x2A376") ; <CJK>
       (?$(Kw>(B . "0x2A374") ; <CJK>
       (?$(Kw?(B . "0x2A372") ; <CJK>
       (?$(Kw@(B . "0x2A375") ; <CJK>
       (?$(KwA(B . "0x2A40E") ; <CJK>
       (?$(KwB(B . "0x2A40D") ; <CJK>
       (?$(KwC(B . "0x2A494") ; <CJK>
       (?$(KwD(B . "0x2A492") ; <CJK>
       (?$(KwE(B . "0x2A493") ; <CJK>
       (?$(KwF(B . "0x2A491") ; <CJK>
       (?$(KwG(B . "0x2A48F") ; <CJK>
       (?$(KwH(B . "0x2A495") ; <CJK>
       (?$(KwI(B . "0x2A4D0") ; <CJK>
       (?$(KwJ(B . "0x2A4F7") ; <CJK>
       (?$(KwK(B . "0x2A576") ; <CJK>
       (?$(KwL(B . "0x2A5AF") ; <CJK>
       (?$(KwM(B . "0x4D9F") ; <CJK>
       (?$(KwN(B . "0x2A626") ; <CJK>
       (?$(KwO(B . "0x2A625") ; <CJK>
       (?$(KwP(B . "0x2A62D") ; <CJK>
       (?$(KwQ(B . "0x2A6A0") ; <CJK>
       (?$(KwR(B . "0x2A6C3") ; <CJK>
       (?$(KwS(B . "0x204D7") ; <CJK>
       (?$(KwT(B . "0x20ACC") ; <CJK>
       (?$(KwU(B . "0x21179") ; <CJK>
       (?$(KwV(B . "0x2117A") ; <CJK>
       (?$(KwW(B . "0x21515") ; <CJK>
       (?$(KwX(B . "0x21FDB") ; <CJK>
       (?$(KwY(B . "0x22185") ; <CJK>
       (?$(KwZ(B . "0x22970") ; <CJK>
       (?$(Kw[(B . "0x2297B") ; <CJK>
       (?$(Kw\(B . "0x22EA5") ; <CJK>
       (?$(Kw](B . "0x22E9F") ; <CJK>
       (?$(Kw^(B . "0x23317") ; <CJK>
       (?$(Kw_(B . "0x233B2") ; <CJK>
       (?$(Kw`(B . "0x23839") ; <CJK>
       (?$(Kwa(B . "0x23840") ; <CJK>
       (?$(Kwb(B . "0x2384E") ; <CJK>
       (?$(Kwc(B . "0x2393E") ; <CJK>
       (?$(Kwd(B . "0x23AE8") ; <CJK>
       (?$(Kwe(B . "0x23AE7") ; <CJK>
       (?$(Kwf(B . "0x24166") ; <CJK>
       (?$(Kwg(B . "0x24161") ; <CJK>
       (?$(Kwh(B . "0x244DA") ; <CJK>
       (?$(Kwi(B . "0x24714") ; <CJK>
       (?$(Kwj(B . "0x248DF") ; <CJK>
       (?$(Kwk(B . "0x24F18") ; <CJK>
       (?$(Kwl(B . "0x25039") ; <CJK>
       (?$(Kwm(B . "0x2503A") ; <CJK>
       (?$(Kwn(B . "0x25730") ; <CJK>
       (?$(Kwo(B . "0x25732") ; <CJK>
       (?$(Kwp(B . "0x2590E") ; <CJK>
       (?$(Kwq(B . "0x25A4C") ; <CJK>
       (?$(Kwr(B . "0x25DE8") ; <CJK>
       (?$(Kws(B . "0x25DF1") ; <CJK>
       (?$(Kwt(B . "0x25DEB") ; <CJK>
       (?$(Kwu(B . "0x25DEC") ; <CJK>
       (?$(Kwv(B . "0x25F74") ; <CJK>
       (?$(Kww(B . "0x25F73") ; <CJK>
       (?$(Kwx(B . "0x261F1") ; <CJK>
       (?$(Kwy(B . "0x26342") ; <CJK>
       (?$(Kwz(B . "0x2633E") ; <CJK>
       (?$(Kw{(B . "0x26341") ; <CJK>
       (?$(Kw|(B . "0x2652C") ; <CJK>
       (?$(Kw}(B . "0x268D2") ; <CJK>
       (?$(Kw~(B . "0x269BB") ; <CJK>
       (?$(Kx!(B . "0x27158") ; <CJK>
       (?$(Kx"(B . "0x27157") ; <CJK>
       (?$(Kx#(B . "0x27156") ; <CJK>
       (?$(Kx$(B . "0x2715A") ; <CJK>
       (?$(Kx%(B . "0x457D") ; <CJK>
       (?$(Kx&(B . "0x27561") ; <CJK>
       (?$(Kx'(B . "0x27568") ; <CJK>
       (?$(Kx((B . "0x27565") ; <CJK>
       (?$(Kx)(B . "0x2755F") ; <CJK>
       (?$(Kx*(B . "0x27564") ; <CJK>
       (?$(Kx+(B . "0x2755E") ; <CJK>
       (?$(Kx,(B . "0x2755B") ; <CJK>
       (?$(Kx-(B . "0x27567") ; <CJK>
       (?$(Kx.(B . "0x277C3") ; <CJK>
       (?$(Kx/(B . "0x278A2") ; <CJK>
       (?$(Kx0(B . "0x27953") ; <CJK>
       (?$(Kx1(B . "0x27B7D") ; <CJK>
       (?$(Kx2(B . "0x27C20") ; <CJK>
       (?$(Kx3(B . "0x27FAE") ; <CJK>
       (?$(Kx4(B . "0x27FAF") ; <CJK>
       (?$(Kx5(B . "0x27FB0") ; <CJK>
       (?$(Kx6(B . "0x281E7") ; <CJK>
       (?$(Kx7(B . "0x281E6") ; <CJK>
       (?$(Kx8(B . "0x281E9") ; <CJK>
       (?$(Kx9(B . "0x283F1") ; <CJK>
       (?$(Kx:(B . "0x283EB") ; <CJK>
       (?$(Kx;(B . "0x283EA") ; <CJK>
       (?$(Kx<(B . "0x283E9") ; <CJK>
       (?$(Kx=(B . "0x28663") ; <CJK>
       (?$(Kx>(B . "0x28902") ; <CJK>
       (?$(Kx?(B . "0x288FE") ; <CJK>
       (?$(Kx@(B . "0x28BDE") ; <CJK>
       (?$(KxA(B . "0x28CC2") ; <CJK>
       (?$(KxB(B . "0x28DE6") ; <CJK>
       (?$(KxC(B . "0x28F5D") ; <CJK>
       (?$(KxD(B . "0x291AD") ; <CJK>
       (?$(KxE(B . "0x29375") ; <CJK>
       (?$(KxF(B . "0x29372") ; <CJK>
       (?$(KxG(B . "0x29377") ; <CJK>
       (?$(KxH(B . "0x4AF6") ; <CJK>
       (?$(KxI(B . "0x29651") ; <CJK>
       (?$(KxJ(B . "0x297E8") ; <CJK>
       (?$(KxK(B . "0x297ED") ; <CJK>
       (?$(KxL(B . "0x297EE") ; <CJK>
       (?$(KxM(B . "0x299B9") ; <CJK>
       (?$(KxN(B . "0x299A1") ; <CJK>
       (?$(KxO(B . "0x299B6") ; <CJK>
       (?$(KxP(B . "0x29AAE") ; <CJK>
       (?$(KxQ(B . "0x29BE8") ; <CJK>
       (?$(KxR(B . "0x4C12") ; <CJK>
       (?$(KxS(B . "0x29C1E") ; <CJK>
       (?$(KxT(B . "0x29D31") ; <CJK>
       (?$(KxU(B . "0x29D32") ; <CJK>
       (?$(KxV(B . "0x4C91") ; <CJK>
       (?$(KxW(B . "0x29F0E") ; <CJK>
       (?$(KxX(B . "0x29F12") ; <CJK>
       (?$(KxY(B . "0x29F09") ; <CJK>
       (?$(KxZ(B . "0x29F05") ; <CJK>
       (?$(Kx[(B . "0x4C90") ; <CJK>
       (?$(Kx\(B . "0x29F03") ; <CJK>
       (?$(Kx](B . "0x29F1F") ; <CJK>
       (?$(Kx^(B . "0x29F0D") ; <CJK>
       (?$(Kx_(B . "0x29F0C") ; <CJK>
       (?$(Kx`(B . "0x29F04") ; <CJK>
       (?$(Kxa(B . "0x29F0A") ; <CJK>
       (?$(Kxb(B . "0x2A1C2") ; <CJK>
       (?$(Kxc(B . "0x2A1BF") ; <CJK>
       (?$(Kxd(B . "0x2A1C9") ; <CJK>
       (?$(Kxe(B . "0x2A1B2") ; <CJK>
       (?$(Kxf(B . "0x2A1C1") ; <CJK>
       (?$(Kxg(B . "0x2A1AF") ; <CJK>
       (?$(Kxh(B . "0x2A1B4") ; <CJK>
       (?$(Kxi(B . "0x2A1B0") ; <CJK>
       (?$(Kxj(B . "0x2A1B6") ; <CJK>
       (?$(Kxk(B . "0x2A1B7") ; <CJK>
       (?$(Kxl(B . "0x2A1BB") ; <CJK>
       (?$(Kxm(B . "0x2A1B1") ; <CJK>
       (?$(Kxn(B . "0x2A2F0") ; <CJK>
       (?$(Kxo(B . "0x2A378") ; <CJK>
       (?$(Kxp(B . "0x2A37A") ; <CJK>
       (?$(Kxq(B . "0x2A379") ; <CJK>
       (?$(Kxr(B . "0x2A3E4") ; <CJK>
       (?$(Kxs(B . "0x2A3E6") ; <CJK>
       (?$(Kxt(B . "0x2A49F") ; <CJK>
       (?$(Kxu(B . "0x2A49D") ; <CJK>
       (?$(Kxv(B . "0x2A498") ; <CJK>
       (?$(Kxw(B . "0x2A499") ; <CJK>
       (?$(Kxx(B . "0x2A4F9") ; <CJK>
       (?$(Kxy(B . "0x2A530") ; <CJK>
       (?$(Kxz(B . "0x2A582") ; <CJK>
       (?$(Kx{(B . "0x2A581") ; <CJK>
       (?$(Kx|(B . "0x2A5B3") ; <CJK>
       (?$(Kx}(B . "0x2A57F") ; <CJK>
       (?$(Kx~(B . "0x2A63A") ; <CJK>
       (?$(Ky!(B . "0x2A63E") ; <CJK>
       (?$(Ky"(B . "0x2A648") ; <CJK>
       (?$(Ky#(B . "0x21186") ; <CJK>
       (?$(Ky$(B . "0x21936") ; <CJK>
       (?$(Ky%(B . "0x21B13") ; <CJK>
       (?$(Ky&(B . "0x21C22") ; <CJK>
       (?$(Ky'(B . "0x21FDD") ; <CJK>
       (?$(Ky((B . "0x225A7") ; <CJK>
       (?$(Ky)(B . "0x2297D") ; <CJK>
       (?$(Ky*(B . "0x3A79") ; <CJK>
       (?$(Ky+(B . "0x2331C") ; <CJK>
       (?$(Ky,(B . "0x23865") ; <CJK>
       (?$(Ky-(B . "0x23860") ; <CJK>
       (?$(Ky.(B . "0x23867") ; <CJK>
       (?$(Ky/(B . "0x3C4E") ; <CJK>
       (?$(Ky0(B . "0x23B1A") ; <CJK>
       (?$(Ky1(B . "0x24AE3") ; <CJK>
       (?$(Ky2(B . "0x25734") ; <CJK>
       (?$(Ky3(B . "0x25918") ; <CJK>
       (?$(Ky4(B . "0x25A52") ; <CJK>
       (?$(Ky5(B . "0x25DFC") ; <CJK>
       (?$(Ky6(B . "0x25F79") ; <CJK>
       (?$(Ky7(B . "0x25F78") ; <CJK>
       (?$(Ky8(B . "0x25F76") ; <CJK>
       (?$(Ky9(B . "0x261FA") ; <CJK>
       (?$(Ky:(B . "0x261F8") ; <CJK>
       (?$(Ky;(B . "0x2652D") ; <CJK>
       (?$(Ky<(B . "0x268D6") ; <CJK>
       (?$(Ky=(B . "0x269BD") ; <CJK>
       (?$(Ky>(B . "0x269BF") ; <CJK>
       (?$(Ky?(B . "0x269BE") ; <CJK>
       (?$(Ky@(B . "0x27144") ; <CJK>
       (?$(KyA(B . "0x27170") ; <CJK>
       (?$(KyB(B . "0x27162") ; <CJK>
       (?$(KyC(B . "0x2716E") ; <CJK>
       (?$(KyD(B . "0x2756E") ; <CJK>
       (?$(KyE(B . "0x2757C") ; <CJK>
       (?$(KyF(B . "0x27574") ; <CJK>
       (?$(KyG(B . "0x27578") ; <CJK>
       (?$(KyH(B . "0x27570") ; <CJK>
       (?$(KyI(B . "0x27579") ; <CJK>
       (?$(KyJ(B . "0x27571") ; <CJK>
       (?$(KyK(B . "0x277CC") ; <CJK>
       (?$(KyL(B . "0x278A7") ; <CJK>
       (?$(KyM(B . "0x278A6") ; <CJK>
       (?$(KyN(B . "0x27B93") ; <CJK>
       (?$(KyO(B . "0x27C21") ; <CJK>
       (?$(KyP(B . "0x27C9C") ; <CJK>
       (?$(KyQ(B . "0x2829D") ; <CJK>
       (?$(KyR(B . "0x283F4") ; <CJK>
       (?$(KyS(B . "0x283F3") ; <CJK>
       (?$(KyT(B . "0x28DF0") ; <CJK>
       (?$(KyU(B . "0x291B8") ; <CJK>
       (?$(KyV(B . "0x291B6") ; <CJK>
       (?$(KyW(B . "0x291BD") ; <CJK>
       (?$(KyX(B . "0x29373") ; <CJK>
       (?$(KyY(B . "0x29382") ; <CJK>
       (?$(KyZ(B . "0x29587") ; <CJK>
       (?$(Ky[(B . "0x29656") ; <CJK>
       (?$(Ky\(B . "0x29659") ; <CJK>
       (?$(Ky](B . "0x297F6") ; <CJK>
       (?$(Ky^(B . "0x299C9") ; <CJK>
       (?$(Ky_(B . "0x299C5") ; <CJK>
       (?$(Ky`(B . "0x299C7") ; <CJK>
       (?$(Kya(B . "0x299CA") ; <CJK>
       (?$(Kyb(B . "0x299C2") ; <CJK>
       (?$(Kyc(B . "0x299C4") ; <CJK>
       (?$(Kyd(B . "0x29BF2") ; <CJK>
       (?$(Kye(B . "0x29BF0") ; <CJK>
       (?$(Kyf(B . "0x29D3B") ; <CJK>
       (?$(Kyg(B . "0x29D3A") ; <CJK>
       (?$(Kyh(B . "0x29F26") ; <CJK>
       (?$(Kyi(B . "0x29F28") ; <CJK>
       (?$(Kyj(B . "0x29F34") ; <CJK>
       (?$(Kyk(B . "0x29F2D") ; <CJK>
       (?$(Kyl(B . "0x2A1D7") ; <CJK>
       (?$(Kym(B . "0x2A1D2") ; <CJK>
       (?$(Kyn(B . "0x2A1D6") ; <CJK>
       (?$(Kyo(B . "0x2A1DC") ; <CJK>
       (?$(Kyp(B . "0x2A1D3") ; <CJK>
       (?$(Kyq(B . "0x2A1D1") ; <CJK>
       (?$(Kyr(B . "0x2A286") ; <CJK>
       (?$(Kys(B . "0x4D1E") ; <CJK>
       (?$(Kyt(B . "0x2A2EF") ; <CJK>
       (?$(Kyu(B . "0x2A2EE") ; <CJK>
       (?$(Kyv(B . "0x2A3E8") ; <CJK>
       (?$(Kyw(B . "0x2A4AC") ; <CJK>
       (?$(Kyx(B . "0x2A4A9") ; <CJK>
       (?$(Kyy(B . "0x2A4AA") ; <CJK>
       (?$(Kyz(B . "0x2A4AB") ; <CJK>
       (?$(Ky{(B . "0x2A4FB") ; <CJK>
       (?$(Ky|(B . "0x2A533") ; <CJK>
       (?$(Ky}(B . "0x2A588") ; <CJK>
       (?$(Ky~(B . "0x2A5B6") ; <CJK>
       (?$(Kz!(B . "0x2A5B7") ; <CJK>
       (?$(Kz"(B . "0x2A5D0") ; <CJK>
       (?$(Kz#(B . "0x2A5CF") ; <CJK>
       (?$(Kz$(B . "0x2A64F") ; <CJK>
       (?$(Kz%(B . "0x2A659") ; <CJK>
       (?$(Kz&(B . "0x2A64C") ; <CJK>
       (?$(Kz'(B . "0x21B18") ; <CJK>
       (?$(Kz((B . "0x21FE0") ; <CJK>
       (?$(Kz)(B . "0x23869") ; <CJK>
       (?$(Kz*(B . "0x24173") ; <CJK>
       (?$(Kz+(B . "0x24172") ; <CJK>
       (?$(Kz,(B . "0x24AE8") ; <CJK>
       (?$(Kz-(B . "0x255FB") ; <CJK>
       (?$(Kz.(B . "0x2591C") ; <CJK>
       (?$(Kz/(B . "0x25E09") ; <CJK>
       (?$(Kz0(B . "0x25E0A") ; <CJK>
       (?$(Kz1(B . "0x25E08") ; <CJK>
       (?$(Kz2(B . "0x25F7D") ; <CJK>
       (?$(Kz3(B . "0x25F7F") ; <CJK>
       (?$(Kz4(B . "0x26267") ; <CJK>
       (?$(Kz5(B . "0x2717A") ; <CJK>
       (?$(Kz6(B . "0x2717B") ; <CJK>
       (?$(Kz7(B . "0x277D1") ; <CJK>
       (?$(Kz8(B . "0x4695") ; <CJK>
       (?$(Kz8(B . "0x2F9CB") ; <CJK>
       (?$(Kz9(B . "0x27B9D") ; <CJK>
       (?$(Kz:(B . "0x27C9D") ; <CJK>
       (?$(Kz;(B . "0x281FC") ; <CJK>
       (?$(Kz<(B . "0x281FB") ; <CJK>
       (?$(Kz=(B . "0x281FD") ; <CJK>
       (?$(Kz>(B . "0x283F5") ; <CJK>
       (?$(Kz?(B . "0x283F6") ; <CJK>
       (?$(Kz@(B . "0x28C0F") ; <CJK>
       (?$(KzA(B . "0x28C1D") ; <CJK>
       (?$(KzB(B . "0x291C7") ; <CJK>
       (?$(KzC(B . "0x291C1") ; <CJK>
       (?$(KzD(B . "0x291BF") ; <CJK>
       (?$(KzE(B . "0x29254") ; <CJK>
       (?$(KzF(B . "0x2937F") ; <CJK>
       (?$(KzG(B . "0x293F5") ; <CJK>
       (?$(KzH(B . "0x2958A") ; <CJK>
       (?$(KzI(B . "0x2958C") ; <CJK>
       (?$(KzJ(B . "0x2965C") ; <CJK>
       (?$(KzK(B . "0x29865") ; <CJK>
       (?$(KzL(B . "0x299CF") ; <CJK>
       (?$(KzM(B . "0x299D0") ; <CJK>
       (?$(KzN(B . "0x29AB8") ; <CJK>
       (?$(KzO(B . "0x29BFA") ; <CJK>
       (?$(KzP(B . "0x29C66") ; <CJK>
       (?$(KzQ(B . "0x29F40") ; <CJK>
       (?$(KzR(B . "0x29F41") ; <CJK>
       (?$(KzS(B . "0x9C72") ; <CJK>
       (?$(KzT(B . "0x2A1F7") ; <CJK>
       (?$(KzU(B . "0x2A1F3") ; <CJK>
       (?$(KzV(B . "0x2A1EF") ; <CJK>
       (?$(KzW(B . "0x2A1F4") ; <CJK>
       (?$(KzX(B . "0x2A1ED") ; <CJK>
       (?$(KzY(B . "0x2A1F2") ; <CJK>
       (?$(KzZ(B . "0x2A1F1") ; <CJK>
       (?$(Kz[(B . "0x2A1F9") ; <CJK>
       (?$(Kz\(B . "0x2A4B4") ; <CJK>
       (?$(Kz](B . "0x2A4FC") ; <CJK>
       (?$(Kz^(B . "0x2A5BC") ; <CJK>
       (?$(Kz_(B . "0x2A65E") ; <CJK>
       (?$(Kz`(B . "0x2A65B") ; <CJK>
       (?$(Kza(B . "0x2A65F") ; <CJK>
       (?$(Kzb(B . "0x2A65D") ; <CJK>
       (?$(Kzc(B . "0x2A6CF") ; <CJK>
       (?$(Kzd(B . "0x2A6CE") ; <CJK>
       (?$(Kze(B . "0x2193A") ; <CJK>
       (?$(Kzf(B . "0x21FE1") ; <CJK>
       (?$(Kzg(B . "0x22315") ; <CJK>
       (?$(Kzh(B . "0x22314") ; <CJK>
       (?$(Kzi(B . "0x24178") ; <CJK>
       (?$(Kzj(B . "0x24179") ; <CJK>
       (?$(Kzk(B . "0x244E6") ; <CJK>
       (?$(Kzl(B . "0x24BB8") ; <CJK>
       (?$(Kzm(B . "0x24F22") ; <CJK>
       (?$(Kzn(B . "0x255FE") ; <CJK>
       (?$(Kzo(B . "0x268DB") ; <CJK>
       (?$(Kzp(B . "0x26A06") ; <CJK>
       (?$(Kzq(B . "0x26AC8") ; <CJK>
       (?$(Kzr(B . "0x27189") ; <CJK>
       (?$(Kzs(B . "0x27586") ; <CJK>
       (?$(Kzt(B . "0x278AD") ; <CJK>
       (?$(Kzu(B . "0x27B99") ; <CJK>
       (?$(Kzv(B . "0x27BD8") ; <CJK>
       (?$(Kzw(B . "0x27C23") ; <CJK>
       (?$(Kzx(B . "0x27D23") ; <CJK>
       (?$(Kzy(B . "0x27FB5") ; <CJK>
       (?$(Kzz(B . "0x283F9") ; <CJK>
       (?$(Kz{(B . "0x28907") ; <CJK>
       (?$(Kz|(B . "0x28C1E") ; <CJK>
       (?$(Kz}(B . "0x28DFB") ; <CJK>
       (?$(Kz~(B . "0x28F72") ; <CJK>
       (?$(K{!(B . "0x28F73") ; <CJK>
       (?$(K{"(B . "0x29387") ; <CJK>
       (?$(K{#(B . "0x29449") ; <CJK>
       (?$(K{$(B . "0x2965D") ; <CJK>
       (?$(K{%(B . "0x297F8") ; <CJK>
       (?$(K{&(B . "0x29C03") ; <CJK>
       (?$(K{'(B . "0x29F4E") ; <CJK>
       (?$(K{((B . "0x29F4D") ; <CJK>
       (?$(K{)(B . "0x29F50") ; <CJK>
       (?$(K{*(B . "0x29F55") ; <CJK>
       (?$(K{+(B . "0x2A209") ; <CJK>
       (?$(K{,(B . "0x2A207") ; <CJK>
       (?$(K{-(B . "0x2A20C") ; <CJK>
       (?$(K{.(B . "0x2A203") ; <CJK>
       (?$(K{/(B . "0x2A206") ; <CJK>
       (?$(K{0(B . "0x2A20B") ; <CJK>
       (?$(K{1(B . "0x2A20A") ; <CJK>
       (?$(K{2(B . "0x2A289") ; <CJK>
       (?$(K{3(B . "0x2A4BB") ; <CJK>
       (?$(K{4(B . "0x2A4FF") ; <CJK>
       (?$(K{5(B . "0x2A536") ; <CJK>
       (?$(K{6(B . "0x2A58B") ; <CJK>
       (?$(K{7(B . "0x2A666") ; <CJK>
       (?$(K{8(B . "0x2A669") ; <CJK>
       (?$(K{9(B . "0x2A667") ; <CJK>
       (?$(K{:(B . "0x2A6C2") ; <CJK>
       (?$(K{;(B . "0x2A6D2") ; <CJK>
       (?$(K{<(B . "0x21FE2") ; <CJK>
       (?$(K{=(B . "0x3828") ; <CJK>
       (?$(K{>(B . "0x22988") ; <CJK>
       (?$(K{?(B . "0x2335B") ; <CJK>
       (?$(K{@(B . "0x23876") ; <CJK>
       (?$(K{A(B . "0x2417D") ; <CJK>
       (?$(K{B(B . "0x245A6") ; <CJK>
       (?$(K{C(B . "0x2535A") ; <CJK>
       (?$(K{D(B . "0x25E17") ; <CJK>
       (?$(K{E(B . "0x268DC") ; <CJK>
       (?$(K{F(B . "0x2718F") ; <CJK>
       (?$(K{G(B . "0x27594") ; <CJK>
       (?$(K{H(B . "0x27595") ; <CJK>
       (?$(K{I(B . "0x27FB6") ; <CJK>
       (?$(K{J(B . "0x28204") ; <CJK>
       (?$(K{K(B . "0x287EE") ; <CJK>
       (?$(K{L(B . "0x2938A") ; <CJK>
       (?$(K{M(B . "0x293F9") ; <CJK>
       (?$(K{N(B . "0x29C07") ; <CJK>
       (?$(K{O(B . "0x29C1F") ; <CJK>
       (?$(K{P(B . "0x29C2A") ; <CJK>
       (?$(K{Q(B . "0x29D45") ; <CJK>
       (?$(K{R(B . "0x29F5C") ; <CJK>
       (?$(K{S(B . "0x29F5B") ; <CJK>
       (?$(K{T(B . "0x29F61") ; <CJK>
       (?$(K{U(B . "0x29F5D") ; <CJK>
       (?$(K{V(B . "0x2A218") ; <CJK>
       (?$(K{W(B . "0x2A21F") ; <CJK>
       (?$(K{X(B . "0x2A383") ; <CJK>
       (?$(K{Y(B . "0x2A416") ; <CJK>
       (?$(K{Z(B . "0x2A414") ; <CJK>
       (?$(K{[(B . "0x2A4BF") ; <CJK>
       (?$(K{\(B . "0x2A4C0") ; <CJK>
       (?$(K{](B . "0x2A673") ; <CJK>
       (?$(K{^(B . "0x2A6C0") ; <CJK>
       (?$(K{_(B . "0x21517") ; <CJK>
       (?$(K{`(B . "0x22989") ; <CJK>
       (?$(K{a(B . "0x2591E") ; <CJK>
       (?$(K{b(B . "0x2591F") ; <CJK>
       (?$(K{c(B . "0x25A54") ; <CJK>
       (?$(K{d(B . "0x25E18") ; <CJK>
       (?$(K{e(B . "0x26205") ; <CJK>
       (?$(K{f(B . "0x27195") ; <CJK>
       (?$(K{g(B . "0x27598") ; <CJK>
       (?$(K{h(B . "0x2759B") ; <CJK>
       (?$(K{i(B . "0x27959") ; <CJK>
       (?$(K{j(B . "0x28208") ; <CJK>
       (?$(K{k(B . "0x28401") ; <CJK>
       (?$(K{l(B . "0x291CE") ; <CJK>
       (?$(K{m(B . "0x293FA") ; <CJK>
       (?$(K{n(B . "0x29ABE") ; <CJK>
       (?$(K{o(B . "0x29D47") ; <CJK>
       (?$(K{p(B . "0x29F6A") ; <CJK>
       (?$(K{q(B . "0x29F69") ; <CJK>
       (?$(K{r(B . "0x29F68") ; <CJK>
       (?$(K{s(B . "0x29F67") ; <CJK>
       (?$(K{t(B . "0x2A225") ; <CJK>
       (?$(K{u(B . "0x2A228") ; <CJK>
       (?$(K{v(B . "0x2A4C4") ; <CJK>
       (?$(K{w(B . "0x2A537") ; <CJK>
       (?$(K{x(B . "0x2A58D") ; <CJK>
       (?$(K{y(B . "0x2A58C") ; <CJK>
       (?$(K{z(B . "0x4D91") ; <CJK>
       (?$(K{{(B . "0x2F920") ; <CJK>
       (?$(K{|(B . "0x25E22") ; <CJK>
       (?$(K{}(B . "0x25F82") ; <CJK>
       (?$(K{~(B . "0x277D9") ; <CJK>
       (?$(K|!(B . "0x28C38") ; <CJK>
       (?$(K|"(B . "0x293FB") ; <CJK>
       (?$(K|#(B . "0x299E1") ; <CJK>
       (?$(K|$(B . "0x29C72") ; <CJK>
       (?$(K|%(B . "0x29D48") ; <CJK>
       (?$(K|&(B . "0x29F6C") ; <CJK>
       (?$(K|'(B . "0x29F70") ; <CJK>
       (?$(K|((B . "0x2A231") ; <CJK>
       (?$(K|)(B . "0x2A230") ; <CJK>
       (?$(K|*(B . "0x2A679") ; <CJK>
       (?$(K|+(B . "0x25E23") ; <CJK>
       (?$(K|,(B . "0x268F8") ; <CJK>
       (?$(K|-(B . "0x29C74") ; <CJK>
       (?$(K|.(B . "0x29F73") ; <CJK>
       (?$(K|/(B . "0x2A234") ; <CJK>
       (?$(K|0(B . "0x2A387") ; <CJK>
       (?$(K|1(B . "0x2A3B2") ; <CJK>
       (?$(K|2(B . "0x2A5C2") ; <CJK>
       (?$(K|3(B . "0x2A67D") ; <CJK>
       (?$(K|4(B . "0x21FE5") ; <CJK>
       (?$(K|5(B . "0x2938C") ; <CJK>
       (?$(K|6(B . "0x29F77") ; <CJK>
       (?$(K|7(B . "0x29F75") ; <CJK>
       (?$(K|8(B . "0x2A238") ; <CJK>
       (?$(K|9(B . "0x2A23A") ; <CJK>
       (?$(K|:(B . "0x2A683") ; <CJK>
       (?$(K|;(B . "0x2A681") ; <CJK>
       (?$(K|<(B . "0x24180") ; <CJK>
       (?$(K|=(B . "0x27199") ; <CJK>
       (?$(K|>(B . "0x4587") ; <CJK>
       (?$(K|?(B . "0x2944A") ; <CJK>
       (?$(K|@(B . "0x29D4A") ; <CJK>
       (?$(K|A(B . "0x2A23C") ; <CJK>
       (?$(K|B(B . "0x2A6C8") ; <CJK>
       (?$(K|C(B . "0x25604") ; <CJK>
       (?$(K|D(B . "0x278AF") ; <CJK>
       (?$(K|E(B . "0x2A689") ; <CJK>
       (?$(K|F(B . "0x2A2FA") ; <CJK>
       (?$(K|G(B . "0x29661") ; <CJK>
       (?$(K|H(B . "0x2A23F") ; <CJK>
       (?$(K|I(B . "0x27193") ; <CJK>
       (?$(K|J(B . "0x2A4C9") ; <CJK>
       (?$(K|K(B . "0x277DE") ; <CJK>
       (?$(K|L(B . "0x29391") ; <CJK>
       (?$(K|M(B . "0x2A68E") ; <CJK>
       (?$(K|N(B . "0x2A68D") ; <CJK>
       (?$(K|O(B . "0x27198") ; <CJK>
       (?$(K|P(B . "0x269C5") ; <CJK>
       (?$(K|Q(B . "0x2A6A5") ; <CJK>
       ))))

(provide 'u-cns-5)

;;; u-cns-5.el ends here
 
