/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.sql.SQLException;
import java.util.HashMap;

public class DB2DDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 3718 $";

    @Override
    public String getName() {
        return "IBM DB2";
    }

    @Override
    public void writeHeader() {
        this.println("-- Created by SQLPower DB2 DDL Generator $Revision: 3718 $ --");
    }

    @Override
    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(-5, new GenericTypeDescriptor("BIGINT", -5, 38L, null, null, 1, false, false));
        this.typeMap.put(-2, new GenericTypeDescriptor("BLOB", -2, Integer.MAX_VALUE, "0x", null, 1, true, false));
        this.typeMap.put(-7, new GenericTypeDescriptor("DECIMAL", -7, 1L, null, null, 1, true, false));
        this.typeMap.put(2004, new GenericTypeDescriptor("BLOB", 2004, Integer.MAX_VALUE, "0x", null, 1, true, false));
        this.typeMap.put(16, new GenericTypeDescriptor("SMALLINT", 5, 5L, null, null, 1, false, false));
        this.typeMap.put(1, new GenericTypeDescriptor("CHAR", 1, 254L, "'", "'", 1, true, false));
        this.typeMap.put(2005, new GenericTypeDescriptor("CLOB", 2005, Integer.MAX_VALUE, "'", "'", 1, true, false));
        this.typeMap.put(91, new GenericTypeDescriptor("DATE", 91, 10L, "'", "'", 1, false, false));
        this.typeMap.put(3, new GenericTypeDescriptor("DECIMAL", 3, 31L, null, null, 1, true, true));
        this.typeMap.put(8, new GenericTypeDescriptor("DOUBLE", 8, 53L, null, null, 1, true, false));
        this.typeMap.put(6, new GenericTypeDescriptor("FLOAT", 6, 53L, null, null, 1, true, false));
        this.typeMap.put(4, new GenericTypeDescriptor("INTEGER", 4, 10L, null, null, 1, false, false));
        this.typeMap.put(-4, new GenericTypeDescriptor("BLOB", -4, Integer.MAX_VALUE, "0x", null, 1, true, false));
        this.typeMap.put(-1, new GenericTypeDescriptor("CLOB", -1, Integer.MAX_VALUE, "'", "'", 1, true, false));
        this.typeMap.put(2, new GenericTypeDescriptor("DECIMAL", 2, 31L, null, null, 1, true, true));
        this.typeMap.put(7, new GenericTypeDescriptor("FLOAT", 7, 31L, null, null, 1, true, false));
        this.typeMap.put(5, new GenericTypeDescriptor("SMALLINT", 5, 5L, null, null, 1, false, false));
        this.typeMap.put(92, new GenericTypeDescriptor("TIME", 92, 8L, "'", "'", 1, false, false));
        this.typeMap.put(93, new GenericTypeDescriptor("TIMESTAMP", 93, 26L, "'", "'", 1, false, false));
        this.typeMap.put(-6, new GenericTypeDescriptor("SMALLINT", -6, 5L, null, null, 1, false, false));
        this.typeMap.put(-3, new GenericTypeDescriptor("BLOB", -3, Integer.MAX_VALUE, null, null, 1, true, false));
        this.typeMap.put(12, new GenericTypeDescriptor("VARCHAR", 12, 32672L, "'", "'", 1, true, false));
    }

    @Override
    public String getCatalogTerm() {
        return null;
    }

    @Override
    public String getSchemaTerm() {
        return "Schema";
    }

    @Override
    public boolean supportsDeleteAction(SQLRelationship r) {
        return r.getDeleteRule() != SQLRelationship.UpdateDeleteRule.SET_DEFAULT;
    }

    @Override
    public boolean supportsUpdateAction(SQLRelationship r) {
        return r.getUpdateRule() == SQLRelationship.UpdateDeleteRule.RESTRICT || r.getUpdateRule() == SQLRelationship.UpdateDeleteRule.NO_ACTION;
    }

    @Override
    public boolean supportsDeferrabilityPolicy(SQLRelationship r) {
        return r.getDeferrability() == SQLRelationship.Deferrability.NOT_DEFERRABLE;
    }

    @Override
    public String getDeferrabilityClause(SQLRelationship r) {
        if (!this.supportsDeferrabilityPolicy(r)) {
            throw new IllegalArgumentException("DB2 does not support deferrability option: " + r.getDeferrability());
        }
        return "";
    }

    @Override
    public void renameColumn(SQLColumn oldCol, SQLColumn newCol) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>(0);
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(oldCol.getParent()));
        this.print(" RENAME ");
        this.print(this.createPhysicalName(colNameMap, (SQLObject)oldCol));
        this.print(" TO ");
        this.print(this.createPhysicalName(colNameMap, (SQLObject)oldCol));
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)oldCol);
    }

    @Override
    public void renameTable(SQLTable oldTable, SQLTable newTable) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>(0);
        this.println("RENAME TABLE " + this.createPhysicalName(colNameMap, (SQLObject)oldTable) + " TO " + this.createPhysicalName(colNameMap, (SQLObject)newTable));
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)newTable);
    }

    @Override
    public void renameIndex(SQLIndex oldIndex, SQLIndex newIndex) throws SQLObjectException {
        this.print("RENAME INDEX ");
        this.print(this.toQualifiedName(oldIndex));
        this.print(" TO ");
        this.println(this.toQualifiedName(newIndex.getName()));
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)oldIndex);
    }

    @Override
    protected String getPlatformName() {
        return "DB2";
    }
}

