/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.util.Utils;

public class StringOption
extends AbstractOption<String> {
    private static final Logger logger = Logger.getLogger(StringOption.class.getName());
    private String value;
    private final List<String> choices = new ArrayList<String>();
    private static final String CHOICE_TAG = "choice";

    public StringOption(Specification specification) {
        super(specification);
    }

    public StringOption(String id, Specification specification) {
        super(id, specification);
    }

    public final List<String> getChoices() {
        return this.choices;
    }

    public final void setChoices(List<String> newChoices) {
        this.choices.clear();
        this.choices.addAll(newChoices);
    }

    @Override
    public StringOption clone() {
        StringOption result = new StringOption(this.getId(), this.getSpecification());
        result.setValues(this);
        result.setChoices(this.choices);
        return result;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        String oldValue = this.value;
        this.value = value;
        if (this.isDefined && !Utils.equals(value, oldValue)) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        this.setValue(valueString != null ? valueString : defaultValueString);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute("value", this.value);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (String choice : this.choices) {
            xw.writeStartElement(CHOICE_TAG);
            xw.writeAttribute("value", choice);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.choices.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (CHOICE_TAG.equals(tag)) {
            this.choices.add(xr.getAttribute("value", null));
            xr.closeTag(CHOICE_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[").append(this.getId()).append(" value=").append(this.value).append(" choices=[");
        if (this.choices != null) {
            for (String choice : this.choices) {
                sb.append(" ").append(choice);
            }
        }
        sb.append("]]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return StringOption.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "stringOption";
    }
}

