/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser;

import org.jboss.galleon.util.formatparser.FormatContentHandler;
import org.jboss.galleon.util.formatparser.FormatContentHandlerFactory;
import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingFormat;
import org.jboss.galleon.util.formatparser.handlers.KeyValueContentHandler;
import org.jboss.galleon.util.formatparser.handlers.ListContentHandler;
import org.jboss.galleon.util.formatparser.handlers.MapContentHandler;
import org.jboss.galleon.util.formatparser.handlers.SetContentHandler;
import org.jboss.galleon.util.formatparser.handlers.StringContentHandler;
import org.jboss.galleon.util.formatparser.handlers.WildcardContentHandler;

public class DefaultContentHandlerFactory
implements FormatContentHandlerFactory {
    private static final DefaultContentHandlerFactory INSTANCE = new DefaultContentHandlerFactory();

    public static DefaultContentHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public FormatContentHandler forFormat(ParsingFormat format, int strIndex) throws FormatParsingException {
        String name = format.getContentType();
        if (name.equals("String")) {
            return new StringContentHandler(format, strIndex);
        }
        if (name.equals("List")) {
            return new ListContentHandler(format, strIndex);
        }
        if (name.equals("KeyValue")) {
            return new KeyValueContentHandler(format, strIndex);
        }
        if (name.equals("Map")) {
            return new MapContentHandler(format, strIndex);
        }
        if (name.equals("Set")) {
            return new SetContentHandler(format, strIndex);
        }
        if (name.equals("?")) {
            return new WildcardContentHandler(format, strIndex);
        }
        throw new FormatParsingException("Unexpected content type " + format);
    }
}

