/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;

public abstract class Instruction {
    public final Opcode opcode;

    public int getSize(int codeAddress) {
        return this.opcode.format.size / 2;
    }

    protected Instruction(Opcode opcode) {
        this.opcode = opcode;
    }

    public abstract Format getFormat();

    public int write(AnnotatedOutput out, int currentCodeAddress) {
        if (out.annotates()) {
            this.annotateInstruction(out, currentCodeAddress);
        }
        this.writeInstruction(out, currentCodeAddress);
        return currentCodeAddress + this.getSize(currentCodeAddress);
    }

    protected void annotateInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.annotate(this.getSize(currentCodeAddress) * 2, "[0x" + Integer.toHexString(currentCodeAddress) + "] " + this.opcode.name + " instruction");
    }

    protected abstract void writeInstruction(AnnotatedOutput var1, int var2);

    public static interface InstructionFactory {
        public Instruction makeInstruction(DexFile var1, Opcode var2, byte[] var3, int var4);
    }
}

