/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.complzss;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.lzss.LzssCodec;
import ghidra.file.formats.lzss.LzssConstants;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@FileSystemInfo(type="lzss", description="LZSS Compression", factory=GFileSystemBaseFactory.class)
public class CompLzssFileSystem
extends GFileSystemBase {
    private static final String NAME = "lzss_decompressed";
    private GFileImpl decompressedFile;
    private byte[] decompressedBytes;

    public CompLzssFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public void close() throws IOException {
        this.decompressedFile = null;
        this.decompressedBytes = null;
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        if (file != null && file.equals(this.decompressedFile)) {
            return new ByteArrayInputStream(this.decompressedBytes);
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return directory == null || directory.equals(this.root) ? Arrays.asList(this.decompressedFile) : Collections.emptyList();
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] compressionBytes = this.provider.readBytes(0L, 4L);
        byte[] lzssBytes = this.provider.readBytes(4L, 4L);
        return Arrays.equals(compressionBytes, LzssConstants.SIGNATURE_COMPRESSION_BYTES) && Arrays.equals(lzssBytes, LzssConstants.SIGNATURE_LZSS_BYTES);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        monitor.setMessage("Decompressing LZSS...");
        byte[] compressedBytes = this.provider.readBytes(384L, this.provider.length() - 384L);
        ByteArrayOutputStream decompressedBOS = new ByteArrayOutputStream();
        LzssCodec.decompress(decompressedBOS, new ByteArrayInputStream(compressedBytes));
        this.decompressedBytes = decompressedBOS.toByteArray();
        this.decompressedFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)NAME, (boolean)false, (long)this.decompressedBytes.length, null);
        this.debug(this.decompressedBytes, NAME);
    }
}

