/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.decorators;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeIndexFunction;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.decorators.ParallelEdgeShapeTransformer;
import edu.uci.ics.jung.visualization.util.ArrowFactory;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class EdgeShape<V, E> {
    private static final Line2D LINE = new Line2D.Float(0.0f, 0.0f, 1.0f, 0.0f);
    private static final GeneralPath BENT_LINE = new GeneralPath();
    private static final QuadCurve2D QUAD_CURVE = new QuadCurve2D.Float();
    private static final CubicCurve2D CUBIC_CURVE = new CubicCurve2D.Float();
    private static final Ellipse2D ELLIPSE = new Ellipse2D.Float(-0.5f, -0.5f, 1.0f, 1.0f);
    private static Rectangle2D BOX = new Rectangle2D.Float();
    private static GeneralPath triangle;
    private static GeneralPath bowtie;
    protected final Graph<V, E> graph;
    protected final Loop loop;
    protected final SimpleLoop simpleLoop;
    protected final Box box;

    public EdgeShape(Graph<V, E> g) {
        this.graph = g;
        this.box = new Box();
        this.loop = new Loop();
        this.simpleLoop = new SimpleLoop();
    }

    private Shape getLoopOrNull(E e) {
        return this.getLoopOrNull(e, this.loop);
    }

    private Shape getLoopOrNull(E e, Function<? super E, Shape> loop) {
        Pair<V> endpoints = this.graph.getEndpoints(e);
        Preconditions.checkNotNull(endpoints);
        boolean isLoop = endpoints.getFirst().equals(endpoints.getSecond());
        if (isLoop) {
            return (Shape)loop.apply(e);
        }
        return null;
    }

    public static <V, E> Line line(Graph<V, E> graph) {
        return new EdgeShape<V, E>(graph).new Line();
    }

    public static <V, E> QuadCurve quadCurve(Graph<V, E> graph) {
        return new EdgeShape<V, E>(graph).new QuadCurve();
    }

    public static <V, E> QuadCurve cubicCurve(Graph<V, E> graph) {
        return new EdgeShape<V, E>(graph).new QuadCurve();
    }

    public static <V, E> Orthogonal orthogonal(Graph<V, E> graph) {
        return new EdgeShape<V, E>(graph).new Orthogonal();
    }

    public static <V, E> Wedge wedge(Graph<V, E> graph, int width) {
        EdgeShape<V, E> edgeShape = new EdgeShape<V, E>(graph);
        edgeShape.getClass();
        return edgeShape.new Wedge(width);
    }

    private int getIndex(E e, EdgeIndexFunction<V, E> edgeIndexFunction) {
        return edgeIndexFunction == null ? 1 : edgeIndexFunction.getIndex(this.graph, e);
    }

    private Shape buildFrame(RectangularShape shape, int index) {
        float x = -0.5f;
        float y = -0.5f;
        float diam = 1.0f;
        diam += diam * (float)index / 2.0f;
        x += x * (float)index / 2.0f;
        y += y * (float)index / 2.0f;
        shape.setFrame(x, y, diam, diam);
        return shape;
    }

    public class Orthogonal
    extends ParallelEdgeShapeTransformer<V, E> {
        public Shape apply(E e) {
            Shape loop = EdgeShape.this.getLoopOrNull(e, EdgeShape.this.box);
            return loop == null ? LINE : loop;
        }
    }

    public class Box
    extends ParallelEdgeShapeTransformer<V, E> {
        public Shape apply(E e) {
            return EdgeShape.this.buildFrame(BOX, EdgeShape.this.getIndex(e, this.edgeIndexFunction));
        }
    }

    public class Wedge
    extends ParallelEdgeShapeTransformer<V, E> {
        public Wedge(int width) {
            triangle = ArrowFactory.getWedgeArrow(width, 1.0f);
            triangle.transform(AffineTransform.getTranslateInstance(1.0, 0.0));
            bowtie = new GeneralPath(0);
            bowtie.moveTo(0.0f, width / 2);
            bowtie.lineTo(1.0f, -width / 2);
            bowtie.lineTo(1.0f, width / 2);
            bowtie.lineTo(0.0f, -width / 2);
            bowtie.closePath();
        }

        public Shape apply(E e) {
            Shape edgeShape = EdgeShape.this.getLoopOrNull(e);
            if (edgeShape != null) {
                return edgeShape;
            }
            return EdgeShape.this.graph.getEdgeType(e) == EdgeType.DIRECTED ? triangle : bowtie;
        }
    }

    public class Loop
    extends ParallelEdgeShapeTransformer<V, E> {
        public Shape apply(E e) {
            return EdgeShape.this.buildFrame(ELLIPSE, EdgeShape.this.getIndex(e, this.edgeIndexFunction));
        }
    }

    public class SimpleLoop
    extends ParallelEdgeShapeTransformer<V, E> {
        public Shape apply(E e) {
            return ELLIPSE;
        }
    }

    public class CubicCurve
    extends ParallelEdgeShapeTransformer<V, E> {
        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> edgeIndexFunction) {
            this.edgeIndexFunction = edgeIndexFunction;
            EdgeShape.this.loop.setEdgeIndexFunction(edgeIndexFunction);
        }

        public Shape apply(E e) {
            Shape edgeShape = EdgeShape.this.getLoopOrNull(e);
            if (edgeShape != null) {
                return edgeShape;
            }
            int index = EdgeShape.this.getIndex(e, this.edgeIndexFunction);
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            CUBIC_CURVE.setCurve(0.0, 0.0, 0.33f, 2.0f * controlY, 0.66f, -controlY, 1.0, 0.0);
            return CUBIC_CURVE;
        }
    }

    public class QuadCurve
    extends ParallelEdgeShapeTransformer<V, E> {
        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> parallelEdgeIndexFunction) {
            this.edgeIndexFunction = parallelEdgeIndexFunction;
            EdgeShape.this.loop.setEdgeIndexFunction(parallelEdgeIndexFunction);
        }

        public Shape apply(E e) {
            Shape edgeShape = EdgeShape.this.getLoopOrNull(e);
            if (edgeShape != null) {
                return edgeShape;
            }
            int index = EdgeShape.this.getIndex(e, this.edgeIndexFunction);
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            QUAD_CURVE.setCurve(0.0, 0.0, 0.5, controlY, 1.0, 0.0);
            return QUAD_CURVE;
        }
    }

    public class BentLine
    extends ParallelEdgeShapeTransformer<V, E> {
        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> edgeIndexFunction) {
            this.edgeIndexFunction = edgeIndexFunction;
            EdgeShape.this.loop.setEdgeIndexFunction(edgeIndexFunction);
        }

        public Shape apply(E e) {
            Shape edgeShape = EdgeShape.this.getLoopOrNull(e);
            if (edgeShape != null) {
                return edgeShape;
            }
            int index = EdgeShape.this.getIndex(e, this.edgeIndexFunction);
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            BENT_LINE.reset();
            BENT_LINE.moveTo(0.0f, 0.0f);
            BENT_LINE.lineTo(0.5f, controlY);
            BENT_LINE.lineTo(1.0f, 1.0f);
            return BENT_LINE;
        }
    }

    public class Line
    implements Function<E, Shape> {
        public Shape apply(E e) {
            Shape loop = EdgeShape.this.getLoopOrNull(e);
            return loop == null ? LINE : loop;
        }
    }
}

