/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.foundation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import org.prevayler.foundation.Guided;

public class DurableOutputStream {
    private final Object _writeLock = new Object();
    private final Object _syncLock = new Object();
    private final File _file;
    private final FileOutputStream _fileOutputStream;
    private final FileDescriptor _fileDescriptor;
    private final boolean _journalDiskSync;
    private ByteArrayOutputStream _active = new ByteArrayOutputStream();
    private ByteArrayOutputStream _inactive = new ByteArrayOutputStream();
    private boolean _closed = false;
    private int _objectsWritten = 0;
    private int _objectsSynced = 0;
    private int _fileSyncCount = 0;

    public DurableOutputStream(File file, boolean journalDiskSync) throws IOException {
        this._file = file;
        this._fileOutputStream = new FileOutputStream(file);
        this._fileDescriptor = this._fileOutputStream.getFD();
        this._journalDiskSync = journalDiskSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(Guided guide) throws IOException {
        int thisWrite;
        guide.startTurn();
        try {
            thisWrite = this.writeObject(guide);
        }
        finally {
            guide.endTurn();
        }
        this.waitUntilSynced(thisWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeObject(Guided guide) throws IOException {
        Object object = this._writeLock;
        synchronized (object) {
            if (this._closed) {
                throw new IOException("already closed");
            }
            try {
                guide.writeTo(this._active);
            }
            catch (IOException exception) {
                this.internalClose();
                throw exception;
            }
            ++this._objectsWritten;
            return this._objectsWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilSynced(int thisWrite) throws IOException {
        Object object = this._syncLock;
        synchronized (object) {
            if (this._objectsSynced < thisWrite) {
                int objectsWritten;
                Object object2 = this._writeLock;
                synchronized (object2) {
                    if (this._closed) {
                        throw new IOException("already closed");
                    }
                    ByteArrayOutputStream swap = this._active;
                    this._active = this._inactive;
                    this._inactive = swap;
                    objectsWritten = this._objectsWritten;
                }
                try {
                    this._inactive.writeTo(this._fileOutputStream);
                    this._inactive.reset();
                    this._fileOutputStream.flush();
                    if (this._journalDiskSync) {
                        this._fileDescriptor.sync();
                    }
                }
                catch (IOException exception) {
                    this.internalClose();
                    throw exception;
                }
                this._objectsSynced = objectsWritten;
                ++this._fileSyncCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this._syncLock;
        synchronized (object) {
            Object object2 = this._writeLock;
            synchronized (object2) {
                if (this._closed) {
                    return;
                }
                this.internalClose();
                this._fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalClose() {
        Object object = this._writeLock;
        synchronized (object) {
            this._closed = true;
            this._active = null;
            this._inactive = null;
        }
    }

    public File file() {
        return this._file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int fileSyncCount() {
        Object object = this._syncLock;
        synchronized (object) {
            return this._fileSyncCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reallyClosed() {
        Object object = this._writeLock;
        synchronized (object) {
            return this._closed;
        }
    }
}

