/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slgh_compile;

import generic.stl.IteratorSTL;
import generic.stl.MapSTL;
import generic.stl.Pair;
import generic.stl.SelfComparator;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.context.Token;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.pcodeCPort.opcodes.OpCode;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.ConstructTpl;
import ghidra.pcodeCPort.semantics.HandleTpl;
import ghidra.pcodeCPort.semantics.OpTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slgh_compile.ConsistencyChecker;
import ghidra.pcodeCPort.slgh_compile.ExprTree;
import ghidra.pcodeCPort.slgh_compile.FieldContext;
import ghidra.pcodeCPort.slgh_compile.FieldQuality;
import ghidra.pcodeCPort.slgh_compile.MacroBuilder;
import ghidra.pcodeCPort.slgh_compile.PcodeCompile;
import ghidra.pcodeCPort.slgh_compile.RtlPair;
import ghidra.pcodeCPort.slgh_compile.SectionVector;
import ghidra.pcodeCPort.slgh_compile.SleighCompileLauncher;
import ghidra.pcodeCPort.slgh_compile.SpaceQuality;
import ghidra.pcodeCPort.slgh_compile.space_class;
import ghidra.pcodeCPort.slghpatexpress.ContextField;
import ghidra.pcodeCPort.slghpatexpress.EndInstructionValue;
import ghidra.pcodeCPort.slghpatexpress.EqualEquation;
import ghidra.pcodeCPort.slghpatexpress.EquationAnd;
import ghidra.pcodeCPort.slghpatexpress.OperandEquation;
import ghidra.pcodeCPort.slghpatexpress.PatternEquation;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenField;
import ghidra.pcodeCPort.slghsymbol.BitrangeSymbol;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.ContextChange;
import ghidra.pcodeCPort.slghsymbol.ContextCommit;
import ghidra.pcodeCPort.slghsymbol.ContextOp;
import ghidra.pcodeCPort.slghsymbol.ContextSymbol;
import ghidra.pcodeCPort.slghsymbol.DecisionProperties;
import ghidra.pcodeCPort.slghsymbol.EndSymbol;
import ghidra.pcodeCPort.slghsymbol.EpsilonSymbol;
import ghidra.pcodeCPort.slghsymbol.FamilySymbol;
import ghidra.pcodeCPort.slghsymbol.LabelSymbol;
import ghidra.pcodeCPort.slghsymbol.MacroSymbol;
import ghidra.pcodeCPort.slghsymbol.NameSymbol;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.slghsymbol.SectionSymbol;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.SpaceSymbol;
import ghidra.pcodeCPort.slghsymbol.StartSymbol;
import ghidra.pcodeCPort.slghsymbol.SubtableSymbol;
import ghidra.pcodeCPort.slghsymbol.SymbolScope;
import ghidra.pcodeCPort.slghsymbol.TokenSymbol;
import ghidra.pcodeCPort.slghsymbol.TripleSymbol;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.pcodeCPort.slghsymbol.ValueMapSymbol;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeListSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.ConstantSpace;
import ghidra.pcodeCPort.space.OtherSpace;
import ghidra.pcodeCPort.space.UniqueSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.pcodeCPort.xml.DocumentStorage;
import ghidra.sleigh.grammar.Location;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.RecognitionException;
import org.jdom.JDOMException;

public class SleighCompile
extends SleighBase {
    static boolean yydebug = false;
    public final PcodeCompile pcode = new PcodeCompile(){

        @Override
        public void reportError(Location location, String msg) {
            SleighCompile.this.reportError(location, msg);
        }

        @Override
        public void reportWarning(Location location, String msg) {
            SleighCompile.this.reportWarning(location, msg);
        }

        @Override
        public int getErrors() {
            return SleighCompile.this.numErrors();
        }

        @Override
        public int getWarnings() {
            return SleighCompile.this.numWarnings();
        }

        @Override
        public AddrSpace getConstantSpace() {
            return SleighCompile.this.getConstantSpace();
        }

        @Override
        public AddrSpace getDefaultSpace() {
            return SleighCompile.this.getDefaultSpace();
        }

        @Override
        public AddrSpace getUniqueSpace() {
            return SleighCompile.this.getUniqueSpace();
        }

        @Override
        public void addSymbol(SleighSymbol sym) {
            SleighCompile.this.addSymbol(sym);
        }

        @Override
        public SleighSymbol findSymbol(String nm) {
            return SleighCompile.this.findSymbol(nm);
        }

        @Override
        public long allocateTemp() {
            return SleighCompile.this.getUniqueAddr();
        }

        @Override
        public void recordNop(Location location) {
            SleighCompile.this.recordNop(location);
        }

        @Override
        public VectorSTL<OpTpl> createMacroUse(Location location, MacroSymbol sym, VectorSTL<ExprTree> param) {
            return SleighCompile.this.createMacroUse(location, sym, param);
        }

        @Override
        public SectionSymbol newSectionSymbol(Location where, String text) {
            return SleighCompile.this.newSectionSymbol(where, text);
        }

        @Override
        public VectorSTL<OpTpl> createCrossBuild(Location find, VarnodeTpl v, SectionSymbol section) {
            return SleighCompile.this.createCrossBuild(find, v, section);
        }

        @Override
        public SectionVector standaloneSection(ConstructTpl c) {
            return SleighCompile.this.standaloneSection(c);
        }

        @Override
        public SectionVector firstNamedSection(ConstructTpl main, SectionSymbol sym) {
            return SleighCompile.this.firstNamedSection(main, sym);
        }

        @Override
        public SectionVector nextNamedSection(SectionVector vec, ConstructTpl section, SectionSymbol sym) {
            return SleighCompile.this.nextNamedSection(vec, section, sym);
        }

        @Override
        public SectionVector finalNamedSection(SectionVector vec, ConstructTpl section) {
            return SleighCompile.this.finalNamedSection(vec, section);
        }
    };
    MapSTL<String, String> preproc_defines = new MapSTL((Comparator)new SelfComparator());
    VectorSTL<FieldContext> contexttable = new VectorSTL();
    Integer firstContextField = null;
    VectorSTL<ConstructTpl> macrotable = new VectorSTL();
    VectorSTL<Token> tokentable = new VectorSTL();
    VectorSTL<SubtableSymbol> tables = new VectorSTL();
    VectorSTL<SectionSymbol> sections = new VectorSTL();
    Constructor curct;
    MacroSymbol curmacro;
    boolean contextlock;
    String filename;
    int lineno;
    int linenoDifferential;
    int userop_count;
    boolean warnunnecessarypcode;
    boolean warndeadtemps;
    boolean warnunusedfields;
    boolean enforcelocalkeyword;
    boolean lenientconflicterrors;
    public boolean warnalllocalcollisions;
    public boolean warnallnops;
    public VectorSTL<String> noplist = new VectorSTL();
    public Deque<WithBlock> withstack = new LinkedList<WithBlock>();
    int errors;
    int warnings;
    private static final Pattern PREPROCPOS = Pattern.compile("%%%(.*)\b(\\d+)%%%");

    static boolean isLocationIsh(Object o) {
        if (o instanceof Location) {
            return true;
        }
        if (o instanceof List) {
            List l = (List)o;
            for (Object t : l) {
                if (!SleighCompile.isLocationIsh(t)) continue;
                return true;
            }
        }
        if (o instanceof VectorSTL) {
            VectorSTL v = (VectorSTL)o;
            for (Object t : v) {
                if (!SleighCompile.isLocationIsh(t)) continue;
                return true;
            }
        }
        return false;
    }

    public static void entry(String name, Object ... args) {
    }

    void predefinedSymbols() {
        SleighCompile.entry("predefinedSymbols", new Object[0]);
        this.symtab.addScope();
        Location location = Location.INTERNALLY_DEFINED;
        this.root = new SubtableSymbol(location, "instruction");
        this.symtab.addSymbol(this.root);
        this.insertSpace(new ConstantSpace(this, "const", 0));
        SpaceSymbol spacesym = new SpaceSymbol(location, this.getConstantSpace());
        this.symtab.addSymbol(spacesym);
        OtherSpace otherSpace = new OtherSpace(this, "OTHER", 1);
        this.insertSpace(otherSpace);
        spacesym = new SpaceSymbol(location, otherSpace);
        this.symtab.addSymbol(spacesym);
        this.insertSpace(new UniqueSpace(this, "unique", this.numSpaces(), 0));
        spacesym = new SpaceSymbol(location, this.getUniqueSpace());
        this.symtab.addSymbol(spacesym);
        StartSymbol startsym = new StartSymbol(location, "inst_start", this.getConstantSpace());
        this.symtab.addSymbol(startsym);
        EndSymbol endsym = new EndSymbol(location, "inst_next", this.getConstantSpace());
        this.symtab.addSymbol(endsym);
        EpsilonSymbol epsilon = new EpsilonSymbol(location, "epsilon", this.getConstantSpace());
        this.symtab.addSymbol(epsilon);
    }

    protected SectionSymbol newSectionSymbol(Location location, String nm) {
        SleighCompile.entry("newSectionSymbol", location, nm);
        SectionSymbol sym = new SectionSymbol(location, nm, this.sections.size());
        try {
            this.symtab.addGlobalSymbol(sym);
        }
        catch (SleighError err) {
            this.reportError(err.location, err.getMessage());
        }
        this.sections.push_back((Object)sym);
        this.numSections = this.sections.size();
        return sym;
    }

    protected VectorSTL<OpTpl> createCrossBuild(Location location, VarnodeTpl addr, SectionSymbol sym) {
        SleighCompile.entry("createCrossBuild", location, addr, sym);
        this.unique_allocatemask = 1;
        VectorSTL res = new VectorSTL();
        VarnodeTpl sectionid = new VarnodeTpl(location, new ConstTpl(this.getConstantSpace()), new ConstTpl(ConstTpl.const_type.real, sym.getTemplateId()), new ConstTpl(ConstTpl.const_type.real, 4L));
        OpTpl op = new OpTpl(location, OpCode.CPUI_PTRSUB);
        op.addInput(addr);
        op.addInput(sectionid);
        res.push_back((Object)op);
        sym.incrementRefCount();
        return res;
    }

    SectionVector standaloneSection(ConstructTpl main) {
        SleighCompile.entry("standaloneSection", main);
        SectionVector res = new SectionVector(main, this.symtab.getCurrentScope());
        return res;
    }

    SectionVector firstNamedSection(ConstructTpl main, SectionSymbol sym) {
        SleighCompile.entry("firstNamedSection", main);
        sym.incrementDefineCount();
        SymbolScope curscope = this.symtab.getCurrentScope();
        SymbolScope parscope = curscope.getParent();
        if (parscope != this.symtab.getGlobalScope()) {
            throw new LowlevelError("firstNamedSection called when not in Constructor scope");
        }
        this.symtab.addScope();
        SectionVector res = new SectionVector(main, curscope);
        res.setNextIndex(sym.getTemplateId());
        return res;
    }

    SectionVector nextNamedSection(SectionVector vec, ConstructTpl section, SectionSymbol sym) {
        SleighCompile.entry("nextNamedSection", vec, section, sym);
        sym.incrementDefineCount();
        this.symtab.popScope();
        SymbolScope curscope = this.symtab.getCurrentScope();
        SymbolScope parscope = curscope.getParent();
        if (parscope != this.symtab.getGlobalScope()) {
            throw new LowlevelError("nextNamedSection called when not in section scope");
        }
        this.symtab.addScope();
        vec.append(section, curscope);
        vec.setNextIndex(sym.getTemplateId());
        return vec;
    }

    SectionVector finalNamedSection(SectionVector vec, ConstructTpl section) {
        SleighCompile.entry("finalNamedSection", vec, section);
        vec.append(section, this.symtab.getCurrentScope());
        this.symtab.popScope();
        return vec;
    }

    int calcContextVarLayout(int start, int sz, int numbits) {
        SleighCompile.entry("calcContextVarLayout", start, sz, numbits);
        VarnodeSymbol sym = ((FieldContext)this.contexttable.get((int)start)).sym;
        int symSize = sym.getSize();
        if (symSize % 4 != 0) {
            this.reportError(sym.location, "Invalid size of context register \"" + sym.getName() + "\" (" + symSize + "); must be a multiple of 4");
        }
        int maxBits = symSize * 8 - 1;
        int i = 0;
        while (i < sz) {
            int endword;
            int j;
            FieldQuality qual = ((FieldContext)this.contexttable.get((int)i)).qual;
            int max = qual.high;
            int min = qual.low;
            if (max - min > 32) {
                this.reportError(qual.location, "Size of bitfield " + qual.name + "=(" + min + "," + max + ") larger than 32 bits in context register \"" + sym.getName() + "\"");
            }
            if (max > maxBits) {
                this.reportError(qual.location, "Scope of bitfield " + qual.name + "=(" + min + "," + max + ") extends beyond the size of context register \"" + sym.getName() + "\"");
            }
            for (j = i + 1; j < sz; ++j) {
                qual = ((FieldContext)this.contexttable.get((int)j)).qual;
                if (qual.low > max) break;
                if (qual.high <= max) continue;
                max = qual.high;
            }
            int alloc = max - min + 1;
            int startword = Utils.unsignedDivide(numbits, 32);
            if (startword != (endword = Utils.unsignedDivide(numbits + alloc - 1, 32))) {
                numbits = endword * 32;
            }
            int low = numbits;
            numbits += alloc;
            while (i < j) {
                qual = ((FieldContext)this.contexttable.get((int)i)).qual;
                int l = qual.low - min + low;
                int h = numbits - 1 - (max - qual.high);
                ContextField field = new ContextField(qual.location, qual.signext, l, h);
                int id = this.addSymbol(new ContextSymbol(qual.location, qual.name, field, sym, qual.low, qual.high, qual.flow));
                if (this.firstContextField == null) {
                    this.firstContextField = id;
                }
                ++i;
            }
        }
        sym.markAsContext();
        return numbits;
    }

    void buildDecisionTrees() {
        SleighCompile.entry("buildDecisionTrees", new Object[0]);
        DecisionProperties props = new DecisionProperties();
        this.root.buildDecisionTree(props);
        for (int i = 0; i < this.tables.size(); ++i) {
            ((SubtableSymbol)this.tables.get(i)).buildDecisionTree(props);
        }
        VectorSTL<String> ierrors = props.getIdentErrors();
        for (int i = 0; i < ierrors.size(); ++i) {
            ++this.errors;
            Msg.error((Object)this, (Object)ierrors.get(i));
        }
        if (!this.lenientconflicterrors) {
            VectorSTL<String> cerrors = props.getConflictErrors();
            for (int i = 0; i < cerrors.size(); ++i) {
                ++this.errors;
                Msg.error((Object)this, (Object)cerrors.get(i));
            }
        }
    }

    void buildPatterns() {
        SleighCompile.entry("buildPatterns", new Object[0]);
        if (this.root == null) {
            this.reportError(null, "No patterns to match--could not find any constructors");
            return;
        }
        this.root.buildPattern(System.err);
        if (this.root.isError()) {
            ++this.errors;
        }
        for (int i = 0; i < this.tables.size(); ++i) {
            if (((SubtableSymbol)this.tables.get(i)).isError()) {
                ++this.errors;
            }
            if (((SubtableSymbol)this.tables.get(i)).getPattern() != null) continue;
            this.reportWarning(((SubtableSymbol)this.tables.get(i)).getLocation(), "Unreferenced table: " + ((SubtableSymbol)this.tables.get(i)).getName());
        }
    }

    void checkConsistency() {
        SleighCompile.entry("checkConsistency", new Object[0]);
        ConsistencyChecker checker = new ConsistencyChecker(this.root, this.warnunnecessarypcode, this.warndeadtemps);
        if (!checker.test()) {
            ++this.errors;
            return;
        }
        if (!checker.testTruncations(this.isBigEndian())) {
            ++this.errors;
            return;
        }
        if (!this.warnunnecessarypcode && checker.getNumUnnecessaryPcode() > 0) {
            Msg.warn((Object)this, (Object)(checker.getNumUnnecessaryPcode() + " unnecessary extensions/truncations were converted to copies"));
            Msg.warn((Object)this, (Object)"Use -u switch to list each individually");
        }
        checker.optimizeAll();
        if (checker.getNumReadNoWrite() > 0) {
            ++this.errors;
            return;
        }
        if (!this.warndeadtemps && checker.getNumWriteNoRead() > 0) {
            Msg.warn((Object)this, (Object)(checker.getNumWriteNoRead() + " operations wrote to temporaries that were not read"));
            Msg.warn((Object)this, (Object)"Use -t switch to list each individually");
        }
    }

    static int findCollision(Map<Long, Integer> local2Operand, ArrayList<Long> locals, int operand) {
        Integer boxOperand = operand;
        for (int i = 0; i < locals.size(); ++i) {
            Integer previous = local2Operand.putIfAbsent(locals.get(i), boxOperand);
            if (previous == null || previous == operand) continue;
            return previous;
        }
        return -1;
    }

    boolean checkLocalExports(Constructor ct) {
        if (ct.getTempl() == null) {
            return true;
        }
        if (ct.getTempl().buildOnly()) {
            return true;
        }
        if (ct.getNumOperands() < 2) {
            return true;
        }
        boolean noCollisions = true;
        TreeMap<Long, Integer> collect = new TreeMap<Long, Integer>();
        for (int i = 0; i < ct.getNumOperands(); ++i) {
            int collideOperand;
            ArrayList<Long> newCollect = new ArrayList<Long>();
            ct.getOperand(i).collectLocalValues(newCollect);
            if (newCollect.isEmpty() || (collideOperand = SleighCompile.findCollision(collect, newCollect, i)) < 0) continue;
            noCollisions = false;
            if (!this.warnalllocalcollisions) break;
            Msg.warn((Object)this, (Object)("Possible collision with symbol " + ct.getOperand(collideOperand).getName() + " and " + ct.getOperand(i).getName() + " in constructor from " + ct.getFilename() + " starting at line " + Integer.toString(ct.getLineno())));
            break;
        }
        return noCollisions;
    }

    void checkLocalCollisions() {
        int collisionCount = 0;
        SubtableSymbol sym = this.root;
        int i = -1;
        while (true) {
            int numconst = sym.getNumConstructors();
            for (int j = 0; j < numconst; ++j) {
                if (this.checkLocalExports(sym.getConstructor(j))) continue;
                ++collisionCount;
            }
            if (++i >= this.tables.size()) break;
            sym = (SubtableSymbol)this.tables.get(i);
        }
        if (collisionCount > 0) {
            Msg.warn((Object)this, (Object)("WARNING: " + Integer.toString(collisionCount) + " constructors with local collisions between operands"));
            if (!this.warnalllocalcollisions) {
                Msg.warn((Object)this, (Object)"Use -c switch to list each individually");
            }
        }
    }

    String checkSymbols(SymbolScope scope) {
        SleighCompile.entry("checkSymbols", scope);
        StringBuilder s = new StringBuilder();
        IteratorSTL<SleighSymbol> iter = scope.begin();
        while (!iter.equals(scope.end())) {
            SleighSymbol sym = (SleighSymbol)iter.get();
            if (sym.getType() == symbol_type.label_symbol) {
                LabelSymbol labsym = (LabelSymbol)sym;
                if (labsym.getRefCount() == 0) {
                    s.append("   Label <");
                    s.append(sym.getName());
                    s.append("> was placed but not used");
                } else if (!labsym.isPlaced()) {
                    s.append("   Label <");
                    s.append(sym.getName());
                    s.append("> was referenced but never placed");
                }
            }
            iter.increment();
        }
        return s.toString();
    }

    int addSymbol(SleighSymbol sym) {
        SleighCompile.entry("addSymbol", sym);
        int id = -1;
        try {
            id = this.symtab.addSymbol(sym);
        }
        catch (SleighError err) {
            this.reportError(err.location, err.getMessage());
        }
        return id;
    }

    public SleighCompile() {
        SleighCompile.entry("SleighCompile", new Object[0]);
        this.contextlock = false;
        this.userop_count = 0;
        this.errors = 0;
        this.warnunnecessarypcode = false;
        this.lenientconflicterrors = true;
        this.warnallnops = false;
        this.root = null;
        this.pcode.resetLabelCount();
    }

    public void reportError(Location location, String msg) {
        SleighCompile.entry("reportError", location, msg);
        if (location == null) {
            Msg.error((Object)this, (Object)msg);
        } else {
            Msg.error((Object)this, (Object)(location + ": " + msg));
        }
        ++this.errors;
    }

    public void reportWarning(Location location, String msg) {
        SleighCompile.entry("reportWarning", location, msg);
        if (location == null) {
            Msg.warn((Object)this, (Object)msg);
        } else {
            Msg.warn((Object)this, (Object)(location + ": " + msg));
        }
        ++this.warnings;
    }

    public void recordNop(Location location) {
        SleighCompile.entry("recordNop", location);
        this.noplist.push_back((Object)("NOP detected at " + location));
    }

    public int numErrors() {
        SleighCompile.entry("numErrors", new Object[0]);
        return this.errors;
    }

    public int numWarnings() {
        SleighCompile.entry("numWarnings", new Object[0]);
        return this.warnings;
    }

    long getUniqueAddr() {
        SleighCompile.entry("getUniqueAddr", new Object[0]);
        long base = this.getUniqueBase();
        this.setUniqueBase(base + 16L);
        return base;
    }

    void setUnnecessaryPcodeWarning(boolean val) {
        SleighCompile.entry("setUnecessaryPcodeWarning", val);
        this.warnunnecessarypcode = val;
    }

    void setDeadTempWarning(boolean val) {
        SleighCompile.entry("setDeadTempWarning", val);
        this.warndeadtemps = val;
    }

    void setUnusedFieldWarning(boolean val) {
        SleighCompile.entry("setUnusedFieldWarning", val);
        this.warnunusedfields = val;
    }

    void setEnforceLocalKeyWord(boolean val) {
        SleighCompile.entry("setEnforceLocalKeyWord", val);
        this.enforcelocalkeyword = val;
        this.pcode.setEnforceLocalKey(val);
    }

    void setLenientConflict(boolean val) {
        SleighCompile.entry("setLenientConflict", val);
        this.lenientconflicterrors = val;
    }

    void setLocalCollisionWarning(boolean val) {
        SleighCompile.entry("setLocalCollisionWarning", val);
        this.warnalllocalcollisions = val;
    }

    void setAllNopWarning(boolean val) {
        SleighCompile.entry("setAllNopWarning", val);
        this.warnallnops = val;
    }

    public void process() {
        SleighCompile.entry("process", new Object[0]);
        if (this.getDefaultSpace() == null) {
            this.reportError(null, "No default space specified");
        }
        if (this.errors > 0) {
            return;
        }
        this.checkConsistency();
        if (this.errors > 0) {
            return;
        }
        this.checkLocalCollisions();
        if (this.errors > 0) {
            return;
        }
        this.buildPatterns();
        if (this.errors > 0) {
            return;
        }
        this.buildDecisionTrees();
        if (this.errors > 0) {
            return;
        }
        try {
            this.buildXrefs();
        }
        catch (SleighError err) {
            Msg.error((Object)this, (Object)err.getMessage(), (Throwable)err);
            ++this.errors;
            return;
        }
        this.checkUniqueAllocation();
        this.checkFieldUsage();
        this.symtab.purge();
    }

    public void calcContextLayout() {
        int sz;
        SleighCompile.entry("calcContextLayout", new Object[0]);
        if (this.contextlock) {
            return;
        }
        this.contextlock = true;
        int context_offset = 0;
        this.contexttable.sort();
        for (int begin = 0; begin < this.contexttable.size(); begin += sz) {
            sz = 1;
            while (begin + sz < this.contexttable.size() && ((FieldContext)this.contexttable.get((int)(begin + sz))).sym.equals(((FieldContext)this.contexttable.get((int)begin)).sym)) {
                ++sz;
            }
            context_offset = this.calcContextVarLayout(begin, sz, context_offset);
        }
        this.contexttable.clear();
    }

    public void setPosition(String pos, int presumedLineno) {
        Matcher m = PREPROCPOS.matcher(pos);
        if (!m.matches()) {
            throw new RuntimeException("couldn't parse position '" + pos + "'");
        }
        this.filename = m.group(1);
        this.lineno = Integer.parseInt(m.group(2));
        this.linenoDifferential = this.lineno - presumedLineno;
    }

    public void setLineno(int presumedLineno) {
        this.lineno = presumedLineno + this.linenoDifferential;
    }

    Pair<Boolean, String> getPreprocValue(String nm) {
        IteratorSTL iter = this.preproc_defines.find((Object)nm);
        if (iter.isEnd()) {
            return new Pair((Object)false, null);
        }
        return new Pair((Object)true, (Object)((String)((Pair)iter.get()).second));
    }

    void setPreprocValue(String nm, String value) {
        this.preproc_defines.put((Object)nm, (Object)value);
    }

    boolean undefinePreprocValue(String nm) {
        IteratorSTL iter = this.preproc_defines.find((Object)nm);
        if (iter.isEnd()) {
            return false;
        }
        this.preproc_defines.erase(iter);
        return true;
    }

    public TokenSymbol defineToken(Location location, String name, long sz) {
        SleighCompile.entry("defineToken", location, name, sz);
        int size = (int)sz;
        if ((size & 7) != 0) {
            this.reportError(location, name + "token size must be multiple of 8");
            size = size / 8 + 1;
        } else {
            size /= 8;
        }
        Token newtoken = new Token(name, size, this.isBigEndian(), this.tokentable.size());
        this.tokentable.push_back((Object)newtoken);
        TokenSymbol res = new TokenSymbol(location, newtoken);
        this.addSymbol(res);
        return res;
    }

    public void addTokenField(Location location, TokenSymbol sym, FieldQuality qual) {
        SleighCompile.entry("addTokenField", location, sym, qual);
        TokenField field = new TokenField(location, sym.getToken(), qual.signext, qual.low, qual.high);
        this.addSymbol(new ValueSymbol(location, qual.name, field));
    }

    public boolean addContextField(VarnodeSymbol sym, FieldQuality qual) {
        SleighCompile.entry("addContextField", sym, qual);
        if (this.contextlock) {
            return false;
        }
        this.contexttable.push_back((Object)new FieldContext(sym, qual));
        return true;
    }

    private int bitsConsumedByUnitSize(int ws) {
        int cnt = 0;
        for (int test = ws - 1; test != 0; test >>= 1) {
            ++cnt;
        }
        return cnt;
    }

    public void newSpace(Location location, SpaceQuality qual) {
        SleighCompile.entry("newSpace", location, qual);
        if (qual.size == 0) {
            this.reportError(location, "Space definition missing size attribute");
            return;
        }
        if (qual.size <= 0 || qual.size > 8) {
            throw new SleighError("Space " + qual.name + " has unsupported size: 16", location);
        }
        if (qual.wordsize < 1 || qual.wordsize > 8) {
            throw new SleighError("Space " + qual.name + " has unsupported wordsize: " + qual.wordsize, location);
        }
        int addressBits = this.bitsConsumedByUnitSize(qual.wordsize) + 8 * qual.size;
        if (addressBits > 64) {
            throw new SleighError("Space " + qual.name + " has unsupported dimensions, requires " + addressBits + "-bits (limit is 64-bits)", location);
        }
        int delay = qual.type == space_class.register_space ? 0 : 1;
        AddrSpace spc = new AddrSpace(this, spacetype.IPTR_PROCESSOR, qual.name, qual.size, qual.wordsize, this.numSpaces(), 256, delay);
        this.insertSpace(spc);
        if (qual.isdefault) {
            if (this.getDefaultSpace() != null) {
                this.reportError(location, "Multiple default spaces");
            } else {
                this.setDefaultSpace(spc.getIndex());
            }
        }
        this.addSymbol(new SpaceSymbol(location, spc));
    }

    public void setEndian(int end) {
        SleighCompile.entry("setEndian", end);
        this.target_endian = end;
        this.predefinedSymbols();
    }

    public void setAlignment(int val) {
        SleighCompile.entry("setAlignment", val);
        this.alignment = val;
    }

    public void defineVarnodes(SpaceSymbol spacesym, long off, int size, VectorSTL<String> names, VectorSTL<Location> locations) {
        SleighCompile.entry("defineVarnodes", spacesym, off, size, names, locations);
        AddrSpace spc = spacesym.getSpace();
        long myoff = off;
        for (int i = 0; i < names.size(); ++i) {
            Location location = (Location)locations.get(i);
            if (!"_".equals(names.get(i))) {
                this.addSymbol(new VarnodeSymbol(location, (String)names.get(i), spc, myoff, size));
            }
            myoff += (long)size;
        }
    }

    public void defineBitrange(Location location, String name, VarnodeSymbol sym, int bitoffset, int numb) {
        SleighCompile.entry("defineBitrange", location, name, sym, bitoffset, numb);
        String namecopy = name;
        int size = 8 * sym.getSize();
        if (numb == 0) {
            this.reportError(location, "Size of bitrange is zero for: " + namecopy);
            return;
        }
        if (bitoffset >= size || bitoffset + numb > size) {
            this.reportError(location, "Bad bitrange for: " + namecopy);
            return;
        }
        if (bitoffset % 8 == 0 && numb % 8 == 0) {
            AddrSpace newspace = sym.getFixedVarnode().space;
            long newoffset = sym.getFixedVarnode().offset;
            int newsize = numb / 8;
            newoffset = this.isBigEndian() ? (newoffset += (long)((size - bitoffset - numb) / 8)) : (newoffset += (long)(bitoffset / 8));
            this.addSymbol(new VarnodeSymbol(location, namecopy, newspace, newoffset, newsize));
        } else {
            if (size > 64) {
                this.reportError(location, "Illegal bitrange on varnode larger than 64 bits: " + sym.getName());
            }
            this.addSymbol(new BitrangeSymbol(location, namecopy, sym, bitoffset, numb));
        }
    }

    public void addUserOp(VectorSTL<String> names, VectorSTL<Location> locations) {
        SleighCompile.entry("addUserOp", names, locations);
        for (int i = 0; i < names.size(); ++i) {
            boolean isInternal = this.pcode.isInternalFunction((String)names.get(i));
            if (isInternal) {
                this.reportError((Location)locations.get(i), (String)names.get(i) + " is an internal pcodeop and cannot be redefined as a pseudoop");
            }
            UserOpSymbol sym = new UserOpSymbol((Location)locations.get(i), (String)names.get(i));
            sym.setIndex(this.userop_count++);
            this.addSymbol(sym);
        }
    }

    public SleighSymbol dedupSymbolList(VectorSTL<SleighSymbol> symlist) {
        SleighCompile.entry("dedupSymbolList", symlist);
        SleighSymbol res = null;
        for (int i = 0; i < symlist.size(); ++i) {
            SleighSymbol sym = (SleighSymbol)symlist.get(i);
            if (sym == null) continue;
            for (int j = i + 1; j < symlist.size(); ++j) {
                if (symlist.get(j) != sym) continue;
                res = sym;
                symlist.set(j, null);
            }
        }
        return res;
    }

    public void attachValues(VectorSTL<SleighSymbol> symlist, VectorSTL<Location> locations, VectorSTL<Long> numlist) {
        SleighCompile.entry("attachValues", symlist, locations, numlist);
        SleighSymbol dupsym = this.dedupSymbolList(symlist);
        if (dupsym != null) {
            this.reportWarning(dupsym.location, "\"attach values\" list contains duplicate entries: " + dupsym.getName());
        }
        for (int i = 0; i < symlist.size(); ++i) {
            Location location = (Location)locations.get(i);
            ValueSymbol sym = (ValueSymbol)symlist.get(i);
            if (sym == null) continue;
            PatternValue patval = sym.getPatternValue();
            if (patval.maxValue() + 1L != (long)numlist.size()) {
                this.reportError(location, "Attach value " + sym + " is wrong size for list " + numlist);
            }
            this.symtab.replaceSymbol(sym, new ValueMapSymbol(location, sym.getName(), patval, numlist));
        }
    }

    public void attachNames(VectorSTL<SleighSymbol> symlist, VectorSTL<Location> locations, VectorSTL<String> names) {
        SleighCompile.entry("attachNames", symlist, locations, names);
        SleighSymbol dupsym = this.dedupSymbolList(symlist);
        if (dupsym != null) {
            this.reportWarning(dupsym.location, "\"attach names\" list contains duplicate entries: " + dupsym.getName());
        }
        for (int i = 0; i < symlist.size(); ++i) {
            Location location = (Location)locations.get(i);
            ValueSymbol sym = (ValueSymbol)symlist.get(i);
            if (sym == null) continue;
            PatternValue patval = sym.getPatternValue();
            if (patval.maxValue() + 1L != (long)names.size()) {
                this.reportError(location, "Attach name " + sym + " is wrong size for list " + names);
            }
            this.symtab.replaceSymbol(sym, new NameSymbol(location, sym.getName(), patval, names));
        }
    }

    public void attachVarnodes(VectorSTL<SleighSymbol> symlist, VectorSTL<Location> locations, VectorSTL<SleighSymbol> varlist) {
        SleighCompile.entry("attachVarnodes", symlist, locations, varlist);
        SleighSymbol dupsym = this.dedupSymbolList(symlist);
        if (dupsym != null) {
            this.reportWarning(dupsym.location, "\"attach variables\" list contains duplicate entries: " + dupsym.getName());
        }
        for (int i = 0; i < symlist.size(); ++i) {
            Location location = (Location)locations.get(i);
            ValueSymbol sym = (ValueSymbol)symlist.get(i);
            if (sym == null) continue;
            if (this.firstContextField != null && sym.getId() == this.firstContextField.intValue()) {
                this.reportError(location, sym.getName() + " cannot be used to attach variables because it occurs at the lowest bit position in context at " + sym.getLocation());
                continue;
            }
            PatternValue patval = sym.getPatternValue();
            if (patval.maxValue() + 1L != (long)varlist.size()) {
                this.reportError(location, "Attach varnode " + sym + " is wrong size for list " + varlist);
            }
            int sz = 0;
            for (int j = 0; j < varlist.size(); ++j) {
                VarnodeSymbol vsym = (VarnodeSymbol)varlist.get(j);
                if (vsym == null) continue;
                if (sz == 0) {
                    sz = vsym.getFixedVarnode().size;
                    continue;
                }
                if (sz == vsym.getFixedVarnode().size) continue;
                this.reportError(location, "Attach statement contains varnodes of different sizes");
                break;
            }
            this.symtab.replaceSymbol(sym, new VarnodeListSymbol(location, sym.getName(), patval, varlist));
        }
    }

    public SubtableSymbol newTable(Location location, String nm) {
        SleighCompile.entry("newTable", location, nm);
        SubtableSymbol sym = new SubtableSymbol(location, nm);
        this.addSymbol(sym);
        this.tables.push_back((Object)sym);
        return sym;
    }

    public void newOperand(Location location, Constructor ct, String nm) {
        SleighCompile.entry("newOperand", location, ct, nm);
        int index = ct.getNumOperands();
        OperandSymbol sym = new OperandSymbol(location, nm, index, ct);
        this.addSymbol(sym);
        ct.addOperand(sym);
    }

    public PatternEquation constrainOperand(Location location, OperandSymbol sym, PatternExpression patexp) {
        EqualEquation res;
        SleighCompile.entry("constrainOperand", location, sym, patexp);
        TripleSymbol definingSymbol = sym.getDefiningSymbol();
        if (definingSymbol instanceof FamilySymbol) {
            FamilySymbol famsym = (FamilySymbol)definingSymbol;
            res = new EqualEquation(location, famsym.getPatternValue(), patexp);
        } else {
            this.reportError(location, "Constraining currently undefined operand: " + sym);
            PatternExpression.release(patexp);
            res = null;
        }
        return res;
    }

    public void defineOperand(Location location, OperandSymbol sym, PatternExpression patexp) {
        SleighCompile.entry("defineOperand", location, sym, patexp);
        try {
            sym.defineOperand(patexp);
            sym.setOffsetIrrelevant();
        }
        catch (SleighError err) {
            this.reportError(location, err.getMessage());
            PatternExpression.release(patexp);
        }
    }

    public PatternEquation defineInvisibleOperand(Location location, TripleSymbol sym) {
        SleighCompile.entry("defineInvisibleOperand", location, sym);
        int index = this.curct.getNumOperands();
        OperandSymbol opsym = new OperandSymbol(location, sym.getName(), index, this.curct);
        this.addSymbol(opsym);
        this.curct.addInvisibleOperand(opsym);
        OperandEquation res = new OperandEquation(location, opsym.getIndex());
        symbol_type tp = sym.getType();
        try {
            if (tp == symbol_type.value_symbol || tp == symbol_type.context_symbol) {
                opsym.defineOperand(sym.getPatternExpression());
            } else {
                opsym.defineOperand(sym);
            }
        }
        catch (SleighError err) {
            this.reportError(location, err.getMessage());
        }
        return res;
    }

    public void selfDefine(OperandSymbol sym) {
        SleighCompile.entry("selfDefine", sym);
        SleighSymbol sleighSymbol = this.symtab.findSymbol(sym.getName(), 1);
        if (!(sleighSymbol instanceof TripleSymbol)) {
            this.reportError(sym.getLocation(), sym.getName() + ": No matching global symbol");
            return;
        }
        TripleSymbol glob = (TripleSymbol)sleighSymbol;
        symbol_type tp = glob.getType();
        try {
            if (tp == symbol_type.value_symbol || tp == symbol_type.context_symbol) {
                sym.defineOperand(glob.getPatternExpression());
            } else {
                sym.defineOperand(glob);
            }
        }
        catch (SleighError err) {
            this.reportError(sym.getLocation(), err.getMessage());
        }
    }

    public boolean contextMod(VectorSTL<ContextChange> vec, ContextSymbol sym, PatternExpression pe) {
        SleighCompile.entry("contextMod", vec, sym, pe);
        VectorSTL vallist = new VectorSTL();
        pe.listValues((VectorSTL<PatternValue>)vallist);
        for (int i = 0; i < vallist.size(); ++i) {
            if (!(vallist.get(i) instanceof EndInstructionValue)) continue;
            return false;
        }
        ContextField field = (ContextField)sym.getPatternValue();
        ContextOp op = new ContextOp(sym.getLocation(), field.getStartBit(), field.getEndBit(), pe);
        vec.push_back((Object)op);
        return true;
    }

    public void contextSet(VectorSTL<ContextChange> vec, TripleSymbol sym, ContextSymbol cvar) {
        SleighCompile.entry("contextSet", vec, sym, cvar);
        ContextField field = (ContextField)cvar.getPatternValue();
        ContextCommit op = new ContextCommit(sym, field.getStartBit(), field.getEndBit(), cvar.isFlow());
        vec.push_back((Object)op);
    }

    public MacroSymbol createMacro(Location location, String name, VectorSTL<String> params, VectorSTL<Location> locations) {
        SleighCompile.entry("createMacro", location, name, params, locations);
        this.curct = null;
        this.curmacro = new MacroSymbol(location, name, this.macrotable.size());
        this.addSymbol(this.curmacro);
        this.symtab.addScope();
        this.pcode.resetLabelCount();
        for (int i = 0; i < params.size(); ++i) {
            OperandSymbol oper = new OperandSymbol((Location)locations.get(i), (String)params.get(i), i, null);
            this.addSymbol(oper);
            this.curmacro.addOperand(oper);
        }
        return this.curmacro;
    }

    void compareMacroParams(MacroSymbol sym, VectorSTL<ExprTree> param) {
        SleighCompile.entry("compareMacroParams", sym, param);
        for (int i = 0; i < param.size(); ++i) {
            VarnodeTpl outvn = ((ExprTree)param.get((int)i)).outvn;
            if (outvn == null || outvn.getOffset().getType() != ConstTpl.const_type.handle) continue;
            int hand = outvn.getOffset().getHandleIndex();
            OperandSymbol macroop = sym.getOperand(i);
            OperandSymbol parentop = this.curct == null ? this.curmacro.getOperand(hand) : this.curct.getOperand(hand);
            if (!macroop.isCodeAddress()) continue;
            parentop.setCodeAddress();
        }
    }

    public VectorSTL<OpTpl> createMacroUse(Location location, MacroSymbol sym, VectorSTL<ExprTree> param) {
        SleighCompile.entry("createMacroUse", location, sym, param);
        if (sym.getNumOperands() != param.size()) {
            String errmsg = "Invocation of macro \"" + sym.getName();
            errmsg = param.size() > sym.getNumOperands() ? errmsg + "\" passes too many parameters" : errmsg + "\" passes too few parameters";
            this.reportError(sym.getLocation(), errmsg);
            return new VectorSTL();
        }
        this.compareMacroParams(sym, param);
        OpTpl op = new OpTpl(location, OpCode.CPUI_CAST);
        VarnodeTpl idvn = new VarnodeTpl(location, new ConstTpl(this.getConstantSpace()), new ConstTpl(ConstTpl.const_type.real, sym.getIndex()), new ConstTpl(ConstTpl.const_type.real, 4L));
        op.addInput(idvn);
        return ExprTree.appendParams(op, param);
    }

    public Constructor createConstructor(Location location, SubtableSymbol sym) {
        SleighCompile.entry("createConstructor", location, sym);
        if (sym == null) {
            sym = WithBlock.getCurrentSubtable(this.withstack);
        }
        if (sym == null) {
            sym = this.root;
        }
        this.curmacro = null;
        this.curct = new Constructor(location, sym);
        sym.addConstructor(this.curct);
        this.symtab.addScope();
        this.pcode.resetLabelCount();
        return this.curct;
    }

    void resetConstructors() {
        SleighCompile.entry("resetConstructors", new Object[0]);
        this.symtab.setCurrentScope(this.symtab.getGlobalScope());
    }

    private static VarnodeTpl find_size(ConstTpl offset, ConstructTpl ct) {
        SleighCompile.entry("find_size", offset, ct);
        VectorSTL<OpTpl> ops = ct.getOpvec();
        for (int i = 0; i < ops.size(); ++i) {
            OpTpl op = (OpTpl)ops.get(i);
            VarnodeTpl vn = op.getOut();
            if (vn != null && vn.isLocalTemp() && vn.getOffset().equals(offset)) {
                return vn;
            }
            for (int j = 0; j < op.numInput(); ++j) {
                vn = op.getIn(j);
                if (!vn.isLocalTemp() || !vn.getOffset().equals(offset)) continue;
                return vn;
            }
        }
        return null;
    }

    private static boolean force_exportsize(ConstructTpl ct) {
        SleighCompile.entry("force_exportsize", ct);
        HandleTpl result = ct.getResult();
        if (result == null) {
            return true;
        }
        if (result.getPtrSpace().isUniqueSpace() && result.getPtrSize().isZero()) {
            VarnodeTpl vt = SleighCompile.find_size(result.getPtrOffset(), ct);
            if (vt == null) {
                return false;
            }
            result.setPtrSize(vt.getSize());
        } else if (result.getSpace().isUniqueSpace() && result.getSize().isZero()) {
            VarnodeTpl vt = SleighCompile.find_size(result.getPtrOffset(), ct);
            if (vt == null) {
                return false;
            }
            result.setSize(vt.getSize());
        }
        return true;
    }

    boolean expandMacros(ConstructTpl ctpl) {
        VectorSTL<OpTpl> vec = ctpl.getOpvec();
        VectorSTL newvec = new VectorSTL();
        IteratorSTL iter = vec.begin();
        while (!iter.isEnd()) {
            OpTpl op = (OpTpl)iter.get();
            if (op.getOpcode() == OpCode.CPUI_CAST) {
                MacroBuilder builder = new MacroBuilder(this, op.location, (VectorSTL<OpTpl>)newvec, ctpl.numLabels());
                int index = (int)op.getIn(0).getOffset().getReal();
                if (index >= this.macrotable.size()) {
                    return false;
                }
                builder.setMacroOp(op);
                ConstructTpl macro_tpl = (ConstructTpl)this.macrotable.get(index);
                builder.build(macro_tpl, -1);
                ctpl.setNumLabels(ctpl.numLabels() + macro_tpl.numLabels());
                op.dispose();
                if (builder.hasError()) {
                    return false;
                }
            } else {
                newvec.push_back((Object)op);
            }
            iter.increment();
        }
        ctpl.setOpvec((VectorSTL<OpTpl>)newvec);
        return true;
    }

    boolean finalizeSections(Constructor big, SectionVector vec) {
        SleighCompile.entry("finalizeSections", big, vec);
        VectorSTL myErrors = new VectorSTL();
        RtlPair cur = vec.getMainPair();
        int i = -1;
        Object sectionstring = "   Main section: ";
        int max = vec.getMaxId();
        while (true) {
            String errstring;
            if ((errstring = this.checkSymbols(cur.scope)).length() == 0) {
                if (!this.expandMacros(cur.section)) {
                    myErrors.push_back((Object)((String)sectionstring + "Could not expand macros"));
                }
                VectorSTL check = new VectorSTL();
                big.markSubtableOperands((VectorSTL<Integer>)check);
                Pair<Integer, Location> res = cur.section.fillinBuild((VectorSTL<Integer>)check, this.getConstantSpace());
                if ((Integer)res.first == 1) {
                    myErrors.push_back((Object)((String)sectionstring + "Duplicate BUILD statements at " + res.second));
                }
                if ((Integer)res.first == 2) {
                    myErrors.push_back((Object)((String)sectionstring + "Unnecessary BUILD statements at " + res.second));
                }
                if (!this.pcode.propagateSize(cur.section)) {
                    myErrors.push_back((Object)((String)sectionstring + "Could not resolve at least 1 variable size"));
                }
            }
            if (i < 0 && cur.section.getResult() != null) {
                if (big.getParent() == this.root) {
                    myErrors.push_back((Object)"   Cannot have export statement in root constructor");
                } else if (!SleighCompile.force_exportsize(cur.section)) {
                    myErrors.push_back((Object)"   Size of export is unknown");
                }
            }
            if (cur.section.delaySlot() != 0) {
                if (this.root != big.getParent()) {
                    this.reportWarning(null, "Delay slot used in " + big);
                }
                if (cur.section.delaySlot() > this.maxdelayslotbytes) {
                    this.maxdelayslotbytes = cur.section.delaySlot();
                }
            }
            while (++i < max) {
                cur = vec.getNamedPair(i);
                if (cur.section == null) continue;
            }
            if (i >= max) break;
            SectionSymbol sym = (SectionSymbol)this.sections.get(i);
            sectionstring = "   " + sym.getName() + " section: ";
        }
        if (!myErrors.empty()) {
            this.reportError(big.location, "in " + big);
            for (int j = 0; j < myErrors.size(); ++j) {
                this.reportError(null, (String)myErrors.get(j));
            }
            return false;
        }
        return true;
    }

    void shiftUniqueVn(VarnodeTpl vn, int sa) {
        SleighCompile.entry("shiftUniqueVn", vn, sa);
        if (vn.getSpace().isUniqueSpace() && vn.getOffset().getType() == ConstTpl.const_type.real) {
            long val = vn.getOffset().getReal();
            vn.setOffset(val <<= sa);
        }
    }

    void shiftUniqueOp(OpTpl op, int sa) {
        SleighCompile.entry("shiftUniqueOp", op, sa);
        VarnodeTpl outvn = op.getOut();
        if (outvn != null) {
            this.shiftUniqueVn(outvn, sa);
        }
        for (int i = 0; i < op.numInput(); ++i) {
            this.shiftUniqueVn(op.getIn(i), sa);
        }
    }

    void shiftUniqueHandle(HandleTpl hand, int sa) {
        long val;
        SleighCompile.entry("shiftUniqueHandle", hand, sa);
        if (hand.getSpace().isUniqueSpace() && hand.getPtrSpace().getType() == ConstTpl.const_type.real && hand.getPtrOffset().getType() == ConstTpl.const_type.real) {
            val = hand.getPtrOffset().getReal();
            hand.setPtrOffset(val <<= sa);
        } else if (hand.getPtrSpace().isUniqueSpace() && hand.getPtrOffset().getType() == ConstTpl.const_type.real) {
            val = hand.getPtrOffset().getReal();
            hand.setPtrOffset(val <<= sa);
        }
        if (hand.getTempSpace().isUniqueSpace() && hand.getTempOffset().getType() == ConstTpl.const_type.real) {
            val = hand.getTempOffset().getReal();
            hand.setTempOffset(val <<= sa);
        }
    }

    void shiftUniqueConstruct(ConstructTpl tpl, int sa) {
        SleighCompile.entry("shiftUniqueConstruct", tpl, sa);
        HandleTpl result = tpl.getResult();
        if (result != null) {
            this.shiftUniqueHandle(result, sa);
        }
        VectorSTL<OpTpl> vec = tpl.getOpvec();
        for (int i = 0; i < vec.size(); ++i) {
            this.shiftUniqueOp((OpTpl)vec.get(i), sa);
        }
    }

    void checkUniqueAllocation() {
        if (this.unique_allocatemask == 0) {
            return;
        }
        this.unique_allocatemask = 255;
        int sa = 8;
        int secsize = this.sections.size();
        SubtableSymbol sym = this.root;
        int i = -1;
        while (true) {
            int numconst = sym.getNumConstructors();
            for (int j = 0; j < numconst; ++j) {
                Constructor ct = sym.getConstructor(j);
                ConstructTpl tpl = ct.getTempl();
                if (tpl != null) {
                    this.shiftUniqueConstruct(tpl, sa);
                }
                for (int k = 0; k < secsize; ++k) {
                    ConstructTpl namedtpl = ct.getNamedTempl(k);
                    if (namedtpl == null) continue;
                    this.shiftUniqueConstruct(namedtpl, sa);
                }
            }
            if (++i >= this.tables.size()) break;
            sym = (SubtableSymbol)this.tables.get(i);
        }
        long ubase = this.getUniqueBase();
        this.setUniqueBase(ubase <<= sa);
    }

    void checkFieldUsage() {
        if (this.warnunusedfields) {
            VectorSTL<SleighSymbol> unsoughtSymbols = this.symtab.getUnsoughtSymbols();
            IteratorSTL siter = unsoughtSymbols.begin();
            while (!siter.isEnd()) {
                ValueSymbol valueSymbol;
                PatternValue patternValue;
                SleighSymbol sleighSymbol = (SleighSymbol)siter.get();
                if (sleighSymbol instanceof ValueSymbol && (patternValue = (valueSymbol = (ValueSymbol)sleighSymbol).getPatternValue()) instanceof TokenField && sleighSymbol.location != Location.INTERNALLY_DEFINED) {
                    this.reportWarning(patternValue.location, "token field " + sleighSymbol.getName() + " defined but never used");
                }
                siter.increment();
            }
        }
    }

    public void pushWith(SubtableSymbol ss, PatternEquation pateq, VectorSTL<ContextChange> contvec) {
        this.withstack.push(new WithBlock(ss, pateq, contvec));
    }

    public void popWith() {
        this.withstack.pop();
    }

    public void buildConstructor(Constructor big, PatternEquation pateq, VectorSTL<ContextChange> contvec, SectionVector vec) {
        boolean noerrors = true;
        if (vec != null && (noerrors = this.finalizeSections(big, vec))) {
            big.setMainSection(vec.getMainSection());
            int max = vec.getMaxId();
            for (int i = 0; i < max; ++i) {
                ConstructTpl section = vec.getNamedSection(i);
                if (section == null) continue;
                big.setNamedSection(section, i);
            }
        }
        if (noerrors) {
            pateq = WithBlock.collectAndPrependPattern(this.withstack, pateq);
            contvec = WithBlock.collectAndPrependContext(this.withstack, contvec);
            big.addEquation(pateq);
            big.removeTrailingSpace();
            if (contvec != null) {
                big.addContext(contvec);
            }
        }
        this.symtab.popScope();
    }

    public void buildMacro(MacroSymbol sym, ConstructTpl rtl) {
        SleighCompile.entry("buildMacro", sym, rtl);
        String errstring = this.checkSymbols(this.symtab.getCurrentScope());
        if (errstring.length() != 0) {
            this.reportError(sym.getLocation(), " in definition of macro " + sym.getName() + ":" + errstring);
            return;
        }
        if (!this.expandMacros(rtl)) {
            this.reportError(sym.getLocation(), "Could not expand submacro in definition of macro " + sym.getName());
            return;
        }
        this.pcode.propagateSize(rtl);
        sym.setConstruct(rtl);
        this.symtab.popScope();
        this.macrotable.push_back((Object)rtl);
    }

    @Override
    public void initialize(DocumentStorage store) {
    }

    @Override
    public int instructionLength(Address baseaddr) {
        return 0;
    }

    @Override
    public int printAssembly(PrintStream s, int size, Address baseaddr) {
        return 0;
    }

    public static void main(String[] args) throws JDOMException, IOException, RecognitionException {
        System.exit(SleighCompileLauncher.runMain(args));
    }

    protected static class WithBlock {
        SubtableSymbol ss;
        PatternEquation pateq;
        VectorSTL<ContextChange> contvec;

        WithBlock(SubtableSymbol ss, PatternEquation pateq, VectorSTL<ContextChange> contvec) {
            this.ss = ss;
            this.pateq = pateq;
            this.contvec = contvec;
        }

        static PatternEquation collectAndPrependPattern(Deque<WithBlock> stack, PatternEquation pateq) {
            for (WithBlock with : stack) {
                if (with.pateq == null) continue;
                pateq = new EquationAnd(null, with.pateq, pateq);
            }
            return pateq;
        }

        static VectorSTL<ContextChange> collectAndPrependContext(Deque<WithBlock> stack, VectorSTL<ContextChange> contvec) {
            for (WithBlock with : stack) {
                if (with.contvec == null) continue;
                contvec.insertAll(contvec.begin(), with.contvec);
            }
            return contvec;
        }

        static SubtableSymbol getCurrentSubtable(Deque<WithBlock> stack) {
            for (WithBlock with : stack) {
                if (with.ss == null) continue;
                return with.ss;
            }
            return null;
        }
    }
}

