/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import generic.algorithms.ReducingListBasedLcs;
import ghidra.program.database.code.StringDiff;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

class StringDiffUtils {
    private static int MINIMUM_DIFF_SIZE = 100;

    StringDiffUtils() {
    }

    static StringDiff[] getLineDiffs(String s1, String s2) {
        return StringDiffUtils.getLineDiffs(s1, s2, MINIMUM_DIFF_SIZE);
    }

    static StringDiff[] getLineDiffs(String s1, String s2, int minimumDiffSize) {
        StringDiff trailingInserted;
        List<Line> bList;
        if (s2.length() < minimumDiffSize) {
            return new StringDiff[]{StringDiff.allTextReplaced(s2)};
        }
        List<Line> aList = StringDiffUtils.split(s1);
        LineLcs lcs = new LineLcs(aList, bList = StringDiffUtils.split(s2));
        List commons = lcs.getLcs();
        if (commons.isEmpty()) {
            return new StringDiff[]{StringDiff.allTextReplaced(s2)};
        }
        int aIndex = 0;
        int bIndex = 0;
        int aLastIndex = 0;
        int bLastIndex = 0;
        LinkedList<StringDiff> results = new LinkedList<StringDiff>();
        for (Line common : commons) {
            int bEnd;
            int bStart;
            List<Line> bPrevious;
            StringDiff insert;
            aIndex = StringDiffUtils.indexOf(aList, common, aLastIndex);
            bIndex = StringDiffUtils.indexOf(bList, common, bLastIndex);
            int aDelta = aIndex - aLastIndex;
            int bDelta = bIndex - bLastIndex;
            int aEnd = aIndex;
            int aStart = aEnd - aDelta;
            List<Line> aPrevious = aList.subList(aStart, aEnd);
            StringDiff delete = StringDiffUtils.createDelete(aPrevious);
            if (delete != null) {
                results.add(delete);
            }
            if ((insert = StringDiffUtils.createInsert(bPrevious = bList.subList(bStart = (bEnd = bIndex) - bDelta, bEnd), StringDiffUtils.charOffset(aList, aIndex))) != null) {
                results.add(insert);
            }
            aLastIndex = aIndex + 1;
            bLastIndex = bIndex + 1;
        }
        StringDiff trailingDeleted = StringDiffUtils.createDeleteAtEnd(aList, aLastIndex, aList.size());
        if (trailingDeleted != null) {
            results.add(trailingDeleted);
        }
        if ((trailingInserted = StringDiffUtils.createInsertAtEnd(bList, bLastIndex, bList.size(), s1.length())) != null) {
            results.add(trailingInserted);
        }
        return results.toArray(new StringDiff[results.size()]);
    }

    private static int charOffset(List<Line> list, int index) {
        Line line = list.get(index);
        return line.start;
    }

    private static StringDiff createInsertAtEnd(List<Line> list, int start, int end, int insertIndex) {
        if (start - 1 == end) {
            return null;
        }
        List<Line> toDo = list.subList(start, end);
        boolean newlineNeeded = true;
        StringDiff insert = StringDiffUtils.createInsert(toDo, insertIndex, newlineNeeded);
        return insert;
    }

    private static StringDiff createInsert(List<Line> lines, int insertIndex) {
        return StringDiffUtils.createInsert(lines, insertIndex, false);
    }

    private static StringDiff createInsert(List<Line> lines, int insertIndex, boolean isAtEnd) {
        if (lines.isEmpty()) {
            return null;
        }
        StringBuilder buffy = new StringBuilder();
        if (isAtEnd) {
            buffy.append('\n');
        }
        for (Line line : lines) {
            buffy.append(line.getText());
        }
        return StringDiff.textInserted(buffy.toString(), insertIndex);
    }

    private static StringDiff createDeleteAtEnd(List<Line> list, int start, int end) {
        if (start - 1 == end) {
            return null;
        }
        List<Line> toDo = list.subList(start, end);
        boolean includeLastNewline = false;
        StringDiff delete = StringDiffUtils.createDelete(toDo, includeLastNewline);
        return delete;
    }

    private static StringDiff createDelete(List<Line> lines) {
        return StringDiffUtils.createDelete(lines, true);
    }

    private static StringDiff createDelete(List<Line> lines, boolean includeLastNewline) {
        if (lines.isEmpty()) {
            return null;
        }
        int start = 0;
        int end = 0;
        for (Line line : lines) {
            start = line.start;
            end = line.start + line.text.length();
        }
        Line last = lines.get(lines.size() - 1);
        if (!includeLastNewline && last.isLastLine) {
            --start;
        }
        return StringDiff.textDeleted(start, end);
    }

    private static int indexOf(List<Line> list, Line line, int from) {
        for (int i = from; i < list.size(); ++i) {
            if (!list.get(i).textMatches(line)) continue;
            return i;
        }
        return list.size();
    }

    private static List<Line> split(String s) {
        LinkedList<Line> result = new LinkedList<Line>();
        List<String> lines = Arrays.asList(StringUtils.splitPreserveAllTokens((String)s, (char)'\n'));
        int start = 0;
        for (String line : lines) {
            Line l = new Line(line + "\n", start);
            result.add(l);
            start += l.text.length();
        }
        if (result.isEmpty()) {
            result.add(new Line("", 0));
        }
        Line last = (Line)result.peekLast();
        last.markAsLast();
        return result;
    }

    static String applyDiffs(String s, List<StringDiff> diffs) {
        if (diffs.isEmpty()) {
            return s;
        }
        if (diffs.get((int)0).start < 0) {
            String data = diffs.get((int)0).text;
            return data == null ? "" : data;
        }
        int pos = 0;
        StringBuilder buf = new StringBuilder(s.length());
        for (StringDiff element : diffs) {
            String data;
            if (element.start > pos) {
                buf.append(s.substring(pos, element.start));
                pos = element.start;
            }
            if ((data = element.text) != null) {
                buf.append(data);
                continue;
            }
            pos = element.end;
        }
        if (pos < s.length()) {
            buf.append(s.substring(pos));
        }
        return buf.toString();
    }

    private static class LineLcs
    extends ReducingListBasedLcs<Line> {
        LineLcs(List<Line> x, List<Line> y) {
            super(x, y);
        }

        protected boolean matches(Line x, Line y) {
            return x.text.equals(y.text);
        }
    }

    private static class Line {
        private String text;
        private int start;
        private boolean isLastLine;

        public Line(String line, int start) {
            this.text = line;
            this.start = start;
        }

        String getText() {
            if (this.isLastLine) {
                return this.textWithoutNewline();
            }
            return this.text;
        }

        void markAsLast() {
            this.isLastLine = true;
        }

        private String textWithoutNewline() {
            if (this.text.charAt(this.text.length() - 1) == '\n') {
                return this.text.substring(0, this.text.length() - 1);
            }
            return this.text;
        }

        public String toString() {
            return this.textWithoutNewline() + " @ " + this.start;
        }

        boolean textMatches(Line other) {
            return Objects.equals(this.text, other.text);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.start;
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Line other = (Line)obj;
            if (this.start != other.start) {
                return false;
            }
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }
    }
}

