/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import java.io.Serializable;

public class GroupPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] groupNames;

    public GroupPath(String groupName) {
        this.groupNames = new String[1];
        this.groupNames[0] = groupName;
    }

    public GroupPath(String[] groupNames) {
        this.groupNames = new String[groupNames.length];
        System.arraycopy(groupNames, 0, this.groupNames, 0, groupNames.length);
    }

    public void updateGroupPath(String oldname, String newname) {
        for (int i = 0; i < this.groupNames.length; ++i) {
            if (!this.groupNames[i].equals(oldname)) continue;
            this.groupNames[i] = newname;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupPath p = (GroupPath)obj;
        if (this.groupNames.length != p.groupNames.length) {
            return false;
        }
        for (int i = 0; i < this.groupNames.length; ++i) {
            if (this.groupNames[i].equals(p.groupNames[i])) continue;
            return false;
        }
        return true;
    }

    public String getLastPathComponent() {
        return this.groupNames[this.groupNames.length - 1];
    }

    public Group getGroup(Program program, String treeName) {
        Listing listing = program.getListing();
        ProgramModule m = listing.getModule(treeName, this.groupNames[this.groupNames.length - 1]);
        if (m != null) {
            return m;
        }
        return listing.getFragment(treeName, this.groupNames[this.groupNames.length - 1]);
    }

    public GroupPath getParentPath() {
        if (this.groupNames.length == 1) {
            return null;
        }
        String[] p = new String[this.groupNames.length - 1];
        System.arraycopy(this.groupNames, 0, p, 0, p.length);
        return new GroupPath(p);
    }

    public String[] getPath() {
        return this.groupNames;
    }

    public int getPathCount() {
        return this.groupNames.length;
    }

    public String getPathComponent(int index) {
        return this.groupNames[index];
    }

    public boolean isDescendant(GroupPath grpPath) {
        if (this.groupNames.length > grpPath.groupNames.length) {
            return false;
        }
        if (this.equals(grpPath)) {
            return true;
        }
        for (int i = 0; i < this.groupNames.length; ++i) {
            if (this.groupNames[i].equals(grpPath.groupNames[i])) continue;
            return false;
        }
        return true;
    }

    public GroupPath pathByAddingChild(String child) {
        String[] p = new String[this.groupNames.length + 1];
        System.arraycopy(this.groupNames, 0, p, 0, this.groupNames.length);
        p[p.length - 1] = child;
        return new GroupPath(p);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.groupNames.length; ++i) {
            sb.append(this.groupNames[i]);
            if (i >= this.groupNames.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.groupNames.length; ++i) {
            hash += this.groupNames[i].hashCode();
        }
        return hash;
    }
}

