/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.actions.AbstractCreateManualMatchAction;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.functionassociation.FunctionAssociationContext;
import ghidra.feature.vt.gui.task.CreateManualMatchTask;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import javax.swing.Icon;
import resources.ResourceManager;

public class CreateManualMatchAction
extends AbstractCreateManualMatchAction {
    public static final Icon ICON = ResourceManager.loadImage((String)"images/Plus.png");

    public CreateManualMatchAction(VTController controller) {
        super("Create Manual Match", VTPlugin.OWNER, controller);
        this.setToolBarData(new ToolBarData(ICON, "Create"));
        this.setPopupMenuData(new MenuData(new String[]{"Create Manual Match"}, ICON));
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Create_Manual_Match"));
    }

    public void actionPerformed(ActionContext context) {
        FunctionAssociationContext providerContext = (FunctionAssociationContext)context;
        Function sourceFunction = providerContext.getSelectedSourceFunction();
        Function destinationFunction = providerContext.getSelectionDestinationFunction();
        VTSession session = this.controller.getSession();
        final CreateManualMatchTask createMatchTask = new CreateManualMatchTask(session, sourceFunction, destinationFunction);
        createMatchTask.addTaskListener(new TaskListener(){

            public void taskCompleted(Task task) {
                CreateManualMatchAction.this.controller.setSelectedMatch(createMatchTask.getNewMatch());
            }

            public void taskCancelled(Task task) {
            }
        });
        this.controller.runVTTask(createMatchTask);
    }
}

