/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.db.VTMatchSetDB;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class RemoveMatchTask
extends VtTask {
    private final List<VTMatch> matches;

    public RemoveMatchTask(VTSession session, List<VTMatch> matches) {
        super("Remove Matches", session);
        this.matches = matches;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws Exception {
        this.removeMatches(monitor);
        return true;
    }

    private boolean removeMatches(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Removing matches");
        monitor.initialize((long)this.matches.size());
        boolean failed = false;
        for (VTMatch match : this.matches) {
            monitor.checkCanceled();
            VTMatchSetDB matchSet = (VTMatchSetDB)match.getMatchSet();
            boolean matchRemoved = matchSet.removeMatch(match);
            if (!matchRemoved) {
                failed = true;
            }
            monitor.incrementProgress(1L);
        }
        monitor.setProgress((long)this.matches.size());
        if (failed) {
            this.reportError("One or more of your matches could not be removed.\nNote: You can't remove a match if it is currently accepted.");
        }
        return true;
    }
}

