/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.prop;

import ghidra.util.prop.PropertyPage;
import ghidra.util.prop.PropertySet;
import ghidra.util.prop.PropertyVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class VoidPropertySet
extends PropertySet {
    private static final long serialVersionUID = 1L;

    public VoidPropertySet(String name) {
        super(name, null);
    }

    @Override
    public int getDataSize() {
        return 4;
    }

    public void put(long index) {
        PropertyPage page = this.getOrCreatePage(this.getPageID(index));
        int n = page.getSize();
        page.add(this.getPageOffset(index));
        this.numProperties += page.getSize() - n;
    }

    @Override
    protected void moveIndex(long from, long to) {
        boolean value = this.hasProperty(from);
        this.remove(from);
        if (value) {
            this.put(to);
        } else {
            this.remove(to);
        }
    }

    @Override
    protected void saveProperty(ObjectOutputStream oos, long index) throws IOException {
    }

    @Override
    protected void restoreProperty(ObjectInputStream ois, long index) throws IOException, ClassNotFoundException {
        this.put(index);
    }

    @Override
    public void applyValue(PropertyVisitor visitor, long addr) {
        if (this.hasProperty(addr)) {
            visitor.visit();
        }
    }
}

