/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.HashUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class MD5Utilities {
    public static final int SALT_LENGTH = 4;
    public static final int UNSALTED_HASH_LENGTH = 32;
    public static final int SALTED_HASH_LENGTH = 36;

    public static char[] getMD5Hash(char[] msg) {
        return HashUtilities.getSaltedHash(HashUtilities.MD5_ALGORITHM, new char[0], msg);
    }

    public static char[] getSaltedMD5Hash(char[] salt, char[] msg) {
        return HashUtilities.getSaltedHash(HashUtilities.MD5_ALGORITHM, salt, msg);
    }

    public static char[] getSaltedMD5Hash(char[] msg) {
        char[] salt = new char[4];
        for (int i = 0; i < salt.length; ++i) {
            salt[i] = HashUtilities.getRandomLetterOrDigit();
        }
        return MD5Utilities.getSaltedMD5Hash(salt, msg);
    }

    public static String getMD5Hash(InputStream in) throws IOException {
        return HashUtilities.getHash(HashUtilities.MD5_ALGORITHM, in);
    }

    public static String getMD5Hash(File file) throws IOException {
        return HashUtilities.getHash(HashUtilities.MD5_ALGORITHM, file);
    }

    public static String getMD5Hash(List<String> values) {
        return HashUtilities.getHash(HashUtilities.MD5_ALGORITHM, values);
    }

    public static char[] hexDump(byte[] data) {
        return HashUtilities.hexDump(data);
    }
}

