/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.object;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.naming.MDQualifiedBasicName;
import mdemangler.object.MDObject;
import mdemangler.typeinfo.MDTypeInfo;
import mdemangler.typeinfo.MDTypeInfoParser;

public class MDObjectCPP
extends MDObject {
    protected MDQualifiedBasicName qualifiedName;
    protected MDTypeInfo typeInfo;
    protected boolean embeddedObjectFlag;

    public MDObjectCPP(MDMang dmang) {
        super(dmang);
    }

    public MDQualifiedBasicName getQualifiedName() {
        return this.qualifiedName;
    }

    public MDTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public MDObjectCPP getEmbeddedObject() {
        if (this.embeddedObjectFlag) {
            return this.getQualifiedName().getBasicName().getEmbeddedObject();
        }
        return this;
    }

    @Override
    public void insert(StringBuilder builder) {
        this.qualifiedName.insert(builder);
        if (this.typeInfo != null) {
            this.typeInfo.insert(builder);
        }
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.dmang.peek() != '?') {
            throw new MDException("Invalid ObjectCPP");
        }
        this.dmang.increment();
        if (this.dmang.peek(0) == '?' && this.dmang.peek(1) == '?') {
            this.embeddedObjectFlag = true;
        }
        this.qualifiedName = new MDQualifiedBasicName(this.dmang);
        this.qualifiedName.parse();
        if (this.qualifiedName.isString()) {
            return;
        }
        if (this.dmang.peek() != '\uffff') {
            int RTTINum = this.qualifiedName.getRTTINumber();
            this.typeInfo = MDTypeInfoParser.parse(this.dmang, RTTINum);
            if (this.qualifiedName.isTypeCast()) {
                this.typeInfo.setTypeCast();
            }
            this.typeInfo.parse();
            if (!this.typeInfo.getNameModifier().isEmpty()) {
                this.qualifiedName.setNameModifier(this.typeInfo.getNameModifier());
            }
        }
    }
}

