/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.typeinfo;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.MDType;

public class MDTypeInfo
extends MDParsableItem {
    private static final String PRIVATE = "private: ";
    private static final String PROTECTED = "protected: ";
    private static final String PUBLIC = "public: ";
    private static final String STATIC = "static ";
    private static final String VIRTUAL = "virtual ";
    private static final String THUNK = "[thunk]:";
    private static final String EXTERNC = "extern \"C\" ";
    private StorageClass storage = StorageClass._NOT_SPECIFIED;
    private AccessSpecifier access = AccessSpecifier._NOT_SPECIFIED;
    private boolean isThunk = false;
    private boolean isMember = true;
    private boolean isExternC = false;
    protected MDType mdtype;
    protected boolean isTypeCast;
    protected String nameModifier = "";

    public MDTypeInfo(MDMang dmang) {
        super(dmang, 1);
    }

    public String getNameModifier() {
        return this.nameModifier;
    }

    public void setPrivate() {
        this.access = AccessSpecifier._PRIVATE;
    }

    public boolean isPrivate() {
        return this.access == AccessSpecifier._PRIVATE;
    }

    public void setProtected() {
        this.access = AccessSpecifier._PROTECTED;
    }

    public boolean isProtected() {
        return this.access == AccessSpecifier._PROTECTED;
    }

    public void setPublic() {
        this.access = AccessSpecifier._PUBLIC;
    }

    public boolean isPublic() {
        return this.access == AccessSpecifier._PUBLIC;
    }

    public void setStatic() {
        this.storage = StorageClass._STATIC;
    }

    public boolean isStatic() {
        return this.storage == StorageClass._STATIC;
    }

    public void setVirtual() {
        this.storage = StorageClass._VIRTUAL;
    }

    public boolean isVirtual() {
        return this.storage == StorageClass._VIRTUAL;
    }

    public void setThunk() {
        this.isThunk = true;
    }

    public boolean isThunk() {
        return this.isThunk;
    }

    public void setExternC() {
        this.isExternC = true;
    }

    public boolean isExternC() {
        return this.isExternC;
    }

    public void setNonMember() {
        this.isMember = false;
    }

    public boolean isMember() {
        return this.isMember;
    }

    public void setTypeCast() {
        this.isTypeCast = true;
    }

    public MDType getMDType() {
        return this.mdtype;
    }

    @Override
    public void insert(StringBuilder builder) {
        if (this.mdtype != null) {
            this.mdtype.insert(builder);
        }
        this.insertAccessModifiers(builder);
    }

    private void insertAccessModifiers(StringBuilder builder) {
        StringBuilder modifiersBuilder = new StringBuilder();
        switch (this.storage) {
            case _NOT_SPECIFIED: {
                break;
            }
            case _STATIC: {
                this.dmang.insertString(modifiersBuilder, STATIC);
                break;
            }
            case _VIRTUAL: {
                this.dmang.insertString(modifiersBuilder, VIRTUAL);
            }
        }
        switch (this.access) {
            case _NOT_SPECIFIED: {
                break;
            }
            case _PRIVATE: {
                this.dmang.insertString(modifiersBuilder, PRIVATE);
                break;
            }
            case _PROTECTED: {
                this.dmang.insertString(modifiersBuilder, PROTECTED);
                break;
            }
            case _PUBLIC: {
                this.dmang.insertString(modifiersBuilder, PUBLIC);
            }
        }
        if (this.isThunk) {
            this.dmang.insertString(modifiersBuilder, THUNK);
        }
        if (this.isExternC) {
            this.dmang.insertString(modifiersBuilder, EXTERNC);
        }
        this.dmang.insertSpacedString(builder, modifiersBuilder.toString());
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.mdtype != null) {
            this.mdtype.parse();
        }
    }

    private static enum StorageClass {
        _NOT_SPECIFIED,
        _STATIC,
        _VIRTUAL;

    }

    private static enum AccessSpecifier {
        _NOT_SPECIFIED,
        _PRIVATE,
        _PROTECTED,
        _PUBLIC;

    }
}

