/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.ProgramProcessorContext;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;

public class InstructionStasher {
    private Program program;
    private Address address;
    private InstructionPrototype prototype;
    private Reference[] referencesFrom;
    private Address minAddress;

    public InstructionStasher(Program program, Address address) {
        this.program = program;
        this.address = address;
        this.clearAndSave();
    }

    private void clearAndSave() {
        Instruction instruction = this.program.getListing().getInstructionContaining(this.address);
        if (instruction == null) {
            return;
        }
        this.minAddress = instruction.getMinAddress();
        this.prototype = instruction.getPrototype();
        this.referencesFrom = instruction.getReferencesFrom();
        this.program.getListing().clearCodeUnits(this.minAddress, instruction.getMaxAddress(), false);
    }

    public void restore() throws CodeUnitInsertionException {
        if (this.prototype == null) {
            return;
        }
        DumbMemBufferImpl buf = new DumbMemBufferImpl(this.program.getMemory(), this.minAddress);
        ProgramProcessorContext context = new ProgramProcessorContext(this.program.getProgramContext(), this.minAddress);
        this.program.getListing().createInstruction(this.minAddress, this.prototype, (MemBuffer)buf, (ProcessorContextView)context);
        for (Reference reference : this.referencesFrom) {
            if (reference.getSource() == SourceType.DEFAULT) continue;
            this.program.getReferenceManager().addReference(reference);
        }
    }
}

