/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.action.MenuData;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.context.ProgramSymbolContextAction;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.program.model.listing.Function;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import javax.swing.Icon;
import resources.ResourceManager;

public class GoToExternalLocationAction
extends ProgramSymbolContextAction {
    private SymbolTreePlugin plugin;

    public GoToExternalLocationAction(SymbolTreePlugin plugin) {
        super("Go To External Location", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Go to External Location"}, (Icon)ResourceManager.loadImage((String)"images/searchm_obj.gif"), "0External"));
    }

    @Override
    public boolean isEnabledForContext(ProgramSymbolActionContext context) {
        if (context.getSymbolCount() != 1) {
            return false;
        }
        Symbol symbol = context.getFirstSymbol();
        if (symbol == null) {
            return false;
        }
        if (symbol.getSymbolType() == SymbolType.LABEL || symbol.getSymbolType() == SymbolType.FUNCTION) {
            return symbol.isExternal();
        }
        return false;
    }

    @Override
    public void actionPerformed(ProgramSymbolActionContext context) {
        Function f;
        Symbol symbol = context.getFirstSymbol();
        if (symbol == null) {
            return;
        }
        Object obj = symbol.getObject();
        ExternalLocation extLoc = null;
        if (obj instanceof Function && (f = (Function)obj).isExternal()) {
            extLoc = f.getExternalLocation();
        }
        if (obj instanceof ExternalLocation) {
            extLoc = (ExternalLocation)obj;
        }
        if (extLoc != null) {
            this.plugin.goTo(extLoc);
        }
    }
}

