/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.table.field.ProgramBasedDynamicTableColumnExtensionPoint;

public class FunctionPurgeTableColumn
extends ProgramBasedDynamicTableColumnExtensionPoint<Function, String> {
    public String getColumnDisplayName(Settings settings) {
        return this.getColumnName();
    }

    public String getColumnName() {
        return "Function Purge";
    }

    public String getValue(Function rowObject, Settings settings, Program pgm, ServiceProvider serviceProvider) throws IllegalArgumentException {
        Function function = rowObject;
        Object stringDepth = "UNK";
        int depth = function.getStackPurgeSize();
        switch (depth) {
            case 0x7FFFFFFE: {
                stringDepth = "INV";
                break;
            }
            case 0x7FFFFFFF: {
                stringDepth = "UNK";
                break;
            }
            default: {
                stringDepth = depth < 0 ? "-" + Integer.toHexString(-depth) : Integer.toHexString(depth);
            }
        }
        return stringDepth;
    }
}

