/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.spi.commons.query.QueryTreeBuilderRegistry;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.QueryObjectModel;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelFactoryImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;

public class QueryManagerImpl
implements QueryManager {
    private static final String[] SUPPORTED_QUERIES = QueryTreeBuilderRegistry.getSupportedLanguages();
    private static final List SUPPORTED_QUERIES_LIST = Collections.unmodifiableList(Arrays.asList(SUPPORTED_QUERIES));
    private final SessionImpl session;
    private final ItemManager itemMgr;
    private final SearchManager searchMgr;
    private final QueryObjectModelFactoryImpl qomFactory;

    public QueryManagerImpl(final SessionImpl session, ItemManager itemMgr, final SearchManager searchMgr) {
        this.session = session;
        this.itemMgr = itemMgr;
        this.searchMgr = searchMgr;
        this.qomFactory = new QueryObjectModelFactoryImpl(session){

            protected QueryObjectModel createQuery(QueryObjectModelTree qomTree) throws InvalidQueryException, RepositoryException {
                return searchMgr.createQueryObjectModel(session, qomTree, "JCR-SQL2");
            }
        };
    }

    public Query createQuery(String statement, String language) throws InvalidQueryException, RepositoryException {
        this.sanityCheck();
        return this.searchMgr.createQuery(this.session, this.itemMgr, statement, language);
    }

    public Query getQuery(Node node) throws InvalidQueryException, RepositoryException {
        this.sanityCheck();
        return this.searchMgr.createQuery(this.session, this.itemMgr, node);
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        return SUPPORTED_QUERIES_LIST.toArray(new String[SUPPORTED_QUERIES.length]);
    }

    public QueryObjectModelFactory getQOMFactory() {
        return this.qomFactory;
    }

    QueryHandler getQueryHandler() {
        return this.searchMgr.getQueryHandler();
    }

    private void sanityCheck() throws RepositoryException {
        if (!this.session.isLive()) {
            throw new RepositoryException("corresponding session has been closed");
        }
    }
}

