/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filter;

import docking.widgets.filter.MatchesPatternTextFilter;
import docking.widgets.filter.TextFilter;
import ghidra.util.UserSearchUtils;
import java.util.regex.Pattern;

public class StartsWithTextFilter
extends MatchesPatternTextFilter {
    public StartsWithTextFilter(String filterText, boolean caseSensitive, boolean allowGlobbing) {
        super(filterText, caseSensitive, allowGlobbing);
    }

    @Override
    protected Pattern createPattern() {
        int options = 32;
        if (!this.caseSensitive) {
            options |= 2;
        }
        Pattern pattern = UserSearchUtils.createStartsWithPattern((String)this.filterText, (boolean)this.allowGlobbing, (int)options);
        return pattern;
    }

    @Override
    public boolean isSubFilterOf(TextFilter parentFilter) {
        if (!(parentFilter instanceof StartsWithTextFilter)) {
            return false;
        }
        StartsWithTextFilter parent = (StartsWithTextFilter)parentFilter;
        if (this.caseSensitive != parent.caseSensitive || this.allowGlobbing != parent.allowGlobbing) {
            return false;
        }
        boolean isSubFilter = this.filterText.startsWith(parent.filterText);
        return isSubFilter;
    }
}

