/*
 * Decompiled with CFR 0.152.
 */
package docking.wizard;

import docking.wizard.MagePanel;
import docking.wizard.WizardPanelListener;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public abstract class AbstractMageJPanel<T>
extends JPanel
implements MagePanel<T> {
    protected WeakSet<WizardPanelListener> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();

    public AbstractMageJPanel() {
    }

    public AbstractMageJPanel(LayoutManager layout) {
        super(layout);
    }

    @Override
    public void addWizardPanelListener(WizardPanelListener l) {
        this.listeners.add((Object)l);
    }

    @Override
    public void removeWizardPanelListener(WizardPanelListener l) {
        this.listeners.remove((Object)l);
    }

    protected void notifyListenersOfValidityChanged() {
        for (WizardPanelListener listener : this.listeners) {
            listener.validityChanged();
        }
    }

    protected void notifyListenersOfStatusMessage(String msg) {
        for (WizardPanelListener listener : this.listeners) {
            listener.setStatusMessage(msg);
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return null;
    }

    @Override
    public HelpLocation getHelpLocation() {
        return null;
    }
}

