/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.installation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.installation.SamlSPDescriptorClientInstallation;

public class ModAuthMellonClientInstallation
implements ClientInstallationProvider {
    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI serverBaseUri) {
        SamlClient samlClient = new SamlClient(client);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(baos);
        String idpDescriptor = SamlService.getIDPMetadataDescriptor((UriInfo)session.getContext().getUri(), session, realm);
        String spDescriptor = SamlSPDescriptorClientInstallation.getSPDescriptorForClient(client);
        String clientDirName = client.getClientId().replace('/', '_').replace(' ', '_');
        try {
            zip.putNextEntry(new ZipEntry(clientDirName + "/idp-metadata.xml"));
            zip.write(idpDescriptor.getBytes());
            zip.closeEntry();
            zip.putNextEntry(new ZipEntry(clientDirName + "/sp-metadata.xml"));
            zip.write(spDescriptor.getBytes());
            zip.closeEntry();
            if (samlClient.requiresClientSignature()) {
                if (samlClient.getClientSigningPrivateKey() != null) {
                    zip.putNextEntry(new ZipEntry(clientDirName + "/client-private-key.pem"));
                    zip.write(samlClient.getClientSigningPrivateKey().getBytes());
                    zip.closeEntry();
                }
                if (samlClient.getClientSigningCertificate() != null) {
                    zip.putNextEntry(new ZipEntry(clientDirName + "/client-cert.pem"));
                    zip.write(samlClient.getClientSigningCertificate().getBytes());
                    zip.closeEntry();
                }
            }
            zip.close();
            baos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Response.ok((Object)baos.toByteArray(), (String)this.getMediaType()).build();
    }

    public String getProtocol() {
        return "saml";
    }

    public String getDisplayType() {
        return "Mod Auth Mellon files";
    }

    public String getHelpText() {
        return "This is a zip file.  It contains a SAML SP descriptor, SAML IDP descriptor,  private key pem, and certificate pem that you will use to configure mod_auth_mellon for Apache.  You'll use these files when crafting the main Apache configuration file.  See mod_auth_mellon website for more details.";
    }

    public String getFilename() {
        return "keycloak-mod-auth-mellon-sp-config.zip";
    }

    public String getMediaType() {
        return "application/zip";
    }

    public boolean isDownloadOnly() {
        return true;
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "mod-auth-mellon";
    }
}

