/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.file.common;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.storage.file.common.BlockContext;
import org.keycloak.models.map.storage.file.common.WritingMechanism;

public class StringListMapContext
extends BlockContext.DefaultMapContext<Collection<String>> {
    public StringListMapContext() {
        super(Collection.class);
    }

    public static StringListMapContext prefixed(String prefix) {
        return new Prefixed(prefix);
    }

    public AttributeValueYamlContext getContext(String nameOfSubcontext) {
        return new AttributeValueYamlContext();
    }

    @Override
    public void writeValue(Map<String, Collection<String>> value, WritingMechanism mech) {
        if (UndefinedValuesUtils.isUndefined(value)) {
            return;
        }
        mech.writeMapping(() -> {
            AttributeValueYamlContext c = this.getContext("$@[]@$");
            for (Map.Entry entry : new TreeMap(value).entrySet()) {
                Collection attrValues = (Collection)entry.getValue();
                mech.writePair((String)entry.getKey(), () -> c.writeValue(attrValues, mech));
            }
        });
    }

    public static class AttributeValueYamlContext
    extends BlockContext.DefaultListContext<String> {
        public AttributeValueYamlContext() {
            super(String.class);
        }

        @Override
        public void writeValue(Collection<String> value, WritingMechanism mech) {
            if (UndefinedValuesUtils.isUndefined(value)) {
                return;
            }
            if (value.size() == 1) {
                mech.writeObject(value.iterator().next());
            } else {
                super.writeValue(value, mech);
            }
        }

        @Override
        public void add(Object value) {
            if (value != null) {
                super.add(String.valueOf(value));
            }
        }
    }

    private static class Prefixed
    extends StringListMapContext {
        protected final String prefix;

        public Prefixed(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public void add(String name, Object value) {
            super.add(this.prefix + name, value);
        }
    }
}

